/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.resource;

import java.net.URL;
import java.io.InputStream;
import java.io.IOException;
import java.io.File;

/**
 * Represents a resource that doesnot exist.
 * 
 * @author Christos KK Loverdos
 */

public final class EmptyResource implements IResource
{
    public static final EmptyResource INSTANCE = new EmptyResource();
    
    private EmptyResource()
    {
    }

    public String getName()
    {
        return null;
    }

    public URL getURL()
    {
        return null;
    }

    public InputStream getInputStream() throws IOException
    {
        return null;
    }

    public boolean exists()
    {
        return false;
    }

    public boolean isFile()
    {
        return false;
    }

    public File getFile()
    {
        return null;
    }

    public String toString()
    {
        return "EmptyResource()";
    }
}
