/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.filter;


/**
 * An implementation of {@link org.ckkloverdos.filter.IFilter} providing boolean NOT
 * semantics for another filters.
 *
 * @author Christos KK Loverdos
 */
public class NotFilter implements IFilter
{
	private IFilter filter;

    /**
     * Contructs a new filter that negates the results of the provided filter <code>f</code>.
     * 
     * @param f
     */
    public NotFilter(IFilter f)
	{
		this.filter = f;
	}

    /**
     * Tests if <code>object</code> is accepted according to this filter semantics (boolean NOT
     * for the filter given in the {@link org.ckkloverdos.filter.NotFilter#NotFilter(IFilter) constructor}).
     * @param object
     * @param hints
     */
    public boolean accept(Object object, Object hints)
	{
		return !filter.accept(object, hints);
	}

}
