/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.filter;

/**
 * A filter that tests for <code>null</code> equality.
 * 
 * @author Christos KK Loverdos
 */
public class IsNull implements IFilter
{
    public static final IsNull IS_NULL = new IsNull();

    public IsNull() {}

    /**
     * Tests that <code>object</code> is <code>null</code>.
     * The second parameter, <code>hints</code>, is ignored.
     * 
     * @param object
     * @param hints
     */
    public boolean accept(Object object, Object hints)
    {
        return null == object;
    }
}
