/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.filter;

/**
 * A generic filter interface.
 * 
 * @author Christos KK Loverdos
 */
public interface IFilter
{
    /**
     * Tests whether or not the specified <code>object</code> can be accepted
     * by the filter.
     * The second parameter <code>hints</code> is used as a generic extra piece
     * of information. 
     *
     * @param object
     * @param hints
     */
    public boolean accept(Object object, Object hints);
}
