/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.ckkloverdos.io.IOUtil;
import org.ckkloverdos.source.ISource;
import org.ckkloverdos.source.SourceType;

public abstract class SourceSkeleton
implements ISource {
    protected String name;
    protected SourceType type;
    protected InputStream is;
    protected boolean valid;

    protected SourceSkeleton() {
    }

    private void checkName(String name) {
        if (null == name) {
            throw new NullPointerException("Null name");
        }
    }

    private void checkType(SourceType type) {
        if (null == type) {
            throw new NullPointerException("Null type");
        }
    }

    protected SourceSkeleton(String name, SourceType type, InputStream is) {
        this.checkName(name);
        this.checkType(type);
        this.name = name;
        this.type = type;
        this.is = is;
        this.valid = null != is;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.type + ":" + this.name;
    }

    public SourceType getType() {
        return this.type;
    }

    public InputStream getInputStream() throws IOException {
        return this.is;
    }

    public boolean isText() {
        return this.type.isText();
    }

    public String getString() throws IOException {
        return this.getString("UTF-8");
    }

    public Reader getReader() throws IOException {
        return this.getReader("UTF-8");
    }

    public String getString(String encoding) throws IOException {
        return IOUtil.readString(this.is, encoding);
    }

    public Reader getReader(String encoding) throws IOException {
        return new InputStreamReader(this.is, encoding);
    }

    protected void setValid(boolean valid) {
        this.valid = valid;
    }

    protected void setInputStream(InputStream is) {
        this.is = is;
    }

    protected void setName(String name) {
        this.checkName(name);
        this.name = name;
    }

    protected void setType(SourceType type) {
        this.checkType(type);
        this.type = type;
    }
}

