/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.log;

import org.ckkloverdos.java.JavaPlatform;
import org.ckkloverdos.string.KVToString;
import org.ckkloverdos.string.ToString;
import org.ckkloverdos.util.CallUtil;
import org.ckkloverdos.util.ClassUtil;
import org.ckkloverdos.util.Util;

public class StdLogger {
    public static final String DEBUG = "DEBUG";
    public static final String INFO = " INFO";
    public static final String WARN = " WARN";
    public static final String ERROR = "ERROR";
    private boolean printDate;
    private String uid;
    private String where;
    private int stackDepthOverride;
    private int indent;
    private boolean withSite;

    public StdLogger() {
        this(null, null, true);
    }

    public StdLogger(String uid) {
        this(uid, true);
    }

    public StdLogger(String uid, boolean printDate) {
        this(uid, null, printDate);
    }

    public StdLogger(String uid, String where) {
        this(uid, where, true);
    }

    public StdLogger(String uid, String where, boolean printDate) {
        this(uid, where, printDate, 0);
    }

    StdLogger(String uid, String where, boolean printDate, int stackDepthOverride) {
        this(uid, where, printDate, stackDepthOverride, false);
    }

    private StdLogger(String uid, String where, boolean printDate, int stackDepthOverride, boolean withSite) {
        this.uid = uid;
        this.where = where;
        this.printDate = printDate;
        this.stackDepthOverride = 3 + stackDepthOverride;
        this.withSite = withSite;
    }

    private String getPrintString(String level, String msg) {
        String line = "";
        if (this.printDate) {
            line = line + Util.getFormattedDate();
        }
        if (null != level) {
            if (line.length() > 0) {
                line = line + " ";
            }
            line = line + level;
        }
        if (null != this.where) {
            if (0 != this.where.length()) {
                if (line.length() > 0) {
                    line = line + " ";
                }
                String _where = this.withSite ? CallUtil.getStackShortInfo(this.stackDepthOverride) + "." + this.where : this.where;
                line = line + "[" + _where + "]";
            }
        } else {
            if (line.length() > 0) {
                line = line + " ";
            }
            line = line + "[" + CallUtil.getStackShortInfo(this.stackDepthOverride) + "]";
        }
        if (null != this.uid && this.uid.length() > 0) {
            if (line.length() > 0) {
                line = line + " ";
            }
            line = line + this.uid;
        }
        msg = String.valueOf(msg);
        if (line.length() > 0 && msg.length() > 0) {
            line = line + " ";
        }
        return line + this.indentedMsg(msg);
    }

    private void print(String level, String msg) {
        System.out.println(this.getPrintString(level, msg));
    }

    private void print(String level, ToString msg) {
        System.out.println(this.getPrintString(level, msg.toString()));
    }

    private void print(String level, Throwable e) {
        System.out.println(this.getPrintString(level, Util.getStackTrace(e)));
    }

    private void print(String level, String msg, Throwable e) {
        System.out.println(this.getPrintString(level, msg + " [" + ClassUtil.getShortClassName(e) + "]" + (null == e.getMessage() ? "" : " " + e.getMessage()) + JavaPlatform.LINE_SEPARATOR + Util.getStackTrace(e)));
    }

    private String indentedMsg(String msg) {
        if (this.indent <= 0) {
            return msg;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.indent; ++i) {
            sb.append("  ");
        }
        sb.append(msg);
        return sb.toString();
    }

    public StdLogger forSite(String where) {
        if (null != this.where && 0 != this.where.length()) {
            where = this.where + "." + where;
        }
        return new StdLogger(this.uid, where, this.printDate, 0, true);
    }

    public StdLogger indent() {
        ++this.indent;
        return this;
    }

    public StdLogger unindent() {
        --this.indent;
        return this;
    }

    public void log(String msg) {
        this.print(null, msg);
    }

    public void log(boolean b) {
        this.print(null, String.valueOf(b));
    }

    public void log(String key, Object val) {
        this.print(null, new KVToString(key, val));
    }

    public void log(String msg, String key, Object val) {
        this.print(null, new KVToString(msg + key, val));
    }

    public void log(String key, Object val, String k2, Object v2) {
        this.print(null, new KVToString(key, val, k2, v2));
    }

    public void log(String msg, String key, Object val, String k2, Object v2) {
        this.print(null, new KVToString(msg + key, val, k2, v2));
    }

    public void log(String key, Object val, String k2, Object v2, String k3, Object v3) {
        this.print(null, new KVToString(key, val, k2, v2, k3, v3));
    }

    public void log(String msg, String key, Object val, String k2, Object v2, String k3, Object v3) {
        this.print(null, new KVToString(msg + key, val, k2, v2, k3, v3));
    }

    public void log(String key, Object val, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        this.print(null, new KVToString(key, val, k2, v2, k3, v3, k4, v4));
    }

    public void log(String msg, String key, Object val, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        this.print(null, new KVToString(msg + key, val, k2, v2, k3, v3, k4, v4));
    }

    public void log(String key, Object val, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5) {
        this.print(null, new KVToString(key, val, k2, v2, k3, v3, k4, v4, k5, v5));
    }

    public void log(String msg, String key, Object val, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5) {
        this.print(null, new KVToString(msg + key, val, k2, v2, k3, v3, k4, v4, k5, v5));
    }

    public void log(ToString msg) {
        this.print(null, msg);
    }

    public void log(Throwable msg) {
        this.print(null, msg);
    }

    public void log(Object msg) {
        this.print(null, String.valueOf(msg));
    }

    public void debug(String msg) {
        this.print(DEBUG, msg);
    }

    public void debug(ToString msg) {
        this.print(DEBUG, msg);
    }

    public void debug(Throwable e) {
        this.print(DEBUG, e);
    }

    public void debug(String msg, Throwable e) {
        this.print(DEBUG, msg, e);
    }

    public void debug(ToString msg, Throwable e) {
        this.print(DEBUG, msg.toString(), e);
    }

    public void debug(Object o, Throwable e) {
        this.print(DEBUG, String.valueOf(o), e);
    }

    public void debug(Object msg) {
        this.print(DEBUG, String.valueOf(msg));
    }

    public void debug(String key, Object val) {
        this.print(DEBUG, new KVToString(key, val));
    }

    public void debug(String msg, String key, Object val) {
        this.print(DEBUG, new KVToString(msg + key, val));
    }

    public void debug(String key, Object val, String k2, Object v2) {
        this.print(DEBUG, new KVToString(key, val, k2, v2));
    }

    public void debug(String msg, String key, Object val, String k2, Object v2) {
        this.print(DEBUG, new KVToString(msg + key, val, k2, v2));
    }

    public void debug(String key, Object val, String k2, Object v2, String k3, Object v3) {
        this.print(DEBUG, new KVToString(key, val, k2, v2, k3, v3));
    }

    public void debug(String msg, String key, Object val, String k2, Object v2, String k3, Object v3) {
        this.print(DEBUG, new KVToString(msg + key, val, k2, v2, k3, v3));
    }

    public void debug(String key, Object val, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        this.print(DEBUG, new KVToString(key, val, k2, v2, k3, v3, k4, v4));
    }

    public void debug(String msg, String key, Object val, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        this.print(DEBUG, new KVToString(msg + key, val, k2, v2, k3, v3, k4, v4));
    }

    public void debug(String key, Object val, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5) {
        this.print(DEBUG, new KVToString(key, val, k2, v2, k3, v3, k4, v4, k5, v5));
    }

    public void info(ToString msg) {
        this.print(INFO, msg);
    }

    public void info(Throwable e) {
        this.print(INFO, e);
    }

    public void info(String msg, Throwable e) {
        this.print(INFO, msg, e);
    }

    public void info(ToString msg, Throwable e) {
        this.print(INFO, msg.toString(), e);
    }

    public void info(Object o, Throwable e) {
        this.print(INFO, String.valueOf(o), e);
    }

    public void info(Object msg) {
        this.print(INFO, String.valueOf(msg));
    }

    public void info(String key, Object val) {
        this.print(INFO, new KVToString(key, val));
    }

    public void info(String msg, String key, Object val) {
        this.print(INFO, new KVToString(msg + key, val));
    }

    public void info(String key, Object val, String k2, Object v2) {
        this.print(INFO, new KVToString(key, val, k2, v2));
    }

    public void info(String msg, String key, Object val, String k2, Object v2) {
        this.print(INFO, new KVToString(msg + key, val, k2, v2));
    }

    public void info(String key, Object val, String k2, Object v2, String k3, Object v3) {
        this.print(INFO, new KVToString(key, val, k2, v2, k3, v3));
    }

    public void info(String msg, String key, Object val, String k2, Object v2, String k3, Object v3) {
        this.print(INFO, new KVToString(msg + key, val, k2, v2, k3, v3));
    }

    public void info(String key, Object val, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        this.print(INFO, new KVToString(key, val, k2, v2, k3, v3, k4, v4));
    }

    public void info(String msg, String key, Object val, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        this.print(INFO, new KVToString(msg + key, val, k2, v2, k3, v3, k4, v4));
    }

    public void info(String key, Object val, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5) {
        this.print(INFO, new KVToString(key, val, k2, v2, k3, v3, k4, v4, k5, v5));
    }

    public void warn(String msg) {
        this.print(WARN, msg);
    }

    public void warn(ToString msg) {
        this.print(WARN, msg);
    }

    public void warn(Throwable e) {
        this.print(WARN, e);
    }

    public void warn(String msg, Throwable e) {
        this.print(WARN, msg, e);
    }

    public void warn(ToString msg, Throwable e) {
        this.print(WARN, msg.toString(), e);
    }

    public void warn(Object o, Throwable e) {
        this.print(WARN, String.valueOf(o), e);
    }

    public void warn(Object msg) {
        this.print(WARN, String.valueOf(msg));
    }

    public void warn(String key, Object val) {
        this.print(WARN, new KVToString(key, val));
    }

    public void warn(String msg, String key, Object val) {
        this.print(WARN, new KVToString(msg + key, val));
    }

    public void warn(String key, Object val, String k2, Object v2) {
        this.print(WARN, new KVToString(key, val, k2, v2));
    }

    public void warn(String msg, String key, Object val, String k2, Object v2) {
        this.print(WARN, new KVToString(msg + key, val, k2, v2));
    }

    public void warn(String key, Object val, String k2, Object v2, String k3, Object v3) {
        this.print(WARN, new KVToString(key, val, k2, v2, k3, v3));
    }

    public void warn(String msg, String key, Object val, String k2, Object v2, String k3, Object v3) {
        this.print(WARN, new KVToString(msg + key, val, k2, v2, k3, v3));
    }

    public void warn(String key, Object val, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        this.print(WARN, new KVToString(key, val, k2, v2, k3, v3, k4, v4));
    }

    public void warn(String msg, String key, Object val, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        this.print(WARN, new KVToString(msg + key, val, k2, v2, k3, v3, k4, v4));
    }

    public void warn(String key, Object val, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5) {
        this.print(WARN, new KVToString(key, val, k2, v2, k3, v3, k4, v4, k5, v5));
    }

    public void error(String msg) {
        this.print(ERROR, msg);
    }

    public void error(ToString msg) {
        this.print(ERROR, msg);
    }

    public void error(Throwable e) {
        this.print(ERROR, e);
    }

    public void error(String msg, Throwable e) {
        this.print(ERROR, msg, e);
    }

    public void error(ToString msg, Throwable e) {
        this.print(ERROR, msg.toString(), e);
    }

    public void error(Object o, Throwable e) {
        this.print(ERROR, String.valueOf(o), e);
    }

    public void error(Object msg) {
        this.print(ERROR, String.valueOf(msg));
    }

    public void error(String key, Object val) {
        this.print(ERROR, new KVToString(key, val));
    }

    public void error(String msg, String key, Object val) {
        this.print(ERROR, new KVToString(msg + key, val));
    }

    public void error(String key, Object val, String k2, Object v2) {
        this.print(ERROR, new KVToString(key, val, k2, v2));
    }

    public void error(String msg, String key, Object val, String k2, Object v2) {
        this.print(ERROR, new KVToString(msg + key, val, k2, v2));
    }

    public void error(String key, Object val, String k2, Object v2, String k3, Object v3) {
        this.print(ERROR, new KVToString(key, val, k2, v2, k3, v3));
    }

    public void error(String msg, String key, Object val, String k2, Object v2, String k3, Object v3) {
        this.print(ERROR, new KVToString(msg + key, val, k2, v2, k3, v3));
    }

    public void error(String key, Object val, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        this.print(ERROR, new KVToString(key, val, k2, v2, k3, v3, k4, v4));
    }

    public void error(String msg, String key, Object val, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        this.print(ERROR, new KVToString(msg + key, val, k2, v2, k3, v3, k4, v4));
    }

    public void error(String key, Object val, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5) {
        this.print(ERROR, new KVToString(key, val, k2, v2, k3, v3, k4, v4, k5, v5));
    }

    public void setUID(String uid) {
        this.uid = uid;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public String getWhere() {
        return this.where;
    }

    public String getUID() {
        return this.uid;
    }

    public void enter() {
        this.print(null, ">>>ENTER");
    }

    public void exit() {
        this.print(null, "<<<EXIT");
    }
}

