/*
     Copyright (c) 1999,2010 Michael Dillon

     Permission is hereby granted, free of charge, to any person obtaining a copy
     of this software and associated documentation files (the "Software"), to deal
     in the Software without restriction, including without limitation the rights
     to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     copies of the Software, and to permit persons to whom the Software is
     furnished to do so, subject to the following conditions:
     
     The above copyright notice and this permission notice shall be included in
     all copies or substantial portions of the Software.
     
     THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     THE SOFTWARE.
*/
/*
	MultiTasker Awareness Module
*/
//#include <stdio.h>
#include <dos.h>
//#include <conio.h>

#define NOT_PRESENT 0
#define PRESENT 1
#define OS2_BOX 2
#define TRUE 1 // Redundant defines
#define FALSE 0

enum MultiTaskerEnvironments { DOS = 0, OS_2 = 1, Win31 = 2, Win95 = 3, WinNT = 4, NONE = 5};

unsigned char TaskerType = DOS; // Default
unsigned short int OS_Major = 0; // OS Versions
unsigned short int OS_Minor = 0;
unsigned short int OS_Rev = 0;
unsigned short int WOS_Major = 0; // Windows Versions
unsigned short int WOS_Minor = 0;
unsigned char BadFunctionCall = 0; // Used for Windows Sleep call

void FindMultiTasker(void);
void TimeSlice(void);
unsigned char OS2Check(void);
unsigned char DOSVersion(void);
void DOSTrueVersion(void);
unsigned char WindowsEnhancedCheck(void);

void DOSSleep(void);
void WindowsSleep(void);

void FindMultiTasker(void)
{
	if (DOSVersion() == OS2_BOX) // OS/2 was found by the BOX
	{
		if (OS2Check() == NOT_PRESENT); // PROBLEM!!!!
		TaskerType = NONE; // Failure in determination
	}
	else
	{
		if (OS_Major >= 5)
		{
			DOSTrueVersion();
			if (OS_Major == 5 && OS_Minor == 5) // WinNT found (DOS Box)
			{
				TaskerType = WinNT;
			}
			else if (OS_Major == 7 && WindowsEnhancedCheck() != NOT_PRESENT)
			{
				TaskerType = Win95; // DOS 7.0+ exists in Win9x
			}
			else if (OS_Major >= 5)
			{
				TaskerType = DOS;
			}
		}
		else if (WindowsEnhancedCheck() == PRESENT)
		{
			TaskerType = Win31; // Lower DOS version but still Windows 3.x Enhanced Mode
		}
		else
		{
			TaskerType = NONE; // DOS 5+ not found
		}
	}
}

void TimeSlice(void)
{
	if (TaskerType == DOS)
	{
		DOSSleep();
	}
	if ((TaskerType == Win31 || TaskerType == Win95 || TaskerType == WinNT || TaskerType == OS_2) && !BadFunctionCall)
	{
		WindowsSleep();
	}
}

unsigned char OS2Check(void)
{
	REGS regs;
	regs.x.ax = 0x4010; // Check for OS/2 Installation
	int86(0x2F, &regs, &regs); // Call MultiPlex Interrupt
	if (regs.x.ax == 0x4010) // Non-OS/2 environment
	{
		return (NOT_PRESENT);
	}
	else if (regs.x.ax == 0x0000)
	{
		return (PRESENT);
	}
	else // OS/2 installed!
	{
		OS_Major = regs.h.bl;
		OS_Minor = regs.h.bh;
	}
	return (PRESENT);
}

unsigned char DOSVersion(void)
{
	REGS regs;
	regs.x.ax = 0x3000;
	int86(0x21, &regs, &regs);
	if (regs.h.al == 10 || regs.h.al == 20) // OS/2 compatibility box
	{
		return (OS2_BOX);
	}
	else
	{
		OS_Major = regs.h.al;
		OS_Minor = regs.h.ah;
	}
	return (PRESENT);
}

void DOSTrueVersion(void)
{
	REGS regs;
	regs.x.ax = 0x3306;
	int86(0x21, &regs, &regs);
	OS_Major = regs.h.bl;
	OS_Minor = regs.h.bh;
	OS_Rev = regs.h.dl;
}

unsigned char WindowsEnhancedCheck(void)
{
	REGS regs;
	regs.x.ax = 0x1600;
	int86(0x2F, &regs, &regs);
	if (regs.h.al == 0x00 || regs.h.al == 0x01 || regs.h.al == 0x80 || regs.h.al == 0xFF)
	{
		return (NOT_PRESENT);
	}
	else
	{
		WOS_Major = regs.h.al;
		WOS_Minor = regs.h.ah;
	}
	return (PRESENT);
}


// Sleep Functions

void DOSSleep(void)
{
	REGS regs;
	int86(0x28, &regs, &regs); // Call DOS idle Function
}

void WindowsSleep(void) // Release Virtual Machine Time Slice
{
	REGS regs;
	regs.x.ax = 0x1680; // Release VM-TS
	int86(0x2F, &regs, &regs);
	if (regs.h.ah == 0x80)
	{
		BadFunctionCall = TRUE; // uh oh.... function call fell through
	}
}
