/*
     Copyright (c) 1999,2010 Michael Dillon

     Permission is hereby granted, free of charge, to any person obtaining a copy
     of this software and associated documentation files (the "Software"), to deal
     in the Software without restriction, including without limitation the rights
     to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     copies of the Software, and to permit persons to whom the Software is
     furnished to do so, subject to the following conditions:
     
     The above copyright notice and this permission notice shall be included in
     all copies or substantial portions of the Software.
     
     THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     THE SOFTWARE.
*/
//#include <conio.h>
//#include <stdio.h>
//#include <stdlib.h>
//#include <string.h>
#include <limits.h>
#include "mtasker.cpp"
#include "typekill.cpp"

enum Types { SCHAR = 0, SSHORT = 1, USHORT = 2, SLONG = 3, ULONG = 4 };

/*
	Function GetNumeric()

	prototype: GetNumeric(<type> &number, length, Type);
		<type> refers to the variable's type (e.g. char, int)
		length is how many digits to input
		Type is a value from the enumerated Types

	Purpose: To input integer values
*/

// Templatized Form of GetNumeric
template <class Conv> void GetNumeric(Conv &num, unsigned short int length, unsigned short int Type, Conv Original);
// GetNumeric functions
void GetNumeric(signed char &num, unsigned short int length, unsigned short int Type, signed char Original, unsigned char NegFlag = 0);
void GetNumeric(signed short int &num, unsigned short int length, unsigned short int Type, signed short int Original, unsigned char NegFlag = 0);
void GetNumeric(unsigned short int &num, unsigned short int length, unsigned short int Type, unsigned short int Original, unsigned char NegFlag = 0);
void GetNumeric(signed long int &num, unsigned short int length, unsigned short int Type, signed long int Original, unsigned char NegFlag = 0);
void GetNumeric(unsigned long int &num, unsigned short int length, unsigned short int Type, unsigned long int Original, unsigned char NegFlag = 0);

/*
	Function: GetString()

	Prototype: GetString(unsigned char *string, length, unsigned char *orig);
		string is the variable that will be changed through input
		length is the max number of characters to input
		orig is the original string <if any>

	Purpose: Input a string at a maximum length
*/
void GetString(unsigned char *string, unsigned short int length, unsigned char *orig);

// Prototype for ColorCodePrintf() that resides in the main file
void ColorCodePrintf(unsigned char *Format_String,...);

// Secondary function required by the template
void typekill(unsigned char *string, unsigned short int Type);

void GetString(unsigned char *string, unsigned short int length, unsigned char *orig)
{
	unsigned short int done = 0, idx = strlen(orig);
	unsigned char ch = 0;
	strcpy(string, orig); // Copy Original to New string
	while (!done)
	{
		while (ch == 0)
		{
			TimeSlice();
			ch = getch();
		}
		if ((ch == 13 || ch == 10) && idx <= length && idx != 0)
		{
			if (idx != length)
				string[idx] = '\x0';
			else
				string[length] = '\x0';
			done = 1;
		}
		else if ((ch == 13 || ch == 10) && idx == 0)
		{
			done = 1;
		}
		else if (ch == 8)
		{
			if (idx != 0)
			{
				ColorCodePrintf(" \x8 \x8\x8 \x8");
				idx--;
				string[idx] = '\x0';
			}
		}
		else if ((ch >= 32 && ch <= 127) && idx < length)
		{
			string[idx] = ch;
			idx++;
			ColorCodePrintf("%c", ch);
		}
		if (idx > length)
		{
			ColorCodePrintf("\x8");
			idx = length;
		}
		ch = 0;
	}
	if (strlen(string) == 0) // Null string
	{
		strcpy(string, orig); // Restore original
	}
}

template <class Conv> void GetNumeric(Conv &num, unsigned short int length, unsigned short int Type, Conv Original, unsigned char NegFlag = 0)
{
	unsigned char string[20] = "\x0";
	unsigned short int done = 0, idx = 0, SignFlag = 0;
	unsigned char ch = 0;
	while (!done)
	{
		while (ch == 0)
		{
			TimeSlice();
			ch = getch();
		}
		if ((ch == 13 || ch == 10) && idx <= length && idx != 0)
		{
			if (idx != length)
				string[idx] = '\x0';
			else
				string[length] = '\x0';
			done = 1;
		}
		else if ((ch == 13 || ch == 10) && idx == 0)
		{
			done = 1;
		}
		else if (ch == 8)
		{
			if (idx != 0)
			{
				ColorCodePrintf(" \x8 \x8\x8 \x8");
				idx--;
				string[idx] = '\x0';
				if (idx == 0 && SignFlag == 1)
				{
					length--;
					SignFlag = 0;
				}
			}
		}
		else if (((ch >= '0' && ch <= '9') || (ch == '-') || (ch == '+')) && (idx <= (length - 1)))
		{
			if ((ch == '-' || ch == '+') && (Type == SCHAR || Type == SSHORT || Type == SLONG) && NegFlag == 1)
			{
				if (SignFlag != 1)
				{
					string[idx] = ch; // With signs
					length++;
					SignFlag = 1;
					idx++;
					ColorCodePrintf("%c", ch);
				}
			}
			else if ((ch != '-' && ch != '+'))
			{
				string[idx] = ch; // No signs
				idx++;
				ColorCodePrintf("%c", ch);
			}
		}
		if (idx > length)
		{
			ColorCodePrintf("\x8");
			idx = length;
		}
		ch = 0;
	}
	if (done == 1 && idx == 0)
	{
		switch(Type)
		{
			case SCHAR:
			case SSHORT:
			case USHORT: itoa(Original, string, 10);
			case SLONG:
			case ULONG: ltoa(Original, string, 10);
		}
	}
	switch(Type)
	{
		case SCHAR: typekill(string, SCHAR); num = atoi(string); break;
		case SSHORT: typekill(string, SSHORT); num = atoi(string); break;
		case USHORT: typekill(string, USHORT); num = atoi(string); break;
		case SLONG: typekill(string, SLONG); num = atol(string); break;
		case ULONG: typekill(string, ULONG); num = atol(string); break;
	}
}

void typekill(unsigned char *string, unsigned short int Type)
{
	unsigned char type_string_max[15] = "\x0";
	unsigned char type_string_min[15] = "\x0";
	switch(Type)
	{
		case SCHAR:
			itoa(CHAR_MAX, type_string_max, 10);
			itoa(CHAR_MIN + 1, type_string_min, 10);
			break;
		case SSHORT:
			itoa(SHRT_MAX, type_string_max, 10);
			itoa(SHRT_MIN + 1, type_string_min, 10);
			break;
		case USHORT:
			itoa(USHRT_MAX, type_string_max, 10);
			itoa(0, type_string_min, 10);
			break;
		case SLONG:
			ltoa(LONG_MAX, type_string_max, 10);
			ltoa(LONG_MIN + 1, type_string_min, 10);
			break;
		case ULONG:
			ltoa(ULONG_MAX, type_string_max, 10);
			ltoa(0, type_string_min, 10);
	}
	StringConversion(type_string_max, strlen(type_string_max) + 1);
	StringConversion(type_string_min, strlen(type_string_min));
	if (StringComparison(string, type_string_max, 1) == -2)
	{
		strcpy(string, type_string_max); // Max out
	}
	else if (StringComparison(string, type_string_max, 1) == -1)
	{
		if (StringComparison(string, type_string_min, 1) == -2)
		{
			strcpy(string, type_string_min);
		}
	}
}