/*
 WHO CALLED ProBoard PEX Version and MS-DOS EXE
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of WHO CALLED.

 WHO CALLED is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 WHO CALLED is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with WHO CALLED; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if !defined( __USERSXI_H )
	#include "usersxi.h"
#endif

#if !defined( PB_SDK )
	#if !defined( __STDIO_H )
		#include <stdio.h>
	#endif
#endif
#if !defined( __PBCONFIG_H )
	#include "pbconfig.h"
#endif

/*
 * routines local to this module
*/
static FILE *_openUsersXI( const char *mode );


/*
 * opens the USERSXI.BBS file in requested mode
*/
	FILE*
_openUsersXI( const char *mode )
{
	char path[MAXPATH];

#if !defined( PB_SDK )
	CONFIG cfg;
	if( -1 == ReadConfig(&cfg) ) return NULL;
	sprintf( path, "%s\\USERSXI.BBS", cfg.msgpath );
#else
	sprintf( path, "%s\\USERSXI.BBS", Config->msgpath );
#endif

	return fopen( path, mode );
}

/*
 * writes the USERSXI structure to the XI file
*/
	int
WriteUsersXI( int num, USERSXI_BBS *rec )
{
	FILE *fp;
	 int  retval = 0;

	fp = _openUsersXI( "r+b" );
	if( !fp ) return -1;

	fseek( fp, l_mul((long)(num - 1), (long)sizeof(USERSXI_BBS)), SEEK_SET );
	if( 1 != fwrite( rec, sizeof(USERSXI_BBS), 1, fp ) ) retval = -1;

	fclose(fp);
	return retval;
}


/*
 * number of users in USERSXI.BBS file (same as NumUsers???)
*/
	int
NumUsersXI( void )
{
	FILE *fp;
	 int  num;

	fp = _openUsersXI( "rb" );
	if( !fp ) return -1;

	fseek( fp, 0L, SEEK_END );
	num = (int)l_div( ftell(fp), (long)sizeof(USERSXI_BBS) );

	fclose(fp);
	return num;
}

/*
 * reads the record num into rec
*/
	int
ReadUsersXI( int num, USERSXI_BBS *rec )
{
	FILE *fp;
	 int  retval = 0;

	fp = _openUsersXI( "rb" );
	if( !fp ) return -1;

	fseek( fp, l_mul((long)(num - 1), (long)sizeof(USERSXI_BBS)), SEEK_SET );
	if( 1 != fread(rec, sizeof(USERSXI_BBS), 1, fp) ) retval = -1;

	fclose(fp);
	return retval;
}