/*
 WHO CALLED ProBoard PEX Version and MS-DOS EXE
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of WHO CALLED.

 WHO CALLED is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 WHO CALLED is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with WHO CALLED; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if !defined( __LLISTADT_H )
#define __LLISTADT_H

/*
 ****************************************************************************
		   Basic implemetnation of Singly-Linked List, Queue and Stack
 ****************************************************************************
*/
#if !defined( __PBINC_H )
	#include "pbinc.h"
#endif

/*
 * None of the structures contain user-accessible data!
*/
typedef struct __atom{
	struct __atom *next;
} llatom;

typedef struct{
	size_t count;
	llatom *head;
	llatom *tail;
	llatom  _dummy[2];
} llist;

/*
 * Use these for the 'where' parameter in lladd()
*/
#define LLPUT_START 0   /* add the new node at the start of the list   */
#define LLPUT_SORT  1   /* use the sort functon to insert the new node */
#define LLPUT_END   2   /* append the new node to the end of the list  */

/* size_t llcount( llist *list ); */
#define llcount(l) ( (l)->count )

#if defined( __cplusplus )
	extern "C" {
#endif

llist *llnew( void );
void  *lladd( llist *list, const void *data, size_t width, int where, ... );
void   llfree( void *node );
void   llkill( llist *list, void *node, void (*freeData)(void *) );
void   lldelete( llist *list, void (*freeData)(void *) );
void  *llget( llist *list, void *node, void *data, size_t width,
		  void (*freeData)(void *) );
void  *llfirst( llist *list );
void  *llnext( const void *node );
void   llfeach( llist *list, const void *key,
		  int  (*compare)(const void *key, const void *data),
		  void (*process)(void *data) );
void  *llfindfirst( llist *list, const void *key,
		  int (*compare)(const void *, const void *) );
void  *llfindnext( void *node );

/*
 * for both stack and queue
*/
#define llpeek(l)           llfirst( (l) )

/*
 * Stack-access macros
*/
#define llpush(l,d,w)       lladd( (l), (d), (w), LLPUT_START )
#define llpop(l,d,w,f)      llget( (l), llfirst(l), (d), (w), (f) )

/*
 * Queue-access macros
*/
#define llenqueue(l,d,w)    lladd( (l), (d), (w), LLPUT_END )
#define lldequeue(l,d,w,f)  llpop( (l), (d), (w), (f) )

#if defined( __cplusplus )
	}
#endif
#endif
