/*
 WHO CALLED ProBoard PEX Version and MS-DOS EXE
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of WHO CALLED.

 WHO CALLED is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 WHO CALLED is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with WHO CALLED; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if !defined( __FIXARG_H )
#define __FIXARG_H

/*
 ***************************************************************************
	 Fix the buggy PB_SDK: it does not handle variable arguments properly
 ***************************************************************************
*/

/* we don't want to override the standard ANSI/UNIX libraries */
#if !defined( __STDARG_H ) || defined( __VARARGS_H )

/* get the current value of __FAR to determine pointer type   */
#if !defined( __MACDEF_H )
	#include "macdef.h"
#endif

/* this is the va_list definition */
typedef void __FAR *va_list;

/* this will make the size always even by adding 1 to the odd numbers  */
#define __size(t) ( (sizeof(t)+1) & 0xFFFE )

/* set the 'a' pointer to the memory location right after fix (param)  */
#define va_start(a,fix) \
	( (void)((a) = (va_list)((char __FAR *)(&fix)+__size(fix))) )

/* retrieve address of next variable of type 't' and increment pointer */
#define va_arg(a,t) \
	( *(t __FAR *)(((*(char __FAR* __FAR*)&(a))+=__size(t))-(__size(t))) )

/* a do-nothing NOP */
#define va_end(a)   ( (void)0 )

#endif
#endif