/*
 * This file is part of VizPak (PEX)
 *
 * Copyright (C) 1995-1997 by Branislav L. Slantchev
 * A Product of Silicon Creations, Inc.
 *
 * This file is distributed under the terms and conditions of the GNU
 * General Public License. For more information, refer to the file
 * Copying.Doc which is included in the archive.
*/
#ifndef INCLUDED_VIZ_H
#define INCLUDED_VIZ_H
#include "typedef.h"
#include "geometry.h"

#define BUFFERSIZE   1024
#define DEFAULTDELAY 80

/*
 * this class defines the abstract visual effect, all others are derived
 * from it. it implements the common command-line parser and string printer
*/
class AbstractViz
{
public:
	typedef enum { okToCenter, dontCenter  } CenterType;
	typedef enum { forceFancy, normalFancy } FancyType;

	AbstractViz(int argc, char *argv[], char *argv0, FancyType, CenterType);
	virtual ~AbstractViz();

	virtual void effect() = 0;

protected:
	enum viz_options
	{
		reverse = 0x0001,
		center  = 0x0002,
		once    = 0x0004,
		fancy   = 0x0008,
	};

	void putns(const char *text, int n);

	zRect  m_bounds;
	int    m_flags;
	int    m_nSkip;
	int    m_nDelay;
	int    m_nColor;
	int    m_nPaletteDefs;
	int   *m_palette;
	char   m_text[BUFFERSIZE];
	size_t m_nTextSize;
	ushort m_exitCode;
};

/*
 * the marquee scrolls a text in both directions (with optional Strobe)
*/
class Marquee: public AbstractViz
{
public:
	Marquee(int argc, char *argv[], char *argv0);
	void effect();
private:
	void left();
	void right();
};

/*
 * the strobe cycles through color palettes to create a beacon illusion
*/
class Strobe: public AbstractViz
{
public:
	Strobe(int argc, char *argv[], char *argv0);
	void effect();
};

class Glisten: public AbstractViz
{
public:
	Glisten(int argc, char *argv[], char *argv0);
	void effect();
};

class Bounce: public AbstractViz
{
public:
	Bounce(int argc, char *argv[], char *argv0);
	~Bounce();
	void effect();

private:
	char *m_eraseString;
};

#endif /* INCLUDED_VIZ_H */
