/*
 * This file is part of VizPak (PEX)
 *
 * Copyright (C) 1995-1997 by Branislav L. Slantchev
 * A Product of Silicon Creations, Inc.
 *
 * This file is distributed under the terms and conditions of the GNU
 * General Public License. For more information, refer to the file
 * Copying.Doc which is included in the archive.
*/
#include "vizpak.h"
#include "pblsdk.h"

#ifndef PB_SDK
	#include <conio.h>
	#include <dos.h>
#else
	#include "pblibc.h"
#endif

Strobe::Strobe(int argc, char *argv[], char *argv0)
	:AbstractViz(argc, argv, argv0, AbstractViz::forceFancy,
				 AbstractViz::okToCenter)
{
}

void
Strobe::effect()
{
	for( ;; )
	{
		for( int i = 0; i < m_nPaletteDefs; ++i )
		{
			gotoxy(m_bounds.a.x, m_bounds.a.y);
			textattr(m_palette[i]);
			cprintf(m_text);
			if( 0 != (m_exitCode = PeekChar())) return;
			delay(m_nDelay);
		}
		if( m_flags & once ) break;
	}
}
