/*
 * This file is part of VizPak (PEX)
 *
 * Copyright (C) 1995-1997 by Branislav L. Slantchev
 * A Product of Silicon Creations, Inc.
 *
 * This file is distributed under the terms and conditions of the GNU
 * General Public License. For more information, refer to the file
 * Copying.Doc which is included in the archive.
*/
#include "vizpak.h"
#include "pblsdk.h"

#ifndef PB_SDK
	#include <string.h>
	#include <conio.h>
	#include <dos.h>
#else
	#include "pblibc.h"
#endif

Marquee::Marquee(int argc, char *argv[], char *argv0)
	:AbstractViz(argc, argv, argv0, AbstractViz::normalFancy,
				 AbstractViz::dontCenter)
{
	// adjust text (put a leading or trailing blank)
	// we will assume that we have enough space in m_text
	if( m_flags & reverse )
	{
		memmove(&m_text[1], m_text, m_nTextSize+1);
		m_text[0] = ' ';
	}
	else strcat(m_text, " ");
	// adjust to new text length
	m_nTextSize++;
}

void
Marquee::effect()
{
	if( m_flags & reverse ) left();
	else right();
}

void
Marquee::left()
{
	for( ;; )
	{
		int nChars, step = 1;
		int idxChar = m_nTextSize - 1;

		for( int x = m_bounds.a.x; x < m_bounds.b.x; )
		{
			gotoxy(x, m_bounds.a.y);
			nChars = m_nTextSize - idxChar;

			if( m_bounds.b.x - x < nChars )
			{
				nChars -= step;
				step++;
			}
			putns(&m_text[idxChar], nChars);

			if( 0 != (m_exitCode = PeekChar()) ) return;

			delay(m_nDelay);

			if( 0 != idxChar ) idxChar--;
			else x++;
		}

		if( m_flags & once ) return;
	}
}

void
Marquee::right()
{
	for( ;; )
	{
		int   x, skip = 1;
		char *p;

		for( x = m_bounds.b.x, p = m_text;
			 EOS != *p;
			 x = ((x > m_bounds.a.x) ? x - 1 : m_bounds.a.x) )
		{
			gotoxy( x, m_bounds.a.y );
			if( x == m_bounds.a.x )
			{
				if( skip ) skip = 0;
				else p++;
			}
			putns(p, m_bounds.b.x - x + 1);

			if( 0 != (m_exitCode = PeekChar()) ) return;

			delay(m_nDelay);
		}

		if( m_flags & once ) return;
	}
}
