/*
 * This file is part of VizPak (PEX)
 *
 * Copyright (C) 1995-1997 by Branislav L. Slantchev
 * A Product of Silicon Creations, Inc.
 *
 * This file is distributed under the terms and conditions of the GNU
 * General Public License. For more information, refer to the file
 * Copying.Doc which is included in the archive.
*/
#include <stdio.h>
#include <string.h>
#include "file.h"
#include "utils.h"

typedef struct
{
	char copyright[80];
	char idString[7];
	long numCookies;
} COOKIE_IDX;

static COOKIE_IDX header =
{
 "Baked Cookie File.\n\rCopyright (c) 1997 by Branislav L. Slantchev\n\x1A",
 "SC-IDX", 0L
};

static char *progname;

	int
main( int argc, char *argv[] )
{
	FILE *fin = NULL, *fout = NULL;
    long numCookies;
    char path[80] = "";

	progname = strlwr(file_name(*argv));
	fprintf(stderr, "Cookie Baker v1.0r1\n");
	fprintf(stderr, "  Copyright (C) 1995-1997 by Branislav L. Slantchev\n");
	fprintf(stderr, "  A Product of Silicon Creations [%s]\n", __DATE__ );
	if( 2 > argc ) fail("\n%s: must specify a file name\n", progname);

	file_chext(path, strlwr(argv[1]), ".idx");
	if( NULL == (fin = fopen(argv[1], "rt")) )
		fail("\n%s: couldn't bake the cookie file '%s'\n", progname, argv[1]);
	if( NULL == (fout = fopen(path, "wb")) )
		fail("\n%s: couldn't create the baking file '%s'\n", progname, path);

	/* first, we need to create the header for the baked file */
	fwrite(&header, sizeof(header), 1, fout);

	/* now start reading the raw file and calculate the offsets */
	printf("\nNow baking cookie:          ");
	for( numCookies = 0L; ; numCookies++ )
	{
		char aLine[255];
		char *clock = "|/-\\";

		long curOfs = ftell(fin);
		if( NULL == fgets(aLine, sizeof(aLine), fin) ) break;
		if( 80 < strlen(aLine) )
		{
			fclose(fin);
			fclose(fout);
			unlink(path);
			fail("\n%s: line %ld exceeds max length:\n'%s'\n",
					progname, numCookies + 1, aLine);
		}
		fwrite(&curOfs, sizeof(long), 1, fout);
		printf("\b\b\b\b\b\b\b\b\b%c %5ld %c",
			clock[(int)numCookies%4], numCookies, clock[(int)numCookies%4]);
	}

	header.numCookies = numCookies;
	rewind(fout);
	fwrite(&header, sizeof(header), 1, fout);

	printf("\rI baked %ld cookies (I hope you like them!)\n", numCookies);
	fclose(fin);
	fclose(fout);
	return 0;
}
