// PB/Scan v1.1 -- PowerPEX Edition
// Written by Gregory Gulick
// Copyright 1994 by Gregory Gulick

#include <pb_sdk.h>

#define VERSION "1.11"

// The following CONSTants are C's TRUE and FALSE which are different
// from Philippe's.  These are TRUE and FALSE as defined by many of
// C' routines.

#define CTRUE 0
#define CFALSE -1

#define NONE 0
#define ZIP 1
#define ARJ 2

void main(int argc, char **argv);				// Main body
void read_configuration(void);					// Read PBSCAN.CFG
void error_log(char error_type[80]);			// Error report file
void read_pbscan_log(void);						// Read PBSCAN.LOG
void duplicate_search(void);					// Search for file dupes
int import_description(int file_number);		// Has file description?
void process_uploads(void);						// Start processing uploads
void calculate_upload_credit(void);				// Calculate upload credit.
void logo(void);							    // Beta test logo.
void scan_files(void);                          // Scan files.
void clean_work_directory(void);				// Clean out work directory
void get_pex_directory(char command_line[100]); // Get pex directory string
void check_archive_conversion(void);			// Check for archive cvsion
void determine_comp_type(void);					// Determine compression type

// Global Variable Declarations

	// Configuration Information :

	char work_directory[85];					// Directory for UnZips
	char board_directory[85];                   // Directory for BBS Files
	char file_listing[85];						// File Listing Name
	int upload_multiplier;						// Upload Multiplier. (*)
	int want_scan_files;						// Scan files for virus?
	char thd_dir[85];                           // Directory for TranScan
	char uploaded_by[85];						// Uploaded By String (*)
	int maxlines;								// Max lines in File Desc
	int multi_node;								// Running multi-node?
	int default_archive;						// Default archive format

	char reg_name[50];                          // Is program registered?
	char PEX_DIRECTORY[100];					// Pex directory

	// Upload statistics and information

	char upload_directory[85];					// Upload Directory.
	int total_uploaded;							// Number uploaded
	long total_bytes;							// Total bytes uploaded

	// Uploaded file information

	char filename[100][80];						// Array of filenams len=80
	long filesize[100];    			 			// Size of files in Kbytes
	int file_deleted[100];						// Deleted boolean
	char file_delete_reason[100][80];			// Reason for file deletion
	int file_compression[100];					// Compression Type
	char file_comp_command[100][100];			// Commpression Command

	char ch;

//
// Variable notes:
// ---------------
//
// 	The lines listed with a (*) at the end, indicate that an empty
//	value for that variable denotes the disabling of the designated
//	function.
//

void read_configuration(void)
{
	FILE *fp;                               	// *fp is the file pointer.
	int config_position = 1;					// Location in PBSCAN.CFG
	char data[85];		   						// Var for reading file.
	char dir_check[150];                        // Var for DIR existance

	fp = fopen("PBSCAN.CFG","r");				// Open CONFIG File

	while (fgets(data,80,fp) != NULL)
	{
		if (strstr(data,";") == NULL) {
			switch(config_position) {
				case 1 : strncpy(work_directory,data,strlen(data)-1);break;
				case 2 : strncpy(board_directory,data,strlen(data)-1);break;
				case 3 : strncpy(file_listing,data,strlen(data)-1);break;
				case 4 : upload_multiplier = atoi(data);break;
				case 5 : want_scan_files = atoi(data);break;
				case 6 : strncpy(thd_dir,data,strlen(data)-1);break;
				case 7 : strncpy(uploaded_by,data,strlen(data)-1);break;
				case 8 : maxlines = atoi(data);break;
				case 9 : multi_node = atoi(data);break;
			   case 10 : default_archive = atoi(data);break;
			}
			++config_position;					// Increment config_position
		}
	}
	fclose(fp);									// Close CONFIG file
	strcpy(dir_check,work_directory);
	strcat(dir_check,".");
    if (access(dir_check,00) != 0) {            // Does work dir exist?
       strcpy(dir_check,"*Q *Z MD ");
	   strcat(dir_check,work_directory);
       ch=WaitKey();
       MenuFunction(MENU_SHELL,dir_check);      // If not, create it.
       error_log("Work directory did not exist.  Created.");
    }
}

void read_pbscan_log(void)
{

	// Variable used in this function and their purposes:
	// --------------------------------------------------
	// *fp - File pointer used for all file access routines.
	// upload_log[100] - string with the actual PBSCAN.LOG filename and path.
	// *s_loc - Space Location pointer.
	// text[255] - String for reading the contents of PBSCAN.LOG
	// *temp - Temporary pointer used for string searches.
	// *ftp - Filename Temporary Pointer.  Same as above.
	// loop_var - Generic loop variable.

	FILE *fp;
	char upload_log[100], *s_loc, text[255], *temp, *ftp, *endptr, ch;
	int loop_var;

	strcpy(upload_log,board_directory);         // Get filename and directory
	strcat(upload_log,"PBSCAN.LOG");			// for PBSCAN.LOG.
	if (access(upload_log,00) == CTRUE) {		// If PBSCAN.LOG exists...
		fp = fopen(upload_log,"r");				// Open PBSCAN.LOG
			fgets(text,200,fp);					// Read 90 characters.
		fclose(fp);								// Close PBSCAN.LOG

		// The for loop here is used to execute the entire procedure
		// twice, thus riding the string of the two initial spaces
		// which must be removed for obtaining the upload directory.

		for (loop_var = 0; loop_var < 2; ++ loop_var) {
			s_loc = strstr(text," ");			// Find the first space.
			++s_loc;							// Skip the space.
			strcpy(text,"\x0");					// Clear text variable.
			strcpy(text,s_loc);					// Move *s_loc to text
			s_loc = strstr(text," ");
		}

		// This procedure finds the last occurance of "\" and stores that
		// result into the pointer, s_loc which is then incremented to
		// include the backslash.  strncpy() is then called to copy the
		// contents of text for the lenght of text minus the length
		// of location of the backslash stored in s_loc.
		//
		// Note that strncpy() is used, but no terminating null is added.
		// This is because it is already present because the number of
		// characters to copy is equal to the length of the source string.
		// This is seen elsewhere in PB/Scan as well.

		s_loc = strrchr(text,'\\');
		++s_loc;
		strncpy(upload_directory,text,strlen(text) - strlen(s_loc));

		// This procedure re-opens PBSCAN.LOG and obtains the following
		// information:  The number of files uploaded, the uploaded
		// filenames, and the total bytes uploaded.

		total_uploaded = 0;						// Reset total uploads
		total_bytes = 0;						// Reset bytes uploaded

		fp = fopen(upload_log,"r");
			while (fgets(text,200,fp) != NULL) {
				++total_uploaded;				// Increment total uploaded
				temp = strrchr(text,'\\');
				++temp;							// Skip backslash
				ftp = strstr(temp, " ");

		// Determine actual filename without path and extra information.

				strncpy(filename[total_uploaded],temp,strlen(temp) - strlen(ftp));

		// Convert the string to a long integer.  Gets the size
		// of the file.

				++ftp;							// Skip the space
				filesize[total_uploaded] = strtol(ftp,&endptr,10);

		// Reset the file's deletion flag and delete reason string.

				file_deleted[total_uploaded] = CFALSE;
				strcpy(file_delete_reason[total_uploaded],"[NOT DELETED]");

				total_bytes = total_bytes + filesize[total_uploaded];
			}
		fclose(fp);
		if (BaudRate == 0) {                    // Querry PBSCAN.LOG delete
		   SetColor(WHITE);
		   printf("\n:: NOTE ::  It is important that you delete PBSCAN.LOG so that users do\n");
           printf("not get credit for other's uploads.  If you wish to delete PBSCAN.LOG now\n");
           printf("please press Y here, otherwise press N.\n\n");
		   printf("Delete PBSCAN.LOG? ");
           ch = WaitKey();
           if (toupper(ch) == 'Y')
			  remove(upload_log);
        }
        else
            remove(upload_log);
	}
	else {
		exit();									// No uploads?  Abort program.
	}
}

void duplicate_search(void)
{
	char proboard_log[100];						// ProBoard log filename.
	FILE *fp;									// File pointer.
	char text[100];								// String for read file.
	int lv;										// Loop variable.

	strcpy(proboard_log,board_directory);		// Set up filename for
	strcat(proboard_log,"PROBOARD.LOG");		// log file.

	if (access(proboard_log,00) == CFALSE) {		// No log file?  Report it.
		error_log("Could not find PROBOARD.LOG for duplicate search.\n           Continuing without duplicate file search.");
		return;
	}
	else {
		fp = fopen(proboard_log,"r");
			while (fgets(text,90,fp) != NULL) {
				if (strstr(text,"DUPE") != NULL) {
					for (lv = 0; lv <= total_uploaded; ++lv) {
						if (strstr(text,filename[lv]) != NULL) {
							file_deleted[lv] = CTRUE;
							strcpy(file_delete_reason[lv],"Duplicate file online.");

							// Duplicate file?  Take away upload credit:
							// Decrease number of files uploaded.

							total_bytes = total_bytes - filesize[lv];
						}
					}
				}
			}
		fclose(fp);
	}
}

int import_description(int file_number)
{

	// Variables used and their purposes in this function:
	//
	// *fp - File pointer to the FILE_ID and DESC files.
	// *fl - File pointer to File Listing.
	// file_id[80] - FILE_ID.DIZ with work directory path.
	// desc_sdi[80] - DESC.SDI with work directory path.
	// clean_directory[80] - String used for cleaning out work directory.
	// file_list[80] - The upload directory and file listing as used in config.


	FILE *fp, *fl;
	char file_id[80], desc_sdi[80], file_list[80];
	char text[255];

	if (file_compression[file_number] == NONE)	// If no file compression,
		return(CFALSE);							// return for manual desc.

	clean_work_directory();

	SetColor(WHITE);
	printf("\n ");
	SetColor(CYAN);
	printf("Uncompressing %s...",filename[file_number]);
	MenuFunction(MENU_SHELL,file_comp_command[file_number]);

	strcpy(file_id,work_directory);				// Define FILE_ID.DIZ and
	strcpy(desc_sdi,work_directory);			// DESC.SDI.
	strcat(file_id,"FILE_ID.DIZ");
	strcat(desc_sdi,"DESC.SDI");
	strcpy(file_list,upload_directory);
	strcat(file_list,file_listing);


	if (access(file_id,00) != CFALSE) {
		SetColor(WHITE);
		printf("\n    \007 \005Importing FILE_ID.DIZ.\n");
		if (access(file_list,00) == CFALSE)     // If file listing does not
			fl = fopen(file_list,"w");			// exist, create it.  If it
		else									// does exist, append to it.
			fl = fopen(file_list,"a");
		fp = fopen(file_id,"r");				// Open FILE_ID.DIZ
			fgets(text,90,fp);
			fprintf(fl,"%s %s", filename[file_number], text);
			while(fgets(text,90,fp) != NULL) {	// While not EOF,
				fprintf(fl,"+%s",text);			// Write FILE_ID.DIZ to FL
				if (strstr(text,"\n") == NULL)	// No new line?  PRINT ONE!
					fprintf(fl,"\n");
			}
												// Print uploaded by info
			if (strlen(uploaded_by) != 0)
				fprintf(fl, "+%s %s\n",uploaded_by, CurUser->name);
		fclose(fp);
		fclose(fl);
		clean_work_directory();
		return(TRUE);
	}
	if (access(desc_sdi,00) != CFALSE) {		// Procedure is same as above.
		SetColor(WHITE);
		printf("\n    \007 \005Importing DESC.SDI.\n");
		if (access(file_list,00) == CFALSE)
			fl = fopen(file_list,"w");
		else
			fl = fopen(file_list,"a");
		fp = fopen(desc_sdi,"r");
			fgets(text,90,fp);
			fprintf(fl,"%s %s", filename[file_number], text);
			while(fgets(text,90,fp) != NULL)
				fprintf(fl,"+%s",text);

			if (strlen(uploaded_by) != 0)
				fprintf(fl, "+%s %s\n",uploaded_by, CurUser->name);
		fclose(fp);
		fclose(fl);
		clean_work_directory();
		return(TRUE);
	}
	clean_work_directory();
	return(CFALSE);
}

void process_uploads(void)
{
	int lv, line_num, loop_var;						// Loop variables
	char desc[75][75], file_list[80], text[80];
	FILE *fp;

	strcpy(file_list,upload_directory);
	strcat(file_list,file_listing);

	for (lv = 0; lv <= total_uploaded; ++lv) {
		if (file_deleted[lv] != CTRUE) {
			if (import_description(lv) == CFALSE) {
				SetColor(WHITE);
				printf("\n\nPlease enter a description for %s.\n",filename[lv]);
				printf("You may enter up to %d lines.  When\n", maxlines);
				printf("finshed, press [");
				SetColor(YELLOW);
				printf ("Enter");
				SetColor(WHITE);
				printf("] on an empty line.\n\n");
				line_num = 0;
				do {
					++line_num;
					Input(text,40,INPUT_ALL);
					printf("\n");
					strcpy(desc[line_num],text);
				} while ((line_num < maxlines) && (strlen(text) !=0));
				if (line_num < maxlines)
					--line_num;
				if (access(file_list,00) == CFALSE)
					fp = fopen(file_list,"w");
				else
					fp = fopen(file_list,"a");
				fprintf(fp,"%s %s\n", filename[lv], desc[1]);
				if (line_num > 1) {
					for (loop_var=2;loop_var<=line_num;++loop_var)
						fprintf(fp,"+%s\n",desc[loop_var]);
				}
				if (strlen(uploaded_by) != 0)
					fprintf(fp,"+%s %s\n",uploaded_by,CurUser->name);
				fclose(fp);
			}
		}
	}
	if (upload_multiplier != 0)
		calculate_upload_credit();				// Calculate upload credit.
	printf("\007\nPress [\003Enter\007] to Continue.");
	ch = WaitKeys("\r");
}

void calculate_upload_credit()
{
	long baud =0;
	long ucredit = 0;
	long cps = 0;
	long temp = 0;
	long p_credit = 0;

	int time_left;								// Minutes remaining

	FILE *fp;      								// Badname file
	char data[100];								// String for reading file
	char filename[100];							// Badname filename
	bool ok_to_credit = TRUE;					// Okay to credit user?

	if (BaudRate == 0)							// Allows the program to
		baud = 14400;							// function in local mode.
	else
		baud = BaudRate;
	cps = l_div(baud,10);
	temp = l_div(total_bytes,cps);
	p_credit = l_div(temp,60);
	ucredit = l_mul(p_credit,upload_multiplier);
	++ucredit;

	// This next if statment opens BADNAME.PBS and checks if the current
	// user's name is located in it.  If so, no time will be credited
	// to the user's account.  Notice the string comparison.  A strnicmp
	// is used to compare the user's name to that of the name in the
	// badname file.  A numeric search is used because there is a good
	// chance that the name in the file will contain a \n in it, therefore
	// a search is done for only the length of the current user's name.

	strcpy(filename,PEX_DIRECTORY);
	strcat(filename,"BADNAME.PBS\x0");
	if (access(filename,00) == CTRUE) {	// Check for bad users
		fp = fopen(filename,"r");
		while(fgets(data,90,fp) != NULL) {
			if (strnicmp(data,CurUser->name,strlen(CurUser->name)) == 0)
				ok_to_credit = FALSE;
		}
		fclose(fp);
	}

	if (ucredit > TimeUntilEvent())				// Event sensitivity
		ucredit = TimeUntilEvent();

	time_left = TimeLeft();

	if (time_left > TimeUntilEvent())
		ucredit = 0;

	if (ok_to_credit == TRUE) {
		if (ucredit < 0)
			ucredit = 0;
		printf("\n\007 You have been credited %ld minutes.\n",ucredit);
		AddTime(ucredit);
	}
}

void scan_files(void)
{
	int x;                                      // Loop variable
	char scan[100];                             // Scan command
	char file_list[80];                         // File listing dir and name
	FILE *fl;                                   // File pointer for FILES.BBS

	strcpy(file_list,upload_directory);         // Location of FILES.BBS
	strcat(file_list,file_listing);             // FILES.BBS?

	SetColor(YELLOW);
	if (multi_node != 0) {					// If multi-node...
		printf("\n Activating THD ProScan...\n\n");
	}
	else {
		printf("\n Activating THD ProScan...");
		sleep(2);
		printf("\f");
	}

	for (x=1;x<=total_uploaded;++x) {           // Top loop for scanning
		if (file_deleted[x] == CFALSE) {        // If not deleted, scan
		   strcpy(scan,"*Q *X ");               // Quit, like command line
		   strcat(scan,thd_dir);                // THDPro's dir
		   strcat(scan,"THDPRO.EXE ");          // THDPRO.EXE
		   strcat(scan,upload_directory);       // Dir of uploaded file
		   strcat(scan,filename[x]);            // Filename to scan
		   if (default_archive == 1) 			// If want ZIP conversion
			   strcat(scan," TOZIP");		    // THD Pro convert to ZIP
		   else if (default_archive == 2)		// If want ARJ conversion
				strcat(scan," TOARJ");			// THD Pro convert to ARJ
		   strcat(scan," *P");					// Send port number
		   MenuFunction(MENU_SHELL,scan);       // Execute THD ProScan
		   if (ErrorLevel() != 0) {             // If failed...
			  file_deleted[x] = CTRUE;          // Turn DELETE flag on
			  if (access(file_list,00) == CFALSE)
				  fl = fopen(file_list,"w");    // Create if not exist
			  else
				  fl = fopen(file_list,"a");    // Append if exist

			  // If fails virus scan, place a warning in file listing

			  fprintf(fl,"%s >> Failed Virus/Integrity Scan!\n",filename[x]);
			  fprintf(fl,"%s %s\n",uploaded_by, CurUser->name);
			  fclose(fl);

			  // If fails virus scan in multi-node, inform the user.
			  if (multi_node != 0) {
				SetColor(RED);
				printf("   %s Failed Virus/Integrity Check.\n",filename[x]);
			  }
		   }
		   if ((ErrorLevel() == 0) && (multi_node != 0)) {
			SetColor(CYAN);
			printf("   %s Passed Virus/Integrity Check.\n",filename[x]);
		   }
		}
	}
	if (multi_node != 0) {
		printf("\n\007Press any key to resume \003PB/Scan\007.");
		ch=WaitKey();
	}
}

void error_log(char error_type[80])
{
	FILE *fp;
	time_t current_time;                    	// Define time structure

	time(&current_time);						// Put time at the address
												// of current_time.

	if (access("PBSCAN.ERR",00) == CFALSE)
		fp = fopen("PBSCAN.ERR","w");
	else
		fp = fopen("PBSCAN.ERR","a");
			fprintf(fp,"-------------------------------------------------------------------------\n");
			fprintf(fp,"PB/Scan experienced an error on %s",ctime(&current_time));
			fprintf(fp,"   Error : %s\n",error_type);
			fprintf(fp,"-------------------------------------------------------------------------\n");
		fclose(fp);
}

void logo(void)
{
	int name_len=0, board_len=0;                // Len of name and board
	FILE *dfp;                                  // Decrypt file pointer
	char key_name[100], key_board[100];         // Registration variables
	char test_name[100];                        // Name for comparison
	char data[100], ch;                         // String for reading file
	int x,y;                                    // Generic loop variables
	char filename[100];							// Filename string
	char space[100];
	char reg[100];
	int reg_flag=0;

	strcpy(key_name,"");
	strcpy(test_name,"");
	strcpy(key_board,"");
	strcpy(data,"");

	strcpy(reg_name,"deretsigernU");            // Default name is unreg
	strrev(reg_name);                           // Revers the sucker

	strcpy(filename,PEX_DIRECTORY);
	strcat(filename,"POWERPEX.KEY\x0");
	if (access(filename,00) == CTRUE) {   		// If there is a key...
	   dfp=fopen(filename,"r");           		// Open the key
	   fgets(data,5,dfp);                       // Read name length
	   name_len=atoi(data);                     // Convert name len to int
	   fgets(data,5,dfp);                       // Read board length
	   board_len=atoi(data);                    // Convert board len to int
	   if ((name_len > 2) && (board_len > 1)) { // If valid lengths
		  strcpy(key_name,"\x0");               // Clear key_name
		  strcpy(key_board,"\x0");              // Clear board_name
		  for (x=0;x!=name_len;++x) {           // Loop to get sysop name
			  ch = fgetc(dfp);                  // Read sysop name character
			  key_name[x]=ch;                   // Move it to the proper loc
			  for (y=1;y<31;++y) {              // Loop to read junk
                  ch = fgetc(dfp);              // Read junk
			  }
          }
          key_name[x]=NULL;
          strrev(key_name);
		  for (x=0;x!=board_len;++x) {
              ch = fgetc(dfp);
			  key_board[x]=ch;
			  for (y=1;y<31;++y) {
				  ch = fgetc(dfp);
			  }
		  }
		  key_board[x]=NULL;
		  strrev(key_board);
	   }
	   if((strcmp(key_name,Config->sysopname) == 0) && (strcmp(key_board,Config->bbsname) ==0)) {
		   strcpy(reg_name,key_name);
		   reg_flag=1;
	   }

	   fclose(dfp);
	}

	printf("\f");
	strcpy(space,"                          ");
	SetColor(BLUE);
	printf("%s  PB/Scan - Version 1.1\n",space);
	strcpy(space,"            ");
	SetColor(CYAN);
	printf("%sA PowerPEX Developed by Gregory Gulick and Gil Gulick\n",space);
	strcpy(space,"                 ");
	SetColor(MAGENTA);
	printf("%sWritten by Gregory Gulick  Copyright 1994",space);
	SetColor(WHITE);
	printf("\n\n");
	strcpy(reg,"Registered to ");
	strcat(reg,reg_name);
	for (x=1;x!=(40-(strlen(reg)/2));++x)
		printf(" ");
	if (reg_flag == 1)
		SetColor(YELLOW);
	else
		SetColor(0x11);
	printf("%s\n",reg);
}

void clean_work_directory(void)
{

	// This procedure deletes all occurances of FILE_ID.DIZ and DESC.SDI.

	char filename[100];

	strcpy(filename,work_directory);
	strcat(filename,"FILE_ID.DIZ\x0");
	remove(filename);
	strcpy(filename,work_directory);
	strcat(filename,"DESC.SDI\x0");
	remove(filename);
}

void get_pex_directory(char command_line[100])
{
	char *location, *locations;

	if ((location = (char *) calloc(1,100)) == NULL){
		error_log("Out of memory!\n");
		exit();
	}

	locations = location;

	location = strrchr(command_line,'\\');
	strncpy(PEX_DIRECTORY, command_line,
		strlen(command_line)-strlen(location)+1);

	free(locations);
}

void check_archive_conversion(void)
{
	int loop;
	char test_file[100], new_filename[100], *temp;

	for (loop = 1; loop <= total_uploaded; ++loop) {
		strcpy(test_file,"\x0");
		strcpy(test_file,upload_directory);
		strcat(test_file,filename[loop]);
		strcat(test_file,"\x0");

		// The next condition statement tests if the file does not exist,
		// AND if the name has a period in it.

		if ((access(test_file,00) != CTRUE) &&
			(strstr(test_file,".") != NULL)) {
			temp = strrchr(test_file,'.');		// Find the period
			++temp;								// Include period
			strncpy(new_filename,test_file,strlen(test_file)-strlen(temp));

			// This next line adds a terminating null to new_filename[]
			// since strncpy() doesn't.

			new_filename[strlen(test_file) - strlen(temp)] = '\x0';

			// This procedure adds the appropriate extension depending on
			// the deault_archive setting.

			if (default_archive == ZIP)
				strcat(new_filename,"ZIP\x0");
			else if (default_archive == ARJ)
				strcat(new_filename,"ARJ\x0");

			// This tests if the new filename exists.  If so, let the new
			// filename replace the existing filename and use it from here
			// on out.

			if (access(new_filename,00) == CTRUE) {
				temp = strrchr(new_filename,'\\');
				++temp;							// Skip backslash
				strcpy(filename[loop],temp);
			}

		}
	}
}

void determine_comp_type()
{

	// Determine the type of file compression used on the file.
	// The deault if none (0).
	//
	// If a compression type is found, the shell string for that
	// compression type is generated.


	int loop;

	for (loop = 1; loop <= total_uploaded; ++loop) {
		file_compression[loop] = NONE;
		strcpy(file_comp_command[loop],"\x0");
		if (strstr(filename[loop],".ZIP") != NULL) {
			file_compression[loop] = ZIP;
			strcat(file_comp_command[loop],"*Q *Z PKUNZIP ");
			strcat(file_comp_command[loop],upload_directory);
			strcat(file_comp_command[loop],filename[loop]);
			strcat(file_comp_command[loop]," FILE_ID.DIZ DESC.SDI ");
			strcat(file_comp_command[loop],work_directory);
		}
		else if (strstr(filename[loop],".ARJ") != NULL) {
			file_compression[loop] = ARJ;
			strcat(file_comp_command[loop],"*Q *Z ARJ X ");
			strcat(file_comp_command[loop],upload_directory);
			strcat(file_comp_command[loop],filename[loop]);
			strcat(file_comp_command[loop]," ");
			strcat(file_comp_command[loop],work_directory);
			strcat(file_comp_command[loop]," FILE_ID.DIZ DESC.SDI ");
		}
	}
}

void main(int argc, char **argv)
{
	++argc;										// Shut off warning.
	get_pex_directory(argv[0]);             	// Get PEX Directory
	if (access("PBSCAN.CFG",00) == CTRUE) {		// If config file exists...
		SuspendTimer();							// Suspend system timer
		read_configuration();                   // Read config file
		read_pbscan_log();                      // Read PBSCAN.LOG
		duplicate_search();                     // Search for dupes
		if (want_scan_files == TRUE)			// If want a scan...
			scan_files();						// ... Scan files.
		check_archive_conversion();				// Check archive conversion
		determine_comp_type();					// Determine compression type
		logo();									// Display logo info
		process_uploads();                      // Begin process
		RestartTimer();          				// Restart system timer
	}
	else
		error_log("PBSCAN.CFG was missing.  Program halted.");


}
