/*
        PB_TOOLS.C

        Updates:

        1993 aug 22 sun: Edwin Groothuis
                            Created
        1993 aug 22 sun: Edwin Groothuis
                            Added clrscr
                            Added ReadLine
                            Added Loc_kbhit
                            Added kbhit
        1993 sep 26 sun: Edwin Groothuis
                            Added WaitEnter
                            Added Title
        1994 feb 14 mon: Edwin Groothuis
                            Added hex2long
                            Added ToUpper
                            Added ToLower
        1994 feb 26 sat: Edwin Groothuis
                            Added hex2word
        1994 mar 07 mon: Edwin Groothuis
                            Added WaitInit
                            Added WaitUpdate
                            Added WaitDone
        1994 mar 09 wed: Edwin Groothuis
                            Added UpperAll
        1994 mar 29 tue: Edwin Groothuis
                            Added FileExist
        1994 sep 13 tue: Edwin Groothuis
                            Added CRC32 routines
                            Added FindUser
                            Added FindUserAlias
                            Added FindUserName
*/

#include    <pb_sdk.h>
#include    <pb_tools.h>


char    waitkeys[4]="\\|/-";
int     Wait;



void clrscr(void)
{
    printf("\f");
}


char    *ReadLine(s,len,f)
FILE    *f;
int     len;
char    *s;
{
    char    c;
    int     i;

    strcpy(s,"");i=len;
    while (((c=getc(f))!='\n')&&i--)
    {
        strncat(s,&c,1);
        if (feof(f)) break;
    }
    return s;
}

             


int     Loc_kbhit(void)
{
    return ScanKey();
}


int     kbhit(void)
{
    return PeekChar();
}


void    WaitEnter(void)
{
    printf("\007Press \003[Enter]\007 to continue\t");
}

void    Title(const char *s)
{
    int     i;

    printf("\f\003%s",s);
    printf("\007 (c) \x01M\002a\x03v\004E\x05t\x06J\x07u\x04\n\007",s);
    for (i=0;i<strlen(s);i++)
        printf("");
    printf("\n\n");
}

word    hex2word(const char *s)
{
    word    hex;
    char    c[200];
    int     i;

    for (i=0;i<4;i++)
        c[i]=toupper(s[i]);
    c[strlen(s)]=0;

    hex=0;
    for (i=0;i<4;i++)
    {
        hex<<=4;
        hex+=(c[i]<':' ? c[i]-'0' : c[i]-'A'+10);
    }
    return hex;
}

long    hex2long(const char *s)
{
    long    hex;
    char    c[200];
    int     i;

    for (i=0;i<8;i++)
        c[i]=toupper(s[i]);
    c[strlen(s)]=0;

    hex=0;
    for (i=0;i<8;i++)
    {
        hex=l_shl(hex,4);
        hex+=(c[i]<':' ? c[i]-'0' : c[i]-'A'+10);
    }
    return hex;
}

char    *ToUpper(const char *s)
{
    char    c[200];
    int     i;

    for (i=0;s[i];i++)
        c[i]=toupper(s[i]);
    c[i]=0;

    return c;
}

char    *ToLower(const char *s)
{
    char    c[200];
    int     i;

    for (i=0;s[i];i++)
        c[i]=tolower(s[i]);
    c[i]=0;

    return c;
}


void    WaitInit(void)
{
    Wait=0;
}

void    WaitUpdate(void)
{
    ++Wait;
    Wait%=4;
    printf("\b%c",waitkeys[Wait]);
}

void    WaitDone(void)
{
    printf("\b \b");
}



void    UpperAll(void *s,int size)
{
    int     i;
    char    *t;

    t=(char *)s;
    if (size)
        for (i=0;i<size;i++)
            t[i]=toupper(t[i]);
    else
        for (i=0;t[i];i++)
            t[i]=toupper(t[i]);
}


bool    FileExist(char *s)
{
    FILE    *f;

    if ((f=fopen(s,"rb"))==NULL)
        return FALSE;
    else {
        fclose(f);
        return TRUE;
    }
}



long    GetLongint(FILE *f)
{
    int     i;
    char    s[100];
    byte    s0,s1,s2,s3,s4;
    long    l,l1,l2,l3,l4;

    s[4]=0;
    s1=fgetc(f);
    s2=fgetc(f);
    s3=fgetc(f);
    s4=fgetc(f);

    l1=s1;
    l2=s2;
    l3=s3;
    l4=s4;
    l=l1+l_shl(l2,8)+l_shl(l3,16)+l_shl(l4,24);
    return l;
}


/* Returns number of the userrecord or -1L if not found                       */
long    FindUser(char *_Name)
{
    FILE    *f;
    long    NameCrc,UserNumber,l;
    char    Name[100],s[100];
    int     i;

    strcpy(Name,_Name);
    UpperAll(Name,strlen(Name));
    NameCrc=-1L;
    for (i=0;i<strlen(Name);i++)
    {
        NameCrc=UpdCrc32(Name[i],NameCrc);
    }

    strcpy(s,Config->msgpath);
    strcat(s,"\\usersidx.bbs");
    if ((f=fopen(s,"rb"))==NULL)
        return -1L;
    UserNumber=-1L;
    while (!feof(f))
    {
        l=GetLongint(f);
        if (l==NameCrc)
        {
            UserNumber=l_div(ftell(f)-4L,8L);
            break;
        }
    }    
    fclose(f);
    return UserNumber;
}


/* Returns number of the userrecord or -1L if not found                       */
long    FindUserName(char *_Name)
{
    FILE    *f;
    long    NameCrc,UserNumber,l;
    char    Name[100],s[100];
    int     i;

    strcpy(Name,_Name);
    UpperAll(Name,strlen(Name));
    NameCrc=-1L;
    for (i=0;i<strlen(Name);i++)
    {
        NameCrc=UpdCrc32(Name[i],NameCrc);
    }

    strcpy(s,Config->msgpath);
    strcat(s,"\\usersidx.bbs");
    if ((f=fopen(s,"rb"))==NULL)
        return -1L;

    UserNumber=-1L;
    while (!feof(f))
    {
        l=GetLongint(f);
        if (l==NameCrc)
        {
            UserNumber=l_div(ftell(f)-4L,8L);
            break;
        }
        for (i=0;i<4;i++)           // just removing the
            fgetc(f);               // alias crc
    }    
    fclose(f);
    return UserNumber;
}


/* Returns number of the userrecord or -1L if not found                       */
long    FindUserAlias(char *_Name)
{
    FILE    *f;
    long    NameCrc,UserNumber,l;
    char    Name[100],s[100];
    int     i;

    strcpy(Name,_Name);
    UpperAll(Name,strlen(Name));
    NameCrc=-1L;
    for (i=0;i<strlen(Name);i++)
    {
        NameCrc=UpdCrc32(Name[i],NameCrc);
    }

    strcpy(s,Config->msgpath);
    strcat(s,"\\usersidx.bbs");
    if ((f=fopen(s,"rb"))==NULL)
        return -1L;

    for (i=0;i<4;i++)           // just removing the
        fgetc(f);               // username crc
    UserNumber=-1L;
    while (!feof(f))
    {
        l=GetLongint(f);
        if (l==NameCrc)
        {
            UserNumber=l_div(ftell(f)-4L,8L);
            break;
        }
        for (i=0;i<4;i++)           // just removing the
            fgetc(f);               // username crc
    }    
    fclose(f);
    return UserNumber;
}

