
/* ------------------------------------------------------------
 * Filename ............... demo.cpp
 *
 * General Purpose ........ Little cursor handling demo
 * ------------------------------------------------------------
 * First date ............. 03-30-95 10:21pm
 *
 * First in version ....... 1.00
 *
 * Written by ............. Alain Schellinck
 *
 * Copyright .............. Nephilim software development
 * ------------------------------------------------------------
 * Revisions:
 * ----------
 *
 *   Date   | By |                  Purpose                   |
 * ---------+----+--------------------------------------------+
 *          |    |                                            |
 *          |    |                                            |
 *          |    |                                            |
 */

/*-------------------------------------------------------------------------*/

#include <main.hpp>
#pragma hdrstop

/*-------------------------------------------------------------------------*/

#include <keyboard.hpp>

/*--] Code [---------------------------------------------------------------*/

/*
 * Routine   : main()
 * Purpose   : main function ;-)
 * ------------------------------------------------------------------------
 * Parameters: None
 * Return    : None
 *
 */

void main()
{
   printf("\f\7");
   printf("This is a little demonstration program for the cursor key routines.\n");
   printf("You will see the cursor now in the upper left corner of the screen.\n");
   printf("Use the CURSOR keys to move the cursor. In the upper right screen, you will\n");
   printf("see a <L> (= local key) or <R> (= remote key). This means that the function\n");
   printf("can detect from where the keypress came.   Press ESCAPE to cancel this demo.\n");

   TKeyboard = new KeyboardT;          // construct the Keyboard object

   IntT x = 1;
   IntT y = 1;

   GotoXY(x, y);

   FlgT loop = True;
   while(loop)
   {
      if(!TKeyboard->isEmpty())        // ok, we got a key
      {
         GotoXY(77, 1);
         if(TKeyboard->isLocalKey())   // is it a local keypress ?
            printf("<L>");
         else
            printf("<R>");

         switch(TKeyboard->get())
         {
            case KEY_UP    :           // cursor up
            {
               if(y > 1)
                  y--;
            }
            break;

            case KEY_DN    :           // cursor down
            {
               if(y < 24)
                  y++;
            }
            break;

            case KEY_LT    :           // cursor left
            {
               if(x > 1)
                  x--;
            }
            break;

            case KEY_RT    :           // cursor right
            {
               if(x < 80)
                  x++;
            }
            break;

            case KEY_ESC   :           // escape
            {
               loop = False;
            }
            break;
         }

         GotoXY(x, y);
      }
   }

   delete TKeyboard;
}

/*---------------------------] END OF THE CODE [---------------------------*/

