/*
 FileNav, File Library Navigator
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of FileNav.

 FileNav is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 FileNav is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with FileNav; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if !defined( __STRLIB_H )
	#include "strlib.h"
#endif

/*
 * Searches for s2 in s1, not case sensitive
*/
	char*
stristr( const char *s1, const char *s2 )
{
	char first = toupper(*s2);
	size_t len = strlen(s2);

	for( ; toupper(*s1) != first || strnicmp(s1,s2,len); ++s1 )
		if( EOS == *s1 ) return NULL;
	return (char *)s1;
}
