/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         ApplyMethod
*/
ApplyMethod: procedure
    arg method
    ok = VRMethod( "CN_1", "GetRecordList", "Selected", "record." )
    if ok = 1 then do
        do i = 1 to record.0
            caption = VRMethod( "CN_1", "GetRecordAttr", record.i, "Caption" )
            w = word( caption, 1 )
            call VRMethod w, method
        end
    end
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Focus
*/
Focus: /* for focusing on one object */
    call VRMethod "CN_1", "GetRecordList", "Selected", "record."
    if record.0 > 1 then do
        call VRMessage VRWindow(), "The focus cannot be set on" record.0 "windows at once.", "Error", "E"
    end
    else if record.0 = 0 then do
        call VRMessage VRWindow(), "You must select a window upon which to focus!", "Error", "E"
    end
    else do
        caption = VRMethod( "CN_1", "GetRecordAttr", record.1, "Caption" )
        w = word( caption, 1 )
        call VRMethod w, "SetFocus"
    end
return

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    window = VRWindow()
    call LoadVars
    call SetupWindow
    call LoadSecondaries
    call SetupObjects
    call Refresh
    drop window
return

LoadVars:
    parent = "?HWND1"
    common.1 = "Maximize       - {Alt}{F10}"
    common.2 = "Minimize       - {Alt}{F9}"
    common.3 = "Size           - {Alt}{F8}"
    common.4 = "Move           - {Alt}{F7}"
    common.5 = "Restore        - {Alt}{F5}"
    common.6 = "Close          - {Alt}{F4}"
    common.7 = "Window List    - {Ctrl}{Esc}"
    common.8 = "Deselect All   - {Ctrl}\"
    common.9 =  "Select All     - {Ctrl}/"
    common.10 = "Popup Menu     - {Shift}{F10}"
    common.11 = "Send to Focus  - !!"
    common.0 = 11
return

SetupWindow:
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return

LoadSecondaries:
    bottom = VRGet( window, "Height")
    window = VRLoad( VRWindow(), VRWindowPath(), "KeyWin" )
    call VRSet window, "Top", bottom
return

SetupObjects:
    call VRMethod "DDCB_Common", "AddStringList", "common."
return

/*:VRX         KeyWin_Close
*/
KeyWin_Close:
    call VRSet "KeyWin", "Visible", 0
return
/*:VRX         MN_Close_Click
*/
MN_Close_Click:
    ok = VRMethod( "CN_1", "GetRecordList", "Selected", "record." )
    if ok = 1 then do
        do i = 1 to record.0
            caption = VRMethod( "CN_1", "GetRecordAttr", record.i, "Caption" )
            w = word( caption, 1 )
            call VRMethod "Application", "SendKeyString", w, "{Alt}{F4}"
        end
    end
return

/*:VRX         MN_Focus_Click
*/
MN_Focus_Click:
    call Focus
return

/*:VRX         MN_Information_Click
*/
MN_Information_Click:
    call About VRWindow()
return

/*:VRX         MN_Maximize_Click
*/
MN_Maximize_Click:
    call ApplyMethod "Maximize"
return

/*:VRX         MN_Minimize_Click
*/
MN_Minimize_Click:
   call ApplyMethod "Minimize"
return

/*:VRX         MN_Restore_Click
*/
MN_Restore_Click:
    call ApplyMethod "Restore"
return

/*:VRX         MN_SendKey_Click
*/
MN_SendKey_Click:
    call SendKey
return

/*:VRX         MN_Shake_Click
*/
MN_Shake_Click:
    call Shake
return

/*:VRX         PB_1_Click
*/
PB_1_Click:
    call Shake
return

/*:VRX         PB_Add_Click
*/
PB_Add_Click:
    EFstring = VRGet( "EF_KeyString", "Value" )
    value = VRGet( "DDCB_Key", "Value" )
    if value <> "" then do
        if VRGet( "Ctrl", "Set" ) then do
            EFstring = EFstring || "{Ctrl}"
        end
        if VRGet( "Alt", "Set" ) then do
            EFstring = EFstring || "{Alt}"
        end
        if VRGet( "Shift", "Set" ) then do
            EFstring = EFstring || "{Shift}"
        end
        EFstring = EFstring || value
    end

    value = VRGet( "DDCB_Common", "Value")
    if value <> "" then do
        last = words( value )
        word = word( value, last )
        EFString = EFString || word
    end

    call VRSet "EF_KeyString", "Value", EFstring
    call VRSet "DDCB_Key", "Value", ""
    call VRSet "DDCB_Common", "Value", ""

return

/*:VRX         PB_Focus_Click
*/
PB_Focus_Click:
    call ApplyMethod "SetFocus"
return
/*:VRX         PB_Send_Click
*/
PB_Send_Click:
    keys = VRGet( "EF_KeyString", "Value" )
    x = 1
    do while keys <> ""
        parse var keys tree.x "!!" keys
        x = x + 1
    end
    x = x - 1
    tree.0 = x

    call Focus
    do x = 1 to tree.0
        ok = VRMethod( "Application", "SendKeyString", , tree.x )
    end
return

/*:VRX         PB_SendKey_Click
*/
PB_SendKey_Click:
    call SendKey
return
/*:VRX         PB_Update_Click
*/
PB_Update_Click:
    call Refresh
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Refresh
*/
Refresh:
    w = VRWindow()
    call VRSet w, "Pointer", "Wait", "ShowHints", 0, "StatusText", "Refreshing..."
    call VRSet "CN_1", "Painting", 0
    call VRMethod "CN_1", "RemoveRecord", "All"
    /* Start with the desktop's first child */
    window = "?HWND1"
    firstChild = VRGet( window, "FirstChild" )
    call AddChildren firstChild, ""
    call VRSet "CN_1", "Painting", 1
    call VRSet w, "Pointer", "<default>", "ShowHints", 1, "StatusText", ""
return

AddChildren: procedure
    parse arg w, parentRec
    do while w <> ""
        if VRGet( w, "Visible" ) = 1 then do          
            caption = w || " " || VRGet( w, "ClassName" ) || "0a"x || VRGet( w, "Caption" ) 
            rec = VRMethod( "CN_1", "AddRecord", parentRec, "Last", caption )
            firstChild = VRGet( w, "FirstChild" )
            call AddChildren firstChild, rec
        end
        w = VRGet( w, "Sibling" )
    end
return
/*:VRX         SendKey
*/
SendKey:
    Call VRSet "KeyWin", "Visible", 1
return

/*:VRX         Shake
*/
Shake:
    delta = 50
    ok = VRMethod( "CN_1", "GetRecordList", "Selected", "record." )
    if ok = 1 then do
        do i = 1 to record.0
            caption = VRMethod( "CN_1", "GetRecordAttr", record.i, "Caption" )
            w = word( caption, 1 )
            left = VRGet( w, "Left" )
            top = VRGet( w, "Top" )

            call VRSet w, "Top", top - delta
            call VRSet w, "Top", top + 2 * delta
            call VRSet w, "Top", top 

            call VRSet w, "Left", left - delta
            call VRSet w, "Left", left + 2 * delta
            call VRSet w, "Left", left 
        end
    end
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

