/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Fini
*/
Fini:
    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window

    /* Halt the remaining threads
    */

    call VRMethod "Application", "ListThreads", "threads."
    do i = 1 to threads.0
        if( threads.i \= 1 )then do
            call VRMethod "Application", "HaltThread", threads.i
        end
    end
    if( threads.0 > 1 )then do
        call SysSleep 2
    end
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init: procedure expose InitArgs.
    /* Create the window
    */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"

    /* Rexx call to load 'SysLoadFuncs' function.
    */

    call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
    call SysLoadFuncs

    /* InitArgs.0 is the number of parameters passed to the application.
        and InitArgs.1 is the first parameter.
    */

    if( InitArgs.0 = 1 ) then do
        do i = 1 to InitArgs.1
            call VRMethod "Application", "StartThread", "child"
        end
    end

    /* VREvent( "N" ) sets the 'nowait' option for VREvent.
    */

    do while( VREvent( "N" ) <> "nop" )
        nop
    end

    call Update
return

/*:VRX         LB_Threads_Click
*/
LB_Threads_Click:
    call VRSet "PB_Halt", "Enabled", 1
return

/*:VRX         PB_Halt_Click
*/
PB_Halt_Click:
    /* Halt the specified thread.
    */

    tid = VRGet( "LB_Threads", "SelectedString" )
    call VRMethod "Application", "HaltThread", tid
    call VRMethod "LB_Threads", "DeleteString", tid
    call VRSet "PB_Halt", "Enabled", 0
    drop tid    
return
/*:VRX         PB_Spawn_Click
*/
PB_Spawn_Click:
    /* Start a thread
    */

    call VRMethod "Application", "StartThread", "child"
return

/*:VRX         Quit
*/
Quit:
    /* Close the application
    */

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         ShowMessage
*/
ShowMessage: procedure
    /* Show message from thread.
    */

    call VRMethod "LB_Messages", "Addstring", VRInfo( "Message" )
    call Update
return

/*:VRX         Update
*/
Update: procedure
    /* Update the 'Threads' list box.
    */

    call VRMethod "Application", "ListThreads", "threads."
    call VRMethod "LB_Threads", "Clear"
    do i = 2 to threads.0
        call VRMethod "LB_Threads", "AddString", threads.i
    end
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

