/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Fini
*/
Fini:
    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /* Create the window    
    */

    window = VRWindow()
    call VRSet window, "WindowState", "Minimized"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"

    /* Get the current process ID
    */

    myPID = VRMethod( "Application", "GetProcessID" )
    call VROptions "NoSyntax"
    
    drop window
return

/*:VRX         Quit
*/
Quit:
    /* Close the application
    */

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         TM_1_Trigger
*/
TM_1_Trigger:
    /*  If no window has the focus, set caption to blank
    */

    w = VRMethod( "Screen", "GetFocusWindow" )
    if w = "" then do
        text = ""
        signal SetText
    end

    /*  Get infomation about the window
    */

    pid = VRGet( w, "ProcessID" )
    id = VRGet( w, "ID" )

    /*  If this is a client window, return information about it's
        parent (the frame window) instead.
    */

    if id = 32776 then do
        w = VRGet( w, "Parent" )
    end

    /*  If the focus window is not part of this program, make
        it's caption part of our caption.
    */

    text = w
    if myPID \= pid then do
        text = w || '0a'x || VRGet( w, "Caption" )
    end
    else do
        text = w || '0a'x || "(Hocus focus)"
    end

SetText:
    call VRSet "TM_1", "Caption", text
    call VRSet "Window1", "Caption", text

eTM_1_Trigger:
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

