/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         CN_Files_DoubleClick
*/
CN_Files_DoubleClick:
/********************
    Refill the container with the contents of a subdirectory.
*/
    /*  Don't do anything if the user did not double click on 
        a record.
    */
    record = VRInfo( "Record" )
    if( record = "" ) then do
        signal CNDone
    end

    /*  Get the canonical form of the directory the user clicked on.
    */
    newDir = Dir || "\" || VRMethod( "CN_Files", "GetRecordAttr", record, "Caption" )
    if( \VRIsDir( newDir ) ) then do
        signal CNDone
    end
    
    /*  Update the display
    */
    Parent = ""
    Dir = VRParseFilePath( newDir )
    call FillList 

CNDone:
    drop record newDir
return

/*:VRX         CN_Files_ExpandTree
*/

CN_Files_ExpandTree:
/*******************
    Display the files in a subdirectory
*/
    Parent = VRInfo( "Record" )

    /*  Get the first child record of the parent. 
        If the first child of parent has no caption, then it's the
        dummy record-- remove it before adding the real records. If 
        there is a caption, we've already added children (and so there's
        nothing to do).
    */
    child = VRMethod( "CN_Files", "GetRecordAttr", parent, "FirstChild" )
    if( child <> "" ) then do
        caption = VRMethod( "CN_Files", "GetRecordAttr", child, "Caption" )
        if( caption <> "" ) then do
            signal ExpandDone
        end
        call VRMethod "CN_Files", "RemoveRecord", child
    end

    /*  Get the directory that the icon represents. This information
        happens to be the same as the record's Icon attribute.
    */
    savedDir = Dir
    Dir = VRMethod( "CN_Files", "GetRecordAttr", parent, "Icon" )
    call FillList
    Dir = savedDir

ExpandDone:
    drop child caption savedDir
return

/*:VRX         FillList
*/
/*  Fill the container with the contents of the current directory.
*/
FillList: procedure expose Fields. Parent Dir
    /*  Clear the container
    */
    call VRSet "Window1", "Pointer", "Wait"
    call VRSet "CN_Files", "Painting", 0
    if( Parent = "" ) then do
        call VRMethod "CN_Files", "RemoveRecord", "All"
    end

    file = VRDir( Dir || "\*", "SN", "D" )
    do while( file <> "" )
        parse var file size name
        if( ( name <> "." ) & ( ( name <> ".." ) | ( parent = "" ) ) ) then do
            fullpath =  Dir || '\' || name
            record = VRMethod( "CN_Files", "AddRecord", parent, , name, fullpath )
            call VRMethod "CN_Files", "SetFieldData", record, Fields.!icon, fullpath
            call VRMethod "CN_Files", "SetFieldData", record, Fields.!name, name
            call VRMethod "CN_Files", "SetFieldData", record, Fields.!size, size

            /*  Add a dummy record so that the record appears with a "+" 
                sign beside it in the tree views.
            */
            if( VRIsDir( fullpath ) & ( name <> ".." ) ) then do
                call VRMethod "CN_Files", "AddRecord", record
            end
        end
        file = VRDir( , "SN" )
    end

    call VRSet "CN_Files", "Painting", 1
    call VRSet "Window1", "Pointer", "<Default>"
return
/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init: procedure expose Fields. Dir Parent
    /*  Add detail view fields
    */
    Fields.!icon = VRMethod( "CN_Files", "AddField", "Icon", "Icon" )
    Fields.!name = VRMethod( "CN_Files", "AddField", "String", "Name" )
    Fields.!size = VRMethod( "CN_Files", "AddField", "String", "Size" )
    
    Dir = VRCurrDir()
    Parent = ""
    call FillList

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return

/*:VRX         MN_Arrange_Click
*/
MN_Arrange_Click:
    call VRMethod "CN_Files", "Arrange"
return

/*:VRX         MN_Ascend_Click
*/
MN_Ascend_Click:
    call VRSet "CN_Files", "Sort", "Ascending"
    call VRMethod "CN_Files", "SortRecords"
return

/*:VRX         MN_Descend_Click
*/
MN_Descend_Click:
    call VRSet "CN_Files", "Sort", "Descending"
    call VRMethod "CN_Files", "SortRecords"
return

/*:VRX         MN_Detail_Click
*/
MN_Detail_Click:
    call VRSet "CN_Files", "View", VRGet( VRInfo( "Object" ), "Caption" )
return

/*:VRX         MN_Flowed_Click
*/
MN_Flowed_Click:
    flowed = VRGet( "CN_Files", "Flowed" )
    call VRSet "CN_Files", "Flowed", \flowed
    call VRSet VRInfo( "Object" ), "Checked", \flowed
    drop flowed
return

/*:VRX         MN_Icon_Click
*/
MN_Icon_Click:
    call VRSet "CN_Files", "View", VRGet( VRInfo( "Object" ), "Caption" )
return

/*:VRX         MN_IconTree_Click
*/
MN_IconTree_Click:
    call VRSet "CN_Files", "View", VRGet( VRInfo( "Object" ), "Caption" )
return

/*:VRX         MN_Name_Click
*/
MN_Name_Click:
    call VRSet "CN_Files", "View", VRGet( VRInfo( "Object" ), "Caption" )
return

/*:VRX         MN_NameTree_Click
*/
MN_NameTree_Click:
    call VRSet "CN_Files", "View", VRGet( VRInfo( "Object" ), "Caption" )
return

/*:VRX         MN_ProdInfo_Click
*/
MN_ProdInfo_Click:
    call About VRWindow()
return

/*:VRX         MN_Small_Click
*/
MN_Small_Click:
    small = VRGet( "CN_Files", "MiniIcons" )
    call VRSet VRInfo("Object"), "Checked", \small
    call VRSet "CN_Files", "MiniIcons", \small
    drop small
return

/*:VRX         MN_Text_Click
*/
MN_Text_Click:
    call VRSet "CN_Files", "View", VRGet( VRInfo( "Object" ), "Caption" )
return

/*:VRX         MN_TextTree_Click
*/
MN_TextTree_Click:
    call VRSet "CN_Files", "View", VRGet( VRInfo( "Object" ), "Caption" )
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

