/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Bitmap_Click
*/
Bitmap_Click:
    if( VRGet( 'Bitmap', 'Set' ) = 1 )then do
        call EnableOptions
    end
    call CheckFields
return

/*:VRX         Cancel_Click
*/
Cancel_Click:
    InsertString = ""
    call Quit
return

/*:VRX         CheckFields
*/
CheckFields:
    if( VRGet( 'DefaultIcon', 'Set' ) = 1 & VRGet( 'File', 'Value' ) \= '' )then
        call VRSet 'OK', 'Enabled', 1
    else if( VRGet( 'ID', 'Value' ) \= '' & VRGet( 'File', 'Value' ) \= '' )then
        call VRSet 'OK', 'Enabled', 1
    else  
        call VRSet 'OK', 'Enabled', 0
return

/*:VRX         DefaultIcon_Click
*/
DefaultIcon_Click:
    if( VRGet( 'DefaultIcon', 'Set' ) = 1 )then do
        call DisableOptions
    end
    call CheckFields
return

/*:VRX         DisableOptions
*/
DisableOptions:
    call VRSet 'Preload', 'Enabled', 0
    call VRSet 'Moveable', 'Enabled', 0
    call VRSet 'Discardable', 'Enabled', 0
return

/*:VRX         EnableOptions
*/
EnableOptions:
    call VRSet 'Preload', 'Enabled', 1
    call VRSet 'Moveable', 'Enabled', 1
    call VRSet 'Discardable', 'Enabled', 1
return

/*:VRX         File_Change
*/
File_Change:
    call CheckFields
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return InsertString

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Icon_Click
*/
Icon_Click:
    if( VRGet( 'Icon', 'Set' ) = 1 )then do
        call EnableOptions
    end
    call CheckFields
return

/*:VRX         ID_Change
*/
ID_Change:
    call CheckFields
return

/*:VRX         Init
*/
Init:

    if( InitArgs.0 > 1 )then do
        file = InitArgs.2
        ext = translate( VRParseFilePath( file, "e" ) )
        if( ext = "ICO" )then do
            call VRSet 'Icon', 'Set', 1
        end; else do
            call VRSet 'Bitmap', 'Set', 1
        end
        call VRSet 'File', 'Value', file
    end

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         OK_Click
*/
OK_Click:
    id   = VRGet( 'ID', 'Value' )
    file = VRGet( 'File', 'Value' )
    if( VRGet( 'DefaultIcon', 'Set' ) = 1 )then do
        InsertString = 'DEFAULTICON' file
    end; else do
        if( VRGet( 'Bitmap', 'Set' ) = 1 )then
            type = 'BITMAP'
        else
            type = 'ICON'
         
        options = ''
        if( VRGet( 'Preload', 'Set' ) = 1 )then do
            options = options 'PRELOAD'
        end
        if( VRGet( 'Discardable', 'Set' ) = 1 )then do
            options = options 'DISCARDABLE'
        end
        if( VRGet( 'Moveable', 'Set' ) = 1 )then do
            options = options 'MOVEABLE'
        end

        InsertString = type id options file
    end
    call Quit
return

/*:VRX         PB_1_Click
*/
PB_1_Click: 
resource_file = VRFileDialog( VRWindow(), "Select Image Resource File (*.ico, *.bmp)", "Open", , , ,  )
ok = VRSet( "File", "Value", resource_file )
resource_ext = VRParseFilePath( resource_file, "E" )
if resource_ext = "*.bmp" then do
    ok = VRSet( "Bitmap", "Set", 1 )
end
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

/*:VRX         Window1_Help
*/
Window1_Help: 
    address cmd 'view progguid.inf Adding resources to your project'
return

