/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         __VXREXX____APPENDS__
*/
__VXREXX____APPENDS__: 

return

/*:VRX         CNCT_Database_FIni
*/
CNCT_Database_FIni: 
    procedure expose Globals.
 
    /*  Connect to the database
    */
    ok = VRMethod( "CNCT_Database", "Disconnect" )
    if( ok = 0 ) then do
        call VRMessage VRWindow(), "Could not close connection:",
            VRGet( "CNCT_Database", "Status" )
    end
return

/*:VRX         CNCT_Database_Init
*/
CNCT_Database_Init: 
    procedure expose Globals.
 
    /*  Connect to the database
    */
    ok = VRMethod( "CNCT_Database", "Connect" )
    if( ok = 0 ) then do
        call VRMessage VRWindow(), "Could not open connection:",
            VRGet( "CNCT_Database", "Status" )
    end
return

/*:VRX         DBCnct_Close
*/
DBCnct_Close:   
    Globals.!Status = "Abort"
    call Quit
return

/*:VRX         Fini
*/
Fini:
    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window

    if( Globals.!Status = "Abort" ) then do     
        return "Abort"
    end

    /* Check the database type
    */
    
    db2_set = VRGet( "RB_DB2", "Set" )
    
    /* Set the return value to the current database type
    */

    if( db2_set = 1 ) then do
        return_val = "DB2"
    end
    else do
        return_val = "WSQL"
    end

return return_val

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return "Abort"

/*:VRX         Init
*/
Init:
    /* Create the window
    */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         PB_CNCT_Cancel_Click
*/
PB_CNCT_Cancel_Click: 
    /* Globals.!Status = "Abort" causes the termination
       of the application.
    */

    Globals.!Status = "Abort"

    call Quit
return

/*:VRX         PB_CNCT_OK_Click
*/
PB_CNCT_OK_Click: 
    /* Globals.!Status = "Abort" will cause the application
       to halt.
    */

    Globals.!Status = "OK"

    call Quit
return

/*:VRX         Quit
*/
Quit:
    /* Execution will continue in Starter (Init) after 
       'Quit' is called.
    */

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

