/************************************************/
/* BUILDVRX.CMD : Build VX-REXX Desktop objects */
/************************************************/

address CMD

'@echo off'

call RXFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

call setlocal

target_dir   = ''
szVideoMode = ''

parse arg target_dir

folder_title = 'Watcom VX-REXX'

if( target_dir = '' )then
    target_dir = directory()
else do
    if( lastpos( "\", target_dir ) = length( target_dir ) ) then do
        target_dir = left( target_dir, length( target_dir ) - 1 )
    end
end

if( directory( target_dir ) = '' )then
    call Usage

target_dir = directory( target_dir )

/*
 * CleanIni -- Clean up the .INI file out of old VX-REXX information.
 *             Cleans up old beta stuff, too.
 */

CleanIni:
    call SysIni 'user', 'PMWP_ASSOC_FILTER', '*.VRP', 'DELETE:'
    call SysIni 'user', 'PMWP_ASSOC_TYPE', 'VX-REXX Project', 'DELETE:'
    call SysIni 'user', 'PMWP_ASSOC_TYPE', 'VRx Project', 'DELETE:'

    call sysini 'user', 'PM_Workplace:Templates', 'All:', 'ids.'
    do i = 1 to ids.0
        if( pos( 'REXX', ids.i ) \= 0 & pos( 'VX', ids.i ) \= 0 & ,
            pos( 'Project', ids.i ) \= 0 )then do
            call SysIni 'user', 'PM_Workplace:Templates', ids.i, 'DELETE:'
        end
    
        if( pos( 'VRx', ids.i ) \= 0 & pos( 'Project', ids.i ) \= 0 )then do
            call SysIni 'user', 'PM_Workplace:Templates', ids.i, 'DELETE:'
        end
    end

    call SysDestroyObject '<VXREXX_SAMPLES>'
    call SysDestroyObject '<VXREXX_TEMPLATE>'
    call SysDestroyObject '<VXREXX_PROJECTS>'
    call SysDestroyObject '<VXREXX_MACROS>'
    call SysDestroyObject '<VXREXX_FOLDER>'

    return
    
/*
 * FileExists
 */
    
FileExists:
    return( stream( arg(1), 'c', 'query exists' ) <> '' )

/*
 * Usage
 */

Usage:
    say ''
    say 'Usage: buildvrx [target_dir] [resolution]'
    say ''
    say '    target_dir   = path where Watcom VX-REXX has been installed'
    say '    resolution   = 640x480, 800x600, 1024x768 where 640x480 is the default'
    say ''
    say 'This program builds/rebuilds the various Workplace Shell objects'
    say 'needed to run WATCOM VX-REXX.'
    exit
