/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         DDCB_ApplyTo_Change
*/
DDCB_ApplyTo_Change:
    call ResetControls
return

/*:VRX         Fini
*/
Fini:
    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /* Create the window
    */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window

    /* Fill in all the DDCB's
    */

    call ResetControls
return

/*:VRX         MI_ProdInfo_Click
*/
MI_ProdInfo_Click:
    /* Display the product information as a multiline
       message dialog.
    */

    buttons.0 = 1
    buttons.1 = "Ok"
    
    message.0 = 4
    message.1 = "Chart Titles Sample"
    message.2 = ""
    message.3 = "This sample application shows some"
    message.4 = "of the text available on the chart."

    call VRMessageStem VRWindow(), "message.", ,
        "Product Information", "I", "buttons.", 1, 1    
return

/*:VRX         PB_Apply_Click
*/
/* The following procedure updates the chart according to
   the selections made in the entry fields.
*/

PB_Apply_Click:
    /* Read values from controls 
    */

    text = VRGet( "EF_Text", "Value" )
    color = VRGet( "EF_Color", "Value" )
    alignment = VRGet( "DDCB_Alignment", "Value" )

    call VRSet "WC_Titles", "Painting", 0

    /* Set all of the related attributes on the chart 
    */

    call VRMethod "WC_Titles", "SetOption", applyTo, text
    call VRMethod "WC_Titles", "SetOption", applyTo||"Color", color
    call VRMethod "WC_Titles", "SetOption", applyTo||"Alignment", alignment

    /* Reset the entry fields.
    */

    call ResetControls

    call VRSet "WC_Titles", "Painting", 1
return

/*:VRX         Quit
*/
Quit:
    /* Close the application
    */

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         ResetControls
*/
/* The following procedure fills in all the text fields and
   DDCB boxes according to the selected in the Apply_To DDCB.
*/

ResetControls:
    /* Find out which chart title we're talking about 
    */

    applyTo = VRGet( "DDCB_ApplyTo", "SelectedString" )
    
    /* Get all of the related attributes from the chart 
    */

    text = VRMethod( "WC_Titles", "GetOption", applyTo )
    color = VRMethod( "WC_Titles", "GetOption", applyTo||"Color" )
    alignment = VRMethod( "WC_Titles", "GetOption", applyTo||"Alignment" )

    /* Update the corresponding controls 
    */

    call VRSet "EF_Text", "Value", text
    call VRSet "EF_Color", "Value", color
    call VRSet "DDCB_Alignment", "Value", alignment
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

