/*Ŀ*/
/* File: SPACE.C                                          Date: 04/15/1998 */
/*Ĵ*/
/* Description: Program to report the total, used, and free disk space in  */
/*              the specified drive/partition.                             */
/* Entry:                                                                  */
/* Assumptions:                                                            */
/* Programmers: Wing F Yuen                                                */
/*                                                                         */
/* Compiler   : IBM VisualAge C++ compiles with                            */
/*                icc space.c                                              */
/*                                                                         */
/*              Microsoft C6 (#ifdef _MSC_VER) compiles with:              */
/*                cl /AS /Lp space.c os2.lib /link /pm:vio                 */
/*                                                                         */
/*              Watcom C/C++ v11.0                                         */
/*                wcl386 -3 space.c                                        */
/*                wcl -i=\watcom\h\os21x -x -2 -lp -bt=os2 space.c         */
/*                                                                         */
/* Notes      : All local   variables begin with a Capital letter          */
/*              All global  variables are prefixed with the letter 'g'     */
/*              All pointer variables are prefixed with the letter 'p'     */
/*              All user-supplied functions begin with a Capital letter;   */
/*                the only exception is main()                             */
/*Ĵ*/
/* Change Log :                                                            */
/**/
#define NDEBUG                                   /* define for production    */
#define MAX_BYTES_FREE (0x7FFFFFFF)              /* 2G - 1                   */

#define INCL_DOSFILEMGR                          /* File Manager values      */
#include <os2.h>
#include <stdio.h>
#include <ctype.h>                               /* toupper()                */
#include <string.h>
#include <io.h>                                  /* chsize(), _chsize()      */
#include <errno.h>                               /* errno                    */

/*Ŀ*/
/* Global variables                                                        */
/**/
#if (defined(_MSC_VER) || (!defined(__386__) && defined(__WATCOMC__)))

USHORT     gDriveNumber=0;                       /* Drive number             */
USHORT     gFSInfoLevel;                         /* File system data required*/
INT        gRc;
#else

ULONG      gDriveNumber=0;                       /* Drive number             */
ULONG      gFSInfoLevel;                         /* File system data required*/
APIRET     gRc;                                  /* Return code              */
#endif

FSALLOCATE gFSInfoBuf;                           /* File system info buffer  */
FSINFO     gFSVolBuf;
ULONG      gCluster, gTotal, gUsed, gFree;
FILE       *gHog;
char       gDriveVolume[12];
char       gDriveSerial[10];
char       gDriveFormat[8];                      /* FAT or HPFS              */
char       gDriveLetter;
char       gHogFileName[16];            /* dummy file to hold freespace < 2Gb*/
long       gOldHogSize;                          /* old size                 */
long       gNewHogSize;                          /* new size needed          */

/*Ŀ*/
/* Local function prototypes                                               */
/**/
int  CollectFileInfo (void);
void CollectVolInfo  (void);
long FileSize        (const char *FileSpec);
char *Split000       (ULONG Number, char Separator);
int  WriteNewHogFile (void);

/*Ŀ*/
/* main()                                                                  */
/**/
int main (int ArgC, char *ArgV[])
{
  ULONG  DriveMap;

  if (ArgC < 2) {
      #if (defined(_MSC_VER) || (!defined(__386__) && defined(__WATCOMC__)))

      gRc = DosQCurDisk( &gDriveNumber, &DriveMap);
      #else

      gRc = DosQueryCurrentDisk( &gDriveNumber, &DriveMap);
      #endif
      if (gRc)
           gDriveLetter = '\0';
      else gDriveLetter = 'A' + gDriveNumber - 1;
      gDriveNumber = 0L;                         /* current partition        */
  }
  else if (!strcmp( "/?", ArgV[1])) {
      printf( "\nSyntax: %s [DriveLetter[:]]\n" \
              "\nThe current drive will be use if no DriveLetter is given."
              "\nThe trailing colon is also optional.\n"
              "\nThis PUBLIC DOMAIN program helps you maintain the amount of"
              "\nfree space in the specified drive to under 2 GigaBytes. Thus"
              "\nstopping older programs using 32-bit signed integer math. "
              "\nfrom seeing space above 2Gb as negative.\n"
              "\nIf it can't find the SPACE.HOG file, which YOU must create,"
              "\nin the root directory of the specifed Drive, it becomes a"
              "\nrun-of-the-mill free space reporting utility.\n"
              "\nIf it sees the SPACE.HOG file, it will add or shrink this"
              "\n\"hogged\" space to maintain the 2 Gb freespace ceiling. It"
              "\nwill release all the space, by leaving a 0 byte SPACE.HOG, if"
              "\nthe resulting freespace is under the 2Gb ceiling.\n"
              "\nWarning: Please use this program and its source code at your"
              "\n         own risk. I provide no warranty of any kind. But"
              "\n         I do welcome bug reports via email to:\n"
              "\n         rrt0260@ibm.net or 74774.357@compuserve.com\n"
              "\nWing Yuen                                      %s\n"
              , ArgV[0], __DATE__);
      return 0;
  }                                              /* End if                   */
  else {
      gDriveLetter = toupper( *ArgV[1]);
      gDriveNumber = (ULONG)(gDriveLetter - 'A' + 1);
  }                                              /* End if                   */
  if (CollectFileInfo()) {
      return gRc;
  }
  gCluster = gFSInfoBuf.cSectorUnit * gFSInfoBuf.cbSector;
  gFree    = gFSInfoBuf.cUnitAvail  * gCluster;

  /*Ŀ*/
  /* User must create the SPACE.HOG file                                   */
  /**/
  sprintf( gHogFileName, "%c:\\space.hog", gDriveLetter);
  if (-1 != (gOldHogSize = FileSize( gHogFileName))) {
      #ifndef NDEBUG

      printf( "Free           = %ld\n", gFree      );
      #endif
      if (gFree > MAX_BYTES_FREE) {
          /*Ŀ*/
          /* Increase HogFile size                                         */
          /**/
          gNewHogSize = gOldHogSize + gFree - MAX_BYTES_FREE;
      }
      else {
          /*Ŀ*/
          /* Release some space in file HogFileName to leave MAX_BYTES_FREE*/
          /* byte of free space if possible.                               */
          /**/
          gNewHogSize = gOldHogSize - MAX_BYTES_FREE + gFree;
          if (gNewHogSize < 0) {
              gNewHogSize = 0;
          }
      }                                          /* End if                   */
      #ifndef NDEBUG

      printf( "OldHogSize     = %ld\n", gOldHogSize);
      printf( "NewHogSize     = %ld\n", gNewHogSize);
      printf( "Free           = %ld\n", gFree      );
      printf( "MAX_BYTES_FREE = %ld\n", MAX_BYTES_FREE);
      #endif
      if (gNewHogSize != gOldHogSize) {
          /*Ŀ*/
          /* Resize HogFileName                                            */
          /**/
          if (WriteNewHogFile()) {
              printf( __FILE__"/main(): Can't resize %s\n", gHogFileName);
          }
      }
  }
  /*Ŀ*/
  /* Refresh the space usage                                               */
  /**/
  if (CollectFileInfo()) {
      return gRc;
  }
  gFree  = gFSInfoBuf.cUnitAvail  * gCluster;
  gTotal = gFSInfoBuf.cUnit       * gCluster;
  gUsed  = gTotal - gFree;

  CollectVolInfo();

  printf( "\n SpaceHog v1.01 by Wing Yuen            compiled on %s", __DATE__);
  printf( "\n  Volume in drive %c is %-11s   Serial number is %s",
          gDriveLetter, gDriveVolume, gDriveSerial);
  printf( "\n --------------------------------------------------------------");
  printf( "\n%15s bytes per sector",       Split000( gFSInfoBuf.cbSector, ','));
  printf( "\n%15s bytes per cluster",      Split000( gCluster,            ','));
  printf( "\n%15s bytes total disk space", Split000( gTotal,              ','));
  printf( "\n%15s bytes used",             Split000( gUsed ,              ','));
  if (gNewHogSize) {
      printf( "\n*%14s bytes reserved in %s ",
              Split000( gNewHogSize,         ','), gHogFileName);
  }
  printf( "\n%15s bytes free\n",           Split000( gFree ,              ','));

  return 0;
}                                                /* main()                   */

/*Ŀ*/
/* CollectFileInfo()                                      Date: 04/15/1998 */
/*Ĵ*/
/* Description: Collect file information of gDriveLetter                   */
/* Returns    : Nothing                                                    */
/* Assumptions: None                                                       */
/* Programmers: Wing F Yuen                                                */
/**/
int CollectFileInfo (void)
{
  gFSInfoLevel = FSIL_ALLOC;          /* requests file system allocation info*/
  #if (defined(_MSC_VER) || (!defined(__386__) && defined(__WATCOMC__)))

  gRc = DosQFSInfo( gDriveNumber,
                    gFSInfoLevel,
                    (PBYTE)&gFSInfoBuf,
                    sizeof gFSInfoBuf);
  if (gRc) {
      printf( "DosQFSInfo error: Rc%ld", gRc);
      return 2;
  }
  #else

  gRc = DosQueryFSInfo( gDriveNumber,
                        gFSInfoLevel,
                        &gFSInfoBuf,
                        sizeof gFSInfoBuf);
  if (gRc) {
      printf( "DosQueryFSInfo error: Rc%ld", gRc);
      return 2;
  }
  #endif

  /*Ŀ*/
  /* On successful return, the data buffer FSInfoBuf contains a set of     */
  /* information about space allocation within the specified file system.  */
  /**/
  return 0;
}                                                /* CollectFileInfo()        */

/*Ŀ*/
/* CollectVolInfo()                                       Date: 04/15/1998 */
/*Ĵ*/
/* Description: Collect volume information of gDriveLetter                 */
/* Returns    : Nothing                                                    */
/* Assumptions: None                                                       */
/* Programmers: Wing F Yuen                                                */
/**/
void CollectVolInfo (void)
{
  #if defined (__IBMC__)

  UINT    VolSer;

  #else

  USHORT  VolSer;
  #endif

  #if (defined(_MSC_VER) || (!defined (__386__) && defined (__WATCOMC__)))

  gFSInfoLevel = FSIL_VOLSER;           /* requests volume/serial number info*/
  gRc = DosQFSInfo( gDriveNumber,
                    gFSInfoLevel,
                    (PBYTE)&gFSVolBuf,
                    sizeof gFSVolBuf);

  if (gRc) {
      printf( "DosQFSInfo error: Rc%ld", gRc);
      strcpy( gDriveSerial, "unknown");
      strcpy( gDriveVolume, "unknown");
      return;
  }

    #if (defined (__WATCOMC__) && !defined (__386__))

  VolSer = *((USHORT *)(&gFSVolBuf.fdateCreation));
  sprintf( gDriveSerial, "%04X:%04X",
           (USHORT)(VolSer >>16),
           (USHORT)(VolSer     ));
    #else

  sprintf( gDriveSerial, "%04X:%04X",
           (USHORT)(gFSVolBuf.ulVSN >>16),
           (USHORT)(gFSVolBuf.ulVSN     ));
    #endif
  #else

  gFSInfoLevel = FSIL_VOLSER;           /* requests volume/serial number info*/
  gRc = DosQueryFSInfo( gDriveNumber,
                        gFSInfoLevel,
                        &gFSVolBuf,
                        sizeof gFSVolBuf);

  if (gRc) {
      printf( "DosQueryFSInfo error: Rc%ld", gRc);
      strcpy( gDriveSerial, "unknown");
      strcpy( gDriveVolume, "unknown");
      return;
  }
  VolSer = *((UINT *)(&gFSVolBuf.fdateCreation));
  sprintf( gDriveSerial, "%04X:%04X",
           (USHORT)(VolSer >>16),
           (USHORT)(VolSer     ));
  #endif

  /*Ŀ*/
  /* On successful return, the data buffer FSVolBuf contains a set of      */
  /* information about the volume/serial number of the drive.              */
  /**/
  strcpy( gDriveVolume, gFSVolBuf.vol.szVolLabel);
  if ('\0' == gDriveVolume[0]) {
      strcpy( gDriveVolume, "unlabeled");
  }
  return;
}                                                /* CollectVolInfo()         */

/*Ŀ*/
/* FileSize()                                             Date: 04/15/1998 */
/*Ĵ*/
/* Description: Return the size of the specified file.                     */
/* Returns    : Nothing                                                    */
/* Assumptions: None                                                       */
/* Programmers: Wing F Yuen                                                */
/**/
long FileSize (const char *FileSpec)
{
  FILE *Tmp;
  long FileLen;

  if (NULL == (Tmp = fopen( FileSpec, "rb")))
      return -1L;

  #if (defined(_MSC_VER) ||  defined (__WATCOMC__))

  FileLen = filelength( fileno( Tmp));
  #else                                          /* VisualAge C++            */

  FileLen = _filelength( fileno( Tmp));          /* needs /Se                */

  #endif
  fclose( Tmp);
  return FileLen;
}                                                /* FileSize()               */

/*Ŀ*/
/* Split000()                                             Date: 04/15/1998 */
/*Ĵ*/
/* Description: Add commas as separators between the thousands, millions & */
/*              billions. This is accomplished by shifting trailing digits */
/*              three at a time, then inserting a comma before repeating.  */
/* Returns    : Nothing                                                    */
/* Assumptions: ULONG is a 32 bit unsigned integer type                    */
/* Programmers: Wing F Yuen                                                */
/**/
char *Split000 (ULONG Bytes, char Separator)
{
  int    CommaCnt, DigitCnt, i;
  static
  char   Buffer[14];
  char   *Src, *Dst;

  sprintf( Buffer, "%lu", Bytes);
  DigitCnt = strlen( Buffer);
  CommaCnt = (DigitCnt-1) / 3;
  Dst = Buffer + DigitCnt + CommaCnt;
  Src = Buffer + DigitCnt;
  *Dst = *Src;
  for (i = 0; i < CommaCnt; i++) {
      *--Dst = *--Src;
      *--Dst = *--Src;
      *--Dst = *--Src;
      *--Dst = Separator;
  }                                              /* End for                  */
  return Buffer;
}                                                /* Split000()               */

/*Ŀ*/
/* WriteNewHogFile()                                      Date: 04/15/1998 */
/*Ĵ*/
/* Description: Replace the HogFileName with one of a new size.            */
/* Returns    : Nothing                                                    */
/* Assumptions: None                                                       */
/* Programmers: Wing F Yuen                                                */
/**/
int WriteNewHogFile (void)
{
  #if (defined(_MSC_VER) || (!defined (__386__) && defined (__WATCOMC__)))

  USHORT RcApi;
  HFILE  Hog;
  USHORT ActionTaken;
  #else

  APIRET RcApi;
  HFILE  Hog;
  ULONG  ActionTaken;
  #endif

  RcApi = DosOpen( gHogFileName,
                   &Hog,
                   &ActionTaken,
                   gNewHogSize,
                   FILE_NORMAL,
                   OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_REPLACE_IF_EXISTS,
                   OPEN_SHARE_DENYREADWRITE | OPEN_ACCESS_WRITEONLY,
                   0L);
  if (RcApi) {
      printf( __FILE__"WriteNewHogFile(): DosOpen() returns %u\n", RcApi);
      return 1;
  }

  RcApi = DosClose( Hog);
  if (RcApi) {
      printf( __FILE__"WriteNewHogFile(): DosClose() returns %u\n", RcApi);
      return 1;
  }

  return 0;
}                                                /* WriteNewHogFile()        */
