/****************************************************************/
/*          Remove a user from the FtpServer database           */
/*                                                              */
/*      Author:       Peter Moylan (peter@ee.newcastle.edu.au)  */
/*      Started:      7 December 2000                           */
/*      Last revised: 8 June 2004                               */
/*                                                              */
/*  Usage:                                                      */
/*         remove username                                      */
/*                                                              */
/*  Installation:                                               */
/*         Put this file in the directory containing FTPD.INI   */
/*                                                              */
/****************************************************************/

CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs

PARSE ARG username
IF username = '' THEN
    DO
        SAY "Usage: remove username"
        EXIT 0
    END

/* Check the source directory, in case this command file is     */
/* run from a different directory.                              */

PARSE SOURCE rubbish rubbish SrcDir
j = LASTPOS('\', SrcDir)
IF j > 0 THEN SrcDir = LEFT(SrcDir, j-1)

INIFile = IniFileFor(SrcDir, username)
IF SysIni(INIFile, username, 'DELETE:') \= '' THEN
    DO
        SAY "Can't delete user "username
        EXIT 1
    END

SAY "User "username" removed"
EXIT 0

/****************************************************************/
/*  Procedure to find the INI file that contains the data for   */
/*  one user.  In most installations this will turn out to be   */
/*  the file called FTPD.INI, but if the option to use multiple */
/*  INI files is activated then the file name is based on a     */
/*  hash coding of the username.                                */
/****************************************************************/

IniFileFor:  PROCEDURE

    PARSE UPPER ARG SrcDir, username
    file = SrcDir'\FTPD.INI'
    HashMax = SysIni(file, '$SYS', 'HashMax')
    IF HashMax = 'ERROR:' THEN HashMax = 0
    ELSE HashMax = C2D(REVERSE(HashMax))
    IF HashMax \= 0 THEN DO
        code = 0
        DO WHILE username <> ''
            ch = LEFT(username,1)
            username = RIGHT(username, LENGTH(username)-1)
            code = (16*code + C2D(ch)) // HashMax
        END
        code = TRANSLATE(FORMAT(code,4), '0', ' ')
        file = SrcDir'\FTPD'code'.INI'
    END
    RETURN file

