/****************************************************************/
/* Alters the FtpServer INI file to change the IP address of    */
/* the firewall that is specified in the 'behind firewall'      */
/* rules.  You can do the same job by running Setup.exe, but    */
/* running Setup might not be acceptable to someone who wants   */
/* to automate the job.                                         */
/*                                                              */
/* Note: Must be in the same directory as FTPD.INI              */
/*                                                              */
/*       Programmer:      P. Moylan                             */
/*       Last modified:   30 January 2002                       */
/*                                                              */
/* Prerequisite: for this to work you must have RXU.DLL in      */
/* your LIBPATH.  RXU, a Rexx library written by Dave Boll, is  */
/* available from Hobbes with the name rxu1a.zip.               */
/*                                                              */
/*       Usage:    newfwip addr                                 */
/*             where 'addr' is the IP address of the firewall,  */
/*             in dotted IP notation.                           */
/*       Example:  newfwip 188.99.54.3                          */
/*                                                              */
/****************************************************************/

/* Convert IP address to binary (not entirely obvious in Rexx) */

parse arg n1'.'n2'.'n3'.'n4
NewAddress = D2C(n1)||D2C(n2)||D2C(n3)||D2C(n4)

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
call rxfuncadd 'rxuinit','rxu','rxuinit'
call rxuinit

/* Update the appropriate INI file entry. */

Call SysIni 'FTPD.INI', '$SYS', 'FirewallIPAddr', NewAddress

/* Tell FtpServer to re-read its INI file. */

SemName = "\SEM32\FTPSERVER\UPDATED"
if RxOpenEventSem(hev, SemName) \= 0 then
    rc = RxCreateEventSem( hev ,'Shared', SemName, 'Reset')
call RxPostEventSem hev
call RxResetEventSem hev

call RxCloseEventSem hev
call RxuTerm

return 0

