/****************************************************************/
/* Utility to retrieve a lost FtpServer password.               */
/*                                                              */
/*       Programmer:      P. Moylan                             */
/*       Last modified:   8 June 2004                           */
/*                                                              */
/*   Usage:    findpassword username                            */
/*                                                              */
/****************************************************************/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

parse arg username
DO WHILE username = ''
    CALL CharOut , 'Username: '
    PARSE PULL username
END

INIFile = INIFileFor('.', username)
IF SysIni(INIFile, username, 'EncryptPassword') = '01'X THEN
    DO
        SAY 'Sorry, the password has been encrypted and cannot be read.'
        EXIT 1
    END

password = SysIni(INIFile, username, 'Password')
SAY 'username = 'username
SAY 'password = 'password
EXIT 0

/****************************************************************/
/*  Procedure to find the INI file that contains the data for   */
/*  one user.  In most installations this will turn out to be   */
/*  the file called FTPD.INI, but if the option to use multiple */
/*  INI files is activated then the file name is based on a     */
/*  hash coding of the username.                                */
/****************************************************************/

IniFileFor:  PROCEDURE

    PARSE UPPER ARG SrcDir, username
    file = SrcDir'\FTPD.INI'
    HashMax = SysIni(file, '$SYS', 'HashMax')
    IF HashMax = 'ERROR:' THEN HashMax = 0
    ELSE HashMax = C2D(REVERSE(HashMax))
    IF HashMax \= 0 THEN DO
        code = 0
        DO WHILE username <> ''
            ch = LEFT(username,1)
            username = RIGHT(username, LENGTH(username)-1)
            code = (16*code + C2D(ch)) // HashMax
        END
        code = TRANSLATE(FORMAT(code,4), '0', ' ')
        file = SrcDir'\FTPD'code'.INI'
    END
    RETURN file

