/* GFS Generalized File Selector front-end by DGD v2 (mod'd from LD4) */
/*  Keyboarding will always beat mousing around!
  Uses Classic REXX (+ RexxUtil) only. Freeware, but only for OS/2 - ECS.
  No installation except to place this in \OS2, and edit associations below.
  Applications open in foreground; you can switch back to GFS to open more.
  Automatic adjustment to VIO rows, columns: "mode 100, 40" works nicely.
  Unfortunately, no easy way to maximize from REXX, but look into this which
    is handy for other reasons too: http://dink.org/files/console-0_1_0.zip

Commands implemented:
  <escape> exits
  up and down arrow keys move highlight
  left and right arrow keys move into and out of directories
  page-up and page-down do as they're named
  <enter> launches executable associated with file extension
    (also, somewhat experimental, when on directory same as right arrow)
   - .EXEs are run (can be either dangerous or useless without parameters...)
   - .ZIPs are unzipped (requires UNZIP.EXE) to temporary directory (which
     needs to be specified for your system); also, RAMFS is suggested
   - for unassociated file types asks whether to open with TEDIT
  <ctrl-enter> attempts to execute, any file
  <home> sets a directory to move files to, useful for sorting into categories
  <insert> moves highlighted file to "home" directory (no confirmation...)
  <alt-c> toggles between copy and move action for <insert>
  <delete> asks to confirm, deletes file or directory (uppercase required!)
  <alt-p> sets passwords for RARs and ZIPs
    READ-ONLY ATTRIBUTES ARE NO OBSTACLE! But System and Hidden still protect.
  F1 brings up further help, including ALT-keys now used for options
    UPPERcase A-Z select drive; also uses some alt-keys
    lowercase a-z and 0-9 jumps to first FILE starting with character
NOTE ^^^ ABOVE ARE MAJOR CHANGES FROM PREVIOUS VERSION!
Version 2 looks and operates like v1, but much improved and rationalized. In 
  specific, sorting and list display options now STAY set, and the file 
  highlighted after a delete is accurately found.
*/

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
/* Call SysCurState 'OFF'  */
call syscls

/* CONSTANTs for some useful keys; see ex_read_key */
zky= d2c(0);  xky= d2c(224); /* prefixes for extended keys */
k_esc= x2c('1b');  k_enter= x2c('0d');  k_bksp= d2c(8);  k_tab= d2c(9);
k_up= 'H';    k_down= 'P';  k_left= 'K';  k_right= 'M';
k_ins= 'R';   k_del= 'S';   k_home= 'G';  k_end= 'O';
k_pgup= 'I';  k_pgdn= 'Q';
/* control keys */
k_c_left= 's'; k_c_right= 't'; k_c_up= ''||d2c(141); k_c_dn= ''||d2c(145);
k_c_pgup= ''||d2c(132);  k_c_pgdn= 'v'; k_c_enter= d2c(10);
/* alt keys */
k_a_left= zky||d2c(155); k_a_right= zky||d2c(157);
k_a_up= zky||d2c(152); k_a_dn= zky||d2c(160);
k_a_enter= zky||d2c(28);
k_a_a= zky||d2c(30); k_a_b= zky||d2c(48); k_a_c= zky||d2c(46);
k_a_d= zky||d2c(32); k_a_e= zky||d2c(18); k_a_f= zky||d2c(33);
k_a_g= zky||d2c(34); k_a_h= zky||d2c(35); k_a_i= zky||d2c(23);
k_a_j= zky||d2c(36); k_a_k= zky||d2c(37); k_a_l= zky||d2c(38);
k_a_m= zky||d2c(50); k_a_n= zky||d2c(49); k_a_o= zky||d2c(24);
k_a_p= zky||d2c(25); k_a_q= zky||d2c(16); k_a_r= zky||d2c(19);
k_a_s= zky||d2c(31); k_a_t= zky||d2c(20); k_a_u= zky||d2c(22);
k_a_v= zky||d2c(47); k_a_w= zky||d2c(17); k_a_x= zky||d2c(45);
k_a_y= zky||d2c(21); k_a_z= zky||d2c(44);
/* function keys; only F1 (Help) used in file_select */
k_f1= zky||';';  k_f2= zky||'<';  k_f3= zky||'=';  k_f4= zky||'>';
k_f5= zky||'?';  k_f6= zky||'@';  k_f7= zky||'A';  k_f8= zky||'B';
k_f9= zky||'C';  k_f10= zky||'D'; k_f11= zky||d2c(133);  k_f12= zky||d2c(134);

/* text screen colors: used for highlighting */
black= 0; red= 1; green= 2; yellow= 3;
blue= 4; magenta= 5; cyan= 6; white= 7;
fgnd = 30   /* add color: 30 + 2 = 32 ==> green foreground */
bgnd = 40   /* add color: 40 + 7 = 47 ==> white background */
AEsc= '1B'x||'['  /* define ANSI-ESCape; + 0 = low, 1 = high int*/
norcolr= AEsc||'0;'||fgnd + white||';'||bgnd + black||'m' /* normal */
highcolr= AEsc||'1;'||fgnd + white||';'||bgnd + black||'m' /* normal */
revcolr= AEsc||'0;'||fgnd + black||';'||bgnd + white||'m' /* reversed */
ansi_clreol= AEsc||'K'

/* semi-CONSTANT */
parse value systextscreensize() with scry scrx
scry= scry - 1; scrx= scrx - 1; /* adj to 0, 0 based values */
numeric digits 12 /* necessary to display bytes of gigabytes */

glo_var= 'dirlist.'

/* ============== ALL CODE ABOVE is necessary for file_select ============= */

/* ================== Begin FRONT-END SPECIFIC section. =================== */

scry= scry - 1 /* this app, also provide info / message line at bottom:
Free: 0123456789AB  Home: 0123456789012345678901234567890123456789... */

/* EDIT / ADD ASSOCIATIONS BELOW AS SPECIFIC TO YOUR SYSTEM
   values before executable go with 'start' command; see > help start
   .EXE files are all a special case and are invoked
   .ZIP files require UNZIP.EXE in PATH, and UNZIP32.DLL in LIBPATH
   commas chain all to 1 string, automagically adds space after ']' */

fassoc= ']', /* dummy to avoid anomaly in retrieving first substring */
  '/WIN /C C:\OS2\TEDIT.EXE [*.sys *.txt *.doc *.cmd *.bat *.log *.os2',
    '*.c *.h *.cpp *.diz *.me *.1st]',
  'C:\FIREFOX\FIREFOX.EXE [*.htm *.html *.shtml *.asp *.php]',
  '/C /B C:\Z28\Z.EXE [*.mp3 *.wav *.m3u *.pls]', /* playlists don't work? */
  'C:\OS2\VIEW.EXE [*.inf]',
  'C:\PMVIEW\PMVIEW.EXE [*.bmp *.jpg *.gif]', /* many others to list... */
  'C:\GS\GSVIEW2\GVPM.EXE [*.pdf]',
  '/PM C:\MPLAYER\MPLAYER.EXE -really-quiet',
    '[*.avi *.wmv *.mmpg *.mpeg *.mov *.flv *.rm *.rmvb *.m4v *.asf *.mp4',
    '*.divx *.vob]',
  'HANDLE_RAR [*.rar]', /* special case to use optional passwords */
  'HANDLE_ZIP [*.zip]', /* EXTRA SPECIAL CASE expanded in temporary dir... */
/* ^^^ if no '.EXE' here, calls the procedure of that name */

fassoc= translate(fassoc) /* lower case up there just for readibility */
curpath= directory() /* handles case of started in dir */
curfil= ''
temp_dir= 'Z:' /* the starting path where .zip files will be unzipped */
temp_dir= temp_dir||'\_G_F_S_T' /* temporary directory, created and erased */
home_dir= 'C:\' /* init to likely boot drive, just for somewhere */
k= ''; pw= ''; copymove= 0 /* 0 = copy */

/* NEW v2.1 file_select_init breaks off these "static" variables to preserve
   mode selection after caller handles an "other" key:
params:   fs_attr, fs_sort, fs_initpos, fs_view, fs_filter
defaults: '*****', 'N',     'M',        ^SPECIFY ^THESE LAST TWO
*/ 
call file_select_init '', '', '', 'DTSA', 1
call main_loop
exit

main_loop: /* can be re-entered ONCE by special case handlers (as .zips) */

do until k= k_esc /* <esc> exits */

/* calling parameters:
   parse arg fs_scol, glo_var, curpath, fs_flspc, fs_cur */
rv= file_select(33, glo_var, curpath, '*', curfil)
/* This is anchor^ column: DETAILS SHOW TO LEFT; FILE NAMES SHOW TO RIGHT */
/* returns: fs_action' '||fs_n||' '||fs_tags||' ' ||fs_path||fs_filnam(fs_n) */

n= word(rv, 2) /* index to dirlist., used several places */
if pos('D', word(dirlist.n, 4)) = 2 then is_dir = 1; else is_dir = 0
fn= substr(rv, wordindex(rv, 4), length(rv) - wordindex(rv, 4) + 1)
k= word(rv, 1) /* the key code returned; see key constants above */
select /* on key */
when k = k_enter & is_dir = 0 then do /* no tags, the ONE at cursor */
  call start_one fn
  call set_current
end
when k = k_c_enter & is_dir = 0 then do /* provides edit / execute option */
  'START /C /F /PGM "'fn'"' /* pass intact, presumably EXECUTE */
  call set_current
end
when k = k_del & n > 2 then do /* ask, delete file */
  call set_current /* to preserve path but going to change curfil below */
  t= 0   /* ^ save to prepare for re-entering file_select */
  call info 'To delete directory, MUST TYPE UPPERCASE "Y"'
  do until chars() > 0
    t= t + 1
    call syscurpos fs_sel.fs_lvl - 1, 1 /* CHEAT by using file_select variables */
    if t // 2 = 1 then call charout, revcolr||'  Delete this file? (Y)   '||norcolr
      else call charout, copies(' ', 26)
    call syssleep 0.5 /* DECIMAL NOT WORK IN OLDER REXXUTIL? Use 1 */
  end
  k= ex_read_key()
  if k = 'Y' | k = 'y' then do
    if k = 'Y' & is_dir = 1 then do /* directory and must be uppercase */
      call delete_tree fn
    end
    else do
      call sysfiledelete(fn) /* file */
    end
    if n < dirlist.0 then n= n + 1; else n= n - 1
    fn= dirlist.n
    curfil= substr(fn, wordindex(fn, 5), length(fn) - wordindex(fn, 5) + 1)
  end
  k= '' /* so doesn't exit if <esc> hit */
end
when k = k_home then do /* mark home directory */
  t= word(rv, 2) /* get index; check really is dir */
  if (t > 2) & (substr(dirlist.t, wordindex(dirlist.t, 4) + 1, 1) = 'D') then do
    rv= dirlist.t /* only as temp var */
    home_dir= filespec("drive", fn)||filespec("path", fn)||,
      substr(rv, wordindex(rv, 5), length(rv) - wordindex(rv, 5) + 1)
  end
  else home_dir= substr(fn, 1, lastpos('\', fn)) /* otherwise, esp floppy... */
  call info 'Home = '||home_dir
  call set_current
end
when k = k_ins then do /* <insert> key copies/moves file IMMEDIATELY... */
  call set_current
  if copymove = 0 then do
/* rc= syscopyobject(fn, home_dir) I just CANNOT make this work at all... */
    'copy "'fn'" 'home_dir
  end
  else do
    rc= sysmoveobject(fn, home_dir)
    if rc = 0 then call beep 1000, 200
    else do
      if n < dirlist.0 then n= n + 1; else n= n - 1
      fn= dirlist.n
      curfil= substr(fn, wordindex(fn, 5), length(fn) - wordindex(fn, 5) + 1)
    end
  end
end
when k = k_a_c then do /* alt-c copy/move toggle */
  call set_current /* must be set with EVERY key, is WHY it's duplicated! */
  if copymove = 0 then do
    copymove= 1
    call info 'Operation for <insert> key set to MOVE!'
  end
  else do
    copymove= 0
    call info 'Operation for <insert> key set to copy.'
  end
end
when k = k_a_p then do /* set password for rars and zips, used until cleared */
  call set_current
  call info 'Set password (just <enter> clears) >'
  parse pull pw
  call info 'Password set to: 'pw''
end
otherwise nop
end /* select */
end /* key loop */
return

set_current:
  curpath= filespec("drive", fn)||filespec("path", fn) /* these two lines */
  curfil= filespec("name", fn)  /* prepare based on processed return value */
return

start_one:
  parse arg fn1
  if lastpos('.', fn1) = 0 then do
  'START /WIN /C C:\OS2\TEDIT.EXE "'||fn1'"'
  end
  else do
  ext= translate(substr(fn1, lastpos('.', fn1), length(fn1) - lastpos('.', fn1) + 1))
  px= pos(ext, fassoc)
  if px > 0 then do
    if ext = '.EXE' then do /* in extension: special case! */
      '"'translate(fn1)'"' /* doubled quoted name */
    end  /* ^ for DOS MUST be upper case (curfil needs orig fn1 though!) */
    else do
      ws= substr(fassoc, 1, px - 1) /* chop fassoc into work string */
      ws= substr(ws, 1, lastpos('[', ws) - 1) /* drops the '[' */
      lp= lastpos(']', ws) + 1  /* find the last ']' */
      ws= substr(ws, lp + 1, length(ws) - lp) /* .EXE with params */
      if pos('.EXE', ws) > 0 then do /* executable IS specified to handle */
        'START '||ws||'"'fn1'"' /* execute, with doubled quoted name */
      end
      else do /* call a named procedure to handle special cases (.zip + ?) */
        ws= strip(word(ws, 1), 'B')
        interpret 'call '||ws||' "'fn1'"'
      end
    end
  end
  else do
    call info '!!! 'ext' does not have an association. Open with TEDIT? (y)'
    do until chars() > 0
      call syssleep 0.5
    end
    k= ex_read_key()
    if k = 'y' | k = 'Y' then do
      'START /C /F /PGM "C:\OS2\TEDIT.EXE" "'fn1'"'
    end
    else call info 'Associations are set by editing GFS.CMD...'
   end
  end /* fix for files without extensions */
return

handle_zip: /* this may be unnecessarily generalized; regard as template */
  parse arg fn2  /* NOTE THAT ZIPs are temporary for looking into! */
  if pw > '' then lp= '-P'||pw; else lp= ''
  'mkdir 'temp_dir
  'unzip "'fn2'" -d 'temp_dir' 'lp
  save_fn= fn /* save the current */
  curpath= temp_dir
  call info 'Viewing ZIP file contents; <escape> returns to previous view.'
  call main_loop
  call delete_tree temp_dir
  k= '' /* cancel the 1st <escape> key so program doesn't exit */
  fn= save_fn
return

handle_rar:      /* special cased ONLY to handle optional passwords */
  parse arg fn2  /* NOTE BUGGISH: RARs create files where GFS was started! */
  if pw > '' then lp= '-p'||pw; else lp= '' /* looking for right syntax... */
  'START /F /C /PGM "C:\OS2\UNRAR.EXE" x "'fn2'" 'lp
return    /* switch here is not specified syntax, ^ but does work... */

delete_tree:
  parse arg ttd
/* section modified from DELTREE.CMD by Mark Polly & Carl Harding */
  rc= sysfiletree(ttd||'\*.*', dl2, 'BSO', '***+*','-**-*') /* for safety, */
  rc= sysfiletree(ttd||'\*.*', dl2, 'FSO')   /* clears ^ just read-only */
  do x = 1 to dl2.0
    rc = sysfiledelete(dl2.x)
  end
  rc=sysfiletree(ttd||'\*.*', dl2, 'DSO')
  do x = dl2.0 to 1 by -1
    rc=sysrmdir(dl2.x)
  end
  rc=sysrmdir(ttd)
  drop dl2.
/* end of cribbed section */
return


info:
  parse arg nfo
  call syscurpos scry + 1, 1
  call charout, ansi_clreol||nfo
return

/* ============== End of front-end (GFS) specific section. ============ */

/* VERSION 2 FILE SELECTOR CHANGES:
   - drives are now selected with UPPER case A-Z
   - ordering and display commands are now on ALT-keys (with previous letters)
   - lower case and 0-9 now jump to first file beginning with character
   - directories are now always kept at top of list regardless of sorting
   - Inelegant fake "static" mode variables with separate file_select_init to
     cure problem of these reset every time handled other keys.

   For documentation beyond application above, you'll just have to do what I
   do: READ the code. Remember that items other than file names are optional,
   as is their DISPLAYED ORDER (not so in dirlist.), controlled by fs_view.
   File_Select does not save or restore the screen.

   However, I direct your attention to the fs_filter variable in the fs_exit
   procedure that's called after a left-arrow key, which for GENERAL purposes
   is handy to automatically turn off filtering when ascending the tree; it's
   commented out for SPECIFIC application here, but filtering can still be
   toggled manually with "alt-F", OR will be turned off if you delete the last
   of files in file_types in current directory, OR when changing drives. Can
   confuse, but HAS TO be that way...
*/

/* ============== ALL CODE BELOW is necessary for file_select ============ */

/* NEW v2.1 file_select_init: breaks off these "static" variables to preserve
   mode selection after caller handles "other" keys
*/
file_select_init: 
parse arg fs_attr, fs_sort, fs_initpos, fs_view, fs_filter
/* defaults: '*****', 'N',     'M',        ^SPECIFY ^THESE LAST TWO */
  fs_ndx= 0; fs_showln= scry; fs_timr= 0 /* initialize */
  fs_sort= translate(fs_sort); fs_initpos= translate(fs_initpos); fs_view= translate(fs_view);
  if fs_attr = '' then fs_attr= '*****'
  if pos(fs_sort, 'DENS') = 0 then fs_sort= 'N' /* default: sort on Name */
  if pos(fs_initpos, 'HMT') = 0 then fs_initpos= 'M' /* show Middle of list */
return

file_select:
parse arg fs_scol, glo_var, fs_path, fs_flspc, fs_cur
  fs_dtlwid= 1; /* too complex to check fs_view correctness, SO UP TO YOU */
  if length(fs_view) > 0 then do fs_loop= 1 to length(fs_view)
    v= substr(fs_view, fs_loop, 1) /* always GET details, CHOOSE which to display */
    if v= 'D' then fs_dtlwid= fs_dtlwid + 9  /* date */
    if v= 'T' then fs_dtlwid= fs_dtlwid + 6  /* time */
    if v= 'S' then fs_dtlwid= fs_dtlwid + 11 /* size */
    if v= 'A' then fs_dtlwid= fs_dtlwid + 6  /* attributes */
    if v= 'L' then fs_dtlwid= fs_dtlwid + 5 /* show Long (Y2K) form */
  end
  /* end \ is crucial, ensure ALWAYS present, starting here to count fs_lvls */
  /* # of levels is actually limited only by a literal '10' in fs_enter_dir */
  /* DON'T advise entering here with more than 9 levels in path! */
  if substr(fs_path, length(fs_path), 1) \= '\' then fs_path= fs_path||'\'
  fs_lvl= 0
  do fs_loop= 1 to length(fs_path)
    if substr(fs_path, fs_loop, 1) = '\' then fs_lvl= fs_lvl + 1
  end
  fs_ndx= get_1_directory(glo_var, fs_path, fs_flspc, fs_attr, fs_filter, 1)
  if fs_ndx = 2 then do /* only dots back? turn off fs_filter and try for ANY */
    fs_filter= 0
    fs_ndx= get_1_directory(glo_var, fs_path, fs_flspc, fs_attr, fs_filter, 1)
  end
  if fs_ndx > 0 then do /* found more than dot dirs (no indent saves space) */
  fs_tags= copies('', fs_ndx) /* prepare tag "array" */
  call fs_sort_list 
  call fs_set_sel
  call fs_show_new_dir
  do fs_loop= 0 to fs_showln /* helps to set off from previous text */
    call syscurpos fs_loop, fs_scol - fs_dtlwid
    call charout, ''
  end
  fs_quit= 0
  do while fs_quit < 1  /* begin key control */
    if chars() > 0 then do
    fs_kd= ex_read_key()
    fs_timr= 0  /* goes into longer sleeps after 10 sec; reset on keypress */
    fs_n= fs_ndx_ofs.fs_lvl + fs_sel.fs_lvl /* used several times */
    select /* by key */
    when fs_kd = k_left then call fs_exit_dir /* left arrow */
    when fs_kd = k_right then do
      if fs_lvl < 10 & fs_n > 2 & substr(fs_filatt(fs_n), 2, 1) = 'D' then,  
        call fs_enter_dir /* right arrow */
    end
    when fs_kd = k_up then do /* up arrow */
      if fs_sel.fs_lvl > 1 then do
        call fs_lowlight
        fs_sel.fs_lvl= fs_sel.fs_lvl - 1
        call fs_highlight
      end
      else do /* fs_sel.fs_lvl = 1 so scroll down */
        if fs_ndx_ofs.fs_lvl > 0 then do
          fs_ndx_ofs.fs_lvl= fs_ndx_ofs.fs_lvl - 1
          call fs_show_section
        end
      end
    end
    when fs_kd = k_down then do /* down arrow */
      if fs_sel.fs_lvl <= fs_maxln - 1 then do
        call fs_lowlight
        if fs_n < fs_ndx then fs_sel.fs_lvl= fs_sel.fs_lvl + 1
        call fs_highlight
      end
      else do /* fs_sel.fs_lvl > fs_maxln so scroll up */
        if fs_ndx_ofs.fs_lvl < fs_ndx - fs_showln then do
          if fs_sel.fs_lvl < fs_ndx - 1 then fs_ndx_ofs.fs_lvl= fs_ndx_ofs.fs_lvl + 1
          call fs_show_section
        end
      end
    end
    when fs_kd = k_pgup then do /* page up */
      fs_ndx_ofs.fs_lvl= fs_ndx_ofs.fs_lvl - fs_showln
      if fs_ndx_ofs.fs_lvl < 0 then do
        fs_ndx_ofs.fs_lvl= 0
        fs_sel.fs_lvl= 1
      end
      call fs_show_section
    end
    when fs_kd = k_c_pgup then do /* ctrl-page up */
      fs_ndx_ofs.fs_lvl= 0
      fs_sel.fs_lvl= 1
      call fs_show_section
    end
    when fs_kd = k_pgdn then do /* page down */
      if fs_ndx > fs_showln then do
        if fs_n + fs_showln < fs_ndx then do
          fs_ndx_ofs.fs_lvl= fs_ndx_ofs.fs_lvl + fs_showln
        end
        else do
          fs_ndx_ofs.fs_lvl= fs_ndx - fs_showln
          fs_sel.fs_lvl= fs_showln
        end
      end
      else fs_sel.fs_lvl= fs_ndx
     call fs_show_section
    end
    when fs_kd = k_c_pgdn then do /* ctrl-page down */
      if fs_ndx > fs_showln then do
        fs_ndx_ofs.fs_lvl= fs_ndx - fs_showln
        fs_sel.fs_lvl= fs_showln
        call fs_show_section
      end
    end
    when fs_kd > '@' & fs_kd < '[' then do /* UPPERcase A-Z, select drive */
      if pos(fs_kd, sysdrivemap('A:', 'USED')) > 0 then do /* select new drive */
        fs_path= fs_kd||':\'
        call syscurpos scry, fs_scol - fs_dtlwid + 1 /* 0, 0 based */
        call charout, 'Waiting for drive 'substr(fs_path, 1, 2)'...'
        fs_lvl= 1
        fs_filter= 0 /* cures not finding files when changing drive */
        fs_ndx= get_1_directory(glo_var, fs_path, fs_flspc, fs_attr, fs_filter, 1)
        fs_cur= ''
        fs_tags= copies('', fs_ndx)
        call fs_sort_list
        call fs_set_sel
        call fs_show_new_dir
      end
    end
    when fs_kd > '`' & fs_kd < '{' |, /* LOWERcase a-z, find 1st char */
         fs_kd > '/' & fs_kd < ':' then do /* OR 0-9 */
      fs_kd= translate(fs_kd) /* oddly, must now upcase it... */
      fs_n= 3
      do until fs_n > dirlist.0
        if fs_kd = translate(substr(word(dirlist.fs_n, 5), 1, 1)) &,
            substr(word(dirlist.fs_n, 4), 2, 1) <> 'D' then do
          fs_cur= fs_filnam(fs_n)  /* ^^^ finds 1st FILE ONLY... */
          call fs_set_sel
          call fs_show_new_dir
          fs_n= dirlist.0 + 1 /* exit kludge */
        end
        else fs_n= fs_n + 1
      end
    end
    when fs_kd = k_a_f then do  /* fs_filter toggle */
      if fs_filter = 1 then fs_filter= 0; else fs_filter= 1
      fs_ndx= get_1_directory(glo_var, fs_path, fs_flspc, fs_attr, fs_filter, 1)
      fs_tags= copies('', fs_ndx)
      call fs_sort_list
      call fs_set_sel
      call fs_show_new_dir
    end
    when fs_kd = k_a_h | fs_kd = k_a_m | fs_kd = k_a_t then do
      if fs_kd = k_a_h then fs_initpos= 'H' /* uncode from alt-keys */
        else if fs_kd = k_a_m then fs_initpos= 'M'
          else if fs_kd = k_a_t then fs_initpos= 'T'
      fs_cur= '' /* set off so fs_set_sel uses fs_initpos rather than finds this */
      call fs_set_sel
      call fs_show_new_dir
    end
    when fs_kd = k_a_d | fs_kd = k_a_e | fs_kd = k_a_n | fs_kd = k_a_s then do
      fs_sort= 'N'; call fs_sort_list; /* always sort first by name */
      if fs_kd <> k_a_n then do        /* results in better ordering */
        if fs_kd= k_a_d then fs_sort= 'D' /* uncode sort type from alt-keys */
          else if fs_kd= k_a_e then fs_sort= 'E'
            else if fs_kd= k_a_s then fs_sort= 'S'
        call fs_sort_list
      end
      call fs_show_new_dir
    end
    when fs_kd = k_c_up then do /* ctrl-up; SET tag and move up */
      if fs_n > 2 then fs_tags= overlay('', fs_tags, fs_n) /* don't tag dot dirs */
      if fs_sel.fs_lvl > 2 then do
        call syscurpos fs_sel.fs_lvl - 1, fs_scol
        call fs_show_tag(fs_n)
        call fs_lowlight
        fs_sel.fs_lvl= fs_sel.fs_lvl - 1
        call fs_highlight
      end
      else do
        if fs_ndx_ofs.fs_lvl > 0 then do
          fs_ndx_ofs.fs_lvl= fs_ndx_ofs.fs_lvl - 1
          call fs_show_section
        end
      end
    end
    when fs_kd = ' ' |,   /* <space> TOGGLE tag and move down */
      fs_kd = k_c_dn then do /* ctrl-down; SET tag and move down */
      if fs_n > 2 then do
        if fs_kd = ' ' & substr(fs_tags, fs_n, 1) = '' then fs_tags= overlay('', fs_tags, fs_n)
          else fs_tags= overlay('', fs_tags, fs_n)
          call syscurpos fs_sel.fs_lvl - 1, fs_scol
          call fs_show_tag(fs_n)
          if fs_sel.fs_lvl <= fs_maxln - 1 then do
          call fs_lowlight
          if fs_n < fs_ndx then fs_sel.fs_lvl= fs_sel.fs_lvl + 1
          call fs_highlight
        end
        else do
          if fs_ndx_ofs.fs_lvl < fs_ndx - fs_showln then do
            if fs_sel.fs_lvl < fs_ndx - 1 then fs_ndx_ofs.fs_lvl= fs_ndx_ofs.fs_lvl + 1
            call fs_show_section
          end
        end
      end
    end
    when fs_kd = k_f1 then do /* F1 Help */
      call fs_show_instructions fs_scol
      call fs_show_section
    end
    when fs_kd = k_enter then do /* <enter>: if not dir (or dots), return */
      if fs_n < 3 then call fs_exit_dir /* ON DOT DIRS, go up */
      if fs_n > 2 & fs_lvl < 10 & substr(fs_filatt(fs_n), 2, 1) = 'D' then,  
        call fs_enter_dir /* OR could do nothing */
      else do 
        fs_action= fs_kd
        fs_quit= 1
      end
    end
    otherwise do /* EXIT on all other keys to handle in caller. */
      fs_action= fs_kd
      fs_quit= 1
    end
    end /* select */
    end /* if charin > 0 */
    else do   /* without sleep keyboard poll keeps CPU BUSY */
      if fs_timr < 100 then call syssleep 0.1; else call syssleep 1
      fs_timr= fs_timr + 1 /* counter for longer sleeps after 10 sec idle */
    end
  end /* while fs_quit */
  end /* fs_ndx > 2 so some found */
  else do
    fs_action= 'Not_Found'
    fs_n= 0
    fs_rv= ''
  end
return fs_action' '||fs_n||' '||fs_tags||' ' ||fs_path||fs_filnam(fs_n)

fs_fildat: /* word 1, year 2 or 4 chars depending whether 'L' in fs_view */
arg fs_ni
fs_rv= word(dirlist.fs_ni, 1)
if pos('L', fs_view) = 0 then fs_rv= substr(fs_rv, 3, 8)
return fs_rv

fs_filtim: /* word 2, colon and seconds omitted in short form */
arg fs_ni
fs_rv= word(dirlist.fs_ni, 2)
if pos('L', fs_view) = 0 then fs_rv= substr(fs_rv, 1, 5)
return fs_rv

fs_filsiz: /* word 3 WITH leading spaces for ease in display */
arg fs_ni
fs_twi= wordindex(dirlist.fs_ni, 2) + length(word(dirlist.fs_ni, 2)) + 1
return substr(dirlist.fs_ni, fs_twi, 10)

fs_filatt: /* word 4 attributes */
arg fs_ni
return word(dirlist.fs_ni, 4)

fs_filnam: /* word 5 --> remainder INCLUDING spaces */
arg fs_ni
fs_twi= wordindex(dirlist.fs_ni, 5)
return substr(dirlist.fs_ni, fs_twi, length(dirlist.fs_ni) - fs_twi + 1)

fs_ellipsis: /* shorten fs_filnam if necessary to fit available space */
arg fs_ni, fs_nw
fs_twi= fs_filnam(fs_ni)
if length(fs_twi) > fs_nw then
  fs_twi= left(fs_twi, fs_nw % 2)||'//'||right(fs_twi, (fs_nw % 2) - 3)
return fs_twi

fs_show_section: /* displays however much of dirlist. fits screen space */
  do fs_loop= 0 to scry - 1  /* sim clear screen; remove all of previous */
    if length(fs_view) = 0 then call syscurpos fs_loop, fs_scol
      else call syscurpos fs_loop, fs_scol - fs_dtlwid + 1
    call charout, ansi_clreol
  end
  fs_totlsiz= 0
  do fs_loop= 3 to fs_ndx
    fs_totlsiz= fs_totlsiz + fs_filsiz(fs_loop)
  end
  fs_loop= 0 /* 0 based for screen line */
  do until fs_loop + fs_ndx_ofs.fs_lvl >= fs_ndx | fs_loop >= fs_maxln
    fs_n= fs_loop + fs_ndx_ofs.fs_lvl + 1
    if length(fs_view) > 0 then do
      call syscurpos fs_loop, fs_scol - fs_dtlwid + 1
      call charout, ansi_clreol
      do fs_a= 1 to length(fs_view) /* order in fs_view sets displayed order! */
        fs_v= substr(fs_view, fs_a, 1)
        if fs_v= 'D' then call charout, fs_fildat(fs_n)' '
        if fs_v= 'T' then call charout, fs_filtim(fs_n)' '
        if fs_v= 'A' then call charout, fs_filatt(fs_n)' '
        if fs_v= 'S' then call charout, fs_filsiz(fs_n)' '
      end
    end
    call syscurpos fs_loop, fs_scol
    call charout, ansi_clreol
    select
      when fs_n = 1 then do
        call charout, d2c(17)||'.   'fs_ndx - 2' files'
      end
      when fs_n = 2 then do
        call charout, d2c(17)||'..  'fwc(fs_totlsiz, 0, 'N')' bytes'
      end
      when fs_n > 2 then do
        call fs_show_tag(fs_n)
        call charout, fs_ellipsis(fs_n, scrx - fs_scol)
      end
    end /* select */
    fs_loop= fs_loop + 1
  end /* do until */
  call fs_highlight
return

fs_show_path: /* assembles bottom line, then truncates to available space */
  fs_ps= ' (F1 Help) ['||word(sysdriveinfo(substr(fs_path, 1, 2)), 4)||'] '||,
    fwc(word(sysdriveinfo(substr(fs_path, 1, 2)), 2), 0, 'M')||,
    '  'fwc(word(sysdriveinfo(substr(fs_path, 1, 2)), 3), 0, 'M')||,
    '  'fs_path
  fs_width= scrx - fs_scol + fs_dtlwid - 1
  if length(fs_ps) < fs_width then fs_ps= fs_ps||copies('_', fs_width - length(fs_ps))
  call syscurpos scry, fs_scol - fs_dtlwid + 1 /* 0, 0 based */
  call charout, substr(fs_ps, length(fs_ps) - fs_width + 1, fs_width)
return

fs_show_new_dir: /* code needed several times */
  if fs_ndx < fs_showln then fs_maxln= fs_ndx; else fs_maxln= fs_showln
  call fs_show_section
  call fs_show_path
return

fs_exit_dir: /* for left-arrow at any time, or <enter> on a dot dir */
  if fs_lvl > 1 & length(fs_path) > 3 then do /* backs up one fs_lvl */
    if fs_lvl > 2 then do
      fs_loop= length(fs_path) - 1
      do until substr(fs_path, fs_loop, 1) = '\' | length(fs_path) < 4
        fs_loop= fs_loop - 1
      end
      fs_loop= fs_loop + 1
    end
    else fs_loop= 4
    fs_cur= substr(fs_path, fs_loop, length(fs_path) - fs_loop)
    fs_loop= length(fs_path)
    do until substr(fs_path, fs_loop, 1) = '\' | length(fs_path) < 4
      fs_loop= fs_loop - 1
    end
    fs_path= substr(fs_path, 1, fs_loop)
    fs_lvl= fs_lvl - 1
/*     fs_filter= 0 going up, so off likely better (re-filter with 'H') */
/* !!! ^ you may want to comment this out for dedicated applications */
    fs_ndx= get_1_directory(glo_var, fs_path, fs_flspc, fs_attr, fs_filter, 1)
    fs_tags= copies('', fs_ndx)
    call fs_sort_list
    call fs_set_sel
    call fs_show_new_dir
  end
return

fs_enter_dir: /* for right-arrow or <enter> on a non-dot dir; 10 LEVEL LIMIT */
  call syscurpos scry, fs_scol - fs_dtlwid + 1 /* 0, 0 based */
  call charout, 'Waiting for directory...'
  fs_cur= '' /* current selection always set off upon enter */
  fs_path= fs_path||fs_filnam(fs_n)||'\'
  fs_lvl= fs_lvl + 1
  fs_sel.fs_lvl= 1
  fs_ndx= get_1_directory(glo_var, fs_path, fs_flspc, fs_attr, fs_filter, 1)
  fs_tags= copies('', fs_ndx)
  call fs_sort_list
  call fs_set_sel
  call fs_show_new_dir
return

fs_highlight: /* show selected item (only the name...) in reverse color */
  call syscurpos fs_sel.fs_lvl - 1, fs_scol + 1
  call charout, revcolr||fs_ellipsis(fs_ndx_ofs.fs_lvl + fs_sel.fs_lvl, scrx - fs_scol)||norcolr
return

fs_lowlight: /* show name back in standard color */
  call syscurpos fs_sel.fs_lvl - 1, fs_scol + 1
  call charout, norcolr||fs_ellipsis(fs_ndx_ofs.fs_lvl + fs_sel.fs_lvl, scrx - fs_scol)
return

fs_show_tag: /* show tag (for dirs, simulate block w reverse color) */
  arg fs_ni
  if substr(fs_filatt(fs_ni), 2, 1) = 'D' then do
    if substr(fs_tags, fs_ni, 1) = '' then call charout, revcolr||d2c(16)||norcolr
    else call charout, d2c(16)
  end
  else call charout, substr(fs_tags, fs_ni, 1)
return

fs_set_sel: /* figures out what part of list to display, and item to select */
  fs_n= 0
  if length(fs_cur) > 0 then do /* assumes fs_cur is valid... */
    fs_cs= 1   /* first search for a matching name */
    do until fs_cs >= fs_ndx | pos(fs_cur, fs_filnam(fs_cs)) = 1
      fs_cs= fs_cs + 1
    end
  end
  else fs_cs= fs_ndx + 1
  if fs_cs <= fs_ndx then do  /* if name match, calc which to highlight */
    if fs_cs > fs_showln then do  /* split into pages */
      fs_ndx_ofs.fs_lvl= fs_cs - fs_showln
      fs_sel.fs_lvl= fs_showln
      fs_n= fs_showln % 2
      if fs_ndx_ofs.fs_lvl + fs_sel.fs_lvl + fs_n < fs_ndx then do
        fs_ndx_ofs.fs_lvl= fs_ndx_ofs.fs_lvl + fs_n
        fs_sel.fs_lvl= fs_sel.fs_lvl - fs_n
      end
    end
    else do /* less than a screenfull */
      fs_ndx_ofs.fs_lvl= 0;
      fs_sel.fs_lvl= fs_cs;
    end
  end
  else do /* no name match, calc a position */
    select
    when fs_initpos = 'H' then do /* show list from Head (top) */
      if fs_lvl > 1 & fs_ndx > 2 then fs_sel.fs_lvl= 3; else fs_sel.fs_lvl= 2
      fs_ndx_ofs.fs_lvl= 0
    end
    when fs_initpos = 'M' then do /* Middle */
      if fs_ndx > fs_showln then do /* more files than screen lines */
        fs_sel.fs_lvl= fs_showln % 2 + 1
        if (fs_ndx > 2 * fs_showln - 1) then fs_ndx_ofs.fs_lvl= fs_ndx % 2 - fs_sel.fs_lvl
          else fs_ndx_ofs.fs_lvl= (fs_ndx - fs_showln) % 2
      end
      else do
        if fs_ndx > 2 then fs_sel.fs_lvl= fs_ndx % 2 + 2; else fs_sel.fs_lvl = 2
        fs_ndx_ofs.fs_lvl= 0
      end
    end
    when fs_initpos = 'T' then do /* Tail (end) */
      if fs_ndx > fs_showln then do
        fs_sel.fs_lvl= fs_showln
        fs_ndx_ofs.fs_lvl= fs_ndx - fs_showln
      end
      else do
        fs_sel.fs_lvl= fs_ndx
        fs_ndx_ofs.fs_lvl= 0
      end
    end
    end /* select */
  end /* else of fs_cs <= fs_ndx */
return

/* get_1_directory can be invoked directly: gets only ONE level, NO recursion,
   BUT does all multiple file spec and filtering. Can be used for multiple
   concurrent lists by specifying stems in glo_var
   SPACES in file spec's present problems, that I DODGE by not allowing, but
   could be added if you're ambitious by changing the delimiter of g1_flspc
*/

get_1_directory:
parse arg glo_var, g1_path, g1_flspc, tattr, g1_filter, g1_dirs
/* get JUST ONE dir in Long (Y2K) form, and re-format:
2000-09-06 12:43:00  1234567890  A----  C:\os2\SWITCHRX.CMD
by removing unnecessary spaces and (known elsewhere) path to:
2000-09-06 12:43:00 1234567890 A---- SWITCHRX.CMD
1  words   2        3          4     5 --> remainder inc spaces */
  drop value(glo_var) /* toss any previous list */
  g1_addl= '____Date__ _Time___ ___Size___ Attrb  .'
  rc= value(glo_var||'1', g1_addl) /* fake dot dirs for sake of convention */
  g1_addl= 'yyyy-mm-dd hh:mm:ss          0 ADHRS  ..'
  rc= value(glo_var||'2', g1_addl) /* though will use the space for info */
  g1_addl= 2 /* additional, now is offset for accumulating to glo_var.0 */
  if substr(g1_path, length(g1_path), 1) \= '\' then g1_path= g1_path||'\'
  if g1_filter = 0 then do; g1_flspc= '*'; tattr= '*****'; end;
  do g1_nspec= 0 to words(g1_flspc) /* space delim'd, so NO OTHER spaces */
    ts.0= 0
    if g1_nspec > 0 then do
      rc= SysFileTree(g1_path||word(g1_flspc, g1_nspec), 'ts', 'FTL', tattr)
    end
    else do /* check get dirs */
      if g1_dirs = 1 then rc= SysFileTree(g1_path||'*', 'ts', 'DTL', tattr)
    end
    if ts.0 > 0 then do
      do g1_n= 1 to ts.0
        ts.g1_n= delstr(ts.g1_n, wordindex(ts.g1_n, 3) - 1, 1)
        ts.g1_n= delstr(ts.g1_n, wordindex(ts.g1_n, 4) - 1, 1)
        ts.g1_n= delstr(ts.g1_n, wordindex(ts.g1_n, 5) - 1, 1)
        p= pos(':\', ts.g1_n) - 1
        ts.g1_n= delstr(ts.g1_n, p, lastpos('\', ts.g1_n) - p + 1) /* strip out path */
        l= g1_n + g1_addl /* arithmetic */
        p= value(glo_var||l, ts.g1_n) /* SET (global) glo_var.[g1_n + addl] TO ts.g1_n */
      end
    end
    g1_addl= g1_addl + ts.0 /* sum # in current list plus all previous */
    p= value(glo_var||'0', g1_addl) /* set the number of elements */
  end
return g1_addl /* becomes fs_ndx, # of entries found */

fs_sort_list: /* Don't quibble that it's a slow primitive bubble sort; */
  fs_ns= fs_ndx  /* makes for easy coding to sort on varied fields. */
  if fs_ns > 3 then do 
    if substr(fs_filnam(2), 2, 1) = '.' then fs_head= 3; else fs_head= 1
    fs_head= 3
    do while substr(fs_filatt(fs_head), 2, 1) = 'D' /* KEEP DIRS FIRST */
      fs_head= fs_head + 1
    end
    if fs_head >= fs_ns then return /* until loop in REXX differs from TP! */
    do until fs_head >= fs_ns
      fs_cnt= fs_head + 1
      do until fs_cnt > fs_ns
        select /* get which field: Date, Extension, Name, or Size */
          when fs_sort = 'D' then do
            fs_v1= word(dirlist.fs_cnt, 1)||word(dirlist.fs_cnt, 2)
            fs_v2= word(dirlist.fs_head, 1)||word(dirlist.fs_head, 2)
          end
          when fs_sort = 'E' then do /* Simplistic. Scrambles re full name. */
            parse upper var dirlist.fs_cnt with dummy '.' fs_v1
            parse upper var dirlist.fs_head with dummy '.' fs_v2
          end
          when fs_sort = 'N' then do
            fs_twi= wordindex(dirlist.fs_cnt, 5)
            fs_v1= substr(dirlist.fs_cnt, fs_twi, length(dirlist.fs_cnt) - fs_twi + 1)
            fs_twi= wordindex(dirlist.fs_head, 5)
            fs_v2= substr(dirlist.fs_head, fs_twi, length(dirlist.fs_head) - fs_twi + 1)
          end
          when fs_sort = 'S' then do
            fs_v1= word(dirlist.fs_cnt, 3)
            fs_v2= word(dirlist.fs_head, 3)
          end
        end /* select */
        if fs_v1 < fs_v2 then do /* compare and swap */
          fs_twi= dirlist.fs_cnt
          dirlist.fs_cnt= dirlist.fs_head
          dirlist.fs_head= fs_twi
        end
        fs_cnt= fs_cnt + 1
      end
      fs_head= fs_head + 1
    end
  end
return

fs_show_instructions: /* NOTE customized for GFS, extra functions */
arg ix
if ix > 40 then ix= 40 /* caller handles all screen clean-up, heh */
call charout, revcolr
iy= 1
call say_inc 'ͻ'
call say_inc ' arrows:               ALT-keys:     '
call say_inc ' 'd2c(30)' up                  Copy/move     '
call say_inc ' 'd2c(31)' down                Filter toggle '
call say_inc ' 'd2c(16)' into directory      Password set  '
call say_inc ' 'd2c(17)' out of directory    sort by:      '
call say_inc '                         Date/time   '
call say_inc ' <escape> exit           Extension   '
call say_inc ' <enter> launch by       Name        '
call say_inc '   association           Size        '
call say_inc ' <CTRL-enter> will     display from  '
call say_inc '   attempt to execute    Head        '
call say_inc '                         Middle      '
call say_inc ' A-Z: select drive       Tail        '
call say_inc ' a-z, 0-9: jump 1st   Ķ'
call say_inc ' <home> sets destination directory    '
call say_inc ' <insert> copies or moves to "home"   '
call say_inc ' <delete> file (y) or directory (Y)   '
call say_inc 'Ķ'
call say_inc '  DGDs Generalized File Selector v2   '
call say_inc 'ͼ'
kd= 0
iy= 1
do while chars() = 0
 if kd // 5 = 0 then do
   call syscurpos iy, ix + 5; call charout, ' Hit any key '
 end
 else do
   call syscurpos iy, ix + 5; call charout, ''
 end
 call syssleep 1
 kd= kd + 1
end
kd= ex_read_key()
kd= ''
call charout, norcolr
return

say_inc:
parse arg it
call syscurpos iy, ix
call charout, it
iy= iy + 1
return

fwc: procedure /* format a number with commas; scale = Normal, Kilo-, Mega- */
  arg ns, len, scale /* ns = number, len = desired length padded; 0 = none */
  nf= ''
  scale= translate(scale)
  if scale <> 'K' & scale <> 'M' then scale= '' /* otherwise default */
  if scale = 'K' then ns= format(ns / 1024, , 0) /* no padding, no decimal */
  if scale = 'M' then ns= format(ns / 1048576, , 0)
  do p= length(ns) to 4 by -3
    nf= ','||substr(ns, p - 2, 3)||nf
  end
  if p > 0 then nf= substr(ns, 1, p)||nf
  nf= nf||scale
  if len > 0 then nf= copies(' ', len - length(nf) - length(scale))||nf
return nf


ex_read_key: /* returns two bytes for extended codes */
  xrkey= sysgetkey('noecho')
  if xrkey = d2c(0) | xrkey = d2c(224) then xrkey= xrkey||sysgetkey('noecho')
return xrkey

