{
 $Id$
}
{*****************************************************************************
 *
 * Purpose ...............: FileMgr Conversion Program
 *                          Bbs file area compiler
 *
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Program FmComp;          { FileMgr bbs file area compiler }

Uses Dos, Crt, S_String, F_file, Fm_Struct, Crosslib;

{ structure for FILEAREA.FM :

  Eerste 20 bytes (string type) bevatten het gekozen bbs + bbs naam.
  Daarna volgen BbsAreaType records, waarvan het eerste record voor
  speciale doeleinden is (voor ra2.0 staat daar bijv het path naar
  de fdb files in }

Type
  BbsAreaType = record
    on           : boolean;        {if true area is geselecteerd in filefind}
    name         : string[40];                            {name of file area}
    nr           : word;               {nu alleen nog ra 2.0/2.5: fbd nummer}
    path         : string[50];                       {path to download files}
  End;

Type
  List = ^Element;

  Element = Record
    B    : Bbsareatype;
    Next : List;
  End;

Var
  Bbsfile : File;
  Bbs     : BbsAreaType;

  BF      : File;  {savfile}
  BbsArea : BbsAreaType;
  Start,
  Current : List;
  SaveSet : Boolean;
  FfMax   : Longint;

  BbsPath : String;
  Number  : Word;
  SPath   : String;                {path to system dir / filemgr environment}
  Batchmode : Boolean;

Procedure OpenSaveFile;
var
  ffinx : longint;
Begin
  if not saveset then exit;

  Assign (BF, Spath+ 'FILEAREA.SAV');
  {$I-} Reset (BF,1); {$I+}
  If IOresult > 0 then
    begin
      Writeln('FILEAREA.SAV not found?!');
      Halt;
    end;
  FFMax := (Filesize(bF) div sizeof(bbsarea))-2;
  New(Start);
  Current := Start;
  Current^.Next := Nil;

  Write('Reading old FILEAREA.FM into memory...');
  For ffinx := 1 to ffmax+1 do
    begin
      Reset(bF,1);
      Seek(bF, ((FFinx-1) * Sizeof(Bbsarea)) + Sizeof(BbsArea) + 20);
      BlockRead(bF,Bbsarea,Sizeof(Bbsarea));

      Current^.b := bbsarea;
      If maxavail > 500 then
        begin
          New(Current^.Next);
          fillchar(current^.next,sizeof(current^.next),#0);
          Current := Current^.Next;
          Current^.Next := Nil;
        end else
        begin
          writeln;
          writeln('Not enough memory left!');
          halt;
        end;
    end;
  write(#13,expand(' ',60),#13);
End;

Procedure CloseSaveFile;
Begin
  if not saveset then exit;
  Close(bf);
  Erase(bf);
  if start^.next <> nil then
    begin
      repeat
        current := start;
        start := current^.next;
        dispose(current);
      until start^.next = nil;
    end;
  dispose(start);
End;

Procedure ReadSaveFile;
Var
  Ffinx : longint;
  Found : boolean;
Begin
  Ffinx := 0; Found := False; Current := Start;

  While not found and (current^.next <> nil) do
    begin
      inc(ffinx);

      if (upper(bbs.name) = upper(current^.b.name)) and
         (upper(bbs.path) = upper(current^.b.path)) then
           begin
             bbs.on := current^.b.on;
             found := true;
           end;
      current := current^.next;
    End;
End;

Procedure CreateFile;       {creates FileArea.FM and sets up first 20 bytes}
{-------------------}
Var Ch      : Char;
    Buf     : String;
    Result  : Word;
    Bbsname : String;
Begin
  SaveSet := False;
  Filemode := 66;
  Assign(Bbsfile,spath+'FILEAREA.FM');
  {$I-} Reset(Bbsfile); {$I+}
  If Ioresult = 0 then
    Begin
      If not batchmode then
        begin
          Write('FILEAREA.FM already exist, overwrite (Y/n) ? : ');
          Repeat Ch := Readkey Until Ch in [#13,'y','Y','n','N'];
        end else ch := 'Y';

      If Ch in ['n','N'] then
        Begin
          Writeln('No'+#10#13);
          Halt;
        End Else
        Begin
          if not batchmode then
            begin
              Writeln('Yes');

              Write('Maintain old filefind area settings (Y/n) ? : ');
              Repeat Ch := Readkey Until Ch in [#13,'y','Y','n','N'];
            end;

          If Ch in [#13,'y','Y'] then
            Begin
              if not batchmode then Writeln('Yes'+#10#13);

              If CopyFile( spath+'FILEAREA.FM', spath+'FILEAREA.SAV') <> 0 then
                Writeln('Could not copy FILEAREA.FM to FILEAREA.SAV!?') else
                  SaveSet := True;
            End Else
              Writeln('No'+#10#13);
        End;
    End;

  {$I-} Rewrite(Bbsfile); {$I+}
  If ioresult <> 0 then
    Begin
      Writeln('Cannot create/rewrite FILEAREA.FM');
      Halt;
    End;
  Reset(Bbsfile,1);

  Fillchar(Bbsname,20,#0);
  Case Str_To_Int(Paramstr(1)) of
    1  : Bbsname := 'SuperBBS 1.18    ';
    2  : Bbsname := 'QuickBBS 2.76    ';
    3  : Bbsname := 'Maximus 3.0      ';
    4  : Bbsname := 'Ezycom 1.10      ';
    5  : Bbsname := 'ProBoard 1.31    ';
    6  : Bbsname := 'PCBoard          ';
    7  : Bbsname := 'SpitFire 2.6b    ';
    8  : Bbsname := 'WildCat          ';
    9  : Bbsname := 'RemoteAccess 1.11';
   10  : Bbsname := 'RemoteAccess 2.0x';
   11  : Bbsname := 'RemoteAccess 2.5x';
   12  : Bbsname := 'RoboBoard 1.08   ';
   13  : Bbsname := 'Opus 1.70        ';
   14  : Bbsname := 'WME 1.09 beta 261';  {WME 1.09.Beta 2611}
   15  : Bbsname := 'Concord 0.01     ';  {should support the latest 1.06 }
   16  : Bbsname := 'Generic/Unknown  ';
  End;

  Buf := Expand(Paramstr(1),2) + Bbsname;
  BlockWrite(Bbsfile, Buf, 20, Result);

  If result <> 20 then
    Begin
      Writeln('Error while writing to FILEAREA.FM');
      Halt;
    End;
  Filemode := 32;
  fillchar(bbs,sizeof(bbs),#0);
End;


Procedure AddToFile(savsetting:boolean);  {adds current values of BBS to FileArea.FM}
{--------------------------------------}
Var
  Result : Word;
Begin
  If SavSetting then
    Begin
      ReadSaveFile;
    End;

  BlockWrite(Bbsfile,Bbs,sizeof(bbs),result);
  If Result <> sizeof(bbs) then
    Begin
      Writeln('Error writing to FILEAREA.FM');
      Halt;
    End;
  Write(expand(int_to_str(bbs.nr)+' - '+bbs.name,60),#13);
End;


{$I FMCONV.1}        {these files contains specific code for each bbs system}
{$I FMCONV.2}
{$I FMCONV.3}
{$I FMCONV.4}
{$I FMCONV.5}
{$I FMCONV.6}
{$I FMCONV.7}
{$I FMCONV.8}
{$I FMCONV.9}
{$I FMCONV.10}
{$I FMCONV.11}
{$I FMCONV.12}
{$I FMCONV.13}
{$I FMCONV.14}
{$I FMCONV.15}
{$I FMCONV.16}
{$I FM_SET.PAS}

Procedure Help;                                    {displays the help screen}
{-------------}
Begin
  Writeln('Usage: FMCONV <BBS type> <BBS directory> [-B]');
  Writeln(#13#10+'   Available BBS types:'+#10#13);
  Writeln(  '   1  -  SuperBBS 1.18            12  -  RoboBoard 1.08'  );
  Writeln(  '   2  -  QuickBBS 2.76            13  -  Opus 1.70'       );
  Writeln(  '   3  -  Maximus 3.0              14  -  Wme 1.09 (b2611)');
  Writeln(  '   4  -  Ezycom 1.10              15  -  Concord 1.06 *'  );
  Writeln(  '   5  -  ProBoard 1.31            16  -  Generic flsearch.ctl');
  Writeln(  '   6  -  PCBoard '            );
  Writeln(  '   7  -  SpitFire 2.6b'        );
  Writeln(  '   8  -  WildCat '            );
  Writeln(  '   9  -  RemoteAccess 1.11        * = supports 0.01'    );
  Writeln(  '  10  -  RemoteAccess 2.0x');
  Writeln(  '  11  -  RemoteAccess 2.5x         = not available yet');
  Writeln;
  Writeln(  ' -B (optional batchmode) assumes YES on all actions');
  Writeln;
End;


function checkepath(str:string;endslace:boolean):string;
var
  tmp,g,s1,s2 : string;
begin
  if pos('%',str) > 0 then
    begin
      tmp := last(length(str)-pos('%',str),str);
      if pos('%',str) > 1 then s1 := first(pos('%',str)-1,str) else s1 := '';
      if pos('%',tmp) > 0 then
        begin
          s2 := last(length(tmp)-pos('%',tmp),tmp);
          tmp := first(pos('%',tmp)-1,tmp);
          if length(tmp) > 0 then
            begin
              g := getenv(tmp);
              if g = '' then
                begin
                  writeln('Environment variable '+tmp+' (%'+tmp+'%) not found!');
                  exit;
                end else
                begin
                  str := s1 + g + s2;
                  if endslace then
                    begin
                      if (last(1,str) <> '\') and (length(str) > 2) then str := str + '\';
                    end;
                end;
            end;
        end;
    end;
  checkepath := str;
end;

procedure readconfig;
begin
  Assign (SF, SPath+'SETUP.FM');
  {$I-} Reset (SF); {$I+}
  If IOresult <> 0 then
    Begin
      WriteLn ('Error opening ',Spath,'SETUP.FM.');
      Writeln (#10#13+'Please run FMSETUP.EXE first or set the FILEMGR environment variable.');
      Halt (1);
    End;

  {$I-} Read (SF, SETUP); {$I+}
  If IOresult > 0 then
    Begin
      If filesize(Sf) < 12600 then
        Writeln('Old SETUP.FM version. Run UPGRADE.EXE first!') else
          WriteLn ('Error reading SETUP.FM');
      Close(SF);
      Halt(1);
    End;
  Close(SF);

  If SETUP.Version < VERSIONNR then
    Begin
      WriteLn ('Incorrect SETUP.FM version. Run UPGRADE.EXE first!');
      Halt(1);
    End;
  If setup.version > versionnr then
    begin
      writeln('Found version ',setup.version,' setup files, this FmConv copy is for version ',versionnr,'!');
      halt(1);
    end;
end;

procedure setsema;
var
  sr     : searchrec;
  lu, mu : longint;
  hund   : word;
  Dt     : Datetime;
begin
  If Setup.semamode <> 0 {none} then
    Begin
      setup.semaphorepath := checkepath(setup.semaphorepath,true);
      If setup.semaphorepath = '' then setup.semaphorepath := upper(systempath);
      If last(1,setup.semaphorepath) <> '\' then setup.semaphorepath := setup.semaphorepath + '\';
      If Exist(setup.semaphorepath+'FMBUSY.NOW') then
        Begin                      { check for startup semaphore }
          FindFirst(setup.semaphorepath+'FMBUSY.NOW', archive, sr);
          If Doserror = 0 then
            Begin
              unpacktime(sr.time,dt);
              mu := getunixdate(dt);
              With dt do
                begin
                  GetTime (Hour, Min, Sec, hund);
                  GetDate (Year, Month, Day, hund);
                end;
              lu := GetUnixDate(dt);
              If (lu-mu) > (setup.maxwaittime*60) then
                Begin        { als ie te oud is deleten }
                  Writeln('Semaphore is '+int_to_str((lu-mu) div 60)+' minuts old: deleted...');
                  Delete_file(setup.semaphorepath+'FMBUSY.NOW');
                  Create_File(setup.semaphorepath+'FMBUSY.NOW'); { en nieuwe creeren }
                End Else
                Begin       { anders wachten totdat maxwait op is }
                  Writeln('Other FileMgr task is busy, aborting...');
                  Halt;             { als ie dan nog bestaat halt }
                End;
              While doserror = 0 do findnext(sr);
            End;
        End Else
        Begin               { if not found set startup semaphore zelf }
          Create_File(setup.semaphorepath+'FMBUSY.NOW');
        End;
    End;
end;

Begin                         {the main program}
  TextAttr := 7;
  ClrScr;
  TextAttr := 14;
  WriteLn(#13#10+'FmConv v2.22 - Bbs file areas converter for Filemgr - 16-03-2008');
  TextAttr := 11;
  Writeln('Copyright (c) Vince Coen / Ron Huiskes 1992-2008. All Rights Reserved.'+#13#10);
  TextAttr := 7;

  spath := getenv('FILEMGR');
  if spath <> '' then
    if last(1,spath) <> '\' then
      spath := spath + '\';
  if spath <> '' then writeln('Using '+spath);

  readconfig;

  batchmode := false;
  if (paramcount = 3) and ((upper(paramstr(3)) = '-B') or (upper(paramstr(3)) = '/B'))
    then batchmode := true;
  if batchmode then writeln('Running in BATCHmode');

  if batchmode or (spath <> '') then writeln;

  If Paramcount < 2 then
    Help Else
      Begin
        setsema;

        CreateFile;
        OpenSaveFile;
        Number := 0;
        BbsPath := Paramstr(2);
        If last(1,BbsPath) <> '\' then BbsPath := BbsPath + '\';
        Case Str_To_Int(ParamStr(1)) of
          1 : Bbs1;
          2 : Bbs2;
          3 : Bbs3;
          4 : Bbs4;
          5 : Bbs5;
          6 : Bbs6;
          7 : Bbs7;
          8 : Bbs8;
          9 : Bbs9;
         10 : Bbs10;
         11 : Bbs11;
         12 : Bbs12;
         13 : Bbs13;
         14 : Bbs14;
         15 : Bbs15;
         15 : Bbs16;
         Else Help;
        End;
        Close(BbsFile);
        CloseSaveFile;
        Writeln(number,' areas converted.'+expand(' ',40)+#10#13);

        if (str_to_int(paramstr(1)) = 9) or
           (str_to_int(paramstr(1)) = 10) or
           (str_to_int(paramstr(1)) = 11) then convert;

        If Setup.semamode <> 0 {none} then
          Delete_file(setup.semaphorepath+'FMBUSY.NOW');
      End;
End.
