{
 $Id$
 VBC - 16/03/08 - v1.32 Cleanup copyright dates and contact details
}
{*****************************************************************************
 *
 * Purpose ...............: Billing History reporting Program
 *
 *****************************************************************************
 * Copyright (C) 1994-2008
 *
 * Vincent Coen / Ron Huiskes                 FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Program Fm_bill;

Uses Dos, Crt,
     S_string, M_window, F_fast, S_screen, Fm_List, Crosslib, Fm_Struct;

Type
 billhis = record           { history file }
   node  : nodetype;        { for this node }
   date  : datetime;        { date this was billed }
   files : word;            { number of files which were billed }
   cost  : real;            { total costs billed that day }
 end;

Var
  month : word;
  spath  : string;
  bfile  : file;
  barray : array[1..50] of billhis;
  b      : billhis;
  dt     : datetime;
  x : word;

Procedure Read_It(node:string);
Var
  x, count : word;
  tmp      : string;
  tel      : word;
  d : nodetype;
  validnode : boolean;
  total : real;
Begin
  tel := 0;
  total := 0;
  Assign(bfile,spath+'billhis.fm');
  {$I-} reset(bfile,1); {$I+}
  if ioresult <> 0 then
    begin
      writeln(#7+'Cannot find '+spath+'BILLHIS.FM');
      cursor_on;
      halt;
    end;

  if (node <> '') and (first(2,upper(node)) <> '/M') and (first(2,upper(node)) <> '-M') then
    begin
      Str2Node (node, d, SETUP.Address[1], ValidNode);
      If not validnode then
        begin
          writeln(#7,'Incorrect nodenumber: '+node);
          cursor_on;
          halt;
        end;
    end else node := '';


  create_list;
  repeat
    blockread(bfile,barray,sizeof(barray),count);
    count := count div sizeof(b);
    for x := 1 to count do
     begin
       inc(tel);
       dt := barray[x].date;
       tmp := allign(int_to_Str(dt.day),2)+'-'+allign(int_to_str(dt.month),2)+'-'+allign(int_to_str(dt.year),2);
       tmp := replace(' ','0',tmp);
       tmp := ' '+expand(int_to_str(tel),5)+'  '+first(18,expand(node2str(barray[x].node),18))+'  '+tmp;
       tmp := tmp + '      ' + expand(int_to_str(barray[x].files),5);
       tmp := tmp + '   ' + allign(real_to_str(barray[x].cost,2),9);

       if node <> '' then
         begin
           if samerec(d,barray[x].node,sizeof(d)) then
             begin
               if (month = 0) or (month = dt.month) then
                 begin
                   add_to_list(tmp);
                   total := total + barray[x].cost;
                 end;
             end;
         end else
         begin
           if (month = 0) or (month = dt.month) then
             begin
               total := total + barray[x].cost;
               add_to_list(tmp);
             end;
         end;
     end;
  until count = 0;

  add_to_list( replicate(53,' ')+'--------');
  add_to_list( replicate(51,' ')+ allign(real_to_str(total,1),9) );

  close(bfile);
End;

Procedure Do_it;
Var
  tmp : string;
Begin
  Mkwin(1,1,80,4,KL4,KL5,1);
  writeat(3,2,KL4,KL5,'FM_BILL v1.32 - View FileMgr''s Billing File.');
  writeat(3,3,KL4,KL5,'Copyright (c) Vince Coen / Ron Huiskes  1994 - 2008 All Rights Reserved.');

  Fillscreen(1,5,80,23,7,0,chr(177));
  writeat(1,24,1,0,replicate(80,''));
  writeat(2,25,7,0,'F1 Export');

  with mwin[1] do
    begin
      x1 := 3;
      x2 := 4;
      y1 := 77;
      y2 := 24;
      st := '';
    end;
  create_window(1);
  writeat(4,5,3,0,'  Entry: Node:               Date:           Files:     Billed:');
  writeat(4,6,1,0,replicate(72,''));
  mwin[1].x2 := 6;

  Repeat
     tmp := Show_List (1, true,true,1,1);
  until tmp = '';

  mwin[1].x2 := 4;
  remove_Window(1);
End;

procedure readconfigfm;
begin
 assign(sf,spath+'SETUP.FM');
 {$I-} reset(sf); {$I+}
 If ioresult <> 0 then
   Begin
     Writeln(#7,'Cannot open '+spath+'SETUP.FM');
     cursor_on;
     Halt;
   End;
 {$I-} read(Sf,setup); {$I+}
 If ioresult <> 0 then
   Begin
     Writeln(#7,'Cannot read '+spath+'SETUP.FM');
     cursor_on;
     Halt;
   End;
 Close(sf);
end;

{$F+} procedure f1_export; {$F-}
var
  tmp : string;
  x : word;
  t : text;
begin
  mwin[1].x2 := 4;

  with mwin[2] do
    begin
      x1 := 27;
      x2 := 10;
      y1 := 50;
      y2 := 16;
      st := ' Export ';
    end;
  create_window(2);
  writeat(29,12,7,0,'Export to filename:');
  tmp := '';
  read_String(32,14,12,12,tmp,c_all);
  if tmp <> '' then
    begin

      assign(t,tmp);
      {$I-} rewrite(t); {$I+}
      if ioresult = 0 then
        begin

          for x := 1 to list_amount do
            begin
              writeln(t,get_from_list(x));
            end;

          close(t);
        end;
    end;
  remove_Window(2);
  mwin[1].x2 := 6;
end;

Begin
  cursor_off;
  textattr := 7;
  clrscr;
  textattr := 14;
  writeln(#13#10+'FM_BILL v1.32 - View FileMgr''s Billing File.');
  textattr := 11;
  writeln('Copyright (c) Vince Coen / Ron Huiskes 1994 - 2008 All Rights Reserved.'+#10#13);
  textattr := 7;

  Spath := getenv('FILEMGR');
  If (last(1,spath) <> '\') and (length(spath) > 0) then spath := spath + '\';

  Readconfigfm;

  month := 0;
  x := 0;
  repeat
    inc(x);
    if (first(2,upper(paramstr(x))) = '/M') or (first(2,upper(paramstr(x))) = '-M') then
      begin
        month := str_to_int(last(length(paramstr(x))-2,paramstr(x)));
        if not (month in [1,2,3,4,5,6,7,8,9,10,11,12]) then
          begin
            writeln('No valid month specified: '+paramstr(x));
            cursor_on;
            halt;
          end;
      end;
  until x > paramcount;

  If paramcount > 0 then
    Read_it(paramstr(1)) else read_it('');

  f1_hook := f1_export;

  Do_It;

  Fillscreen(1,5,80,25,7,0,' ');
  remove_list;
  cursor_on;
End.
