PAGE  80,132
TITLE STRRETAB  Reduce spaces to Tabs routine, Ver 6.20

; STRRETAB.ASM - StrReTab
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine reduces spaces with tabs given the tab spacing.  Imbeded tabs
; are accounted for.  Tab spacing is a minimum of one and zero values are
; forced to 1.  Position 1 is considered column 1.
; Source and Dest can be the same address.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrReTab

Dest         EQU     DWORD PTR [bp+12]
Dofs         EQU     WORD  PTR [bp+12]
S            EQU     DWORD PTR [bp+8]
TabSpaces    EQU     BYTE  PTR [bp+6]
DestTab      EQU     es:[di]
TabAndSpace  EQU     0920h

; StrReTab - Replaces consecutive spaces with tabs given the tab spacing.
; procedure StrReTab (VAR Dest: string; S: string; TabSpaces: byte);

; AH: Col counter    AL: Load
; BH: Tab char       BL: Space char
; CH: 0              CL: Source count
; DH: Tab Spaces     DL: Space span counter

StrReTab     PROC  FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       push  ds               ; Save Pascal's DS
       xor   ax,ax            ; Set AX=0
       lds   si,S             ; Point to original string
       les   di,Dest          ; Point to result
       cld                    ; Set DF to increment
       lodsb                  ; Get length
       mov   cx,ax            ; Place in CX
       jcxz  Exit0            ; If Zero, then exit
; -- Check tab spacing >0 --
       mov   al,TabSpaces     ; Set Tab spaces in AL
       cmp   al,ah            ; Spaces=0?
       jnz   OK               ;   no, spacing OK
       inc   ax               ;   yes, set to 1
OK:    mov   dh,al            ; Save in DH
; -- Set pointers and counters --
       inc   di               ; Point to Result[1]
       mov   bx,TabAndSpace   ; Set BX to constants
T0:    mov   ah,dh            ; Reset col count
       mov   dl,ch            ; Reset span counter=0
; -- Scan for spaces or tabs --
       EVEN                   ; Align for speed
T1:    lodsb                  ; Get char
       cmp   al,bl            ; Space?
       je    T3               ;   yes, count spaces
T2:    stosb                  ;   no, save char
       cmp   al,bh            ; Tab?
       je    T4               ;   yes, reset counter
       dec   ah               ; At tab setting?
       jz    T4               ;   yes, reset counter
       loop  T1               ; Continue to scan
       jmp   SHORT Exit1      ; Go calc length
; -- Check for only one space at tab setting --
T3:    inc   dx               ; Increment span
       dec   ah               ; Decrement col count
       jnz   T6               ; Not at tab setting
; -- Account for tab or tab setting --
       stosb                  ; Save char
T4:    loop  T0               ; Continue to scan
       jmp   SHORT Exit1      ; Go calc length
; -- Attempt to reduce spaces --
T5:    lodsb                  ; Get next space/char
       cmp   al,bl            ; A space?
       jne   T7               ;   no, end of sequence
       inc   dx               ; Increment span
       dec   ah               ; Decrement col count
       jz    T8               ; At tab setting
T6:    loop  T5               ; Check next space
       ; -- Figure out last number of spaces --
T7:    xchg  ax,bx            ; Swap space constant and Char
       xchg  cl,dl            ; Swap string and span count
       rep   stosb            ; Save spaces
       xchg  dl,cl            ; Swap counters back
       xchg  ax,bx            ; Swap space constant and Char
       jcxz  Exit1            ; All done
       jmp   SHORT T2         ; Continue to scan
       ; -- Save a Tab --
T8:    mov   DestTab,bh       ; Save a Tab
       mov   ah,dh            ; Reset col counter
       mov   dl,ch            ; Reset first span counter=0
       inc   di               ; Next dest char
       loop  T5               ; Check next space
; -- Calculate length --
Exit1: mov   ax,Dofs          ; Get original offset
       xchg  ax,di            ; Exchange current DI
       sub   ax,di            ; Calc position
       dec   ax               ; Calc length
Exit0: stosb                  ; Save Result
       pop   ds               ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   10               ; Clear all parameters
StrReTab     ENDP

CODE   ENDS

       END
