PAGE  80,132
TITLE CHRINSR  String Add Right Routine, Ver 6.20

; CHRINSR.ASM - ChrAddR
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine adds repeated characters on the RIGHT of a string.
; Length will truncate at 255.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrInsR
        EXTRN   RepStosB: NEAR

S            EQU     DWORD PTR ss:[bx+8]
Fill         EQU     BYTE  PTR ss:[bx+6]
Count        EQU     BYTE  PTR ss:[bx+4]

; ChrInsR - Add repeated characters on the RIGHT of a string.
; procedure ChrInsR (VAR S: string; Fill: char; Count: byte);

ChrInsR      PROC FAR
       mov   bx,sp            ; Set up stack base
; -- Test Fill count --
       xor   ax,ax            ; Set AX=0
       mov   al,Count         ; Get proposed Count length
       mov   cx,ax            ; Set CH=0
       jcxz  Exit             ; Quit if no count
; -- Get S length --
       les   di,S             ; Point to source string
       mov   al,es:[di]       ; Load S[0] in AL
       mov   dx,ax            ; Save in DX, too
; -- Test new length --
       add   al,cl            ; New length in AX OK?
       jc    Cut              ;   no, have to truncate
; -- Save new length --
Save:  cld                    ; Set DF to increment
       stosb                  ; Set new length
       add   di,dx            ; At S[L+1]
; -- Add trailing chars --
       mov   al,Fill          ; Set AL to padding char
       call  RepStosB         ; Fast fill of trailing chars
Exit:  ret   8                ; Clear all parameters

Cut:   mov   cx,dx            ; Copy string length
       not   cl               ; 255-length
       mov   al,255           ; Set to Max length
       jmp   SHORT Save       ;
ChrInsR      ENDP

CODE   ENDS

       END
