{
 $Id$
}
{*****************************************************************************
 *
 * Purpose ...............: add a description for a file within files.bbs or
 *                          bbs database
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}
Unit Fm_bbs;  { add description to bbs (files.bbs/ra2.0) }

{$O+}

Interface

Uses
  Dos,
  F_File, S_String, Crosslib,
  Fm_Struct, Fm_Log, Fm_Basic, Nw_Tpl;


Function addtolist (tp,lp:string; area:word; tpl:string; replace:byte) : boolean;


Implementation


{   -   addlist  -  generic files.bbs procedure - }

Function AddList (D,L:string; TPLname:string; Replace:byte) : Boolean;
VAR
  O         : Text;
  Tmp       : String;
  pLine     : String;
  pWord     : String[12];
  ToRead,
  Written   : Boolean;

   Procedure Describe;
   Var
     ITEM : AnnounceLinkType;
     DT   : DateTime;
     Error : integer;
   Begin
     fillchar(item,sizeof(item),#0);
     getDOSdate (INFO.Date, DT);
     Move (DT, Today, SizeOf(DateTime));

     item.Name      := INFO.FileSpec;
     item.replaces  := info.replaces;
     item.Area      := INFO.TAG;
     item.Desc      := INFO.Description;

     if (longdesc in area.status) and ((info.longcount > 0) or (length(info.description) = 0)) then
       begin
         move(info.longdesc,item.ldesc,info.longcount);
         item.LCount    := INFO.LongCount;
       end;

     item.Magic     := Info.magic;
     item.CRCstr    := INFO.CRCstr;
     item.Arrived   := INFO.Forwar;
     item.Date      := INFO.Date;
     item.Size      := INFO.Size;
     item.Origin    := INFO.Origin;
     item.From      := INFO.From;
     item.Grp       := 0;
     item.Expo      := INFO.Expo;
     move(info.path,item.Path,sizeof(item.path));

     Convert_Tpl( TplName, Item, True, 1, '');
     Written := True;
   End;

Begin
  Assign (Tplfile, L);                                    {backup file maken}
  {$I-} Reset (tplfile); {$I+}
  if IOresult = 0 then
    begin                                               {if FILES.BBS exists}
      Assign (O, first(length(l)-1,L)+'$');
      Rewrite (O);
      while not EOF(tplfile) do
        begin
          ReadLn  (tplfile, pLine);
          WriteLn (O, pLine);
        end;
      Close (O);
      Close (tplfile);
      Assign (O, first(length(l)-1,L)+'$');
      Reset (O);
      ToRead := True;
    end else
      ToRead := False;

  Assign (tplfile, L);                                 {create new files.bbs}
  {$I-} Rewrite (tplfile); {$I+}
  If ioresult = 0 then
    Begin

      AddList := True;
      Written := False;
      If replace = 0 then info.replaces := '';

      While (ToRead) and (not EOF(O)) do
        Begin
          pWord := '';
          ReadLn (O, pLine);
          If (Length(pLine) > 0) and (not (pLine[1] in [' ','-','%','/','\'])) then
            Begin
              Pword := upper(extractwords(1,1,pLine));

              if (pWord = info.FileSpec) or (FileMatch(pword, info.replaces) and (info.replaces <> '')) then
                Begin

                  if FileMatch(pword,info.replaces) and setup.replace and (pword <> info.filespec) then
                    Begin
                      If area.ReplaceMode = 2 then
                        begin
                          copyfile(d+pword,setup.retirepath+pword);
                        end;
                      If Delete_file(d+pword) then Notify (6,'(replaced '+pword+') ');
                    End;

                  Describe;

                  If not eof(o) then {evt + regels verwijderen}
                    Begin
                      Repeat
                        ReadLn(O,Pline);
                        Tmp := Strip('B',' ',Pline);
                      Until not (tmp[1] in ['+','|','>']) or eof(o);
                      If not (tmp[1] in ['+','|','>']) then writeln(tplfile,pline);
                    End;

                End else
                  WriteLn (tplfile, pLine)
            End else
              WriteLn (tplfile, pLine);
        End;

      If ToRead then
        Begin
          {$I-} Close (O); Erase (O); {$I+}
          If ioresult <> 0 then Addlist := False;
        End;

      If NOT Written then Describe;
      Close (tplfile);               { close new FILES.BBS }
    End Else
      AddList := False;
End;





         (* add a file (and replace if ..) to RemoteAccess 2+ filebase *)

procedure ra2addfile (areanum:word; tp:string; replace:byte);
type
  fileshdrrecord = record
      name           : string[12];
      size,
      crc32          : longint;
      uploader       : string[35];
      uploaddate,
      filedate,
      lastdl         : longint;
      timesdl        : word;
      attrib         : byte;
      password       : string[15];
      keyword        : array[1..5] of string[15];
      cost           : word;
      longdescptr    : longint;
      freespace      : array[1..20] of byte;
  end;

  filesidxrecord = record
      name           : string[12];
      uploaddate     : longint;
      keywordcrc     : array[1..5] of longint;
      longdescptr    : longint;
  end;

var
  fidx    : file of filesidxrecord;
  idx     : filesidxrecord;
  fhdr    : file of fileshdrrecord;
  hdr     : fileshdrrecord;
  ftxt    : file;

  error   : integer;
  dt      : datetime;
  dow, x  : word;
  count : word;
  bbsbase : string;
  ch : char;
begin
  Assign(bF,systempath+'FILEAREA.FM');
  {$I-} Reset(bF,1); {$I+}
  If ioresult <> 0 then
    begin
      notifyCR(2,'Cannot open/find '+systempath+'FILEAREA.FM');
      exit;
    end;

  Seek(bF,20);
  BlockRead(bF,Bbsarea,Sizeof(Bbsarea),count);
  if count <> sizeof(bbsarea) then
    begin
      notifycr(2,'Error reading FILEAREA.FM');
      exit;
    end;
  BbsBase := Bbsarea.Path;
  If Last(1,bbsbase) <> '\' then bbsbase := bbsbase + '\';
  {vind bbsfilebasepath in 1e record van areafile.fm}

  Seek(Bf, (areanum-1) * sizeof(bbsarea) + sizeof(bbsarea) + 20);
  BlockRead(bf,BbsArea,sizeof(Bbsarea),count); {vind area in areafile.fm}
  if count <> sizeof(bbsarea) then
    begin
      notifycr(2,'Error reading FILEAREA.FM');
      exit;
    end;

  Close(Bf);

  assign (fhdr, bbsbase + 'HDR\FDB' + int_to_str(bbsarea.nr) + '.HDR');
  {$I-} reset (fhdr); {$I+}
  If ioresult <> 0 then
    begin
      {$I-} rewrite(fhdr); {$I+}
      If ioresult <> 0 then
        begin
          notifyCR(2,'Cannot open/create '+bbsbase+'HDR\FDB'+int_to_str(bbsarea.nr)+'.HDR');
          exit;
        end;
    end;
  assign (fidx, bbsbase + 'IDX\FDB' + int_to_str(bbsarea.nr) + '.IDX');
  {$I-} reset (fidx); {$I+}
  If ioresult <> 0 then
    begin
      {$I-} rewrite(fidx); {$I+}
      If ioresult <> 0then
        begin
          notifyCR(2,'Cannot open/create '+bbsbase+'IDX\FDB'+int_to_str(bbsarea.nr)+'.IDX');
          close(fhdr);
          exit;
        end;
    end;

  fillchar (idx, sizeof(idx), 0);

  if replace = 0 then info.replaces := '';

  while (  not eof(fidx) and (idx.name <> info.filespec) and
           (not FileMatch(idx.name,info.replaces) or (info.replaces = '')) ) do
     Begin
       read (fidx, idx);
     End;

  if (idx.name = info.filespec) or (FileMatch(idx.name,info.replaces) and (info.replaces <> '')) then
    begin

    seek (fidx, filepos(fidx)-1);

    if FileMatch(idx.name,info.replaces) and setup.replace and (idx.name <> info.filespec) then
      begin                                        {delete to replaced file}
        If area.ReplaceMode = 2 then
          begin
            copyfile(tp+idx.name,setup.retirepath+idx.name);
          end;
        if delete_file(tp+idx.name) then Notify (6,'(replaced '+idx.name+') ');
      end;
  end;

  seek (fhdr, filepos(fidx));

  assign (ftxt, bbsbase + 'TXT\FDB' + int_to_str(bbsarea.nr) + '.TXT');
  {$I-} reset (ftxt,1); {$I+}
  If ioresult <> 0 then
    begin
       {$I-} rewrite(ftxt,1); {$I+}
       If ioresult <> 0 then
         begin
           notifycr(2,'Cannot create '+bbsbase+'TXT\FDB'+int_to_str(bbsarea.nr)+'.TXT');
           close(fhdr);
           close(fidx);
           exit;
         end;
    end;
  seek (ftxt, filesize(ftxt));

  idx.name        := info.filespec;

  getdate (dt.year, dt.month, dt.day, dow);
  gettime (dt.hour, dt.min,   dt.sec, dow);
  packtime(dt, idx.uploaddate);

  idx.longdescptr := filepos(ftxt);
  write (fidx, idx);

  fillchar (hdr, sizeof(hdr), 0);
  getdosdate (info.date, dt);
  hdr.name           := info.filespec;
  hdr.size           := info.size;
{  hdr.crc32          := valhex (info.crcstr, error);}
  hdr.uploader       := node2str(info.from)+' in '+Proper(info.tag);

  packtime(dt, hdr.filedate);
  getdate (dt.year, dt.month, dt.day, dow);
  gettime (dt.hour, dt.min,   dt.sec, dow);
  packtime(dt, hdr.uploaddate);

  hdr.timesdl        := info.expo-1;
  if info.expo = 0 then hdr.timesdl := 0;

  hdr.lastdl         := hdr.uploaddate;
  hdr.longdescptr    := idx.longdescptr;
  write (fhdr, hdr);

  if (info.longcount > 0) and ((longdesc in area.status) or (length(info.description) = 0))
    then {lange omschrijving}
    begin
      info.longdesc[info.longcount+1] := #0;
      for x := 1 to info.longcount+1 do
        begin
          ch := #10;
          blockwrite(ftxt,info.longdesc[x],1);
          if info.longdesc[x] = #13 then blockwrite(ftxt,ch,1);
        end;
    end else
    begin
      info.description[length(info.description)+1] := #0;
      blockwrite (ftxt, info.description[1], length(info.description)+1);
    end;

  close (ftxt);
  close (fhdr);
  close (fidx);
end;


{---------------------------------------------------------------------------}


function addtolist (tp, lp : string; area : word;
                    tpl : string; replace:byte ) : boolean;

   {topath, listpath, area.areanr, info, tpl }

begin
  addtolist := true;
  case setup.filebase of
   0 {filesbbs}  : begin    (* normal FILES.BBS type operation *)
                    if tpl <> '' then
                      addlist (tp,lp,tpl,replace) else addtolist := false;
                   end;
   1 {rabase}    : begin    (* RemoteAccess 2.0+ type           *)
                    if area <> 0 then
                      begin
                        ra2addfile (area, tp, replace);
                      end else
                      begin
                        if tpl <> '' then
                          addlist (tp,lp,tpl,replace) else addtolist := false;
                      end;
                   end;
  end; {case}
end;

end.


