{
 $Id$
}
{*****************************************************************************
 *
 *  Purpose: Filebase control ie ra v2.0
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fil_Spec;    {filebase depending source code}

{$V-}

Interface

Uses
  Dos, Crt, S_String, Fm_Struct, fm_basic;

{---------------------------------------------------------------------------}

Var
  Desc_Buffer : Array[1..2048] of Char;
  Desc_Length : Word;
  Name_Buffer : String[12];
  FileListEnd : Boolean;

Procedure First_File( Filebase:Byte; FilesbbsPath:String; Bbs:Bbsareatype; Searchname:boolean);
   { opens filearea list, reads first file, sets filelistend var }
Procedure Next_File( Filebase:Byte; searchname:boolean );
   { finds next file in filebase, sets filelistend var }
Procedure Close_File ( FileBase:Byte );
   { closed the filearea list }

Function Find_File ( FileName:String; Filebase:Byte; Filesbbspath:String; Bbs:bbsareatype ) : Boolean;
   { opens/closes filearea list, tries to find filename, true if found
     wordt gebruikt in fm_hatch }
Function FileInArea (mask,filesbbspath:string;areanum:word): boolean;
   { ra 2.x only, kijk of een filemask (max300??.*) in een ra 2.x
     filebase zit. wordt gebruikt in fm_file }

{---------------------------------------------------------------------------}

Implementation

type
  fileshdrrecord = record  {ra 2.0 database}
      name           : string[12];
      size,
      crc32          : longint;
      uploader       : string[35];
      uploaddate,
      filedate,
      lastdl         : longint;
      timesdl        : word;
      attrib         : byte;
      password       : string[15];
      keyword        : array[1..5] of string[15];
      cost           : word;
      longdescptr    : longint;
      freespace      : array[1..20] of byte;
  end;


Var
  FilesBbsFile : Text;
  TmpBuffer    : String; {files.bbs, onthoudt volgende regel}

  fhdr         : file of fileshdrrecord;
  hdr          : fileshdrrecord;
  ftxt         : file;

  filelistopen : boolean;


Procedure ReadNextFilesBbsFile;
Var Tmp : String;
    Tm1 : String;
    X   : Integer;
Begin
  If TmpBuffer <> '' then
    Begin
      Tmp := TmpBuffer;
      TmpBuffer := '';
    End Else
    Begin
      Repeat
        {$I-} Readln(FilesBbsFile,Tmp); {$I+}
        X := Ioresult;
      Until (not (Tmp[1] in [' ','+','|','.','>']) and (tmp <> ''))
            or Eof(FilesBbsFile)
            or (X <> 0);
      If (Eof(filesbbsfile) or (X <> 0)) and (tmp = '') then
        Begin
          FileListEnd := True;
          Exit;
        End;
    End;

  {ok, nu hebben we de eerste <filenaam description> regel}
  FillChar(Desc_Buffer,sizeof(desc_buffer),#32);
  Name_Buffer := Strip('B',' ',First(12,Tmp));
  Desc_Length := 0;
  If not setup.wrapdesc then tmp := strip('R',' ',tmp) + #13;

  For X := setup.descstart to length(tmp) do
    Begin
      Inc(Desc_Length);
      Desc_Buffer[Desc_length] := Tmp[x];
    End;

  {kijken of de volgende regels extended ( + ) omschrijvingen zijn}
  Tmp := ' ';
  Repeat
    Readln(FilesBbsFile,Tmp);
    Tmp := Strip('L',' ',Tmp);
    If Tmp[1] in ['+','|','.','>'] then
      Begin
        Tm1 := Strip('B',' ',Tmp);
        If Tm1[1] in ['+','|','>'] then
          Begin
            Tm1 := Last(Length(Tm1)-1,Tm1);
            if setup.wrapdesc then Inc(Desc_Length);
          End;
        If not setup.wrapdesc then tm1 := strip('R',' ',tm1) + #13;
        For X := 1 to Length(Tm1) do
          Begin
            Inc(Desc_Length);
            Desc_Buffer[Desc_Length] := Tm1[x];
          End;
      End;
  Until Not (Tmp[1] in ['+','|','.','>']) or eof(FilesBbsFile);

  If not (Tmp[1] in ['+','|','.','>']) then
    TmpBuffer := Tmp; {volgende regel in tmpbuffer}
End;


Procedure ReadNextFilesRaFile(namesearch:boolean);
Var X : Integer;
Begin
   Hdr.name := '';
   Repeat
     {$I-} Read(fhdr,hdr); {$I+}
     X := Ioresult;
   Until (hdr.name <> '') or eof(fhdr) or (X <> 0);

  If (Eof(fhdr) or (X <> 0)) and (hdr.name = '') then
    Begin
      FileListEnd := True;
      Exit;
    End;

  name_buffer := hdr.name;

  if not namesearch then
    begin
      seek(ftxt,hdr.longdescptr);
      blockread(ftxt,desc_buffer[1],sizeof(desc_buffer),desc_length);
      x := 1;
      while x < desc_length do
        begin
          if desc_buffer[x] = #0 then
            desc_length := x else inc(x);
        end;
      if desc_length > 0 then dec(desc_length);
    end;
End;


Procedure First_File( Filebase:Byte; FilesbbsPath:String; Bbs:Bbsareatype; Searchname:boolean);
Begin
  FileListOpen := True;
  FileListEnd := False;
  Case FileBase of
   0 : Begin {filesbbs}
         TmpBuffer := '';
         Assign(FilesBbsFile,FilesBbsPath);
         {$I-} Reset(FilesBbsFile); {$I+}
         If ioresult <> 0 then
           Begin
             FileListOpen := False;
             FileListEnd := True;
             Exit;
           End;
         ReadNextFilesBbsFile;
       End;
   1 : Begin {ra 2.0}
         assign (fhdr, filesbbspath + 'HDR\FDB' + int_to_str(bbs.nr) + '.HDR');
         {$I-} reset (fhdr); {$I+}
         If ioresult <> 0 then
           begin
             filelistopen := false;
             filelistend := true;
             exit;
           end;
         assign (ftxt, filesbbspath + 'TXT\FDB' + int_to_str(bbs.nr) + '.TXT');
         {$I-} reset (ftxt,1); {$I+}
         If ioresult <> 0 then
           begin
             filelistopen := false;
             filelistend := true;
             close(fhdr);
             exit;
           end;
          ReadNextFilesRaFile(searchname);
        End;
  End;
End;

Procedure Next_File( Filebase:Byte; searchname:boolean );
Begin
  Case FileBase of
   0 : ReadNextFilesBbsFile;
   1 : ReadNextFilesRaFile(searchname);
  End;
End;

Procedure Close_File( Filebase:Byte );
Begin
  If not filelistopen then exit;
  Case FileBase of
   0 : Close(FilesBbsFile);
   1 : Begin
         Close(Fhdr);
         Close(Ftxt);
       End;
  End;
End;


Function FileInArea (mask,filesbbspath:string;areanum:word): boolean;
   {ra 2.x only}
Type
   fvr = array[1..25] of fileshdrrecord;
var
   fd : ^fvr;
   found : boolean;
   fhdrr : file;
   tel, x : word;
Begin
  If MaxAvail < SizeOf(fd) then
    Begin
      writeln('Not enough memory left for quick search (left: ',maxavail,', needed: ',sizeof(fd));
      fileinarea := false;
      exit;
    End Else
      New(fd);

  assign (fhdrr, filesbbspath + 'HDR\FDB' + int_to_str(areanum) + '.HDR');
  {$I-} reset (fhdrr,1); {$I+}
  If ioresult <> 0 then
    begin
      fileinarea := false;
      exit;
    end;
  found := false;
  tel := 1;
  while (tel <> 0) and not found do
    begin
      blockread(fhdrr,fd^[1],sizeof(fileshdrrecord)*25,tel);
      if tel > 0 then tel := tel div sizeof(fileshdrrecord);
      for x := 1 to tel do
        if filematch(fd^[x].name,mask) then found := true;
    end;
  close(fhdrr);
  dispose(fd);
  fileinarea := found;
End;


Function Find_File ( FileName:String; Filebase:Byte; Filesbbspath:String; Bbs:bbsareatype ) : Boolean;
   { opens/closes filearea list, tries to find filename, true if found}
Var Found : Boolean;
    x : word;
begin
  found := false;
  first_file(filebase,filesbbspath,bbs,true);
  if filelistopen then
    begin
      while not filelistend and not found do
        begin
          if upper(name_buffer) = upper(filename) then found := true;
          if not found then next_file(filebase,true) else
            begin
              if filebase = 1 then
                begin
                  seek(ftxt,hdr.longdescptr);
                  blockread(ftxt,desc_buffer[1],sizeof(desc_buffer),desc_length);
                  x := 1;
                  while x < desc_length do
                    begin
                     if desc_buffer[x] = #0 then
                       desc_length := x else inc(x);
                    end;
                  dec(desc_length);
                end;
            end;
        end;
      close_file(filebase);
    end;
  find_File := found;
End;

END.
