#!/bin/bash

tmpfile=/tmp/makediz.$$

find $1 -type f -iname "*.*" > $tmpfile

while read line
do
  if [ -e "$line" ]
    then
    fileto="$(basename "$line")"
    dirto="$(dirname "$line")"
    extension=$(echo "${fileto##*.}" | tr '[a-z]' '[A-Z]') 
    if [ "$extension" != "DIZ" ]
    then
      echo "|08SHA1: |07$(sha1sum "$line" | cut -d ' ' -f1)" > "$dirto/$fileto.diz"
      echo "|03" >> "$dirto/$fileto.diz"
      if [ "$extension" == "ZIP" ]
        then
        unzip -p $line "[fF][iI][lL][eE]_[iI][dD].[dD][iI][zZ]" >> "$dirto/$fileto.diz"
      elif [ "$extension" == "GBA" ]
        then
        echo "GameBoy Advance Rom File" >> "$dirto/$fileto.diz"
      else
        file "$line" | cut -d ':' -f2- >> "$dirto/$fileto.diz"
      fi
    fi
  fi

done < $tmpfile
rm $tmpfile
