(*
   Copyright (c)2020 RCS Development Team <rcs@castlerockbbs.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.

   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
*)
Uses Cfg
Uses User

Const
  PROG_NAME = 'RCS User Stats'
  PROG_VER  = '1.0'

Var
  Str	 : String
  
Procedure Show80
Begin
  // Procedure to show USER STATS to 80column users
  ClrScr
  dispfile('rcsuserstats')
  Str:='|23|00|UH''s Stats'
  gotoXY(10,6)
  write('|23')
  writeLn(PadCt(Str,60,' '))
  GotoXY(5,6)
  write('|23|00|BN|16|07')
  gotoXY(62,6)
  write('|23|00|DA |TI|16|07')
  gotoXY(5,8)
  write('[0;39 D')
  write('|03Handle & User #|11:|15 |UH #|U#')
  gotoXY(5,9)
  write('|03Real Name      |11:|15 |UN')
  gotoXY(5,10)
  write('|03Your Location  |11:|15 |UC')
  gotoXY(5,11)
  write('|03Your IP Address|11:|15 |UY')
  gotoXY(5,12)
  write('|03Your Host Name |11:|15 |UX')
  gotoXY(5,13)
  write('|03First Call     |11:|15 |FO')
  gotoXY(5,14)
  write('|03Last Call      |11:|15 |LO')
  gotoXY(5,15)
  write('|03Total Calls    |11:|15 |CS')
  gotoXY(5,16)
  write('|03Calls Today    |11:|15 |CT')
  gotoXY(5,17)
  write('|03Emails Sent    |11:|15 |ME')
  gotoXY(5,18)
  write('|03Message Posts  |11:|15 |MP')
  gotoXY(5,19)
  write('|03Files Uploaded |11:|15 |FU Files |FK kb')
  gotoXY(5,20)
  write('|03Files DLed     |11:|15 |DL Files |DK kb')
  gotoXY(45,8)
  write('|03Mystic BBS|11       :|15 |VR')
  gotoXY(45,9)
  write('|03Operating System|11 :|15 |OS')
  gotoXY(45,11)
  write('|03Post/Call Ratio|11  :|15 |PC')
  gotoXY(48,13)
  write('[0;0 D|08[|07Current Msg Group|08][0;39 D')
  gotoXY(42,14)
  write('|$C30|MG')
  gotoXY(48,15)
  write('[0;0 D|08[|07Current Msg Area|08][0;39 D')
  gotoXY(42,16)
  write('|$C30|MB')
  gotoXY(48,17)
  write('[0;0 D|08[|07Current File Group|08][0;39 D')
  gotoXY(42,18)
  write('|$C30|FG')
  gotoXY(48,19)
  write('[0;0 D|08[|07Current File Area|08][0;39 D')
  gotoXY(42,20)
  write('|$C30|FB')
  write('[0;0 D')
  pause
End

Procedure Show132
  Begin
// Procedure to show USER STATS to 132column users
  ClrScr
  dispfile('rcsuserstats')
  Str:='|23|00|UH''s Stats'
  gotoXY(20,8)
  write('|23')
  writeLn(PadCt(Str,92,' '))
  GotoXY(7,8)
  write('|23|00|BN|16|07')
  gotoXY(102,8)
  write('|23|00Local: |DA |TI|16|07')
  gotoXY(7,11)
  write('[0;39 D')
  write('|03Handle & User #|11:|15 |UH #|U#')
  gotoXY(7,12)
  write('|03Real Name      |11:|15 |UN')
  gotoXY(7,13)
  write('|03Your Location  |11:|15 |UC')
  gotoXY(7,14)
  write('|03Your Host Name |11:|15 |UX')
  gotoXY(7,15)
  write('|03Your IP Address|11:|15 |UY')
  gotoXY(7,16)
  write('|03First Call     |11:|15 |FO')
  gotoXY(7,17)
  write('|03Last Call      |11:|15 |LO')
  gotoXY(7,18)
  write('|03Total Calls    |11:|15 |CS')
  gotoXY(7,19)
  write('|03Calls Today    |11:|15 |CT')
  gotoXY(7,20)
  write('|03Emails Sent    |11:|15 |ME')
  gotoXY(7,21)
  write('|03Message Posts  |11:|15 |MP')
  gotoXY(7,22)
  write('|03Files Uploaded |11:|15 |FU Files |FK kb')
  gotoXY(7,23)
  write('|03Files DLed     |11:|15 |DL Files |DK kb')
  gotoXY(7,24)
  write('|03Time Left      |11:|15 |TL')
  gotoXY(7,25)
  write('|03Time Bank Mins |11:|15 |TB')
  gotoXY(7,28)
  write('|03Security Level |11:|15 |SD')
  gotoXY(7,30)
  write('|03Post/Call Ratio|11:|15 |PC')
  gotoXY(95,11)
  write('|03Total BBS calls|11  :|15 |TC')
  gotoXY(95,12)
  write('|03Mystic BBS|11       :|15 |VR')
  gotoXY(95,13)
  write('|03Operating System|11 :|15 |OS')
  gotoXY(95,15)
  write('|03Next BBS Event  |11 :|15 |NE')
  gotoXY(95,23)
  write('|03Auto-Signature    |11:|15 |AS')
  gotoXY(95,24)
  write('|03Available for chat|11:|15 |AV')
  gotoXY(95,25)
  write('|03Node Invisibility |11:|15 |IL')
  gotoXY(95,26)
  write('|03Emulation Mode   |11 :|15 |TE')
  gotoXY(95,27)
  write('|03Screen Size      |11 :|15 |US')
  gotoXY(95,29)
  write('|03Total Email       |11:|15 |MW')
  gotoXY(95,30)
  write('|03Unread Email      |11:|15 |MU')
  gotoXY(57,16)
  write('[0;0 D|08[|07Current Msg Group|08][0;39 D')
  gotoXY(47,17)
  write('|$C40|MG')
  gotoXY(57,19)
  write('[0;0 D|08[|07Current Msg Area|08][0;39 D')
  gotoXY(47,20)
  write('|$C40|MB')
  gotoXY(57,24)
  write('[0;0 D|08[|07Current File Group|08][0;39 D')
  gotoXY(47,25)
  write('|$C40|FG')
  gotoXY(57,27)
  write('[0;0 D|08[|07Current File Area|08][0;39 D')
  gotoXY(47,28)
  write('|$C40|FB')
  write('[0;0 D')
  pause
End

Begin
  GetThisUser
  If TermSizeX=132 Then Show132
  Else If TermSizeX=80 Then Show80
End
