(*
   Scrollz Announcements
   
   Copyright 2020-21 Black Panther(RCS) <dan@castlerockbbs.com>
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.

    2021-12-07  RCS Development Team  <rcs@castlerockbbs.com>
V1.0
* Extended the text to allow up to 255 characters per banner
* Hid the cursor instead of moving it to bottom corner
* Put check in place to make sure banner doesn't extend beyond screen width
* Cleaned up some code
* Added auto adjust to allow for terminal size detection
* Will now truncate lines to 255 characters
* Now checks to make sure endx is more than 10 and less than termsizex
* Added error checking on all Str2Int calls
* Added logging to show errors or warnings in config file

*)

Uses CFG

Const
  PROG_NAME    = 'RCS Scrollz Announcements'
  PROG_VER_MAJ = '1'
  PROG_VER_MIN = '0'
  PROG_VER_TYP = 'public beta'
  PROG_DATE    = '07 Dec 2021'
  
Var
  DelTime  :Integer=150
  Banner   :String
  Banners  :Array[1..11] of String
  colortext:String[4]='3'
  capcharlt:String[5]
  capcharrt:String[5]
  colorcaps:String[4]='9'
  count    :Byte=0
  x        :Byte=10
  y        :Byte=8
  z        :Byte=0
  v        :Byte=1
  t        :Byte=1
  oldt     :Byte=1
  oldt2    :Byte=1
  endx     :Byte=70
  msglen   :Byte
  fldlen   :Byte
  temp     :String
  temp1    :String
  ch       :Char
  done     :Boolean=false
  ininame  :String
  
Function IsNumber(str:String):Boolean
Begin
  IsNumber:=Str2Int(str) > 0 Or str = '0'
End
  
procedure init(ini:string)
Var
  config     : FILE
  s          : String
  s1         : String
  s2         : String
  tmp        : Byte
Begin
  fAssign(config,CfgMpePath+ini,66)
  fReset(config)
  If IOResult = 0 Then
  Begin
    While Not fEOF(config) do
    Begin
      fReadLn(config,s)
      if s[0]<>';' then
      Begin
        s1:=WordGet(1,s,'=')
        s2:=WordGet(2,s,'=')
        Case s1 of
          'line'      : Begin
                          If IsNumber(s2) Then y:=Str2Int(s2)
                          Else
                          Begin
                            SysopLog(PROG_NAME+': Error in '+ini+' - line '''+s2+''' is not numeric');
                            SysopLog(PROG_NAME+': Using default of line=8');
                            y:=8;
                          End
                        End
          'start'     : Begin
                          If IsNumber(s2) Then x:=Str2Int(s2)
                          Else
                          Begin
                            SysopLog(PROG_NAME+': Error in '+ini+' - start '''+s2+''' is not numeric');
                            SysopLog(PROG_NAME+': Using default of start=10');
                            x:=10;
                          End
                        End
          'end'       : Begin
                          If IsNumber(s2) Then endx:=Str2Int(s2)
                          Else
                          Begin
                            SysopLog(PROG_NAME+': Warning in '+ini+' - end '''+s2+''' is not numeric');
                            SysopLog(PROG_NAME+': Using default of end='+Int2Str(TermSizeX-x)+' - ('+Int2Str(TermSizeX)+'-'+Int2Str(x)+')');
                          End
                        End
          'colortext' : colortext:=s2
          'capcharlt' : capcharlt:=s2
          'capcharrt' : capcharrt:=s2
          'colorcaps' : colorcaps:=s2
          'speed'     : Begin
                          If IsNumber(s2) Then DelTime:=Str2Int(s2)
                          Else
                          Begin
                            SysopLog(PROG_NAME+': Error in '+ini+' - speed '''+s2+''' is not numeric');
                            SysopLog(PROG_NAME+': Using default of speed=150');
                            DelTime:=150;
                          End
                        End
          'count'     : Begin
                          If IsNumber(s2) Then count:=Str2Int(s2)
                          Else
                          Begin
                            SysopLog(PROG_NAME+': Warning in '+ini+' - count '''+s2+''' is not numeric');
                            SysopLog(PROG_NAME+': Counting total number of banner lines in '+ini);
                          End
                        End
          'banner1'   : Banners[1]:=s2
          'banner2'   : Banners[2]:=s2
          'banner3'   : Banners[3]:=s2
          'banner4'   : Banners[4]:=s2
          'banner5'   : Banners[5]:=s2
          'banner6'   : Banners[6]:=s2
          'banner7'   : Banners[7]:=s2
          'banner8'   : Banners[8]:=s2
          'banner9'   : Banners[9]:=s2
          'banner10'  : Banners[10]:=s2
        End
      End
    End
    fClose(config)
  End 
  Else Writeln('Unable to open config file')
  If (Count=0) Then
  Begin
    While Banners[Count]<>'' Do
      Count:=Count+1;
  End
  If Count>10 Then Count:=10;
  Banners[count+1]:='Welcome to the new RCS Scrollz Announcements for Mystic v'+PROG_VER_MAJ+'.'+PROG_VER_MIN+' '+PROG_VER_TYP+' - '+PROG_DATE
  tmp:=length(capcharlt)+1
  if x>4 then writexy(x-tmp,y,Str2Int(colorcaps),capcharlt)
  if endx>x+10 Then
  Begin
    if endx>TermSizeX-4 Then endx:=TermSizeX-x
    if endx<TermSizeX-4 then writexy(endx+1,y,Str2Int(colorcaps),capcharrt)
  End
  Else 
  Begin
    endx:=TermSizeX-x
    WriteXY(endx+1,y,Str2Int(colorcaps),capcharrt)
  End
End

procedure endmpl
Begin
  Write('|[1')
  ch:=readkey
  StuffKey(ch)
  Halt
End

Begin
  if ParamCount<1 Then
  Begin
    WriteLn('|CRError: No INI file indicated')
    SysopLog('Scrollz was not passed the INI file name')
    halt
  End
  Write('|[0')
  ininame:=ParamStr(1)
  init(ininame)
  fldlen:=endx-x
  if length(colortext)=1 then insert('0',colortext,1)
  if colortext[0]<>'|' then insert('|',colortext,1)
  Repeat
    if keypressed then endmpl
    repeat
      t:=Random(count+1)+1
    until t<>oldt or t<>oldt2
    if Banners[t]='' or t>count then Banner:=Banners[count+1]
    if Banners[t]<>'' then Banner:=Banners[t]
    Banner:=StripMCI(Banner)+'   '
    msglen:=Length(Banner)
    if msglen>255 then delete(Banner,255,msglen-255)
    z:=0
    v:=1
    Repeat
      if keypressed then endmpl
      z:=0
      gotoxy(x,y)
      temp1:=Copy(Strippipe(Banner),1,v)
      temp:=PadLT(temp1,fldlen-z,' ')
      write(colortext+temp)
      z:=z+1
      v:=v+1
      delay(DelTime)
    Until v=msglen or v=fldlen
    z:=1
    Repeat
      if keypressed then endmpl
      temp:=''
      gotoxy(x,y)
      if msglen<fldlen then
        temp:=PadLT(Banner,fldlen-z,' ')
      Else
      Begin
        temp:=Copy(Banner,z,fldlen)
        z:=z+1
      End
      write(temp)
      z:=z+1
      delay(DelTime)
    Until (z>fldlen-msglen)
    z:=0
    v:=2
    Repeat
      if keypressed then endmpl
      gotoxy(x,y)
      temp1:=Copy(Banner,v,msglen)
      temp:=PadRt(temp1,fldlen,' ')
      write(temp)
      v:=v+1
      delay(DelTime)
    Until v=msglen+2
    if count>4 then oldt2:=oldt
    oldt:=t
  Until done
  endmpl
End
