/*
  Program: RCS Last Caller
     Date: 05/20/2019
   Author: Dan Richter(RCS), aka Black Panther of Castle Rock BBS
  Contact: Black Panther at Castle Rock BBS
   telnet://bbs.castlerockbbs.com

  This is a simple MPL program that displays a list of the last 10 callers
  of the BBS. It was written for, and works with, Mystic v1.12A43+.


   Copyright 2020 Black Panther(RCS) <dan@castlerockbbs.com>
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.

*/

Uses CFG

Const prog = 'RCS Last Caller'
Const  ver = 'v0.08b'

Type   RecLastOn = Record                 // CALLERS.DAT
    MDateTime  : LongInt;
    NewUser    : Boolean;
    PeerIP     : String[15];
    PeerHost   : String[50];
    Node       : Byte;
    CallNum    : LongInt;
    Handle     : String[30];
    City       : String[25];
    Address    : String[30];
    Gender     : Char;
    EmailAddr  : String[35];
    UserInfo   : String[30];
    OptionData : Array[1..10] of String[60];
    Reserved   : Array[1..53] of Byte;
  End;

Var
  Callerdat : String
  Call      : array[1..10] of RecLastOn

Function ReadCall:Boolean
Var
  Ret   : Boolean = False
  Fptr  : File
  counter:Byte=1
Begin
  Callerdat:=CFGDataPath+'callers.dat'
  fAssign(Fptr,Callerdat,66)
  fReset(Fptr)
  If IOResult = 0 Then Begin
    For counter:=1 to 10 do
    Begin
      If Not fEof(Fptr) Then Begin
        fReadRec(Fptr,Call[counter])
      End
    End
    Ret:=True
    fClose(Fptr)
  End
  ReadCall:=Ret
End

Procedure progexit
Begin
  Halt
End

Procedure Init
Begin
  Clrscr
  if (ReadCall=false) then progexit
End

Procedure Drawscreen
Var count : integer = 1
Begin
  dispfile('lastten')
  WriteLn('|CR|09  User                    Node  Location                  Date       Time')
  WriteLn('|01---------------|03----|11----|10----|15---------------------|15----|10----|11----|03----|01---------------|11')
  for count:=1 to 10 do
      WriteLn('  '+PadRt(Call[count].Handle,25,' ')+Int2Str(Call[count].Node)+'    '+PadRt(Call[count].City,25,' ')+' '+DateSTR(Call[count].MDateTime,1)+'   '+TimeStr(Call[count].MDateTime,False))
  WriteLn('|15----|10----|11----|03----|01-------------------------------------------|01----|03----|11----|10----|15----')
  gotoxy(1,21)
  WriteLn('|01|BN - |SN')
  gotoxy(58,21)
  WriteLn('|01'+prog+' '+ver)
  gotoxy(1,23)
  pause
  progexit
End

Begin
  Init
  Drawscreen
End
