import numpy as np
import ephem
import datetime
from datetime import timedelta
import sys
import pylab as plt
import os.path
import math

l1=""
l2=""
l3=""

def loadTLE(filename):
    """ Loads a TLE file and creates a list of satellites."""
    global l1
    global l2
    global l3
    f = open(filename)
    l1 = f.readline()
    l2 = f.readline()
    l3 = f.readline()
    f.close()

#Assign parameters
lat= str(sys.argv[1])
lon= str(sys.argv[2])
fl = str(sys.argv[3])

loadTLE(fl)

# Setup lat long of telescope
myplace = ephem.Observer()
#myplace.lat = np.deg2rad(51.75)
#myplace.long = np.deg2rad(-1.259)
myplace.lat = np.deg2rad(float(lat))
myplace.long = np.deg2rad(float(lon))
myplace.date = datetime.datetime.now()

# Load Satellite TLE data.
biif1 = ephem.readtle(l1,l2,l3)


# Make some datetimes
midnight = datetime.datetime.replace(datetime.datetime.now(), hour=0)
dt  = [midnight + timedelta(minutes=(20*x)) for x in range(0, 24*3)]

myplace.date = datetime.datetime.now()
biif1.compute(myplace)
print "|15Object :|07 %s" % l1
print "|15Alt: |07%-30s" % (np.rad2deg(biif1.alt))
print "|15Azim.: |07%-30s" % (np.rad2deg(biif1.az))
print "|15Geographic point beneath satellite"
print "|15Lat: |07%-15s |15Long.:|07 %-15s" % ((np.rad2deg(biif1.sublat)),np.rad2deg(biif1.sublong))
#print "|12https://www.google.gr/maps/@%s,%s,15z" % ((np.rad2deg(biif1.sublat)),np.rad2deg(biif1.sublong))
print "|15Distance from observer to satellite"
print "|07%30s |08meters|07" % (biif1.elevation)
print "|15Range rate of change "
print "|07%30s |08m/s" % (biif1.range_velocity)
print "|15Eclipsed: |07%-30s " % (biif1.eclipsed)
print "|15P|07ress |15CTRL-X |07to |15D|07ownload |15X-Axis |15D|07iagram"
print "|15P|07ress |15CTRL-P |07to |15D|07ownload |15P|07olar |15D|07iagram"
print "|15P|07ress |15CTRL-I |07to |15D|07ownload |15D|07isplayed |15I|07nfo"

# Compute satellite locations at each datetime
sat_alt, sat_az = [], []
for date in dt:
    myplace.date = date
    biif1.compute(myplace)
    sat_alt.append(np.rad2deg(biif1.alt))
    sat_az.append(np.rad2deg(biif1.az))
    
ft = os.path.dirname(fl)
ft = os.path.join(ft, '')

# Plot satellite tracks
plt.figure()
plt.subplot(211)
plt.plot(dt, sat_alt)
plt.ylabel("Altitude (deg)")
plt.xticks(rotation=25)
plt.subplot(212)
plt.plot(dt, sat_az)
plt.ylabel("Azimuth (deg)")
plt.xticks(rotation=25)
plt.savefig(ft+'axis.png')
plt.close

# Plot satellite track in polar coordinates
plt.figure()
plt.polar(np.deg2rad(sat_az), 90-np.array(sat_alt))
plt.ylim(0,90)
plt.savefig(ft+'polar.png')
plt.close
print
print "|07Next |153 |07passes from your coordinates"
print "If there is no data, then the sat does not"
print "pass from your location."
print
for p in range(3):
  tr, azr, tt, altt, ts, azs = myplace.next_pass(biif1)
  print """Date/Time (UTC)       Alt/Azim   Lat/Long  Elev"""
  print """====================================================="""
  while tr < ts:
    myplace.date = tr
    biif1.compute(myplace)
    print "%s   %4.1f %5.1f   %4.1f %+6.1f   %5.1f" % \
      (tr, 
       math.degrees(biif1.alt), 
       math.degrees(biif1.az), 
       math.degrees(biif1.sublat), 
       math.degrees(biif1.sublong), 
       biif1.elevation/1000.)
    tr = ephem.Date(tr + 20.0 * ephem.second)
  print
  myplace.date = tr + ephem.minute
