#!/bin/bash
#
# Paging Module v1.3 (linux) - script
#
# Text Messages
# Audio Playback
# Sysop availability status message
# Login Alert (audio and/or text)
# Email Notification
#
# Developer: niter3
# Alpha Tester: caphood (Hawk Hubbard)
#
# NOTES:
#
# Update the variables below to reflect your setup.
#
#

mysticpath="/mystic" # BBS install location
cellnumb="0000000000" # Cell number.
cellgateway="smsgateway.com" # Cell provider's gateway.
email="email@domain.com" # Your email address
datetime=`date`

# Paging

if [ -e /tmp/cl_temp.txt ]; then

        IFS=$'\n' read -d '' -r -a lines < /tmp/cl_temp.txt

        rm -f /tmp/cl_temp.txt

        mail -s "" $cellnumb@$cellgateway <<< "User ${lines[0]} is paging from ${lines[3]}. (${lines[1]})"

fi

# Alerting

if [ -e /tmp/cl_alert.txt ]; then

        IFS=$'\n' read -d '' -r -a lines < /tmp/cl_alert.txt

        rm -f /tmp/cl_alert.txt

        mail -s "" $cellnumb@$cellgateway <<< "User ${lines[0]} has logged into ${lines[1]} on node ${lines[2]}."

fi

# Email Notification - (Setup is in the .mps)

if [ -e /tmp/cl_email.txt ]; then

        IFS=$'\n' read -d '' -r -a lines < /tmp/cl_email.txt

	rm -f /tmp/cl_email.txt

	echo "${lines[0]} / Page Alert" >> /tmp/cl_emailout.txt
	echo "==============================" >> /tmp/cl_emailout.txt
	echo "" >> /tmp/cl_emailout.txt
	echo "Date/Time: $datetime" >> /tmp/cl_emailout.txt
	echo "User: ${lines[1]}" >> /tmp/cl_emailout.txt
	echo "Node: ${lines[2]}" >> /tmp/cl_emailout.txt
	echo "IP address: ${lines[3]}" >> /tmp/cl_emailout.txt
	echo "Reason: ${lines[4]}" >> /tmp/cl_emailout.txt

	mail -s "" $email < /tmp/cl_emailout.txt 

	rm -f /tmp/cl_emailout.txt

fi


