/*͸
   OS/2 Video API Version 1.00  13-01-96    (C) 1996 by CodeLand Australia 
   WIN.H                                               All Rights Reserved 
  ;*/

typedef SHORT WINDOW;
typedef WINDOW* PWINDOW;

/**/

/* Error codes returned from windowing functions */
#define W_NOERROR   0       /* no error                          */
#define W_ESCPRESS  1       /* Escape key was pressed            */
#define W_ALLOCERR  2       /* memory allocation error           */
#define W_NOTFOUND  3       /* record not found                  */
#define W_NOACTIVE  4       /* no active window                  */
#define W_INVCOORD  5       /* invalid coordinates               */
#define W_INVFORMT  6       /* invalid format string             */
#define W_NOINPDEF  7       /* no input fields defined           */
#define W_STRLONG   8       /* string too long for window        */
#define W_INVBTYPE  9       /* invalid box type                  */
#define W_NOBORDER  10      /* no window border                  */
#define W_NOHIDDEN  11      /* no hidden windows                 */
#define W_NOTHIDD   12      /* window is not hidden              */
#define W_NOSELECT  13      /* no selectable menu items          */
#define W_NOITMDEF  14      /* no menu items defined             */
#define W_NOMNUEND  15      /* no end of menu specified          */
#define W_NOMNUDEF  16      /* no menu defined                   */
#define W_NOMNUBEG  17      /* no begin of menu specified        */
#define W_NOFRMDEF  18      /* no form defined                   */
#define W_NOFRMBEG  19      /* no begin of form specified        */
#define W_NOHLPDEF  20      /* no help record defined            */
#define W_HLPSTKOV  21      /* help stack overflow               */
#define W_HLPSTKUN  22      /* help stack underflow              */
#define W_DOSERROR  23      /* DOS error                         */
#define W_NOMATCH   24      /* no files matched input filespec   */
#define W_INVTAGID  25      /* invalid tag identifier            */

/* Window border identifiers */
#define TP_BORD  0      /* top border    */
#define BT_BORD  1      /* bottom border */
#define LT_BORD  2      /* left border   */
#define RT_BORD  3      /* right border  */

/* Direction codes */
#define D_DOWN    0
#define D_UP      1
#define D_LEFT    2
#define D_RIGHT   3
#define SDOWN     D_DOWN    /* scroll down */
#define SUP       D_UP      /* scroll up   */

/* Fmask definitions for wmenuitem() */
#define M_HASPD     1   /* has pull-down menu attached   */
#define M_NOSEL     2   /* is not selectable             */
#define M_CLOSE     4   /* close menu after select func  */
#define M_CLALL     8   /* close all menus when selected */
#define M_CLOSB    16   /* close menu before select func */

/* Menutype definitions for wmenuend() */
#define M_HORZ      1       /* horizontal menu         */
#define M_VERT      2       /* vertical menu           */
#define M_OMNI      7       /* omnidirectional menu    */
#define M_PD        8       /* pull-down menu          */
#define M_NOQS      16      /* disable quick selection */
#define M_SAVE      32      /* save last bar position  */

/* Special return codes from wmenuget() */
#define M_EXIT      32764   /* exit menu               */
#define M_EXITALL   32765   /* exit all menus          */
#define M_PREVPD    32766   /* previous pull-down menu */
#define M_NEXTPD    32767   /* next pull-down menu     */

/* Window title position definitions for wtitle() */
#define TLEFT       1   /* left justified  */
#define TCENTER     2   /* centered        */
#define TRIGHT      3   /* right justified */

#define WinFillCh(a)          (_WinInfo.fillch=a)
#define WinClear()            WinCClear(_WinInfo.active->wattr)

/**/

/* Menu item record definition */
struct _item_t {
    struct _item_t *prev;   /* Pointer to previous record      */
    struct _item_t *next;   /* Pointer to next record          */
    void *child;            /* Pointer to submenu's record     */
    PCHAR str;              /* Address of selection string     */
    PCHAR desc;             /* Text description of menu option */
    void (*select) (void);  /* Address of selection function   */
    void (*before) (void);  /* Address of "before" function    */
    void (*after)  (void);  /* Address of "after"  function    */
    USHORT hotkey;          /* Hot key to select function      */
    SHORT tagid;            /* Tag identifier                  */
    SHORT help;             /* Help category number            */
    SHORT wrow;             /* Start of text - window row      */
    UCHAR wcol;             /* Start of text - window column   */
    UCHAR schar;            /* Quick selection character       */
    UCHAR fmask;            /* Special feature mask            */
    UCHAR dwrow;            /* Description window row          */
    UCHAR dwcol;            /* Description window column       */
    UCHAR dattr;            /* Description attribute           */
    UCHAR redisp;           /* Redisplay flag                  */
};

/* Window menu record definition */
struct _menu_t {
    struct _menu_t *prev;       /* Pointer to prev menu structure   */
    struct _menu_t *next;       /* Pointer to next menu structure   */
    struct _menu_t *parent;     /* Pointer to parent menu           */
    struct _item_t *item;       /* Pointer to head menu item        */
    struct _item_t *citem;      /* Pointer to current menu item     */
    void (*open) (void);        /* Address of post-opening function */
    SHORT tagcurr;              /* Tag ID of item selection bar on  */
    UCHAR usecurr;              /* Will menu use current window?    */
    UCHAR srow;                 /* Starting row of menu window      */
    UCHAR scol;                 /* Starting column of menu window   */
    UCHAR erow;                 /* Ending row of menu window        */
    UCHAR ecol;                 /* Ending column of menu window     */
    UCHAR btype;                /* Menu window border type          */
    UCHAR battr;                /* Menu window border attribute     */
    UCHAR wattr;                /* Menu window attribute            */
    UCHAR menutype;             /* Menu type mask                   */
    UCHAR barwidth;             /* Width of menu bar or zero        */
    UCHAR textpos;              /* Offset of text from start of bar */
    UCHAR textattr;             /* Attribute of menu text           */
    UCHAR scharattr;            /* Attribute of selection character */
    UCHAR noselattr;            /* Non-selectable text attribute    */
    UCHAR barattr;              /* Attribute of selection bar       */
};

/* Window help information record */
struct _help_t {
    SHORT help[20];             /* Help stack                 */
    PCHAR file;                 /* Help file name             */
    SHORT helpptr;              /* Help stack pointer         */
    USHORT key;                 /* Help hot key               */
    UCHAR winattr;              /* Help window attribute      */
    UCHAR textattr;             /* Help window text attribute */
    UCHAR selattr;              /* Selection text attribute   */
    UCHAR barattr;              /* Selection bar attribute    */
    UCHAR srow;                 /* Help window start row      */
    UCHAR scol;                 /* Help window start column   */
    UCHAR erow;                 /* Help window end row        */
    UCHAR ecol;                 /* Help window end column     */
    UCHAR btype;                /* Help window box type       */
    UCHAR title;                /* Display "Help" title?      */
    void (*open) (void);        /* Pointer to open function   */
};

/* Window input field definition */
struct _field_t {
    struct _field_t *prev;      /* Pointer to previous field       */
    struct _field_t *next;      /* Pointer to next field           */
    PCHAR str;                  /* Address of receiving string     */
    PCHAR buf;                  /* Address of temp receive string  */
    PCHAR format;               /* Input field format string       */
    SHORT (*validate) (char *); /* Address of validation function  */
    void (*before) (void);      /* Address of "before" function    */
    void (*after)  (void);      /* Address of "after"  function    */
    SHORT help;                 /* Help category number            */
    SHORT lenbuf;               /* Length of buffer                */
    SHORT lenfld;               /* Length of screen input field    */
    SHORT lenfmt;               /* Length of format string         */
    UCHAR wrow;                 /* Start of input - window row     */
    UCHAR wcol;                 /* Start of input - window column  */
    UCHAR mode;                 /* 0=init, 1=update, 2=cond update */
    UCHAR decpos;               /* Decimal position (numeric)      */
    UCHAR redisp;               /* Redisplay flag                  */
    CHAR fconv;                 /* Field conversion character      */
};

/* Window data entry form definition */
struct _form_t {
    unsigned (*getkey) (int *); /* pointer to alternate get func   */
    struct _form_t  *prev;      /* pointer to previous form record */
    struct _form_t  *next;      /* pointer to next form record     */
    struct _field_t *field;     /* pointer to head field record    */
    struct _field_t *cfield;    /* pointer to current field record */
    PUSHORT termkey;            /* addr of int for terminating key */
    PCHAR pformat;              /* format string pointer           */
    PCHAR pbuf;                 /* buffer string pointer           */
    UCHAR cwrow;                /* current window row              */
    UCHAR cwcol;                /* current window column           */
    UCHAR decimal;              /* decimal field flag              */
    UCHAR insert;               /* insert mode flag                */
    UCHAR fieldattr;            /* field attribute                 */
    UCHAR textattr;             /* text attribute                  */
};

/* Structure of window records */
struct _wrec_t {
    struct _wrec_t *prev;   /* Pointer to previous window record */
    struct _wrec_t *next;   /* Pointer to next window record     */
    struct _form_t *form;   /* Pointer to head form record       */
    SHORT *wbuf;            /* Address of window's buffer        */
    SHORT *wsbuf;           /* Address of window shadow's buffer */
    CHAR *title;            /* Address of window's title string  */
    WINDOW whandle;         /* Window's handle                   */
    SHORT help;             /* Help category number              */
    UCHAR srow;             /* Start row of window               */
    UCHAR scol;             /* Start column of window            */
    UCHAR erow;             /* End row of window                 */
    UCHAR ecol;             /* End column of window              */
    UCHAR btype;            /* Window's box type                 */
    UCHAR wattr;            /* Window's initial text attribute   */
    UCHAR battr;            /* Atrribute of window's border      */
    UCHAR border;           /* Has border?  0 = no, 1 = yes      */
    UCHAR row;              /* Window's current cursor row       */
    UCHAR column;           /* Window's current cursor column    */
    UCHAR attr;             /* Window's current text attribute   */
    UCHAR tpos;             /* Position of window's title        */
    UCHAR tattr;            /* Attribute of window's title       */
    UCHAR wsattr;           /* Attribute of window's shadow      */
};                                 

/* Window information record */
struct _winfo_t {
    struct _wrec_t  *active;    /* Pointer to active window         */
    struct _wrec_t  *hidden;    /* Pointer to head hidden window    */
    struct _menu_t  *menu;      /* Pointer to head menu record      */
    struct _menu_t  *cmenu;     /* Pointer to current menu record   */
    struct _help_t  *helptr;    /* Pointer to help info record      */
    WINDOW handle;              /* Last handle given to a window    */
    SHORT maxfiles;             /* Max files allowed in wpickfile() */
    SHORT help;                 /* Current help category            */
    SHORT errno;                /* Error num from last window func  */
    SHORT total;                /* Total number of open windows     */
    SHORT mlevel,ilevel;        /* System variables used in menus   */
    UCHAR esc;                  /* Check for Esc in input funcions? */
    UCHAR tabwidth;             /* Window TTY output tab width      */
    UCHAR fillch;               /* Character to fill windows with   */
};
extern struct _winfo_t _WinInfo;

/**/

SHORT  WinBox           (SHORT Srow, SHORT Scol, SHORT Erow, SHORT Ecol,
                         SHORT Btype,SHORT Attr);
SHORT  WinChkBox        (SHORT Srow, SHORT Scol, SHORT Erow, SHORT Ecol);
SHORT  WinChkCol        (SHORT Col);
SHORT  WinChkCoord      (SHORT Row, SHORT Col);
SHORT  WinChkRow        (SHORT Row);
SHORT  WinClose         (VOID);
SHORT  WinCloseAll      (VOID);
SHORT  WinFill          (SHORT Srow, SHORT Scol, SHORT Erow, SHORT Ecol,
                         SHORT Ch,SHORT Attr);
SHORT  WinGotoXY        (SHORT Wrow, SHORT Wcol);
WINDOW WinOpen          (SHORT Srow, SHORT Scol, SHORT Erow, SHORT Ecol,
                         SHORT Btype, SHORT Battr,SHORT Wattr);
SHORT  WinShadOff       (VOID);
SHORT  WinShadow        (SHORT Attr);
SHORT  WinTitle         (PCHAR Str, SHORT Tpos, SHORT Tattr);
SHORT  WinPrintC        (SHORT Row, SHORT Col, SHORT Attr, SHORT Ch);
SHORT  WinPrintS        (SHORT Row, SHORT Col, SHORT Attr, PCHAR Str);
SHORT  WinHLine         (SHORT wsrow, SHORT wscol, SHORT count, SHORT btype, SHORT attr);
SHORT  WinVLine         (SHORT wsrow, SHORT wscol, SHORT count, SHORT btype, SHORT attr);
PUSHORT WinSave         (USHORT srow, USHORT scol, USHORT erow, USHORT ecol);
VOID   WinRestore       (PUSHORT wbuf);
SHORT  WinCenters       (SHORT wrow, SHORT attr, PCHAR str);
WINDOW WinHandle        (VOID);
SHORT  WinTextAttr      (SHORT Attr);
SHORT  WinClrEol        (VOID);
SHORT  WinClrEos        (VOID);
SHORT  WinScroll        (SHORT count, SHORT direction);
SHORT  WinReadCur       (PSHORT wrow, PSHORT wcol);
SHORT  WinCClear        (SHORT attr);
struct _wrec_t * WinFindRec (SHORT whandle);
SHORT  WinDupC          (SHORT ch, SHORT count);
SHORT  WinPutC          (SHORT ch);
SHORT  WinPutS          (PCHAR str);
SHORT  WinActiv         (WINDOW whandle);

/**/

