/*͸
   UED Maximus User Base API                (C) 1996 by CodeLand Australia 
   USER.H Version 3.00  13-01-96                       All Rights Reserved 
  ;*/

/* Uncomment the following line build a Dll */
/* #define MAKDLL */

#ifdef MAKDLL
    #define _fapi EXPENTRY
#else
    #define _fapi PASCAL
#endif /* MAKDLL */

/* MAXIMUS USER RECORD STRUCTURE */
#pragma pack(1)
/* Max3 Access levels, as used in user file, PRM file, and others. */

#define  TRANSIENT   0
#define  DEMOTED     10
#define  LIMITED     20
#define  NORMAL      30
#define  WORTHY      40
#define  PRIVIL      50
#define  FAVORED     60
#define  EXTRA       70
#define  CLERK       80
#define  ASSTSYSOP   90
#define  SYSOP       100
#define  HIDDEN      65535
/*
#define  TWIT        -2
#define  DISGRACE    0x0000
#define  LIMITED     0x0001
#define  NORMAL      0x0002
#define  WORTHY      0x0003
#define  PRIVIL      0x0004
#define  FAVORED     0x0005
#define  EXTRA       0x0006
#define  CLERK       0x0007
#define  ASSTSYSOP   0x0008
#define  SYSOP       0x000A
#define  HIDDEN      0x000b
*/

/* Help levels */
#define  EXPERT     (UCHAR)0x02  /* grizzled veteran, no menus at all       */
#define  REGULAR    (UCHAR)0x04  /* experienced user, brief menus           */
#define  NOVICE     (UCHAR)0x06  /* Full menus plus additional hand-holding */
#define  HOTFLASH   (UCHAR)0x20  /* Hotkey, full-screen interface           */
/* Masks for usr.bits1, below */
#define BITS_HOTKEYS     0x0001 /* Hotkeys, independent of HOTFLASH level   */
#define BITS_NOTAVAIL    0x0002 /* If set, user is NOT normally available   *
                                 * for chat.                                */
#define BITS_FSR         0x0004 /* Full-screen reading in msg areas         */
#define BITS_NERD        0x0008 /* Yelling makes no noise on sysop console  */
#define BITS_NOULIST     0x0010 /* Don't display name in userlist           */
#define BITS_TABS        0x0020 /* Reserved                                 */
#define BITS_ENCRYPT     0x0040 /* Password encryption flag                 */
#define BITS_RIP         0x0080 /* Remote Imaging Prototocol support        */
/* Masks for usr.bits2, below */
#define BITS2_BADLOGON   0x0001 /* MAX: if user's last logon attempt was bad*/
#define BITS2_IBMCHARS   0x0002 /* MAX: if user can receive high-bit chars  */
#define BITS2_RSVD1      0x0004 /* MAX: *obsolete* 1.02 avatar flag         */
#define BITS2_BORED      0x0008 /* Use the line-oriented editor             */
#define BITS2_MORE       0x0010 /* Wants the "MORE?" prompt                 */
#define BITS2_RSVD2      0x0020 /* OPUS: set=wants Ansi                     */
#define BITS2_CONFIGURED 0x0040 /* OPUS: set=used Maximus before            */
#define BITS2_CLS        0x0080 /* OPUS: set=transmit ^L, clear=ignore ^L   */
#define BITS2_BIT8       0x0100 /* used to be 'usr.keys'                    */
#define BITS2_BIT9       0x0200 /* used to be 'usr.keys'                    */
#define BITS2_BITA       0x0400 /* used to be 'usr.keys'                    */
#define BITS2_BITB       0x0800 /* used to be 'usr.keys'                    */
#define BITS2_BITC       0x1000 /* used to be 'usr.keys'                    */
#define BITS2_BITD       0x2000 /* used to be 'usr.keys'                    */
#define BITS2_BITE       0x4000 /* used to be 'usr.keys'                    */
#define BITS2_BITF       0x8000 /* used to be 'usr.keys'                    */

#define SEX_UNKNOWN       0x0000
#define SEX_MALE          0x0001
#define SEX_FEMALE        0x0002
/* Masks for usr.delflag, below.  WARNING!  Only the first eight bits       *
 * of this flag should be used for compatibility with df_save!              */
#define UFLAG_DEL   0x01
#define UFLAG_PERM  0x02
/* Masks for usr.xp_flag, below */
#define XFLAG_EXPDATE    0x0001 /* Use the xp_date to control access        */
#define XFLAG_EXPMINS    0x0002 /* Use the xp_mins number to control access */
#define XFLAG_DEMOTE     0x0004 /* Demote user to priv level in usr.xp_priv */
#define XFLAG_AXE        0x0008 /* Just hang up on user                     */
/* Constants for usr.video, below */
#define GRAPH_TTY         0x00 /* The current user's graphics setting...    */
#define GRAPH_ANSI        0x01
#define GRAPH_AVATAR      0x02
#define GRAPH_RIP         0x03
/* If protocol >= 0, then I suggest that you just print "External          */
/* Protocol (n)", where 'n' is simply 'usr.def_proto+1'.                   */
#define PROTOCOL_none        -1 /* Protocol to use for sending/receiving   */
#define PROTOCOL_xmodem      -2 /* files.  If we're using an EXTERNAL      */
#define PROTOCOL_ymodem      -3 /* protocol, `protocol' will have a value  */
#define PROTOCOL_xmodem1k    -4 /* >= 0.                                   */
#define PROTOCOL_sealink     -5
#define PROTOCOL_zmodem      -6
#define PROTOCOL_ymodemg     -7
struct _stamp { /* DOS-style datestamp */
    struct {
        USHORT da : 5;
        USHORT mo : 4;
        USHORT yr : 7;
    } date;
    struct {
        USHORT ss : 5;
        USHORT mm : 6;
        USHORT hh : 5;
    } time;
};
struct _dos_st
{
    USHORT date;
    USHORT time;
};
union stamp_combo {
    ULONG ldate;
    struct _stamp msg_st;
    struct _dos_st dos_st;
};
typedef union stamp_combo SCOMBO;
#define MAX_ALEN       64  /* MAX3: Max length of usr.msg[] and usr.files[]  */
struct _usr {
    UCHAR name[36];       /* Caller's name                               0*/
    UCHAR city[36];       /* Caller's location                          36*/
    UCHAR alias[21];      /* User's alias (handle)                      72*/
    UCHAR phone[15];      /* User's phone number                        93*/
    USHORT lastread_ptr;  /* A num which points to offset in           108*/
                          /* file -- Offset of lastread pointer will be   */
                          /* lastread_ptr*sizeof(int).                    */
    USHORT timeremaining; /* Time left for current call (xtern pro     110*/
    UCHAR pwd[16];        /* Password                                  112*/
    USHORT times;         /* Number of previous calls to this system   128*/
    UCHAR help;           /* Help level                                130*/
    USHORT group;         /* MAX3: Group number (not implemented)      131*/
    UCHAR video;          /* user's video mode (see GRAPH_XXXX)        133*/
    UCHAR nulls;          /* Number of Nulls (delays) after <cr>       134*/
    UCHAR bits;           /* Bit flags for user (number 1)             135*/
    USHORT dob_year;      /* MAX3: Date of birth: year (1900-)         136*/
    USHORT bits2;         /* Bit flags for user (number 2)             138*/
    SHORT max2priv;       /* Access level                              140*/
    CHAR dataphone[19];   /* MAX3: Data/business phone number          142*/
    UCHAR struct_len;     /* len of struct, divided by 20. SEE ABOVE!  161*/
    USHORT time;          /* Time on-line so far today                 162*/
    USHORT delflag;       /* Used to hold baud rate for O)utside comman164*/
                          /* In USER.BBS, usr.flag uses the constants     */
                          /* UFLAG_xxx, defined earlier in this file.     */
    ULONG msgs_posted;    /* MAX3: Total number of messages posted     166*/
    ULONG msgs_read;      /* MAX3: Total number of messages read       170*/
    UCHAR width;          /* Width of the caller's screen              174*/
    UCHAR len;            /* Height of the caller's screen             175*/
    USHORT credit;        /* Matrix credit, in cents                   176*/
    USHORT debit;         /* Current matrix debit, in cents            178*/
    USHORT xp_priv;       /* Priv to demote to, when time or minutes ru180*/
                          /* out.                                         */
    SCOMBO xp_date;       /* Bit-mapped date of when user expires      182*/
                                /* If zero, then no expiry date.          */
    ULONG xp_mins;        /* How many minutes the user has left before 186*
                           * expiring.                                    */
    UCHAR  xp_flag;       /* Flags for expiry.  See above XFLAG_XXX def190*/
    UCHAR  sex;           /* MAX3: Sex: SEX_MALE or SEX_FEMALE)        191*/
    SCOMBO ludate;        /* Bit-mapped date of user's last call 192*/
    ULONG xkeys;          /* User's keys (all 32 of 'em)               196*/
    UCHAR  lang;          /* The user's current language #             200*/
    CHAR def_proto;       /* Default file-transfer protocol            201*/
    ULONG up;             /* K-bytes uploaded, all calls               202*/
    ULONG down;           /* K-bytes downloaded, all calls             206*/
    ULONG downtoday;      /* K-bytes downloaded, today                 210*/
    UCHAR rsvd45[18];     /* MAX3: Reserved by Maximus for future use  214*/
    USHORT call;          /* Number of previous calls today            232*/
    UCHAR compress;       /* Default compression program to use        234*/
    UCHAR  df_save;       /* MAX3: Used for storing real usr.delflag in235*
                           * LASTUSxx.BBS while in a door.                */
    ULONG extra;          /* User description pointer                  236*/
    SCOMBO date_1stcall;  /* Date of first call to system              400*/
    SCOMBO date_pwd_chg;  /* Date of last password change              244*/
    ULONG nup;            /* Number of files uploaded                  248*/
    ULONG ndown;          /* Number of files downloaded                252*/
    ULONG ndowntoday;     /* Number of files downloaded today          256*/
    USHORT time_added;    /* Time credited to the user for today       260*/
    UCHAR msg[MAX_ALEN];  /* Current message area                      262*/
    UCHAR files[MAX_ALEN];/* Current file area                         326*/
    UCHAR dob_day;        /* Date of birth: day (1-31)                 390*/
    UCHAR dob_month;      /* Date of birth: month (1-12)               391*/
    ULONG point_credit;   /* Total points allocated                    392*/
    ULONG point_debit;    /* Total points used                         396*/
    SCOMBO date_newfile;  /* Date of last new-files check              240*/
    USHORT priv;          /* Privilege level                           404*/
    UCHAR rsvd6[54];      /* Reserved for future use                   406*/
};
typedef struct _usr USR;
typedef struct _usrndx {
    ULONG hash_name;
    ULONG hash_alias;
} USRNDX;
#pragma pack()

/**/

/* Lastread pointer array access */
#define U_MR            8192       /* Maximum user Records accessable  */
#define CHAR_BITS       8
#define LRSZ U_MR/CHAR_BITS+2 /* LastRead bit flag char array size */
#define IsBit(a,b) ((*((a)+((b)/CHAR_BITS))&(1<<((b)%CHAR_BITS)))?1:0)
#define BitOn(a,b) *((a)+((b)/CHAR_BITS))|=(1<<((b)%CHAR_BITS))
#define BitOff(a,b) *((a)+((b)/CHAR_BITS))&=~(1<<((b)%CHAR_BITS))

/* UED user file definition structure */
typedef struct _udef {
    CHAR Mpath[140];            /* Maximus path                         */
    CHAR Uname[40];             /* User file file name                  */
    HFILE Ufh;                  /* User file file handle                */
    USR *Usr;                   /* User file structure pointer          */
    USHORT Usiz;                /* User file structure size             */
    USHORT Unum;                /* User file record count               */
    CHAR Nname[40];             /* Ndx file file name                   */
    HFILE Nfh;                  /* Ndx file file handle                 */
    USRNDX *UsrNdx;             /* Ndx file structure pointer           */
    CHAR Aname[40];             /* Marea.dat file file name             */
    CHAR LrUsed[LRSZ];          /* Lastread pointer bit array           */
    BOOL GotLr;                 /* Got lastread pointers flag           */
    USHORT *Uidx;               /* Sort index array                     */
    VOID **SortArray;           /* Sort data array                      */
    SHORT SortTyp;              /* Current sort method storage          */
    SHORT SortDir;              /* Current sort direction               */
    BOOL isOpen;                /* Open flag                            */
} UDEF;
typedef UDEF* PUDEF;

/**/

SHORT _fapi UserDefOpen (PUDEF *Ud, PCHAR Mpath, PCHAR Uname, PCHAR Aname);
VOID _fapi UserDefClose (PUDEF Ud);
SHORT _fapi UserCreate (PUDEF Ud);
SHORT _fapi UserOpen (PUDEF Ud);
VOID _fapi UserClose (PUDEF Ud);
SHORT _fapi UserRead (PUDEF Ud, USHORT Rec);
SHORT _fapi UserWrite (PUDEF Ud, USHORT Rec);
SHORT _fapi UserAppend (PUDEF Ud);
SHORT _fapi UserIdxCreate (PUDEF Ud);
SHORT _fapi UserIdxRead (PUDEF Ud, USHORT Idx);
SHORT _fapi UserIdxWrite (PUDEF Ud, USHORT Idx);
VOID _fapi UserIdxSort (PUDEF Ud, int (*Compare)(const void *, const void *));
SHORT _fapi UserRename (PUDEF Ud, PCHAR NewName);
SHORT _fapi UserDelete (PUDEF Ud);
VOID _fapi UserDefault (PUDEF Ud);
VOID _fapi UserLrClear (PUDEF Ud, USHORT *LRarray[], USHORT LRnum);
ULONG _fapi UserHash (PUCHAR Str);
VOID _fapi GetSysDateTime (SCOMBO *pt);

SHORT PASCAL NdxCreate (PUDEF Ud);
SHORT PASCAL NdxOpen (PUDEF Ud);
VOID PASCAL NdxClose (PUDEF Ud);
SHORT PASCAL NdxRead (PUDEF Ud, USHORT Rec);
SHORT PASCAL NdxWrite (PUDEF Ud, USHORT Rec);

/**/

