/*͸
   UED - the Maximus-CBCS User Base Editor  (C) 1996 by CodeLand Australia 
   SEARCH.C Search routines                            All Rights Reserved 
  ;*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define INCL_DOS
#include <os2.h>

#include "vid.h"
#include "win.h"
#include "menu.h"
#include "form.h"
#include "user.h"
#include "ued.h"

/**/

static SHORT menu_choice=1;
static USHORT start=0;
static SHORT s_type=1;
static SHORT last_s_type=1;
static CHAR s_str[36]  = "                                   ";

/**/

static VOID search_bn (VOID); /* Used by u_search */
static VOID search_bp (VOID); /* Used by u_search */
static VOID search_bw (VOID); /* Used by u_search */
static VOID search_co (VOID); /* Used by u_search */

/**/

/* If success, returns true, sets CurRec to found record */
SHORT PASCAL UsrSearch (VOID)
{
/*
Ŀ
       Name City Phone PassWord FindNext   
                                           
 Text:                                     

*/
    SHORT i, found=0;
    SHORT save_sel;
    SHORT selflg;               /* Continus menu select control */
    CHAR sbuf[36];              /* Processed search string      */
    CHAR tbuf[36];              /* String display temp buffer   */

    /* Open search window */
    if(!WinOpen(16,17,20,61,bdr,battr2,wattr2)) return found;
    WINSHADOW(); WinPrintS(2,1,wattr,"Text:");

    /* Do menu */
    if(menu_choice<1||menu_choice>5) menu_choice=1;
    save_sel=menu_choice;
    selflg=FormStrBlank(s_str)||start>=Ud->Unum?-1:0;
    if(selflg==-1&&menu_choice==5) menu_choice=last_s_type;
    MenuBegC();
    MenuItem(0, 7, "Name",      'N',  1,0, NULL, 0, 0);
    MenuIBA(search_bn,NULL);
    MenuItem(0,12, "City",      'C',  2,0, NULL, 0, 0);
    MenuIBA(search_bn,NULL);
    MenuItem(0,17, "Phone",     'P',  3,0, NULL, 0, 0);
    MenuIBA(search_bp,NULL);
    MenuItem(0,23, "PassWord",  'W',  4,0, NULL, 0, 0);
    MenuIBA(search_bw,NULL);
    MenuItem(0,32, "FindNext",  'F',  5,selflg, NULL, 0, 0);
    MenuIBA(search_co,NULL);
    MenuEnd(menu_choice,M_HORZ,0,0,wattr2,qattr2,nosel2,WHITE|_RED);
    menu_choice=MenuGet();

    if(menu_choice==-1) { WinClose(); menu_choice=save_sel; return 0; }
    if(menu_choice==5) { /* If a continue command */
        if(!s_type) { menu_choice=1; start=0; } /* Default to name */
    }
    if(menu_choice>0&&menu_choice<5) {
        FormBeg(fattr2,hattr2);
        last_s_type=menu_choice;
        switch(menu_choice) {
        case 1:
        case 2:
            FormDef (2,7,s_str,"???????????????????????????????????",0,2,NULL,0);
             break;
        case 3:
            FormDef (2,7,s_str,"??????????????????",0,2,NULL,0);
            break;
        case 4:
            FormDef (2,7,s_str,"???????????????",0,2,NULL,0);
        }
        i=FormRead(); VidHideCur();

        /* If ECS pressed, or no string entered, abort */
        if(i==W_ESCPRESS||FormStrBlank(s_str)) { WinClose(); return 0; }
        start=0;  /* Start at the beginning for new search */
        s_type=menu_choice; /* Set search type */
    }

    /* Process the search string */
    strcpy(sbuf,s_str); FormStrLTrim(sbuf); FormStrTrim(sbuf);

    /* Check the start value */
    if(start>=Ud->Unum) start=0;

    /* Open the searching status window */
    if(!WinOpen(11,26,13,52,bdr,WHITE|_RED,WHITE|_RED)) return 0;
    WINSHADOW();
    sprintf(tbuf,"Searching Record  %5d",start+1);
    WinPrintS(0,1,WHITE|_RED,tbuf);

    /* Do the search */
    for(i=start;(USHORT)i<Ud->Unum;i++) {
        if(!((i+1)%20)) {
            sprintf(tbuf,"%5d",i+1);
            WinPrintS(0,19,WHITE|_RED,tbuf);
        }
        if(UserIdxRead(Ud,i)) break;

        if(s_type==1) {
            if(FormStrISOcC(sbuf,Ud->Usr->name)>0 ||
               FormStrISOcC(sbuf,Ud->Usr->alias)>0) {
                CurRec=i; found=1; break;
            }
        }
        else if(s_type==2) {
            if(FormStrISOcC(sbuf,Ud->Usr->city)>0) { CurRec=i; found=1; break; }
        }
        else if(s_type==3) {
            if(FormStrISOcC(sbuf,Ud->Usr->phone)>0 ||
               FormStrISOcC(sbuf,Ud->Usr->dataphone)>0) {
                CurRec=i; found=1; break; }
        }
        else if(s_type==4) {
            if(!(Ud->Usr->bits&(CHAR)BITS_ENCRYPT)) { /* If non-encrypted */
                if(FormStrISOcC(sbuf,Ud->Usr->pwd)>0) {
                    CurRec=i; found=1; break;
                }
            }
        }
        else break;
    }
    start=i+1; /* Set start for next continue */

    /* Process found/not found, close search status window */
    if(found) { /* Found a match! */
        WinClose(); /* Close message window */
        TONEFOUND();
    }
    else { /* Didn't find a damn thing */
        WinPrintS(0,1,WHITE|_RED,"     Search Failed      ");
        TONEERROR();
        MenuWaitKeyT(17);
        WinClose();
    }

    WinClose(); /* Close search window */
    return found;
}

/**/

static VOID search_bn (VOID)
{
    CHAR ebuf[36];  /* Edit search string           */

    strcpy(ebuf,s_str); /* Put search string into the display string */
    FormStrSetSz(ebuf,35);
    WinPrintS( 2,7,fattr2,ebuf);
}

static VOID search_bp (VOID)
{
    CHAR ebuf[36];  /* Edit search string           */

    strcpy(ebuf,s_str); /* Put search string into the display string */
    FormStrSetSz(ebuf,18);
    WinPrintS( 2,7,fattr2,ebuf);
    WinPrintS( 2,25,wattr2,"                 ");
}

static VOID search_bw (VOID)
{
    CHAR ebuf[36];  /* Edit search string           */

    strcpy(ebuf,s_str); /* Put search string into the display string */
    FormStrSetSz(ebuf,15);
    WinPrintS( 2,7,fattr2,ebuf);
    WinPrintS( 2,22,wattr2,"                    ");
}

static VOID search_co (VOID)
{
    switch(last_s_type) {
    case 3: search_bp(); break;
    case 4: search_bw(); break;
    case 1:
    case 2:
    default: search_bn(); break;
    }
}

/**/

