/*͸
   UED - the Maximus-CBCS User Base Editor  (C) 1996 by CodeLand Australia 
   GLOB.C Global functions                             All Rights Reserved 
  ;*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define INCL_DOS
#include <os2.h>

#include "vid.h"
#include "win.h"
#include "menu.h"
#include "form.h"
#include "user.h"
#include "ued.h"

/**/

static SHORT GlobalWindowOpen (PCHAR Header1, PCHAR Header2);
static VOID DelScan (SHORT ctl);
static VOID GetPrivil (CHAR priv[]);
static VOID GetPrivil2 (CHAR priv[], SHORT os);
static VOID KeyLabels (SHORT os);
static VOID GetKeys (CHAR keys[], SHORT os);
static VOID GetKeyKeys (CHAR keys[], SHORT os);
static LONG ymd_to_scalar (USHORT yr, USHORT mo, USHORT day);
static USHORT months_to_days (USHORT month);
static LONG years_to_days (USHORT yr);
static SHORT isleap (USHORT yr);
static SHORT noexpiryblk (UCHAR exp);
static SHORT nocreditblk (USHORT credit);
static SHORT nokeyblk (LONG keys, CHAR gkeys[]);
static SHORT istooold (SHORT priv, LONG daysnow, SCOMBO *lcd, PUSHORT dc, USHORT times);
static SHORT expirycheck (UCHAR exp, SHORT cfg);
static SHORT creditcheck (USHORT credit, SHORT cfg);
static VOID log_del (SHORT lcall, FILE *lp);
static VOID logdatetime (PCHAR logdate);

/**/

VOID GlobalDelete (VOID)
{
    SHORT i, selection=9, done=0;
    LONG lg;
    CHAR dbuf[16][10], dcal[16][10];

    if(!GlobalWindowOpen("GLOBAL DELETE SETTING","- All Records")) return;

    /* Expiry flag */
    WinPrintS(2,40,BLUE|_LGREY,"Allow Expiry Set Deletion:");
    WinPrintS(2,66,LGREY|_BLACK,UedCfg.GlobDel.FlagXpSetDel?Yes:No);
    WinPrintS(3,40,BLUE|_LGREY,"Allow Credit Set Deletion:");
    WinPrintS(3,66,LGREY|_BLACK,UedCfg.GlobDel.FlagCrdtSetDel?Yes:No);

    /* Priv settings */
    WinVLine(1,1,19,bdr,RED|_LGREY);
    WinFill(2,2,18,32,' ',WHITE|_BLUE);
    WinVLine(1,33,19,bdr,RED|_LGREY);
    WinPrintS(2,3,WHITE|_BLUE,"Access           >Days  <Call");
    for(i=0;i<UedCfg.PrivNum;i++) WinPrintS(i+3,3,LGREY|_BLUE,UedCfg.Priv[i]);

    /* Key flags */
    WinPrintS( 5,39,LCYAN|_CYAN," Allow Deletion for Keyed User ");
    KeyLabels(39);

    WinPrintS(2,13,LGREY|_BLUE,"Exit");

    while(!done) {
        /* Display data */
        /* Priv, days, calls */
        for(i=0;i<UedCfg.PrivNum;i++) {
            WinPrintS(i+3,14,LGREY|_BLACK,UedCfg.GlobDel.PrivFlag[i]=='\1'?Yes:No);
            sprintf(dbuf[i],"%5u",UedCfg.GlobDel.PrivDays[i]);
            WinPrintS(i+3,20,LGREY|_BLACK,dbuf[i]); /* Days */
            sprintf(dcal[i],"%5u",UedCfg.GlobDel.PrivCalls[i]);
            WinPrintS(i+3,27,LGREY|_BLACK,dcal[i]); /* Calls */
        }

        /* Keys */
        for(i=0;i<10;i++) {
            WinPrintS(i+6,46,LGREY|_BLACK,UedCfg.GlobDel.Keys[i]?Yes:No);
        }
        for(i=10;i<21;i++) {
            WinPrintS(i-4,56,LGREY|_BLACK,UedCfg.GlobDel.Keys[i]?Yes:No);
        }
        for(i=21;i<32;i++) {
            WinPrintS(i-15,66,LGREY|_BLACK,UedCfg.GlobDel.Keys[i]?Yes:No);
        }

        if(selection<1||selection>9) selection=9;
        MenuBegC(); /* The menu */
        MenuItem(20,  1, "Access",     'A',  1,0, NULL, 0, 0);
        MenuItem(20,  8, "Set Days",   'S',  2,0, NULL, 0, 0);
        MenuItem(20, 17, "Calls",      'C',  3,0, NULL, 0, 0);
        MenuItem(20, 24, "Keys",       'K',  4,0, NULL, 0, 0);
        MenuItem(20, 31, "Expiry",     'E',  5,0, NULL, 0, 0);
        MenuItem(20, 38, "CRedit",     'R',  6,0, NULL, 0, 0);
        MenuItem(20, 47, "Delete",     'D',  7,0, NULL, 0, 0);
        MenuItem(20, 56, "UnDelete",   'U',  8,0, NULL, 0, 0);
        MenuItem(20, 67, "QUIT",       'Q',  9,0, NULL, 0, 0);
        MenuEnd(selection,M_HORZ|M_SAVE,0,0,LGREY|_BLUE,WHITE|_BLUE,BLACK|_BLUE,WHITE|_RED);
        selection=MenuGet();
        switch(selection) {
            case 1 : /* Access */
                        WinPrintS(20,1,WHITE|_BLUE,"A"); WinPrintS(20,2,LGREY|_BLUE,"ccess");
                        GetPrivil(UedCfg.GlobDel.PrivFlag); break;
            case 2 : /* Get days value */
                        WinPrintS(20,8,WHITE|_BLUE,"S"); WinPrintS(20,9,LGREY|_BLUE,"et Days");
                        FormBeg (fattr, hattr);
                        for(i=0;i<UedCfg.PrivNum;i++) {
                            FormDef (i+3,20,dbuf[i],"%%%%%",0,1,NULL,0);
                        }
                        if(FormRead()!=W_ESCPRESS) {
                            TONEUPDATE(); CfgChanged=1;
                        }
                        VidHideCur();
                        for(i=0;i<UedCfg.PrivNum;i++) {
                            lg=atol(dbuf[i]);
                            UedCfg.GlobDel.PrivDays[i]=(USHORT)(lg>65535L?65535L:lg);
                        }
                        break;
            case  3 : /* Calls*/
                        WinPrintS(20,17,WHITE|_BLUE,"C"); WinPrintS(20,18,LGREY|_BLUE,"alls");
                        FormBeg (fattr, hattr);
                        for(i=0;i<UedCfg.PrivNum;i++) {
                            FormDef (i+3,27,dcal[i],"%%%%%",0,1,NULL,0);
                        }
                        if(FormRead()!=W_ESCPRESS) {
                            TONEUPDATE(); CfgChanged=1;
                        }
                        VidHideCur();
                        for(i=0;i<UedCfg.PrivNum;i++) {
                            lg=atol(dcal[i]);
                            UedCfg.GlobDel.PrivCalls[i]=(USHORT)(lg>65535L?65535L:lg);
                        }
                        break;
            case  4 : /* Keys */
                        WinPrintS(20,24,WHITE|_BLUE,"K"); WinPrintS(20,25,LGREY|_BLUE,"eys");
                        GetKeys(UedCfg.GlobDel.Keys,46); break;
            case  5 : /* Expiry */
                        UedCfg.GlobDel.FlagXpSetDel^=1;
                        TONEUPDATE(); CfgChanged=1;
                        WinPrintS(2,66,LGREY|_BLACK,UedCfg.GlobDel.FlagXpSetDel?Yes:No);
                        break;
            case  6 : /* Credit */
                        UedCfg.GlobDel.FlagCrdtSetDel^=1;
                        TONEUPDATE(); CfgChanged=1;
                        WinPrintS(3,66,LGREY|_BLACK,UedCfg.GlobDel.FlagCrdtSetDel?Yes:No);
                        break;
            case  7 : /* Delete */
                        WinPrintS(20,47,WHITE|_BLUE,"D"); WinPrintS(20,48,LGREY|_BLUE,"elete");
                        if(YesNo("Process Deletions?",11,27,13,53)) {
                            DelScan(1);
                            MenuStat=MENU_GDEL;
                        }
                        done++;
                        break;
            case  8 : /* Clear */
                        WinPrintS(20,56,WHITE|_BLUE,"U"); WinPrintS(20,57,LGREY|_BLUE,"nDelete");
                        if(YesNo("Clear Deletions?",11,27,13,53)) {
                            DelScan(0);
                            MenuStat=MENU_GDEL;
                            done++;
                        }
                        break;
            case -1 :
            case  9 :   done++;
                        break;
        }
    }

    WinClose(); /* Close down this window */
}

/**/

VOID GlobalExp (VOID)
{
    if(!GlobalWindowOpen("GLOBAL EXPIRY SETTING","- All Records")) return;

    WinClose(); /* Close down this window */
}

/**/

VOID GlobalKeys (VOID)
{
    SHORT i, selection=6, done=0;
    CHAR *p, ign[4]=" - ";

    if(!GlobalWindowOpen("GLOBAL KEY SETTING","- All Records")) return;

    /* Expiry flag */
    WinPrintS(2,34,BLUE|_LGREY,"Set only Expiry Accounts :");
    WinPrintS(2,60,LGREY|_BLACK,UedCfg.GlobKey.gKeyExpSet?Yes:No);
    WinPrintS(3,34,BLUE|_LGREY,"Set only Credit Accounts :");
    WinPrintS(3,60,LGREY|_BLACK,UedCfg.GlobKey.gKeyCdtSet?Yes:No);

    /* Priv settings */
    WinVLine(1,1,19,bdr,RED|_LGREY);
    WinFill(2,2,18,17,' ',WHITE|_BLUE);
    WinVLine(1,17,19,bdr,RED|_LGREY);
    WinPrintS(2,3,WHITE|_BLUE,"Access");
    for(i=0;i<UedCfg.PrivNum;i++) WinPrintS(i+3,3,LGREY|_BLUE,UedCfg.Priv[i]);
    WinPrintS(2,12,LGREY|_BLUE,"Exit");

    /* Key flags */
    WinPrintS( 5,33,LCYAN|_CYAN," Key Setting Mask              ");
    KeyLabels(33);

    while(!done) {
        /* Display data */
        /* Priv */
        for(i=0;i<UedCfg.PrivNum;i++) {
            WinPrintS(i+3,13,LGREY|_BLACK,UedCfg.GlobKey.gKeyPriv[i]?Yes:No);
        }

        /* Keys */
        for(i=0;i<10;i++) {
            switch(UedCfg.GlobKey.gKeyKeys[i]) {
            case 0: p=ign; break;
            case 1: p=Off; break;
            case 2: p=On; break;
            default: p=ign; break;
            }
            WinPrintS(i+6,40,LGREY|_BLACK,p);
        }
        for(i=10;i<21;i++) {
            switch(UedCfg.GlobKey.gKeyKeys[i]) {
            case 0: p=ign; break;
            case 1: p=Off; break;
            case 2: p=On; break;
            default: p=ign; break;
            }
            WinPrintS(i-4,50,LGREY|_BLACK,p);
        }
        for(i=21;i<32;i++) {
            switch(UedCfg.GlobKey.gKeyKeys[i]) {
            case 0: p=ign; break;
            case 1: p=Off; break;
            case 2: p=On; break;
            default: p=ign; break;
            }
            WinPrintS(i-15,60,LGREY|_BLACK,p);
        }

        if(selection<1||selection>6) selection=6;
        MenuBegC(); /* The menu */
        MenuItem(20,  1, "Access",         'A',  1,0, NULL, 0, 0);
        MenuItem(20, 11, "Expiry Set Only",'E',  2,0, NULL, 0, 0);
        MenuItem(20, 29, "Credit Set Only",'C',  3,0, NULL, 0, 0);
        MenuItem(20, 48, "Keys",           'K',  4,0, NULL, 0, 0);
        MenuItem(20, 56, "Process",        'P',  5,0, NULL, 0, 0);
        MenuItem(20, 67, "QUIT",           'Q',  6,0, NULL, 0, 0);
        MenuEnd(selection,M_HORZ|M_SAVE,0,0,LGREY|_BLUE,WHITE|_BLUE,BLACK|_BLUE,WHITE|_RED);
        selection=MenuGet();
        switch(selection) {
            case 1 : /* Access */
                        WinPrintS(20,1,WHITE|_BLUE,"A"); WinPrintS(20,2,LGREY|_BLUE,"ccess");
                        GetPrivil2(UedCfg.GlobKey.gKeyPriv,13);
                        break;
            case  2 : /* Expiry */
                        UedCfg.GlobKey.gKeyExpSet^=1;
                        if(UedCfg.GlobKey.gKeyExpSet&&UedCfg.GlobKey.gKeyCdtSet)
                            UedCfg.GlobKey.gKeyCdtSet^=1;
                        TONEUPDATE(); CfgChanged=1;
                        WinPrintS(2,60,LGREY|_BLACK,UedCfg.GlobKey.gKeyExpSet?Yes:No);
                        WinPrintS(3,60,LGREY|_BLACK,UedCfg.GlobKey.gKeyCdtSet?Yes:No);
                        break;
            case  3 : /* Credit only */
                        UedCfg.GlobKey.gKeyCdtSet^=1;
                        if(UedCfg.GlobKey.gKeyExpSet&&UedCfg.GlobKey.gKeyCdtSet)
                            UedCfg.GlobKey.gKeyExpSet^=1;
                        TONEUPDATE(); CfgChanged=1;
                        WinPrintS(2,60,LGREY|_BLACK,UedCfg.GlobKey.gKeyExpSet?Yes:No);
                        WinPrintS(3,60,LGREY|_BLACK,UedCfg.GlobKey.gKeyCdtSet?Yes:No);
                        break;
            case  4 : /* Keys */
                        WinPrintS(20,48,WHITE|_BLUE,"K"); WinPrintS(20,49,LGREY|_BLUE,"eys");
                        GetKeyKeys(UedCfg.GlobKey.gKeyKeys,40);
                        break;
            case  5 : /* Process */
                        WinPrintS(20,56,WHITE|_BLUE,"P"); WinPrintS(20,57,LGREY|_BLUE,"rocess");
                        if(YesNo("Process Settings?",11,27,13,53)) {
                            DelScan(4);
                            MenuStat=MENU_GDEL;
                            done++;
                        }
                        break;
            case -1 :
            case  6 : done++; break;
        }
    }

    WinClose(); /* Close down this window */
}

/**/

VOID GlobalCdt (VOID)
{
    if(!GlobalWindowOpen("GLOBAL CREDIT/DEBIT SETTING","- All Records")) return;

    WinClose(); /* Close down this window */
}

/**/

static SHORT GlobalWindowOpen (PCHAR Header1, PCHAR Header2)
{
    if(!WinOpen(1,2,23,75,bdr,RED|_LGREY,BLUE|_LGREY)) return 0;
    PreMenu();
    WinFill(0,0,0,71,' ',WHITE|_RED); /* Under header */
    WinPrintS(0,1,WHITE|_RED,Header1);
    WinPrintS(0,2+strlen(Header1),LGREY|_RED,Header2);
    WinPrintS(0,60,WHITE|_RED,"ESC"); WinPrintS(0,64,LGREY|_RED,"- Abort");
    WinHLine(1,0,72,bdr,RED|_LGREY);
    WinHLine(19,0,72,bdr,RED|_LGREY);
    WinFill(20,0,20,71,' ',WHITE|_BLUE); /* Under menu */

    return 1;
}

/**/

static VOID DelScan (SHORT ctl)
{
    USHORT i, j;                /* Loop var                     */
    SHORT abort=0;              /* Loop control var             */
    SCOMBO datpt;               /* Current date struct          */
    LONG daysnow;               /* Current date in days         */
    SHORT lcall;                /* Days since last call         */
    USHORT ChangedCount=0;      /* Records changed count        */
    SHORT writerec;             /* Record is to be updated flag */
    CHAR tbuf[64];              /* String display temp buffer   */
    /* FILE *lp=NULL; */        /* Log file pointer */

    /* Open the searching status window */
    if(!WinOpen(11,27,13,53,bdr,WHITE|_RED,WHITE|_RED)) return;
    PreMenu();
    WinPrintS(0,1,WHITE|_RED,"Writing Record     1");

    GetSysDateTime(&datpt); /* Get current date & time */
    daysnow=ymd_to_scalar( datpt.msg_st.date.yr+1980,
                           datpt.msg_st.date.mo,
                           datpt.msg_st.date.da);

    /* Open the log */
    /* lp=fopen("UEDDEL.lOG","a+"); */ /* Open log file */

    /* Do the scan */
    for(i=1;i<Ud->Unum;i++) {
        if(!((i+1)%10)) {
            sprintf(tbuf,"%5u",i+1);
            WinPrintS(0,19,WHITE|_RED,tbuf);
        }

        if(UserRead(Ud,i)) break;

        switch(ctl) {
        case 0: /* Do delete flag clear run */
            if(Ud->Usr->delflag&UFLAG_DEL) { /* If set, clear del flag */
                Ud->Usr->delflag=Ud->Usr->delflag&~UFLAG_DEL;
                if(UserWrite(Ud,i)) { abort++; break; }
                ++ChangedCount;
            }
            break;
        case 1: /* Do delete flag set run */
            if( !(Ud->Usr->delflag&UFLAG_DEL) &&
                !(Ud->Usr->delflag&UFLAG_PERM) &&
                noexpiryblk(Ud->Usr->xp_flag) &&
                nocreditblk(Ud->Usr->credit) &&
                nokeyblk(Ud->Usr->xkeys,UedCfg.GlobDel.Keys) &&
                UedCfg.GlobDel.PrivFlag[GetPriv(Ud->Usr->priv)] &&
                istooold(Ud->Usr->priv,daysnow,&Ud->Usr->ludate,&lcall,Ud->Usr->times)
            ) { /* If for the axe, set del flag */
                /* if(lp!=NULL) log_del(lcall,lp); */
                Ud->Usr->delflag=Ud->Usr->delflag|UFLAG_DEL;
                if(UserWrite(Ud,i)) { abort++; break; }
                ++ChangedCount;
            }
            break;
        case 2: /* Do credit/debit set run */
            break;
        case 3: /* Do expiry set run */
            break;
        case 4: /* Do keys set run */
            if( expirycheck(Ud->Usr->xp_flag,UedCfg.GlobKey.gKeyExpSet) &&
                creditcheck(Ud->Usr->credit,UedCfg.GlobKey.gKeyCdtSet) &&
                UedCfg.GlobKey.gKeyPriv[GetPriv(Ud->Usr->priv)]
            ) {
                writerec=0;
                for(j=0;j<16;j++) { /* Step through the keys */
                    switch(UedCfg.GlobKey.gKeyKeys[j]) {
                    case 0: /* Don't touch key */
                            break;
                    case 1: /* Key off */
                            lkey(Ud->Usr->xkeys) &= ~(0x0001<<j);
                            writerec++;
                            break;
                    case 2: /* Key on */
                            lkey(Ud->Usr->xkeys)|=(0x0001<<j);
                            writerec++;
                            break;
                    }
                }
                for(j=16;j<32;j++) { /* Step through the keys */
                    switch(UedCfg.GlobKey.gKeyKeys[j]) {
                    case 0: /* Don't touch key */
                            break;
                    case 1: /* Key off */
                            hkey(Ud->Usr->xkeys) &= ~(0x0001<<(j-16));
                            writerec++;
                            break;
                    case 2: /* Key on */
                            hkey(Ud->Usr->xkeys)|=(0x0001<<(j-16));
                            writerec++;
                            break;
                    }
                }
                if(writerec) {
                    if(UserWrite(Ud,i)) { abort++; break; }
                    ++ChangedCount;
                }
            }
            break;
        }

        if(abort) break;
    }

    /* if(lp!=NULL) fclose(lp); */ /* Close log file */

    WinClose(); /* Close window */

    /* Report */
    TONEFOUND();
    sprintf(tbuf,"Changed %d record%s, Press any Key",ChangedCount,ChangedCount==1?"":"s");
    Mesage(tbuf,11,20,13,60);
    MenuWaitKeyT(90);
    WinClose();
}

/**/

static VOID GetPrivil (CHAR priv[])
{
    SHORT i, sel3=16, changed=0;
    CHAR flag_text[2][4] = { " NO","YES" };
    CHAR save[16];

    for(i=0;i<16;i++) save[i]=priv[i]; /* Copy levels */
    for(;;) {
        MenuBegC(); /* Priv menu */
        MenuItem( 2,13,"Exit",             0x1C0A,16,0,NULL,0,0);
        for(i=0;i<UedCfg.PrivNum;i++) {
            MenuItem(i+3,14,flag_text[priv[i]=='\1'?1:0],0, i,0,NULL,0,0);
        }
        MenuEnd(sel3,M_OMNI,0,0,LGREY|_BLACK,LGREY|_BLACK,LGREY|_BLACK,WHITE|_RED);
        sel3=MenuGet();
        if(sel3 != -1 && sel3 != 16) {
            if(sel3>=0&&sel3<16) { /* Array update */
                priv[sel3]^=1;
                TONEUPDATE(); changed=1;
            }
        }
        else {
            if(sel3==-1) {
                for(i=0;i<16;i++) priv[i]=save[i]; /* Throw away changes */
                if(changed) { changed=0; TONEUPDATE(); }
            }
            WinPrintS(2,13,LGREY|_BLUE,"Exit");
            break; /* Exit */
        }
    }

    if(changed) CfgChanged=1;
}

/**/

static VOID GetPrivil2 (CHAR priv[], SHORT os)
{
    SHORT i, sel3=16, changed=0;
    CHAR flag_text[2][4] = { " NO","YES" };
    CHAR save[16];

    for(i=0;i<16;i++) save[i]=priv[i]; /* Copy levels */
    for(;;) {
        MenuBegC(); /* Priv menu */
        MenuItem( 2,os-1,"Exit",             0x1C0A,16,0,NULL,0,0);
        for(i=0;i<UedCfg.PrivNum;i++) {
            MenuItem(i+3,os,flag_text[priv[i]],0,i,0,NULL,0,0);
        }
        MenuEnd(sel3,M_OMNI,0,0,LGREY|_BLACK,LGREY|_BLACK,LGREY|_BLACK,WHITE|_RED);
        sel3=MenuGet();
        if(sel3 != -1 && sel3 != 16) {
            if(sel3>=0&&sel3<16) { /* Array update */
                priv[sel3]^=1;
                TONEUPDATE(); changed=1;
            }
        }
        else {
            if(sel3==-1) {
                for(i=0;i<16;i++) priv[i]=save[i]; /* Throw away changes */
                if(changed) { changed=0; TONEUPDATE(); }
            }
            break; /* Exit */
        }
    }
    WinPrintS(2,os-1,LGREY|_BLUE,"Exit");
    if(changed) CfgChanged=1;
}

/**/

/* Key flag labels */
static VOID KeyLabels (SHORT os)
{
    WinBox(4,os-1,18,os+31,0,LCYAN|_CYAN);
    WinPrintS( 6,os,WHITE|_CYAN," Key 1     Key C     Key N     ");
    WinPrintS( 7,os,WHITE|_CYAN," Key 2     Key D     Key O     ");
    WinPrintS( 8,os,WHITE|_CYAN," Key 3     Key E     Key P     ");
    WinPrintS( 9,os,WHITE|_CYAN," Key 4     Key F     Key Q     ");
    WinPrintS(10,os,WHITE|_CYAN," Key 5     Key G     Key R     ");
    WinPrintS(11,os,WHITE|_CYAN," Key 6     Key H     Key S     ");
    WinPrintS(12,os,WHITE|_CYAN," Key 7     Key I     Key T     ");
    WinPrintS(13,os,WHITE|_CYAN," Key 8     Key J     Key U     ");
    WinPrintS(14,os,WHITE|_CYAN," Key A     Key K     Key V     ");
    WinPrintS(15,os,WHITE|_CYAN," Key B     Key L     Key W     ");
    WinPrintS(16,os,WHITE|_CYAN,"           Key M     Key X     ");
    WinPrintS(17,os,WHITE|_CYAN,"                               ");
    WinPrintS(17,os+1,LGREY|_BLACK,"Exit");
}

/**/

static VOID GetKeys (CHAR keys[], SHORT os)
{
    SHORT i, sel2=0, changed=0;
    CHAR flag_text[2][4] = { " NO","YES" };
    CHAR save[32];

    for(i=0;i<32;i++) save[i]=keys[i]; /* Copy keys */

    for(;;) { /* Hang around for a while 8-))) */
        MenuBegC(); /* Key menu */
        MenuItem( 6,os,flag_text[keys[ 0]],0, 0,0,NULL,0,0);
        MenuItem( 7,os,flag_text[keys[ 1]],0, 1,0,NULL,0,0);
        MenuItem( 8,os,flag_text[keys[ 2]],0, 2,0,NULL,0,0);
        MenuItem( 9,os,flag_text[keys[ 3]],0, 3,0,NULL,0,0);
        MenuItem(10,os,flag_text[keys[ 4]],0, 4,0,NULL,0,0);
        MenuItem(11,os,flag_text[keys[ 5]],0, 5,0,NULL,0,0);
        MenuItem(12,os,flag_text[keys[ 6]],0, 6,0,NULL,0,0);
        MenuItem(13,os,flag_text[keys[ 7]],0, 7,0,NULL,0,0);
        MenuItem(14,os,flag_text[keys[ 8]],0, 8,0,NULL,0,0);
        MenuItem(15,os,flag_text[keys[ 9]],0, 9,0,NULL,0,0);
        MenuItem( 6,os+10,flag_text[keys[10]],0,10,0,NULL,0,0);
        MenuItem( 7,os+10,flag_text[keys[11]],0,11,0,NULL,0,0);
        MenuItem( 8,os+10,flag_text[keys[12]],0,12,0,NULL,0,0);
        MenuItem( 9,os+10,flag_text[keys[13]],0,13,0,NULL,0,0);
        MenuItem(10,os+10,flag_text[keys[14]],0,14,0,NULL,0,0);
        MenuItem(11,os+10,flag_text[keys[15]],0,15,0,NULL,0,0);
        MenuItem(12,os+10,flag_text[keys[16]],0,16,0,NULL,0,0);
        MenuItem(13,os+10,flag_text[keys[17]],0,17,0,NULL,0,0);
        MenuItem(14,os+10,flag_text[keys[18]],0,18,0,NULL,0,0);
        MenuItem(15,os+10,flag_text[keys[19]],0,19,0,NULL,0,0);
        MenuItem(16,os+10,flag_text[keys[20]],0,20,0,NULL,0,0);
        MenuItem( 6,os+20,flag_text[keys[21]],0,21,0,NULL,0,0);
        MenuItem( 7,os+20,flag_text[keys[22]],0,22,0,NULL,0,0);
        MenuItem( 8,os+20,flag_text[keys[23]],0,23,0,NULL,0,0);
        MenuItem( 9,os+20,flag_text[keys[24]],0,24,0,NULL,0,0);
        MenuItem(10,os+20,flag_text[keys[25]],0,25,0,NULL,0,0);
        MenuItem(11,os+20,flag_text[keys[26]],0,26,0,NULL,0,0);
        MenuItem(12,os+20,flag_text[keys[27]],0,27,0,NULL,0,0);
        MenuItem(13,os+20,flag_text[keys[28]],0,28,0,NULL,0,0);
        MenuItem(14,os+20,flag_text[keys[29]],0,29,0,NULL,0,0);
        MenuItem(15,os+20,flag_text[keys[30]],0,30,0,NULL,0,0);
        MenuItem(16,os+20,flag_text[keys[31]],0,31,0,NULL,0,0);
        MenuItem(17,os-6,"Exit",            0x1C0A,32,0,NULL,0,0);
        MenuEnd(sel2,M_OMNI,0,0,LGREY|_BLACK,LGREY|_BLACK,LGREY|_BLACK,WHITE|_RED);
        sel2=MenuGet();
        if(sel2 != -1 && sel2 != 32) {
            if(sel2>=0&&sel2<32) {
                keys[sel2]^=1;
                TONEUPDATE(); changed=1;
            }
        }
        else {
            if(sel2==-1) {
                    for(i=0;i<32;i++) keys[i]=save[i]; /* Throw away changes */
                    if(changed) { changed=0; TONEUPDATE(); }
            }
            WinPrintS(17,os-6,LGREY|_BLACK,"Exit");
            break; /* Exit */
        }
    }

    if(changed) CfgChanged=1;
}

/**/

static VOID GetKeyKeys (CHAR keys[], SHORT os)
{
    SHORT i, sel2=0, changed=0;
    CHAR flag_text[3][4] = { " - ","OFF"," ON" };
    CHAR save[32];

    for(i=0;i<32;i++) save[i]=keys[i]; /* Copy keys */

    for(;;) { /* Hang around for a while 8-))) */
        MenuBegC(); /* Key menu */
        MenuItem( 6,os,flag_text[keys[ 0]],0, 0,0,NULL,0,0);
        MenuItem( 7,os,flag_text[keys[ 1]],0, 1,0,NULL,0,0);
        MenuItem( 8,os,flag_text[keys[ 2]],0, 2,0,NULL,0,0);
        MenuItem( 9,os,flag_text[keys[ 3]],0, 3,0,NULL,0,0);
        MenuItem(10,os,flag_text[keys[ 4]],0, 4,0,NULL,0,0);
        MenuItem(11,os,flag_text[keys[ 5]],0, 5,0,NULL,0,0);
        MenuItem(12,os,flag_text[keys[ 6]],0, 6,0,NULL,0,0);
        MenuItem(13,os,flag_text[keys[ 7]],0, 7,0,NULL,0,0);
        MenuItem(14,os,flag_text[keys[ 8]],0, 8,0,NULL,0,0);
        MenuItem(15,os,flag_text[keys[ 9]],0, 9,0,NULL,0,0);
        MenuItem( 6,os+10,flag_text[keys[10]],0,10,0,NULL,0,0);
        MenuItem( 7,os+10,flag_text[keys[11]],0,11,0,NULL,0,0);
        MenuItem( 8,os+10,flag_text[keys[12]],0,12,0,NULL,0,0);
        MenuItem( 9,os+10,flag_text[keys[13]],0,13,0,NULL,0,0);
        MenuItem(10,os+10,flag_text[keys[14]],0,14,0,NULL,0,0);
        MenuItem(11,os+10,flag_text[keys[15]],0,15,0,NULL,0,0);
        MenuItem(12,os+10,flag_text[keys[16]],0,16,0,NULL,0,0);
        MenuItem(13,os+10,flag_text[keys[17]],0,17,0,NULL,0,0);
        MenuItem(14,os+10,flag_text[keys[18]],0,18,0,NULL,0,0);
        MenuItem(15,os+10,flag_text[keys[19]],0,19,0,NULL,0,0);
        MenuItem(16,os+10,flag_text[keys[20]],0,20,0,NULL,0,0);
        MenuItem( 6,os+20,flag_text[keys[21]],0,21,0,NULL,0,0);
        MenuItem( 7,os+20,flag_text[keys[22]],0,22,0,NULL,0,0);
        MenuItem( 8,os+20,flag_text[keys[23]],0,23,0,NULL,0,0);
        MenuItem( 9,os+20,flag_text[keys[24]],0,24,0,NULL,0,0);
        MenuItem(10,os+20,flag_text[keys[25]],0,25,0,NULL,0,0);
        MenuItem(11,os+20,flag_text[keys[26]],0,26,0,NULL,0,0);
        MenuItem(12,os+20,flag_text[keys[27]],0,27,0,NULL,0,0);
        MenuItem(13,os+20,flag_text[keys[28]],0,28,0,NULL,0,0);
        MenuItem(14,os+20,flag_text[keys[29]],0,29,0,NULL,0,0);
        MenuItem(15,os+20,flag_text[keys[30]],0,30,0,NULL,0,0);
        MenuItem(16,os+20,flag_text[keys[31]],0,31,0,NULL,0,0);
        MenuItem(17,os-6,"Exit",            0x1C0A,32,0,NULL,0,0);
        MenuEnd(sel2,M_OMNI,0,0,LGREY|_BLACK,LGREY|_BLACK,LGREY|_BLACK,WHITE|_RED);
        sel2=MenuGet();
        if(sel2 != -1 && sel2 != 32) {
            if(sel2>=0&&sel2<32) {
                /* Cycle key flag value */
                if(++keys[sel2]>2) keys[sel2]=0;
                TONEUPDATE(); changed=1;
            }
        }
        else {
            if(sel2==-1) {
                    for(i=0;i<32;i++) keys[i]=save[i]; /* Throw away changes */
                    if(changed) { changed=0; TONEUPDATE(); }
            }
            WinPrintS(17,os-6,LGREY|_BLACK,"Exit");
            break; /* Exit */
        }
    }

    if(changed) CfgChanged=1;
}

/**/

static LONG ymd_to_scalar (USHORT yr, USHORT mo, USHORT day)
{
   LONG scalar;

   scalar = day + months_to_days(mo);
   if ( mo > 2 )                         /* adjust if past February */
      scalar -= isleap(yr) ? 1 : 2;
   yr--;
   scalar += years_to_days(yr);
   return scalar;
}

/**/

static USHORT months_to_days (USHORT month)
{
   return (month * 3057 - 3007) / 100;
}

/**/

static LONG years_to_days (USHORT yr)
{
   return yr * 365L + yr / 4 - yr / 100 + yr / 400;
}

/**/

static SHORT isleap (USHORT yr)
{
   return yr % 400 == 0 || (yr % 4 == 0 && yr % 100 != 0);
}

/**/

/* Returns 0=expiry set block, 1=is ok to del record */
static SHORT noexpiryblk (UCHAR exp)
{
    if((exp&XFLAG_EXPDATE)||(exp&XFLAG_EXPMINS)) {
        /* User has expiry set */
        if(!UedCfg.GlobDel.FlagXpSetDel) return 0;
    }

    return 1;
}

/**/

/* Returns 0=credit set block, 1=is ok to del record */
static SHORT nocreditblk (USHORT credit)
{
    if(credit) {
        /* User has credit set */
        if(!UedCfg.GlobDel.FlagCrdtSetDel) return 0;
    }

    return 1;
}

/**/

/* Returns 0=key mask block, 1=is ok to del record */
static SHORT nokeyblk (LONG keys, CHAR gkeys[])
{
    SHORT i;
    char *k;

    k=ShowKeys(keys); /* Get user key string */
    for(i=0;i<32;i++) {
        if(!gkeys[i]&&k[i]!='.') return 0;
    }

    return 1;
}

/**/

/* Check days since last call, calls made, and override days */
static SHORT istooold (SHORT priv, LONG daysnow, SCOMBO *lcd, PUSHORT dc, USHORT times)
{
    LONG lcall;

    lcall=ymd_to_scalar( lcd->msg_st.date.yr+1980,
                         lcd->msg_st.date.mo,
                         lcd->msg_st.date.da);

    *dc=(USHORT)(daysnow-lcall);
    if(*dc>UedCfg.GlobDel.PrivDays[GetPriv(priv)]) { /* Is too old */
        if(times<UedCfg.GlobDel.PrivCalls[GetPriv(priv)]) { /* Check calls */
            return 1; /* Not enough calls either, so delete */
        }
    }

    return 0;
}

/**/

/* Returns 0=expiry check fail, 1=is ok to set record */
static SHORT expirycheck (UCHAR exp, SHORT cfg)
{
    if(cfg) { /* Set only expiry accounts */
        /* If no expiry set, fail */
        if(!(exp&XFLAG_EXPDATE)&&!(exp&XFLAG_EXPMINS))  return 0;
    }

    return 1;
}

/**/

/* Returns 0=credit set block, 1=is ok to set record */
static SHORT creditcheck (USHORT credit, SHORT cfg)
{
    if(cfg) { /* Set only Credit accounts */
        /* If no credit set, fail */
        if(!credit) return 0;
    }

    return 1;
}

/**/

static VOID log_del (SHORT lcall, FILE *lp)
{
   CHAR name[36], datestr[26];

   strncpy(name,Ud->Usr->name,25); name[25]='\0';
   logdatetime(datestr);
   fprintf(lp,"%sDeleting %-25s (%s %4u days)\n",
       datestr,name,UedCfg.Priv[GetPriv(Ud->Usr->priv)],lcall);
}

/**/

/* Return system date - '  15 Apr 03:40:16 UED  ' */
static VOID logdatetime (PCHAR logdate)
{
    DATETIME dt;

    PCHAR months[12] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun",
                         "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

    if(DosGetDateTime(&dt)) {
        strcpy(logdate,"  UED  ");
        return;
    }

    sprintf(logdate,"  %2.2d %3.3s %2.2d:%2.2d:%2.2d UED  ",
        dt.day,
        months[dt.month-1],
        dt.hours,
        dt.minutes,
        dt.seconds);
}

/**/

