/*͸
   UED - the Maximus-CBCS User Base Editor  (C) 1996 by CodeLand Australia 
   EDIT.C Edit routines                                All Rights Reserved 
  ;*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define INCL_DOS
#include <os2.h>

#include "md5.h"
#include "vid.h"
#include "win.h"
#include "menu.h"
#include "form.h"
#include "user.h"
#include "desc.h"
#include "ued.h"

#define WRITE_KEYS() WinPrintS(18,39,nattr,ShowKeys(Ud->Usr->xkeys))
#define WRITE_PRIV() WinPrintS(7,62,nattr,ShowPriv(Ud->Usr->priv))

/**/

static SHORT DescFlg=1;

static PCHAR def_sex[] = { /* Default sex descriptions */
    "MALE    ","FEMALE  ","UNKNOWN " };

static SHORT ext_prot=1;

/**/

/* EditScreen() menu aid functions */
static VOID PASCAL SetHKeys (VOID);
static VOID PASCAL ClearMenu (VOID);
static VOID PASCAL RunSearch (VOID);
static VOID FrstErec (VOID);
static VOID PrevErec (VOID);
static VOID PgUpErec (VOID);
static VOID PgDnErec (VOID);
static VOID NextErec (VOID);
static VOID LastErec (VOID);

/* Static screen display functions */
static VOID PASCAL ShowLabels (VOID);
static VOID PASCAL ShowDescLabels (VOID);
static VOID PASCAL ShowNoDescLabels (VOID);

/* Data display functions */
static VOID PASCAL ShowDisplay (VOID);
static VOID PASCAL ShowDescDisplay (VOID);
static VOID PASCAL ShowNoDescDisplay (VOID);
static VOID PASCAL ShowHighest (VOID);
static VOID PASCAL ShowIndex (VOID);
static VOID PASCAL ShowFlagsDisplay (VOID);
static VOID PASCAL ShowGender (VOID);

/* Data editing functions */
static VOID PASCAL EditText (VOID);
static VOID EditPwd (VOID);
static VOID FlipDesc (VOID);
static VOID EditGender (VOID);
static VOID PASCAL EditAccess (VOID);
static VOID EditAreas (VOID);
static VOID PASCAL EditLang (VOID);
static VOID PASCAL EditTran (VOID);
static VOID ExtDown (VOID);
static VOID ExtUp (VOID);
static VOID PASCAL EditComp (VOID);
static VOID PASCAL EditVideo (VOID);
static VOID PASCAL EditHelp (VOID);
static VOID PASCAL EditFlags (VOID);
static VOID EditPerm (VOID);
static VOID EditDel (VOID);
static VOID PrivDown (VOID);
static VOID PrivUp (VOID);
static VOID EditKeys (VOID);
static VOID EditKeysFlip (VOID);
static VOID EditExpiry (VOID);
static VOID FlipK1 (VOID);
static VOID FlipK2 (VOID);
static VOID FlipK3 (VOID);
static VOID FlipK4 (VOID);
static VOID FlipK5 (VOID);
static VOID FlipK6 (VOID);
static VOID FlipK7 (VOID);
static VOID FlipK8 (VOID);
static VOID FlipKa (VOID);
static VOID FlipKb (VOID);
static VOID FlipKc (VOID);
static VOID FlipKd (VOID);
static VOID FlipKe (VOID);
static VOID FlipKf (VOID);
static VOID FlipKg (VOID);
static VOID FlipKh (VOID);
static VOID FlipKi (VOID);
static VOID FlipKj (VOID);
static VOID FlipKk (VOID);
static VOID FlipKl (VOID);
static VOID FlipKm (VOID);
static VOID FlipKn (VOID);
static VOID FlipKo (VOID);
static VOID FlipKp (VOID);
static VOID FlipKq (VOID);
static VOID FlipKr (VOID);
static VOID FlipKs (VOID);
static VOID FlipKt (VOID);
static VOID FlipKu (VOID);
static VOID FlipKv (VOID);
static VOID FlipKw (VOID);
static VOID FlipKx (VOID);

/* Utility functions */
static VOID PASCAL WriteRec (VOID);
static VOID EncryptPwd (PCHAR str);

/**/
/*
Ŀ
 UED    permanent  deleted  Index                 Record   565 of   565 
Ĵ
 Name :12345678901234567890123456789012345     PassWord:*************** 
 Alias:12345678901234567890 DESC5678  NERD     DatePWChange   :10-12-93 
 City :12345678901234567890123456789012345                              
                                               Phone    :12345678901234 
 FCall:10-12-93 00:00:00      DOB:10-12-93     Data :123456789012345678 
 LCall:10-12-93 21:48:54   Gender:UNKNOWN      Access        :LimitedXX 
Ĵ
 M.Area:123456789012345678901234567  F.Area:123456789012345678901234567 
                                                                        
 Calls :XXXXXx  File Tran:XXXXXXXXX  Dnld Today:XXXXXXx  TimeToday:XXXX 
 Credt :XXXXXX  File Comp:XXXXXXXXX  Total Dnld:XXXXXXx  TimeCredt:XXXX 
 Debit :XXXXXX  File Today :XXXXXXx  Total Upld:XXXXXXx  Scrn Wdth:XXXX 
 PCredt:XXXXXX  File Dnload:XXXXXXx  MsgRead   :XXXXXXx  Scrn Lgth:XXXX 
 PDebit:XXXXXX  File Upload:XXXXXXx  MsgWritten:XXXXXXx  Nulls    :XXXX 
 Lang:XXXXXXXX  File Scan :10-12-93  CallsToday:XXXXXXx                 
                                       ĿĿĿĿ 
 ANSIXXXX  NOVICEXX  Group:XXXXX  Keys:................................ 
Ĵ
 Edit Access Lang Tran Comp Video Help Flag Prm Del  Upgd  Srch  BROWSE 

Ŀ
 UED    permanent  deleted  Index                 Record   565 of   565 
Ĵ
 Name :12345678901234567890123456789012345     Password:*************** 
 Alias:12345678901234567890           NERD     DatePWChange   :10-12-93 
 City :12345678901234567890123456789012345                              
                                               Phone    :12345678901234 
 FCall:10-12-93 00:00:00      DOB:10-12-93     Data :123456789012345678 
 LCall:10-12-93 21:48:54   Gender:UNKNOWN              Access:LimitedXX 
Ĵ
 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx      MaxEd:XNO 
 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx      FScnR:XNO 
 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx      Hot K:YES 
 Description                          LastReadPtr:xxxxxx      IBMch:YES 
                                                              More :YES 
                        Action:XXXXXX          UsdMx:YES      Tabs :YES 
 EXpiry:XXXX 01-01-80   Demote:XXXXXX          BadLg:XNO      Ulstd:YES 
                                                 Cls:YES      ChAvl:YES 
                                       ĿĿĿĿ 
 ANSIXXXX  NOVICEXX  Group:XXXXX  Keys:................................ 
Ĵ
 Edit Access Lang Tran Comp Video Help Flag Prm Del  Upgd  Srch  BROWSE 

*/
/* Main edit screen */
VOID EditScreen (VOID)
{
    SHORT done, selection=13;

    if(!WinOpen(1,2,23,75,bdr,battr,wattr)) return;
    WINSHADOW();
    ShowLabels(); /* Write the label strings */
    ClearMenu();

    /* Read user record */
    if(UserIdxRead(Ud,CurRec)) {
        WinClose();
        return;
    }

    ShowDisplay(); /* Display record to screen */

    done=0;
    while(!done) {
        if(selection<1||selection>13) selection=13;
        SetHKeys();
        MenuBegC();
        MenuItem(20,  1, "Edit",   'E',  1,0,       NULL, 0, 0); /* Edit */
        MenuItem(20,  6, "Access", 'A',  2,0,       NULL, 0, 0); /* Access */
        MenuItem(20, 13, "Lang",   'L',  3,0,       NULL, 0, 0); /* Lang */
        MenuItem(20, 18, "Tran",   'T',  4,0,       NULL, 0, 0); /* Tran */
        MenuItem(20, 23, "Comp",   'C',  5,0,       NULL, 0, 0); /* Comp */
        MenuItem(20, 28, "Video",  'V',  6,0,       NULL, 0, 0); /* Video */
        MenuItem(20, 34, "Help",   'H',  7,0,       NULL, 0, 0); /* Help */
        MenuItem(20, 39, "Flag",   'F',  8,0,       NULL, 0, 0); /* Flag */
        MenuItem(20, 44, "Prm",    'P',  9,0,       NULL, 0, 0); /* Perm */
        MenuItem(20, 48, "Del",    'D', 10,0,       NULL, 0, 0); /* Del */
        MenuItem(20, 53, "Upgd",   'U', 11,0,       NULL, 0, 0); /* Upgrade */
        MenuItem(20, 59, "Srch",   'S', 12,0,       NULL, 0, 0); /* Search */
        MenuItem(20, 65, "BROWSE", 'B', 13,0,       NULL, 0, 0);
        MenuEnd(selection,M_HORZ|M_SAVE,0,0,BLUE|_LGREY,LBLUE|_LGREY,
            BLACK|_LGREY,WHITE|_RED);
        selection=MenuGet();
        MenuFreOnKey(); /* Disable the hotkey functions */
        ClearMenu();

        switch(selection) { /* Process the menu */
            case  1: EditText();    break;
            case  2: EditAccess();  break;
            case  3: EditLang();    break;
            case  4: EditTran();    break;
            case  5: EditComp();    break;
            case  6: EditVideo();   break;
            case  7: EditHelp();    break;
            case  8: EditFlags();   break;
            case  9: EditPerm();    break;
            case 10: EditDel();     break;
            case 11: if(UpGrde()) {
                         WriteRec();
                         ShowDisplay(); /* Display record to screen */
                     }
                     break;
            case 12: RunSearch();   break;
            case 13: MainStat=STAT_BROW; done++; break;
            case -1: TheMenu();
                     UserIdxRead(Ud,CurRec);
                     switch(MenuStat) {
                     case MENU_QUIT:
                         CfgCheck(); /* Check for INI change/save  */
                         MainStat=STAT_QUIT;
                         ++done; break;
                     case MENU_PACK : /* Pack the base  */
                         ShowIndex();
                         /* Flow through! */
                     case MENU_NEWR : /* Add new record */
                         ShowHighest();
                         ShowDisplay(); /* Display record to screen */
                         break;
                     case MENU_SORT : /* Index */
                         TONEFOUND();
                         ShowIndex();
                         ShowDisplay();
                         break;
                       case MENU_CFGS : /* Cfg change */
                         ShowDisplay();
                         break;
                       case MENU_GDEL:
                         ShowDisplay();
                         break;
                     }
                     break;
            default: break;
        }
    }

    WinClose();
}

/**/

static VOID PASCAL SetHKeys (VOID)
{
    MenuSetOnKey(0x4700,FrstErec,0);   /* Turn on HOME key          */
    MenuSetOnKey(0x4F00,LastErec,0);   /* Turn on END key           */
    MenuSetOnKey(0x4800,PrevErec,0);   /* <Up Arrow>                */
    MenuSetOnKey(0x4A2D,PrevErec,0);   /* <Grey ->                  */
    MenuSetOnKey(0x4900,PgUpErec,0);   /* PgUp                      */
    MenuSetOnKey(0x5100,PgDnErec,0);   /* PgDn                      */
    MenuSetOnKey(0x5000,NextErec,0);   /* <Down Arrow>              */
    MenuSetOnKey(0x4E2B,NextErec,0);   /* <Grey +>                  */
    MenuSetOnKey(0x5300,EditDel,0);    /* <Del>                     */
    /* Show Pwd toggle */
    MenuSetOnKey(0x1177,EditPwd,0);    /* w for PWd                 */
    MenuSetOnKey(0x1157,EditPwd,0);    /* W for PWd                 */
    /* Set Keys */
    MenuSetOnKey(0x256B,EditKeys,0);   /* k for Keys                */
    MenuSetOnKey(0x254B,EditKeys,0);   /* K for Keys                */
    /* Set EXpiry */
    MenuSetOnKey(0x2D78,EditExpiry,0); /* x for EXpiry            */
    MenuSetOnKey(0x2D58,EditExpiry,0); /* X for EXpiry            */
    /* Priv adjust */
    MenuSetOnKey(0x333C,PrivDown,0);   /* "<" - Priv down           */
    MenuSetOnKey(0x343E,PrivUp,0);     /* ">" - Priv up             */
    /* Description toggle */
    MenuSetOnKey(0x0F09,FlipDesc,0);   /* TAB - toggle description  */
    MenuSetOnKey(0x0F00,FlipDesc,0);   /* TAB - display toggle      */
    /* Edit Gender */
    MenuSetOnKey(0x2267,EditGender,0); /* g - Gender edit           */
    MenuSetOnKey(0x2247,EditGender,0); /* G - Gender edit           */
    /* Edit Areas */
    MenuSetOnKey(0x326D,EditAreas,0); /* m - Area edit              */
    MenuSetOnKey(0x324D,EditAreas,0); /* M - Area edit              */
    MenuSetOnKey(0x7800,FlipK1,0);    /* Turn on user Alt 1 toggle */
    MenuSetOnKey(0x7900,FlipK2,0);    /* Turn on user Alt 2 toggle */
    MenuSetOnKey(0x7A00,FlipK3,0);    /* Turn on user Alt 3 toggle */
    MenuSetOnKey(0x7B00,FlipK4,0);    /* Turn on user Alt 4 toggle */
    MenuSetOnKey(0x7C00,FlipK5,0);    /* Turn on user Alt 5 toggle */
    MenuSetOnKey(0x7D00,FlipK6,0);    /* Turn on user Alt 6 toggle */
    MenuSetOnKey(0x7E00,FlipK7,0);    /* Turn on user Alt 7 toggle */
    MenuSetOnKey(0x7F00,FlipK8,0);    /* Turn on user Alt 8 toggle */
    MenuSetOnKey(0x1E00,FlipKa,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x3000,FlipKb,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x2E00,FlipKc,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x2000,FlipKd,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x1200,FlipKe,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x2100,FlipKf,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x2200,FlipKg,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x2300,FlipKh,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x1700,FlipKi,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x2400,FlipKj,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x2500,FlipKk,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x2600,FlipKl,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x3200,FlipKm,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x3100,FlipKn,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x1800,FlipKo,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x1900,FlipKp,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x1000,FlipKq,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x1300,FlipKr,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x1F00,FlipKs,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x1400,FlipKt,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x1600,FlipKu,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x2F00,FlipKv,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x1100,FlipKw,0);    /* Turn on user Alt A toggle */
    MenuSetOnKey(0x2D00,FlipKx,0);    /* Turn on user Alt A toggle */
}

/**/

static VOID PASCAL ClearMenu (VOID)
{
    WinPrintS(20, 0,BLUE|_LGREY," Edit Access Lang Tran Comp Video Help Flag Prm Del  Upgd  Srch  BROWSE ");
    WinPrintS(20, 1,LBLUE|_LGREY,"E");
    WinPrintS(20, 6,LBLUE|_LGREY,"A");
    WinPrintS(20,13,LBLUE|_LGREY,"L");
    WinPrintS(20,18,LBLUE|_LGREY,"T");
    WinPrintS(20,23,LBLUE|_LGREY,"C");
    WinPrintS(20,28,LBLUE|_LGREY,"V");
    WinPrintS(20,34,LBLUE|_LGREY,"H");
    WinPrintS(20,39,LBLUE|_LGREY,"F");
    WinPrintS(20,44,LBLUE|_LGREY,"P");
    WinPrintS(20,48,LBLUE|_LGREY,"D");
    WinPrintS(20,53,LBLUE|_LGREY,"U");
    WinPrintS(20,59,LBLUE|_LGREY,"S");
    WinPrintS(20,65,LBLUE|_LGREY,"B");
}

/**/

static VOID PASCAL RunSearch (VOID)
{
    if(!UsrSearch()) UserIdxRead(Ud,CurRec);
    ShowDisplay();
}

/**/

static VOID FrstErec (VOID)
{
    /* If nothing to do */
    if(CurRec==0) return;

    if(0==UserIdxRead(Ud,0)) {
        CurRec=0;
        ShowDisplay(); /* Display record to screen */
    }
}

/**/

static VOID PrevErec (VOID)
{
    /* If nothing to do */
    if(CurRec<1) return;

    if(0==UserIdxRead(Ud,CurRec-1)) {
        --CurRec;
        ShowDisplay(); /* Display record to screen */
    }
}

/**/

static VOID PgUpErec (VOID)
{
    SHORT NewRec;

    /* If nothing to do */
    if(CurRec<1) return;

    NewRec=CurRec-16;
    if(NewRec<0) NewRec=0;

    if(0==UserIdxRead(Ud,NewRec)) {
        CurRec=NewRec;
        ShowDisplay(); /* Display record to screen */
    }
}

/**/

static VOID PgDnErec (VOID)
{
    SHORT NewRec;

    /* If nothing to do */
    if((USHORT)CurRec>=Ud->Unum-1) return;

    NewRec=CurRec+16;
    if((USHORT)NewRec>Ud->Unum-1) NewRec=Ud->Unum-1;

    if(0==UserIdxRead(Ud,NewRec)) {
        CurRec=NewRec;
        ShowDisplay(); /* Display record to screen */
    }
}

/**/

static VOID NextErec (VOID)
{
    /* If nothing to do */
    if((USHORT)CurRec>=Ud->Unum-1) return;

    if(0==UserIdxRead(Ud,CurRec+1)) {
        ++CurRec;
        ShowDisplay(); /* Display record to screen */
    }
}

/**/

static VOID LastErec (VOID)
{
    /* If nothing to do */
    if((USHORT)CurRec==Ud->Unum-1) return;

    if(0==UserIdxRead(Ud,Ud->Unum-1)) {
        CurRec=Ud->Unum-1;
        ShowDisplay(); /* Display record to screen */
    }
}

/**/

/* Show the label strings */
static VOID PASCAL ShowLabels (VOID)
{
    WinPrintS( 0,1,battr,"UED");
    WinPrintS( 0,28,qattr,"Index"); ShowIndex();
    WinPrintS( 0,50,qattr,"Record       of");
    ShowHighest();
    WinHLine(1,0,72,bdr,battr);
    WinPrintS( 2, 1,wattr,"Name :");
    WinPrintS( 2,47,wattr,"PassWord:"); WinPrintS( 2,51,qattr,"W");
    WinPrintS( 3, 1,wattr,"Alias:");
    WinPrintS( 3,47,wattr,"DatePWChange   :");
    WinPrintS( 4, 1,wattr,"City :");
    WinPrintS( 5,47,wattr,"Phone    :");
    WinPrintS( 6, 1,wattr,"FCall:");
    WinPrintS( 6,30,wattr,"DOB:");
    WinPrintS( 6,47,wattr,"Data :");
    WinPrintS( 7,1,wattr,"LCall:");
    WinPrintS( 7,27,qattr,"G"); WinPrintS( 7,28,wattr,"ender:");
    WinPrintS( 7,47,qattr,"A"); WinPrintS( 7,48,wattr,"ccess        :");
    WinPrintS( 7,54,qattr,"<>");

    WinHLine(8,0,72,bdr,battr); WinPrintS(8,1,qattr,"tab");

    if(DescFlg)  ShowDescLabels();
    else ShowNoDescLabels();

    WinPrintS(18,21,wattr,"Group:");
    WinPrintS(18,34,qattr,"K"); WinPrintS(18,35,wattr,"eys:");

    WinHLine(17,0,72,bdr,battr);
    WinPrintS(17,39,battr,"ĿĿĿĿ");
    WinHLine(19,0,72,bdr,battr);
}

/**/

static VOID PASCAL ShowDescLabels (VOID)
{
    WinPrintS(8,5,battr,"12"); WinPrintS(8,5,qattr,"1");
    WinFill(9,1,11,55,' ',fattr);
    WinPrintS(12,1,wattr,"Description");
    WinPrintS(12,39,wattr,"LastReadPtr:");
    WinPrintS(14,1,wattr,"EXpiry:"); WinPrintS(14, 2,qattr,"X");
    WinPrintS(15,1,wattr,"Action:");
    WinPrintS(16,1,wattr,"Demote:");

    WinPrintS(14,47,wattr,"UsdMx:");
    WinPrintS(15,47,wattr,"BadLg:");
    WinPrintS(16,47,wattr,"  Cls:");
    WinPrintS( 9,62,wattr,"MaxEd:");
    WinPrintS(10,62,wattr,"FScnR:");
    WinPrintS(11,62,wattr,"Hot K:");
    WinPrintS(12,62,wattr,"IBMch:");
    WinPrintS(13,62,wattr,"More :");
    WinPrintS(14,62,wattr,"Tabs :");
    WinPrintS(15,62,wattr,"Ulstd:");
    WinPrintS(16,62,wattr,"ChAvl:");

    WinPrintS(15,28,wattr,"Nerd :");
    WinPrintS(16,28,wattr,"Rip  :");
}

/**/

static VOID PASCAL ShowNoDescLabels (VOID)
{
    WinPrintS(8,5,battr,"12"); WinPrintS(8,6,qattr,"2");
    WinPrintS( 9,1,qattr,"M"); WinPrintS( 9,2,wattr,".Area:");
    WinPrintS( 9,37,wattr,"F.Area:");

    WinPrintS(11,1,wattr,"Calls :");
    WinPrintS(12,1,wattr,"Credit:");
    WinPrintS(13,1,wattr,"Debit :");
    WinPrintS(14,1,wattr,"PCredt:");
    WinPrintS(15,1,wattr,"PDebit:");
    WinPrintS(16,1,qattr,"L"); WinPrintS(16,2,wattr,"ang:");

    WinPrintS(11,16,wattr,"File Tran:"); WinPrintS(11,21,qattr,"T");
    WinPrintS(12,16,wattr,"File Comp:"); WinPrintS(12,21,qattr,"C");
    WinPrintS(13,16,wattr,"File Today :");
    WinPrintS(14,16,wattr,"File Dnload:");
    WinPrintS(15,16,wattr,"File Upload:");
    WinPrintS(16,16,wattr,"File Scan :");

    WinPrintS(11,37,wattr,"Dnld Today:");
    WinPrintS(12,37,wattr,"Total Dnld:");
    WinPrintS(13,37,wattr,"Total Upld:");
    WinPrintS(14,37,wattr,"MsgRead   :");
    WinPrintS(15,37,wattr,"MsgWritten:");
    WinPrintS(16,37,wattr,"CallsToday:");

    WinPrintS(11,57,wattr,"TimeToday:");
    WinPrintS(12,57,wattr,"TimeCredt:");
    WinPrintS(13,57,wattr,"Scrn Wdth:");
    WinPrintS(14,57,wattr,"Scrn Lgth:");
    WinPrintS(15,57,wattr,"Nulls    :");
}

/**/

/* Display number of records */
static VOID PASCAL ShowHighest (VOID)
{
    CHAR num[9];

    FormCvtIC(num,Ud->Unum,5); WinPrintS(0,66,WHITE|_BLACK,num);
}

/**/

static VOID PASCAL ShowIndex (VOID)
{
    CHAR cbuf[16];
    WinPrintS( 0,34,WHITE|_BLACK,FormStrSetSz(strcpy(cbuf,SortStr[Ud->SortTyp]),10));
}

/**/

static VOID PASCAL ShowFlagsDisplay (VOID)
{
    WinPrintS( 9,68,nattr,Ud->Usr->bits2&BITS2_BORED     ?No:Yes);
    WinPrintS(10,68,nattr,Ud->Usr->bits&BITS_FSR         ?Yes:No);
    WinPrintS(11,68,nattr,Ud->Usr->bits&BITS_HOTKEYS     ?Yes:No);
    WinPrintS(12,68,nattr,Ud->Usr->bits2&BITS2_IBMCHARS  ?Yes:No);
    WinPrintS(13,68,nattr,Ud->Usr->bits2&BITS2_MORE      ?Yes:No);
    WinPrintS(14,68,nattr,Ud->Usr->bits&BITS_TABS        ?Yes:No);
    WinPrintS(15,68,nattr,Ud->Usr->bits&BITS_NOULIST     ?No:Yes);
    WinPrintS(16,68,nattr,Ud->Usr->bits&BITS_NOTAVAIL    ?No:Yes);

    WinPrintS(14,53,nattr,Ud->Usr->bits2&BITS2_CONFIGURED?Yes:No);
    WinPrintS(15,53,nattr,Ud->Usr->bits2&BITS2_BADLOGON  ?Yes:No);
    WinPrintS(16,53,nattr,Ud->Usr->bits2&BITS2_CLS       ?Yes:No);

    WinPrintS(15,34,nattr,Ud->Usr->bits&BITS_NERD        ?Yes:No);
    WinPrintS(16,34,nattr,Ud->Usr->bits&BITS_RIP         ?Yes:No);
}

/**/

static VOID PASCAL ShowGender (VOID)
{
    if(Ud->Usr->sex==SEX_MALE)        WinPrintS(7,34,nattr,def_sex[0]);
    else if(Ud->Usr->sex==SEX_FEMALE) WinPrintS(7,34,nattr,def_sex[1]);
    else                              WinPrintS(7,34,nattr,def_sex[2]);
}

/**/

/* Edit a user record */
static VOID PASCAL EditText (VOID)
{
    extern CHAR desc_text[EXT_MAXC+1];    /* Descriptions buffer */
    SHORT Status;
    CHAR DPWC[10], DPWC1[4], DPWC2[4], DPWC3[4]; /* Password date   */
    CHAR DFCL[10], DFCL1[4], DFCL2[4], DFCL3[4]; /* First call date */
    CHAR TFCL[10], TFCL1[4], TFCL2[4], TFCL3[4]; /* First call time */
    CHAR DLCL[10], DLCL1[4], DLCL2[4], DLCL3[4]; /* Last call date  */
    CHAR TLCL[10], TLCL1[4], TLCL2[4], TLCL3[4]; /* Last call time  */
    CHAR DOBR[10], DOBR1[4], DOBR2[4], DOBR3[4]; /* DOB             */
    CHAR Times[8], Credit[8], Debit[8], Pcredit[8], Pdebit[8];
    CHAR Ndowntoday[10], Ndown[10], Nup[10];
    CHAR DFSC[10], DFSC1[4], DFSC2[4], DFSC3[4]; /* File scan date  */
    CHAR Downtoday[10], Down[10], Up[10], Msgs_read[10], Msgs_posted[10];
    CHAR Time[8], Time_added[8], Width[8], Len[8], Nulls[8], LrPtr[6];
    CHAR Group[10], Call[10];
    LONG Work2;
    CHAR d1[EXT_LLEN+1], d2[EXT_LLEN+1], d3[EXT_LLEN+1];
    SHORT desc_update=0, desc_lostptr=0;
    ULONG offset;

    if(UedCfg.Maintenance) {
        /* Get PW date strings */
        ShowDate(&(Ud->Usr->date_pwd_chg),DPWC);
        strncpy(DPWC1,DPWC,2);   DPWC1[2]='\0';
        strncpy(DPWC2,DPWC+3,2); DPWC2[2]='\0';
        strncpy(DPWC3,DPWC+6,2); DPWC3[2]='\0';
    }
    /* Get date first call strings */
    ShowDate(&(Ud->Usr->date_1stcall),DFCL);
    strncpy(DFCL1,DFCL,2);   DFCL1[2]='\0';
    strncpy(DFCL2,DFCL+3,2); DFCL2[2]='\0';
    strncpy(DFCL3,DFCL+6,2); DFCL3[2]='\0';
    /* Get time first call strings */
    ShowTime(&(Ud->Usr->date_1stcall),TFCL);
    strncpy(TFCL1,TFCL,2);   TFCL1[2]='\0';
    strncpy(TFCL2,TFCL+3,2); TFCL2[2]='\0';
    strncpy(TFCL3,TFCL+6,2); TFCL3[2]='\0';
    /* Get DOB strings */
    ShowDOB(Ud->Usr->dob_day,Ud->Usr->dob_month,Ud->Usr->dob_year,DOBR);
    strncpy(DOBR1,DOBR,2);   DOBR1[2]='\0';
    strncpy(DOBR2,DOBR+3,2); DOBR2[2]='\0';
    strncpy(DOBR3,DOBR+6,2); DOBR3[2]='\0';
    /* Get date last call strings */
    ShowDate(&(Ud->Usr->ludate),DLCL);
    strncpy(DLCL1,DLCL,2);   DLCL1[2]='\0';
    strncpy(DLCL2,DLCL+3,2); DLCL2[2]='\0';
    strncpy(DLCL3,DLCL+6,2); DLCL3[2]='\0';
    /* Get time last call strings */
    ShowTime(&(Ud->Usr->ludate),TLCL);
    strncpy(TLCL1,TLCL,2);   TLCL1[2]='\0';
    strncpy(TLCL2,TLCL+3,2); TLCL2[2]='\0';
    strncpy(TLCL3,TLCL+6,2); TLCL3[2]='\0';

    if(DescFlg) {
        d1[0]='\0'; d2[0]='\0'; d3[0]='\0';
        if(Ud->Usr->extra) { /* If we have existing description */
            if(ReadDesc(Ud->Usr->extra)) { /* And can find it */
                /* Load it in for editing */
                SplitDesc(d1,d2,d3);
                desc_update++; /* Flag an update */
            }
            else desc_lostptr++;
        }
        /* Get LrPtr */
        if(UedCfg.Maintenance) sprintf(LrPtr,"%5u",Ud->Usr->lastread_ptr);
    }
    else {
        sprintf(Times,"%6u",Ud->Usr->times);
        sprintf(Downtoday,"%7lu",Ud->Usr->downtoday);
        sprintf(Time,"%4u",Ud->Usr->time);
        sprintf(Credit,"%6u",Ud->Usr->credit);
        sprintf(Down,"%7lu",Ud->Usr->down);
        sprintf(Time_added,"%4u",Ud->Usr->time_added);
        sprintf(Debit,"%6u",Ud->Usr->debit);
        sprintf(Ndowntoday,"%7lu",Ud->Usr->ndowntoday);
        sprintf(Up,"%7lu",Ud->Usr->up);
        sprintf(Width,"%4u",(USHORT)Ud->Usr->width);
        sprintf(Pcredit,"%6lu",Ud->Usr->point_credit);
        sprintf(Ndown,"%7lu",Ud->Usr->ndown);
        sprintf(Msgs_read,"%7lu",Ud->Usr->msgs_read);
        sprintf(Len,"%4u",(USHORT)Ud->Usr->len);
        sprintf(Pdebit,"%6lu",Ud->Usr->point_debit);
        sprintf(Nup,"%7lu",Ud->Usr->nup);
        sprintf(Msgs_posted,"%7lu",Ud->Usr->msgs_posted);
        sprintf(Call,"%7u",Ud->Usr->call);
        sprintf(Nulls,"%4u",(USHORT)Ud->Usr->nulls);
        /* Get date file scan strings */
        ShowDate(&(Ud->Usr->date_newfile),DFSC);
        strncpy(DFSC1,DFSC,2);   DFSC1[2]='\0';
        strncpy(DFSC2,DFSC+3,2); DFSC2[2]='\0';
        strncpy(DFSC3,DFSC+6,2); DFSC3[2]='\0';
    }

    /* Get group string */
    sprintf(Group,"%5u",Ud->Usr->group);

    FormBeg(fattr,hattr); /* Do the edit form */

    FormDef(2,7,Ud->Usr->name,"???????????????????????????????????",0,1,NULL,0);
    FormDef(3,7,Ud->Usr->alias,"????????????????????",0,1,NULL,0);
    if(UedCfg.Maintenance) {
        FormDef(3,63,DPWC1,"%%",0,1,NULL,0);
        FormDef(3,66,DPWC2,"%%",0,1,NULL,0);
        FormDef(3,69,DPWC3,"%%",0,1,NULL,0);
    }
    FormDef(4,7,Ud->Usr->city,"???????????????????????????????????",0,1,NULL,0);
    FormDef(5,57,Ud->Usr->phone, "TTTTTTTTTTTTTT",0,1,NULL,0);
    FormDef(6,7,DFCL1,"%%",0,1,NULL,0);
    FormDef(6,10,DFCL2,"%%",0,1,NULL,0);
    FormDef(6,13,DFCL3,"%%",0,1,NULL,0);
    FormDef(6,16,TFCL1,"%%",0,1,NULL,0);
    FormDef(6,19,TFCL2,"%%",0,1,NULL,0);
    FormDef(6,22,TFCL3,"%%",0,1,NULL,0);
    FormDef(6,34,DOBR1,"%%",0,1,NULL,0);
    FormDef(6,37,DOBR2,"%%",0,1,NULL,0);
    FormDef(6,40,DOBR3,"%%",0,1,NULL,0);
    FormDef(6,53,Ud->Usr->dataphone, "TTTTTTTTTTTTTTTTTT",0,1,NULL,0);
    FormDef(7,7,DLCL1,"%%",0,1,NULL,0);
    FormDef(7,10,DLCL2,"%%",0,1,NULL,0);
    FormDef(7,13,DLCL3,"%%",0,1,NULL,0);
    FormDef(7,16,TLCL1,"%%",0,1,NULL,0);
    FormDef(7,19,TLCL2,"%%",0,1,NULL,0);
    FormDef(7,22,TLCL3,"%%",0,1,NULL,0);
    if(DescFlg) {
        FormDef( 9,1,d1,"???????????????????????????????????????????????????????",0,1,NULL,0);
        FormDef(10,1,d2,"???????????????????????????????????????????????????????",0,1,NULL,0);
        FormDef(11,1,d3,"???????????????????????????????????????????????????????",0,1,NULL,0);
        if(UedCfg.Maintenance) FormDef(12,51,LrPtr,"%%%%%",0,1,NULL,0);
    }
    else {
        FormDef(11,8,Times,"%%%%%%",0,1,NULL,0);
        FormDef(11,48,Downtoday,"%%%%%%%",0,1,NULL,0);
        FormDef(11,67,Time,"%%%%",0,1,NULL,0);
        FormDef(12,8,Credit,"%%%%%%",0,1,NULL,0);
        FormDef(12,48,Down,"%%%%%%%",0,1,NULL,0);
        FormDef(12,67,Time_added,"%%%%",0,1,NULL,0);
        FormDef(13,8,Debit,"%%%%%%",0,1,NULL,0);
        FormDef(13,28,Ndowntoday,"%%%%%%%",0,1,NULL,0);
        FormDef(13,48,Up,"%%%%%%%",0,1,NULL,0);
        FormDef(13,67,Width,"%%%%",0,1,NULL,0);
        FormDef(14,8,Pcredit,"%%%%%%",0,1,NULL,0);
        FormDef(14,28,Ndown,"%%%%%%%",0,1,NULL,0);
        FormDef(14,48,Msgs_read,"%%%%%%%",0,1,NULL,0);
        FormDef(14,67,Len,"%%%%",0,1,NULL,0);
        FormDef(15,8,Pdebit,"%%%%%%",0,1,NULL,0);
        FormDef(15,28,Nup,"%%%%%%%",0,1,NULL,0);
        FormDef(15,48,Msgs_posted,"%%%%%%%",0,1,NULL,0);
        FormDef(15,67,Nulls,"%%%%",0,1,NULL,0);
        FormDef(16,27,DFSC1,"%%",0,1,NULL,0);
        FormDef(16,30,DFSC2,"%%",0,1,NULL,0);
        FormDef(16,33,DFSC3,"%%",0,1,NULL,0);
        FormDef(16,48,Call,"%%%%%%%",0,1,NULL,0);
    }
    FormDef(18,27,Group,"%%%%%",0,1,NULL,0);

    Status=FormRead(); /* Process the input fields */
    VidHideCur();

    FormStrTrim(Ud->Usr->name);
    FormStrTrim(Ud->Usr->alias);
    FormStrTrim(Ud->Usr->city);
    FormStrTrim(Ud->Usr->phone);
    FormStrTrim(Ud->Usr->dataphone);

    if(Status!=W_ESCPRESS) { /* Process changes */
        if(UedCfg.Maintenance) {
            /* Put PW date */
            strcpy(DPWC,DPWC1); strcat(DPWC,"-"); strcat(DPWC,DPWC2);
            strcat(DPWC,"-"); strcat(DPWC,DPWC3);
            GetDate(&(Ud->Usr->date_pwd_chg),DPWC);
        }
        /* Put first call date */
        strcpy(DFCL,DFCL1); strcat(DFCL,"-"); strcat(DFCL,DFCL2);
        strcat(DFCL,"-"); strcat(DFCL,DFCL3);
        GetDate(&(Ud->Usr->date_1stcall),DFCL);
        /* Put first call time */
        strcpy(TFCL,TFCL1); strcat(TFCL,":"); strcat(TFCL,TFCL2);
        strcat(TFCL,":"); strcat(TFCL,TFCL3);
        GetTime(&(Ud->Usr->date_1stcall),TFCL);
        /* Put DOB */
        strcpy(DOBR,DOBR1); strcat(DOBR,"-"); strcat(DOBR,DOBR2);
        strcat(DOBR,"-"); strcat(DOBR,DOBR3);
        GetDOB(&(Ud->Usr->dob_day),&(Ud->Usr->dob_month),&(Ud->Usr->dob_year),
            DOBR);
        /* Put last call date */
        strcpy(DLCL,DLCL1); strcat(DLCL,"-"); strcat(DLCL,DLCL2);
        strcat(DLCL,"-"); strcat(DLCL,DLCL3);
        GetDate(&(Ud->Usr->ludate),DLCL);
        /* Put last call time */
        strcpy(TLCL,TLCL1); strcat(TLCL,":"); strcat(TLCL,TLCL2);
        strcat(TLCL,":"); strcat(TLCL,TLCL3);
        GetTime(&(Ud->Usr->ludate),TLCL);

        if(DescFlg) {
            JoinDesc(d1,d2,d3);
            if(FormStrBlank(desc_text)) { /* No text, so delete the description */
                if(desc_update) { /* If an update */
                    DelDesc(Ud->Usr->extra);
                    Ud->Usr->extra=0x0000L; /* Clear the pointer */
                }
                if(desc_lostptr) Ud->Usr->extra=0x0000L; /* Clear the pointer */
            }
            else {
                if(desc_update) offset=WritDesc(Ud->Usr->extra); /* Is update */
                else offset=AddDesc(); /* Is a new description */
                if(offset) Ud->Usr->extra=offset;
            }

            if(UedCfg.Maintenance) {
                Work2=atol(LrPtr);
                Ud->Usr->lastread_ptr=(USHORT)(Work2>65535L?65535L:Work2);
            }
        }
        else {
            ULONG tmpval;

            Ud->Usr->times=atoi(Times);
            Ud->Usr->downtoday=atol(Downtoday);
            Ud->Usr->time=atoi(Time);
            tmpval=atol(Credit); Ud->Usr->credit=(USHORT)(tmpval>65535L?65535L:tmpval);
            Ud->Usr->down=atol(Down);
            Ud->Usr->time_added=atoi(Time_added);
            tmpval=atol(Debit); Ud->Usr->debit=(USHORT)(tmpval>65535L?65535L:tmpval);
            Ud->Usr->ndowntoday=atol(Ndowntoday);
            Ud->Usr->up=atol(Up);
            Ud->Usr->width=(UCHAR)atoi(Width);
            Ud->Usr->point_credit=atol(Pcredit);
            Ud->Usr->ndown=atol(Ndown);
            Ud->Usr->msgs_read=atol(Msgs_read);
            Ud->Usr->len=(UCHAR)atoi(Len);
            Ud->Usr->point_debit=atol(Pdebit);
            Ud->Usr->nup=atol(Nup);
            Ud->Usr->msgs_posted=atol(Msgs_posted);
            Ud->Usr->call=(USHORT)atoi(Call);
            Ud->Usr->nulls=(UCHAR)atoi(Nulls);
            /* Put file scan date */
            strcpy(DFSC,DFSC1); strcat(DFSC,"-"); strcat(DFSC,DFSC2);
            strcat(DFSC,"-"); strcat(DFSC,DFSC3);
            GetDate(&(Ud->Usr->date_newfile),DFSC);
        }

        /* Put group */
        Ud->Usr->group=atoi(Group);

        WriteRec();
    }

    ShowDisplay();
}

/**/

static VOID EditPwd (VOID)
{
    SHORT Status;
    CHAR Pwd[16];

    MenuFreOnKey(); /* Disable the hotkey functions */

    /* Copy existing pwd */
    if(Ud->Usr->bits&(CHAR)BITS_ENCRYPT) *Pwd='\0';
    else strcpy(Pwd,Ud->Usr->pwd);

    if(!WinOpen(11,26,13,53,bdr,BLUE|_LGREY,BLUE|_LGREY)) return;
    WINSHADOW();
    WinPrintS(0,1,BLUE|_LGREY,"PassWord:");

    FormBeg(fattr,hattr); /* Do the edit form */
    FormDef(0,10,Pwd,"???????????????",0,1,NULL,0);
    Status=FormRead(); /* Process the input fields */
    VidHideCur();

    WinClose(); /* Close window */
    SetHKeys();
    FormStrTrim(Pwd);

    if(Status!=W_ESCPRESS) { /* Process changes */
        if(UedCfg.NoPwEncrypt) { /* Save pwd non-encrypted */
            /* If pwd unchanged, return */
            if(!(Ud->Usr->bits&(CHAR)BITS_ENCRYPT)) {
                if(!strcmp(Pwd,Ud->Usr->pwd)) return;
            }

            /* Transfer new non-encrypted pwd */
            strcpy(Ud->Usr->pwd,Pwd);

            /* Clear encrypt flag */
            Ud->Usr->bits=Ud->Usr->bits&~(UCHAR)BITS_ENCRYPT;
        }
        else { /* Save pwd encrypted */
            EncryptPwd(Pwd);

            /* Transfer new encrypted pwd */
            memcpy(Ud->Usr->pwd,Pwd,16);
            /* Set encrypt flag */
            Ud->Usr->bits=Ud->Usr->bits|(UCHAR)BITS_ENCRYPT;
        }

        /* Update last PW change */
        GetSysDateTime(&Ud->Usr->date_pwd_chg);

        ShowDisplay(); WriteRec();
    }
}

/**/

/* Toggle the description display */
static VOID FlipDesc (VOID)
{
    DescFlg^=1;
    WinFill(9,1,16,70,' ',wattr);
    if(DescFlg) { ShowDescLabels(); ShowDescDisplay(); }
    else { ShowNoDescLabels(); ShowNoDescDisplay(); }
}

/**/

/* Write the label strings */
static VOID PASCAL ShowDisplay (VOID)
{
    CHAR cbuf[64];

    /* Record status */
    if(Ud->Usr->delflag&UFLAG_PERM) WinPrintS(0,8,LRED|_BLUE, "PERMANENT");
    else                            WinPrintS(0,8,DGREY|_BLUE,"permanent");
    if(Ud->Usr->delflag&UFLAG_DEL)  WinPrintS(0,19,LRED|_BLUE, "DELETED");
    else                            WinPrintS(0,19,DGREY|_BLUE,"deleted");

    /* Current record number */
    FormCvtIC(cbuf,CurRec+1,5); WinPrintS( 0,57,WHITE|_BLACK,cbuf);

    /* Record data */
    WinPrintS(2, 7,fattr,FormStrSetSz(strcpy(cbuf,Ud->Usr->name),35));
    if(Ud->Usr->bits&(UCHAR)BITS_ENCRYPT) {
        WinPrintS(2,56,RED|_CYAN,"***ENCRYPTED***");
    }
    else if(UedCfg.ShowPwd&&CurRec) {
        WinPrintS(2,56,nattr,FormStrSetSz(strcpy(cbuf,Ud->Usr->pwd),15));
    }
    else WinPrintS(2,56,nattr,"***************");
    WinPrintS(3, 7,fattr,FormStrSetSz(strcpy(cbuf,Ud->Usr->alias),20));
    WinPrintS(3,38,LRED|_BLUE,Ud->Usr->bits&BITS_NERD?"NERD":"    ");
    if(Ud->Usr->extra) {
        if(UedCfg.Maintenance) {
            sprintf(cbuf,"%08x",Ud->Usr->extra);
            WinPrintS(3,27,LRED|_BLUE,cbuf);
        }
        else WinPrintS(3,27,LRED|_BLUE, "DESC");
    }
    else WinPrintS(3,27,DGREY|_BLUE,"        ");
    WinPrintS(3,63,UedCfg.Maintenance?fattr:nosel,ShowDate(&(Ud->Usr->date_pwd_chg),cbuf));
    WinPrintS(4, 7,fattr,FormStrSetSz(strcpy(cbuf,Ud->Usr->city),35));
    WinPrintS(5,57,fattr,FormStrSetSz(strcpy(cbuf,Ud->Usr->phone),14));
    WinPrintS(6, 7,fattr,ShowDate(&(Ud->Usr->date_1stcall),cbuf));
    WinPrintS(6,16,fattr,ShowTime(&(Ud->Usr->date_1stcall),cbuf));
    WinPrintS(6,34,fattr,ShowDOB(
        Ud->Usr->dob_day,
        Ud->Usr->dob_month,
        Ud->Usr->dob_year,cbuf));
    WinPrintS(6,53,fattr,FormStrSetSz(strcpy(cbuf,Ud->Usr->dataphone),18));
    WinPrintS(7, 7,fattr,ShowDate(&(Ud->Usr->ludate),cbuf));
    WinPrintS(7,16,fattr,ShowTime(&(Ud->Usr->ludate),cbuf));
    ShowGender();
    WRITE_PRIV();

    if(DescFlg) ShowDescDisplay();
    else ShowNoDescDisplay();

    WinPrintS(18, 1,nattr,ShowVideo(Ud->Usr->video));
    WinPrintS(18,11,nattr,ShowHelp(Ud->Usr->help));
    FormCvtIC(cbuf,Ud->Usr->group,5); WinPrintS(18,27,fattr,cbuf);
    WRITE_KEYS();
}

/**/

static VOID PASCAL ShowDescDisplay (VOID)
{
    CHAR cbuf[64];
    CHAR d1[EXT_LLEN+1], d2[EXT_LLEN+1], d3[EXT_LLEN+1];

    FormCvtLC(cbuf,(ULONG)Ud->Usr->lastread_ptr,5);
    WinPrintS(12,51,UedCfg.Maintenance?fattr:nosel,cbuf);

    WinFill(9,1,11,55,' ',fattr);

    if(Ud->Usr->extra) {
        if(ReadDesc(Ud->Usr->extra)) {
            SplitDesc(d1,d2,d3);
            WinPrintS( 9,1,fattr,d1);
            WinPrintS(10,1,fattr,d2);
            WinPrintS(11,1,fattr,d3);
        }
    }

    /* Show Expire by data */
    if((Ud->Usr->xp_flag&XFLAG_EXPDATE)||(Ud->Usr->xp_flag&XFLAG_EXPMINS)) {

        if(Ud->Usr->xp_flag&XFLAG_EXPDATE) {
            WinPrintS(14,8,nattr,"         ");
            WinPrintS(14,8,nattr,ShowDate(&(Ud->Usr->xp_date),cbuf));
        }
        else if(Ud->Usr->xp_flag&XFLAG_EXPMINS) {
            FormCvtLC(cbuf,Ud->Usr->xp_mins,9); WinPrintS(14,8,nattr,cbuf);
        }
        else {
            WinPrintS(14,8,nattr,"None     ");
        }

        /* Show Expiry action data */
        if(Ud->Usr->xp_flag&XFLAG_AXE) {
            WinPrintS(15,8,nattr,"HangUp   ");
            WinPrintS(16,8,nattr,"         ");
        }
        else if(Ud->Usr->xp_flag&XFLAG_DEMOTE) {
            WinPrintS(15,8,nattr,"Demote   ");
            WinPrintS(16,8,nattr,ShowPriv(Ud->Usr->xp_priv));
        }
        else {
            WinPrintS(15,8,nattr,"None     ");
            WinPrintS(16,8,nattr,"         ");
        }
    }
    else {
        WinPrintS(14,8,nattr,"None     ");
        WinPrintS(15,8,nattr,"         ");
        WinPrintS(16,8,nattr,"         ");
    }

    ShowFlagsDisplay();
}

/**/

static VOID PASCAL ShowNoDescDisplay (VOID)
{
    CHAR cbuf[64];

    WinPrintS(9,8,nattr,FormStrSetSz(strcpy(cbuf,Ud->Usr->msg),27));
    WinPrintS(9,44,nattr,FormStrSetSz(strcpy(cbuf,Ud->Usr->files),27));

    FormCvtLC(cbuf,(ULONG)Ud->Usr->times,6); WinPrintS(11,8,fattr,cbuf);
    FormCvtLC(cbuf,(ULONG)Ud->Usr->credit,6); WinPrintS(12,8,fattr,cbuf);
    FormCvtLC(cbuf,(ULONG)Ud->Usr->debit,6); WinPrintS(13,8,fattr,cbuf);
    FormCvtLC(cbuf,Ud->Usr->point_credit,6); WinPrintS(14,8,fattr,cbuf);
    FormCvtLC(cbuf,Ud->Usr->point_debit,6); WinPrintS(15,8,fattr,cbuf);
    FormStrSetSz(strcpy(cbuf,UedCfg.lang[Ud->Usr->lang>7?0:Ud->Usr->lang]),8);
    WinPrintS(16,6,nattr,cbuf);
    WinPrintS(11,26,nattr,ShowProt(Ud->Usr->def_proto));
    FormStrSetSz(strcpy(cbuf,UedCfg.comp[Ud->Usr->compress>15?0:Ud->Usr->compress]),9);
    WinPrintS(12,26,nattr,cbuf);
    FormCvtLC(cbuf,Ud->Usr->ndowntoday,7); WinPrintS(13,28,fattr,cbuf);
    FormCvtLC(cbuf,Ud->Usr->ndown,7); WinPrintS(14,28,fattr,cbuf);
    FormCvtLC(cbuf,Ud->Usr->nup,7); WinPrintS(15,28,fattr,cbuf);
    WinPrintS(16,27,fattr,ShowDate(&(Ud->Usr->date_newfile),cbuf));

    FormCvtLC(cbuf,Ud->Usr->downtoday,7); WinPrintS(11,48,fattr,cbuf);
    FormCvtLC(cbuf,Ud->Usr->down,7); WinPrintS(12,48,fattr,cbuf);
    FormCvtLC(cbuf,Ud->Usr->up,7); WinPrintS(13,48,fattr,cbuf);
    FormCvtLC(cbuf,Ud->Usr->msgs_read,7); WinPrintS(14,48,fattr,cbuf);
    FormCvtLC(cbuf,Ud->Usr->msgs_posted,7); WinPrintS(15,48,fattr,cbuf);
    FormCvtLC(cbuf,Ud->Usr->call,7); WinPrintS(16,48,fattr,cbuf);

    FormCvtLC(cbuf,(ULONG)Ud->Usr->time,4); WinPrintS(11,67,fattr,cbuf);
    FormCvtLC(cbuf,(ULONG)Ud->Usr->time_added,4); WinPrintS(12,67,fattr,cbuf);
    FormCvtLC(cbuf,(ULONG)Ud->Usr->width,4); WinPrintS(13,67,fattr,cbuf);
    FormCvtLC(cbuf,(ULONG)Ud->Usr->len,4); WinPrintS(14,67,fattr,cbuf);
    FormCvtLC(cbuf,(ULONG)Ud->Usr->nulls,4); WinPrintS(15,67,fattr,cbuf);
}

/**/

/* Edit Gender */
static VOID EditGender (VOID)
{
    UCHAR GenderSave;
    SHORT val;

    MenuFreOnKey(); /* Disable the hotkey functions */
    GenderSave=Ud->Usr->sex;

    if(!WinOpen(11,35,15,46,bdr,BLUE|_LGREY,BLUE|_LGREY)) return;
    WINSHADOW();

    if(Ud->Usr->sex==SEX_MALE)        val=0;
    else if(Ud->Usr->sex==SEX_FEMALE) val=1;
    else                              val=2;
    MenuBegC();
    MenuItem(0,0,def_sex[0],*def_sex[0],0,0,NULL,0,0);
    MenuItem(1,0,def_sex[1],*def_sex[1],1,0,NULL,0,0);
    MenuItem(2,0,def_sex[2],*def_sex[2],2,0,NULL,0,0);
    MenuEnd(val,M_VERT,11,1,BLUE|_LGREY,LBLUE|_LGREY,BLUE|_LGREY,WHITE|_RED);
    val=MenuGet();
    WinClose(); /* Close window */
    if(val!=-1) {
        if(val==0)      Ud->Usr->sex=SEX_MALE;
        else if(val==1) Ud->Usr->sex=SEX_FEMALE;
        else            Ud->Usr->sex=SEX_UNKNOWN;
    }

    if(GenderSave!=Ud->Usr->sex) {          /* If it was changed,       */
        ShowGender();                       /* Write it to screen,      */
        WriteRec();               /* and to disk              */
    }

    SetHKeys();
}

/**/

/* Edit access level */
static VOID PASCAL EditAccess (VOID)
{
    USHORT privsave;
    SHORT val, i;
    CHAR cbuf[64];

    privsave=Ud->Usr->priv;

    if(!WinOpen(19-UedCfg.PrivNum,8,20,43,bdr,BLUE|_LGREY,BLUE|_LGREY)) return;
    WINSHADOW();
    WinVLine(0,11,UedCfg.PrivNum,bdr,BLUE|_LGREY);

    for(i=0;i<UedCfg.PrivNum;i++)
        WinPrintS(i,13,BLUE|_CYAN,FormStrSetSz(strcpy(cbuf,UedCfg.PrivDesc[i]),20));
    val=GetPriv(Ud->Usr->priv); /* Get current priv index */

    MenuBegC();
    for(i=0;i<UedCfg.PrivNum;i++)
        MenuItem(i,0,UedCfg.Priv[i],*UedCfg.Priv[i],i,0,NULL,0,0);
    MenuEnd(val,M_VERT,11,1,BLUE|_LGREY,LBLUE|_LGREY,BLUE|_LGREY,WHITE|_RED);
    val=MenuGet();

    WinClose(); /* Close window */

    if(val!=-1) {
        Ud->Usr->priv=UedCfg.PrivValue[val]; /* Get new value */

        if(privsave!=Ud->Usr->priv) {           /* If it was changed,       */
            WRITE_PRIV();                       /* Write it to screen,      */
            WriteRec();                         /* and to disk              */
        }
    }
}

/**/

/* Edit Areas */
static VOID EditAreas (VOID)
{
    SHORT Status;

    MenuFreOnKey(); /* Disable the hotkey functions */

    if(!WinOpen(10,2,13,75,bdr,BLUE|_LGREY,BLUE|_LGREY)) return;
    WINSHADOW();
    WinPrintS(0,1,BLUE|_LGREY,"M.Area:"); WinPrintS(1,1,BLUE|_LGREY,"F.Area:");

    FormBeg(fattr,hattr); /* Do the edit form */
    FormDef(0,8,Ud->Usr->msg,  "???????????????????????????????????????????????????????????????",0,1,NULL,0);
    FormDef(1,8,Ud->Usr->files,"???????????????????????????????????????????????????????????????",0,1,NULL,0);
    Status=FormRead(); /* Process the input fields */
    VidHideCur();
    FormStrTrim(Ud->Usr->msg); FormStrTrim(Ud->Usr->files);

    WinClose(); /* Close window */

    if(Status!=W_ESCPRESS) { /* Process changes */
        ShowDisplay(); WriteRec();
    }

    SetHKeys();
}

/**/

/* Edit language setting */
static VOID PASCAL EditLang (VOID)
{
    SHORT val, i;
    UCHAR langsave;

    if(!WinOpen(11,15,20,26,bdr,BLUE|_LGREY,BLUE|_LGREY)) return;
    WINSHADOW();

    val=langsave=Ud->Usr->lang;
    if(val<0||val>7) val=0;

    MenuBegC();
    for(i=0;i<8;i++) MenuItem(i,0,UedCfg.lang[i],0,i,0,NULL,0,0);
    MenuEnd(val,M_VERT,20,1,BLUE|_LGREY,LBLUE|_LGREY,BLACK|_LGREY,WHITE|_RED);
    val=MenuGet();

    WinClose(); /* Close window */

    if(val!=-1) {
        if(langsave!=(UCHAR)val) {
            Ud->Usr->lang=(UCHAR)val;
            ShowDisplay(); WriteRec();
        }
    }
}

/**/

static VOID PASCAL EditTran (VOID)
{
    SHORT val, i;
    CHAR extstr[10];
    CHAR transave;

    if(!WinOpen(11,20,20,32,bdr,BLUE|_LGREY,BLUE|_LGREY)) return;
    WINSHADOW();

    MenuSetOnKey(0x4B00,ExtDown,0);    /* <Left arrow> */
    MenuSetOnKey(0x333C,ExtDown,0);    /* < */
    MenuSetOnKey(0x4D00,ExtUp,0);      /* <Right arrow> */
    MenuSetOnKey(0x343E,ExtUp,0);      /* > */

    transave=Ud->Usr->def_proto; /* Save existing setting */
    if(Ud->Usr->def_proto>=0) {
        val=_PROT_NUM; ext_prot=(short)Ud->Usr->def_proto+1;
    }
    else val=GetProt(Ud->Usr->def_proto);

    sprintf(extstr,"Extern %02d",ext_prot);

    MenuBegC();
    for(i=0;i<_PROT_NUM;i++)
        MenuItem(i,0,_prot[i].name,*_prot[i].name,i,0,NULL,0,0);
    MenuItem(_PROT_NUM,0,extstr,*extstr,_PROT_NUM,0,NULL,0,0);
    MenuIBA(NULL,NULL);
    MenuEnd(val,M_VERT,20,1,BLUE|_LGREY,LBLUE|_LGREY,BLACK|_LGREY,WHITE|_RED);
    val=MenuGet();

    WinClose(); /* Close window */
    MenuFreOnKey(); /* Disable the hotkey functions */

    if(val!=-1) {
        if(transave!=_prot[val].value) { /* If it was changed, */
            if(val==_PROT_NUM) Ud->Usr->def_proto=(CHAR)(ext_prot-1);
            else Ud->Usr->def_proto=_prot[val].value;
            ShowDisplay(); WriteRec();
        }
    }
}

/**/

static VOID ExtDown (VOID)
{
    struct _item_t *it;

    it=MenuICurr();
    if(it->tagid==_PROT_NUM) {
        if(ext_prot>1) {
            ext_prot--;
            sprintf(it->str,"Extern %02d",ext_prot);
            WinPrintS(_PROT_NUM,1,WHITE|_RED,it->str);
        }
    }
}

/**/

static VOID ExtUp (VOID)
{
    struct _item_t *it;

    it=MenuICurr();
    if(it->tagid==_PROT_NUM) {
        if(ext_prot<16) {
            ext_prot++;
            sprintf(it->str,"Extern %02d",ext_prot);
            WinPrintS(_PROT_NUM,1,WHITE|_RED,it->str);
        }
    }
}

/**/

/* Get new compression setting */
static VOID PASCAL EditComp (VOID)
{
    SHORT val, i;
    UCHAR compsave;
    CHAR Str[16][16];

    if(!WinOpen(3,25,20,37,bdr,BLUE|_LGREY,BLUE|_LGREY)) return;
    WINSHADOW();

    val=compsave=Ud->Usr->compress;
    if(val<0||val>15) val=0;

    for(i=0;i<16;i++) sprintf(Str[i],"%2d %s",i,UedCfg.comp[i]);
    MenuBegC();
    for(i=0;i<16;i++) MenuItem(i,0,Str[i],0,i,0,NULL,0,0);
    MenuEnd(val,M_VERT,20,1,BLUE|_LGREY,LBLUE|_LGREY,BLACK|_LGREY,WHITE|_RED);
    val=MenuGet();

    WinClose(); /* Close window */

    if(val!=-1) {
        if(compsave!=(UCHAR)val) {
            Ud->Usr->compress=(UCHAR)val;
            ShowDisplay(); WriteRec();
        }
    }
}

/**/

/* Get new video setting */
static VOID PASCAL EditVideo (VOID)
{
    SHORT val;
    UCHAR videosave;

    if(!WinOpen(16,30,20,39,bdr,BLUE|_LGREY,BLUE|_LGREY)) return;
    WINSHADOW();

    val=GetVideo(Ud->Usr->video); /* Get current video index */
    videosave=Ud->Usr->video;

    MenuBegC();
    MenuItem(0,0,_video[0].name,'V',0,0,NULL,0,0); /* AVATAR */
    MenuItem(1,0,_video[1].name,'A',1,0,NULL,0,0); /* ANSI   */
    MenuItem(2,0,_video[2].name,'T',2,0,NULL,0,0); /* TTY   */
    MenuEnd(val,M_VERT,20,1,BLUE|_LGREY,LBLUE|_LGREY,BLACK|_LGREY,WHITE|_RED);
    val=MenuGet();

    WinClose(); /* Close window */

    if(val!=-1) {
        if(videosave!=_video[val].value) {
            Ud->Usr->video = _video[val].value;
            ShowDisplay(); WriteRec();
        }
    }
}

/**/

/* Get new help level setting */
static VOID PASCAL EditHelp (VOID)
{
    SHORT val, i;
    UCHAR helpsave;

    if(!WinOpen(16,36,20,47,bdr,BLUE|_LGREY,BLUE|_LGREY)) return;
    WINSHADOW();

    val=GetHelp(Ud->Usr->help); /* Get current help index */
    helpsave=Ud->Usr->help;

    MenuBegC();
    for(i=0;i<_HELP_NUM;i++)
        MenuItem(i,0,_help[i].name,*_help[i].name,i,0,NULL,0,0);
    MenuEnd(val,M_VERT,20,1,BLUE|_LGREY,LBLUE|_LGREY,BLACK|_LGREY,WHITE|_RED);
    val=MenuGet();

    WinClose(); /* Close window */

    if(val!=-1) {
        if(helpsave!=_help[val].value) {        /* If it was changed, */
            Ud->Usr->help =_help[val].value;    /* Update in memory record */
            ShowDisplay(); WriteRec();
        }
    }
}

/**/

/* Edit flags */
static VOID PASCAL EditFlags (VOID)
{
/*
Ŀ
 Abort    Exit 
Ĵ
 FS Editor YES 
 FS Reader  NO 
 Hot Keys  YES 
 IBM Chars YES 
 More Prmt YES 
 Use Tabs  YES 
 User List YES 
 Chat Aval YES 
 Used Max  YES 
 Bad LogOn YES 
 Clr Scrn  YES 
 Nerd User YES 
 RIP Grphs YES 

*/
    SHORT i, done=0;
    UCHAR sbits;
    USHORT sbits2;
    SHORT flag_sel=13;
    CHAR flags[13][4];
    CHAR flagkey[13] = "ERHIMTLAUBCNG";
    CHAR *mtext[] = {
        "FS Editor", "FS Reader", "Hot Keys ",  "IBM Chars",
        "More Prmt", "Use Tabs ", "User List",  "Chat Aval",
        "Used Max ", "Bad LogOn", "Clr Scrn ",  "Nerd User",
        "RIP Grphs"
    };

    sbits=Ud->Usr->bits;
    sbits2=Ud->Usr->bits2;

    /* Setup the menu strings */
    strcpy(flags[ 0],Ud->Usr->bits2&BITS2_BORED?No:Yes);
    strcpy(flags[ 1],Ud->Usr->bits&BITS_FSR?Yes:No);
    strcpy(flags[ 2],Ud->Usr->bits&BITS_HOTKEYS?Yes:No);
    strcpy(flags[ 3],Ud->Usr->bits2&BITS2_IBMCHARS?Yes:No);
    strcpy(flags[ 4],Ud->Usr->bits2&BITS2_MORE?Yes:No);
    strcpy(flags[ 5],Ud->Usr->bits&BITS_TABS?Yes:No);
    strcpy(flags[ 6],Ud->Usr->bits&BITS_NOULIST?No:Yes);
    strcpy(flags[ 7],Ud->Usr->bits&BITS_NOTAVAIL?No:Yes);
    strcpy(flags[ 8],Ud->Usr->bits2&BITS2_CONFIGURED?Yes:No);
    strcpy(flags[ 9],Ud->Usr->bits2&BITS2_BADLOGON?Yes:No);
    strcpy(flags[10],Ud->Usr->bits2&BITS2_CLS?Yes:No);
    strcpy(flags[11],Ud->Usr->bits&BITS_NERD?Yes:No);
    strcpy(flags[12],Ud->Usr->bits&BITS_RIP?Yes:No);

    if(!WinOpen(4,41,20,57,bdr,BLUE|_LGREY,BLUE|_LGREY)) return;
    WINSHADOW();

    for(i=0;i<13;i++) WinPrintS(i+2,1,BLUE|_LGREY,mtext[i]); /* Show labels */
    WinPrintS(2,4,LBLUE|_LGREY,"E"); /* Show labels Keys */
    WinPrintS(3,4,LBLUE|_LGREY,"R"); /* Show labels Keys */
    WinPrintS(4,1,LBLUE|_LGREY,"H"); /* Show labels Keys */
    WinPrintS(5,1,LBLUE|_LGREY,"I"); /* Show labels Keys */
    WinPrintS(6,1,LBLUE|_LGREY,"M"); /* Show labels Keys */
    WinPrintS(7,5,LBLUE|_LGREY,"T"); /* Show labels Keys */
    WinPrintS(8,6,LBLUE|_LGREY,"L"); /* Show labels Keys */
    WinPrintS(9,6,LBLUE|_LGREY,"A"); /* Show labels Keys */
    WinPrintS(10,1,LBLUE|_LGREY,"U"); /* Show labels Keys */
    WinPrintS(11,1,LBLUE|_LGREY,"B"); /* Show labels Keys */
    WinPrintS(12,1,LBLUE|_LGREY,"C"); /* Show labels Keys */
    WinPrintS(13,1,LBLUE|_LGREY,"N"); /* Show labels Keys */
    WinPrintS(14,5,LBLUE|_LGREY,"G"); /* Show labels Keys */

    WinHLine(1,0,15,bdr,battr2);
    if(flag_sel<0||flag_sel>14) flag_sel=14;

    while(!done) {
        MenuBegC(); /* Flags */
        MenuItem(0, 1,"Abort",'o',13,0,NULL,0,0);
        MenuItem(0,10,"Exit", 0x1C0A,14,0,NULL,0,0);
        for(i=0;i<13;i++) MenuItem(i+2,11,flags[i],flagkey[i],i,0,NULL,0,0);
        MenuEnd(flag_sel,M_OMNI,0,0,fattr2,fattr2,nosel2,WHITE|_RED);
        flag_sel=MenuGet();

        i=0;
        switch(flag_sel) {
            case 0 : Ud->Usr->bits2 ^= BITS2_BORED;
                     strcpy(flags[ 0],Ud->Usr->bits2&BITS2_BORED?No:Yes);
                     break;
            case 1 : Ud->Usr->bits  ^= BITS_FSR;
                     strcpy(flags[ 1],Ud->Usr->bits&BITS_FSR?Yes:No);
                     break;
            case 2 : Ud->Usr->bits  ^= BITS_HOTKEYS;
                     strcpy(flags[ 2],Ud->Usr->bits&BITS_HOTKEYS?Yes:No);
                     break;
            case 3 : Ud->Usr->bits2 ^= BITS2_IBMCHARS;
                     strcpy(flags[ 3],Ud->Usr->bits2&BITS2_IBMCHARS?Yes:No);
                     break;
            case 4 : Ud->Usr->bits2 ^= BITS2_MORE;
                     strcpy(flags[ 4],Ud->Usr->bits2&BITS2_MORE?Yes:No);
                     break;
            case 5 : Ud->Usr->bits ^= BITS_TABS;
                     strcpy(flags[ 5],Ud->Usr->bits&BITS_TABS?Yes:No);
                     break;
            case 6 : Ud->Usr->bits  ^= BITS_NOULIST;
                     strcpy(flags[ 6],Ud->Usr->bits&BITS_NOULIST?No:Yes);
                     break;
            case 7 : Ud->Usr->bits  ^= BITS_NOTAVAIL;
                     strcpy(flags[ 7],Ud->Usr->bits&BITS_NOTAVAIL?No:Yes);
                     break;
            case 8 : Ud->Usr->bits2 ^= BITS2_CONFIGURED;
                     strcpy(flags[ 8],Ud->Usr->bits2&BITS2_CONFIGURED?Yes:No);
                     break;
            case 9 : Ud->Usr->bits2 ^= BITS2_BADLOGON;
                     strcpy(flags[ 9],Ud->Usr->bits2&BITS2_BADLOGON?Yes:No);
                     break;
            case 10: Ud->Usr->bits2 ^= BITS2_CLS;
                     strcpy(flags[10],Ud->Usr->bits2&BITS2_CLS?Yes:No);
                     break;
            case 11: Ud->Usr->bits ^= BITS_NERD;
                     strcpy(flags[11],Ud->Usr->bits&BITS_NERD?Yes:No);
                     break;
            case 12: Ud->Usr->bits ^= BITS_RIP;
                     strcpy(flags[12],Ud->Usr->bits&BITS_RIP?Yes:No);
                     break;
            case -1: /* ESC */
            case 13: /* Abort */
                     Ud->Usr->bits=sbits; /* Restore saved record */
                     Ud->Usr->bits2=sbits2;
                     done++;
                     break;
            case 14: /* EXIT */
                     if(Ud->Usr->bits!=sbits||Ud->Usr->bits2!=sbits2) {
                         WriteRec();
                         i++;
                     }
                     done++;
                     break;
        }
    }

    WinClose(); /* Close window */
    if(i) ShowDisplay();
}

/**/

static VOID EditPerm (VOID)
{
    if(!(Ud->Usr->delflag&UFLAG_PERM)&&Ud->Usr->delflag&UFLAG_DEL) {
        /* Undelete record */
        Ud->Usr->delflag=Ud->Usr->delflag&~UFLAG_DEL;
    }
    Ud->Usr->delflag =
        Ud->Usr->delflag&UFLAG_PERM ?
        Ud->Usr->delflag&~UFLAG_PERM  : Ud->Usr->delflag|UFLAG_PERM;

    ShowDisplay(); WriteRec();
}

/**/

static VOID EditDel (VOID)
{
    /* Don't delete 1st record */
    if(0==CurRec && !(Ud->Usr->delflag&UFLAG_DEL)) return;

    if(Ud->Usr->delflag&UFLAG_PERM&&!(Ud->Usr->delflag&UFLAG_DEL)) {
        /* Unlock record */
        Ud->Usr->delflag=Ud->Usr->delflag&~UFLAG_PERM;
    }
    Ud->Usr->delflag =
        Ud->Usr->delflag&UFLAG_DEL ?
        Ud->Usr->delflag&~UFLAG_DEL : Ud->Usr->delflag|UFLAG_DEL;

    ShowDisplay(); WriteRec();
}

/**/

static VOID PrivDown (VOID)
{
    SHORT val;

    val=GetPriv(Ud->Usr->priv); /* Get current priv index */

    val++;
    if(val<UedCfg.PrivNum) {
        Ud->Usr->priv = UedCfg.PrivValue[val];
        WRITE_PRIV(); WriteRec();
    }
}

/**/

static VOID PrivUp (VOID)
{
    SHORT val;

    val=GetPriv(Ud->Usr->priv); /* Get current priv index */

    val--;
    if(val>=0) {
        Ud->Usr->priv = UedCfg.PrivValue[val];
        WRITE_PRIV(); WriteRec();
    }
}

/**/

/* Edit keys settings */
static VOID EditKeys (VOID)
{
/*
Ŀ
 SET USER KEYS               ESC - Abort  Exit 
Ĵ
 User Key Number 1 YES  User Key Number I YES 
 User Key Number 2 YES  User Key Number J YES 
 User Key Number 3 YES  User Key Number K YES 
 User Key Number 4 YES  User Key Number L YES 
 User Key Number 5 YES  User Key Number M YES 
 User Key Number 6 YES  User Key Number N YES 
 User Key Number 7 YES  User Key Number O YES 
 User Key Number 8 YES  User Key Number P YES 
Ĵ
 User Key Number A YES  User Key Number Q YES 
 User Key Number B YES  User Key Number R YES 
 User Key Number C YES  User Key Number S YES 
 User Key Number D YES  User Key Number T YES 
 User Key Number E YES  User Key Number U YES 
 User Key Number F YES  User Key Number V YES 
 User Key Number G YES  User Key Number W YES 
 User Key Number H YES  User Key Number X YES 

*/
    SHORT val, i;
    ULONG savekeys;
    CHAR kbuf[32][4];

    MenuFreOnKey(); /* Disable the hotkey functions */

    if(!WinOpen(2,15,22,63,bdr,battr2,wattr2)) return;
    WINSHADOW();
    WinHLine(1,0,48,bdr,battr2); WinHLine(10,0,48,bdr,battr2);
    WinVLine(1,23,19,bdr,battr2);
    WinPrintS(0,0,battr," SET USER KEYS               ESC - Abort  Quit ");
    WinPrintS(0,29,qattr,"ESC - Abort  Quit");

    /* Setup flag display */
    for(i=0;i<16;i++) strcpy(kbuf[i],(lkey(Ud->Usr->xkeys)&(1<<i))?On:Off);
    for(i=16;i<32;i++) strcpy(kbuf[i],(hkey(Ud->Usr->xkeys)&(1<<(i-16)))?On:Off);

    savekeys=Ud->Usr->xkeys; /* Save current settings */

    for(i= 0;i< 8;i++) {
        WinPrintS(i+2,  1,BLUE|_CYAN,UedCfg.key[i]); /* Show labels */
        WinPrintC(i+2, 17,LBLUE|_LGREY,KeyNum[i]);  /* Show key */
    }
    for(i= 8;i<16;i++) {
        WinPrintS(i+3,  1,BLUE|_CYAN,UedCfg.key[i]); /* Show labels */
        WinPrintC(i+3, 17,LBLUE|_LGREY,KeyNum[i]);  /* Show key */
    }
    for(i=16;i<24;i++) {
        WinPrintS(i-14,25,BLUE|_CYAN,UedCfg.key[i]); /* Show labels */
        WinPrintC(i-14,41,LBLUE|_LGREY,KeyNum[i]);  /* Show key */
    }
    for(i=24;i<32;i++) {
        WinPrintS(i-13,25,BLUE|_CYAN,UedCfg.key[i]); /* Show labels */
        WinPrintC(i-13,41,LBLUE|_LGREY,KeyNum[i]);  /* Show key */
    }

    MenuBegC();
    MenuItem(0,42,"Quit",0x1C0A,33,0,NULL,0,0);
    for(i= 0;i< 8;i++) MenuItem(i+2, 19,kbuf[i],KeyNum[i],i,0,EditKeysFlip,0,0);
    for(i= 8;i<16;i++) MenuItem(i+3, 19,kbuf[i],KeyNum[i],i,0,EditKeysFlip,0,0);
    for(i=16;i<24;i++) MenuItem(i-14,43,kbuf[i],KeyNum[i],i,0,EditKeysFlip,0,0);
    for(i=24;i<32;i++) MenuItem(i-13,43,kbuf[i],KeyNum[i],i,0,EditKeysFlip,0,0);
    MenuEnd(33,M_OMNI,0,0,fattr2,fattr2,nosel,WHITE|_RED);
    val=MenuGet();

    WinClose(); /* Close window */

    if(val==-1) Ud->Usr->xkeys=savekeys;
    else {
        if(savekeys!=Ud->Usr->xkeys) { /* If there is a change */
            ShowDisplay(); WriteRec();
        }
    }

    SetHKeys();
}

/**/

/* Used by EditKeys() to toggle a key */
static VOID EditKeysFlip (VOID)
{
    struct _item_t *it;

    it=MenuICurr();
    if(it->tagid>=0&&it->tagid<32) {
        if(it->tagid<16) {
            lkey(Ud->Usr->xkeys) ^= 1<<it->tagid;
            strcpy(it->str,(lkey(Ud->Usr->xkeys)&(1<<it->tagid))?On:Off);
        }
        else {
            hkey(Ud->Usr->xkeys) ^= 1<<(it->tagid-16);
            strcpy(it->str,(hkey(Ud->Usr->xkeys)&(1<<(it->tagid-16)))?On:Off);
        }
        it->redisp=1;
    }
}

/**/

static VOID EditExpiry (VOID)
{
    SHORT done=0, val=6, exp, exp2, exp3, exp4, status;
    CHAR time[9], date[9], date1[4], date2[4], date3[4], str[16];
    USHORT save_xp_priv;
    UCHAR save_xp_flag;
    ULONG save_xp_mins;
    CHAR savedate[9];

    MenuFreOnKey(); /* Disable the hotkey functions */

    /* Save current setting */
    save_xp_priv=Ud->Usr->xp_priv; 
    save_xp_flag=Ud->Usr->xp_flag;
    save_xp_mins=Ud->Usr->xp_mins;
    strcpy(savedate,ShowDate(&Ud->Usr->xp_date,str));

    if(!WinOpen(4,21,20,57,bdr,battr2,wattr2)) return;
    WINSHADOW();
    WinHLine(1,0,36,bdr,battr2); WinHLine(13,0,36,bdr,battr2);
    WinPrintS( 0,0,battr," ACCOUNT EXPIRY                    ");
    WinPrintS( 0,23,qattr,"ESC - Abort");
    WinBox(2,1,6,10,bdr,nosel); WinBox(8,1,12,10,bdr,nosel);
    WinPrintS( 3,2,nosel," None   "); WinPrintS( 4,2,nosel," Date   ");
    WinPrintS( 5,2,nosel," Time   "); WinPrintS( 9,2,nosel," None   ");
    WinPrintS(10,2,nosel," Demote "); WinPrintS(11,2,nosel," Hangup ");
    WinBox(2,12,12,33,bdr,battr2);
    WinPrintS( 3,13,wattr2,"Expiry by  :");

    /* Set exp */
    if(Ud->Usr->xp_flag&XFLAG_EXPDATE) { WinPrintS( 3,25,fattr2,"Date    "); exp=2; }
    else if(Ud->Usr->xp_flag&XFLAG_EXPMINS) { WinPrintS( 3,25,fattr2,"Time    "); exp=3; }
    else { WinPrintS( 3,25,fattr2,"None    "); exp=1; }

    WinPrintS( 5,13,wattr2,"Expiry Date:");
    WinPrintS( 5,25,fattr2,savedate);
    WinPrintS( 7,13,wattr2,"Expiry Time:");
    WinPrintS( 9,13,wattr2,"Action    :");

    /* Set exp3 */
    if(Ud->Usr->xp_flag&XFLAG_AXE) { WinPrintS( 9,24,fattr2,"HangUp   "); exp3=3; }
    else if(Ud->Usr->xp_flag&XFLAG_DEMOTE) { WinPrintS( 9,24,fattr2,"Demote   "); exp3=2; }
    else { WinPrintS( 9,24,fattr2,"None     "); exp3=1; }

    WinPrintS(11,13,wattr2,"Demote to :");
    WinPrintS(11,24,fattr2,ShowPriv(Ud->Usr->xp_priv));
    WinPrintS(14,0,battr,"                                   ");

    while(!done) {
        FormCvtLC(time,Ud->Usr->xp_mins,8); WinPrintS( 7,25,fattr2,time);
        if(val<1||val>6) val=6;
        MenuBegC();
        MenuItem(14, 1,"EXpiry",'X',1,0,NULL,0,0);
        MenuItem(14, 8,"Action",'A',2,0,NULL,0,0);
        MenuItem(14,15,"Date",  'D',3,0,NULL,0,0);
        MenuItem(14,20,"Time",  'T',4,0,NULL,0,0);
        MenuItem(14,25,"Priv",  'P',5,0,NULL,0,0);
        MenuItem(14,30,"Quit",  'Q',6,0,NULL,0,0);
        MenuEnd(val,M_HORZ,0,0,LGREY|_BLUE,WHITE|_BLUE,BLACK|_BLUE,WHITE|_RED);
        val=MenuGet();

        switch(val) {
        case 1 : /* EXpiry */
                 WinPrintS(14, 1,LGREY|_BLUE,"Expiry"); WinPrintS(14, 2,WHITE|_BLUE,"X");
                 MenuBegC();
                 MenuItem(3,2," None   ", 'N',1,0,NULL,0,0);
                 MenuItem(4,2," Date   ", 'D',2,0,NULL,0,0);
                 MenuItem(5,2," Time   ", 'T',3,0,NULL,0,0);
                 MenuEnd(exp,M_VERT,0,0,nosel,nosel,nosel,WHITE|_RED);
                 if((exp2=MenuGet())!=-1) {
                     exp=exp2; /* Save selection */
                     WinPrintS( 3,2,nosel," None   ");
                     WinPrintS( 4,2,nosel," Date   ");
                     WinPrintS( 5,2,nosel," Time   ");
                     Ud->Usr->xp_flag&=~XFLAG_EXPDATE;
                     Ud->Usr->xp_flag&=~XFLAG_EXPMINS;
                     switch(exp2) {
                     case 1: /* None */
                             WinPrintS( 3,25,fattr2,"None    ");
                             break;
                     case 2: /* Date */
                             Ud->Usr->xp_flag|=XFLAG_EXPDATE;
                             WinPrintS( 3,25,fattr2,"Date    ");
                             break;
                     case 3: /* Time */
                             WinPrintS( 3,25,fattr2,"Time    ");
                             Ud->Usr->xp_flag|=XFLAG_EXPMINS;
                             break;
                     }
                 }
                 break;
        case 2 : /* Action */
                 WinPrintS(14, 8,WHITE|_BLUE,"A"); WinPrintS(14, 9,LGREY|_BLUE,"ction");
                 MenuBegC();
                 MenuItem( 9,2," None   ",  'N',1,0,NULL,0,0);
                 MenuItem(10,2," Demote ",'D',2,0,NULL,0,0);
                 MenuItem(11,2," Hangup ",'H',3,0,NULL,0,0);
                 MenuEnd(exp3,M_VERT,0,0,nosel,nosel,nosel,WHITE|_RED);
                 if((exp4=MenuGet())!=-1) {
                     exp3=exp4; /* Save selection */
                     WinPrintS( 9,2,nosel," None   ");
                     WinPrintS(10,2,nosel," Demote ");
                     WinPrintS(11,2,nosel," Hangup ");
                     Ud->Usr->xp_flag&=~XFLAG_DEMOTE;
                     Ud->Usr->xp_flag&=~XFLAG_AXE;
                     switch(exp4) {
                     case 1: /* None */
                             WinPrintS( 9,24,fattr2,"None     ");
                             break;
                     case 2: /* Demote */
                             Ud->Usr->xp_flag|=XFLAG_DEMOTE;
                             WinPrintS( 9,24,fattr2,"Demote   ");
                             break;
                     case 3: /* Hangup */
                             WinPrintS( 9,24,fattr2,"HangUp   ");
                             Ud->Usr->xp_flag|=XFLAG_AXE;
                             break;
                     }
                 }
                 break;
        case 3 : /* Date */
                 WinPrintS(14,15,WHITE|_BLUE,"D"); WinPrintS(14,16,LGREY|_BLUE,"ate");
                 strcpy(date,ShowDate(&Ud->Usr->xp_date,str));
                 strncpy(date1,date,2); date1[2]='\0';
                 strncpy(date2,date+3,2); date2[2]='\0';
                 strncpy(date3,date+6,2); date3[2]='\0';
                 FormBeg(fattr,hattr); /* Do menu */
                 FormDef( 5,25,date1,"%%",0,1,NULL,0);
                 FormDef( 5,28,date2,"%%",0,1,NULL,0);
                 FormDef( 5,31,date3,"%%",0,1,NULL,0);
                 status=FormRead(); /* Process the input fields */
                 VidHideCur(); /* Fix cursor */
                 if(status!=W_ESCPRESS) { /* Process changes */
                     strcpy(date,date1); strcat(date,"-");
                     strcat(date,date2); strcat(date,"-");
                     strcat(date,date3);
                     GetDate(&Ud->Usr->xp_date,date);
                     WinPrintS( 5,25,fattr2,ShowDate(&Ud->Usr->xp_date,str));
                 }
                 break;
        case 4 : /* Time */
                 WinPrintS(14,20,WHITE|_BLUE,"T"); WinPrintS(14,21,LGREY|_BLUE,"ime");

                 FormCvtLC(time,Ud->Usr->xp_mins,8);
                 FormBeg(fattr,hattr); /* Do menu */
                 FormDef( 7,25,time,"%%%%%%%%",0,1,NULL,0);
                 status=FormRead(); /* Process the input fields */
                 VidHideCur(); /* Fix cursor */
                 if(status!=W_ESCPRESS) { /* Process changes */
                     Ud->Usr->xp_mins=atol(time);
                 }
                 break;
        case 5 : /* Priv */
                 WinPrintS(14,25,WHITE|_BLUE,"P"); WinPrintS(14,26,LGREY|_BLUE,"riv");
                 Ud->Usr->xp_priv=GetXPriv(Ud->Usr->xp_priv);
                 WinPrintS(11,24,fattr2,ShowPriv(Ud->Usr->xp_priv));
                 break;
        case -1: /* Abort */
                 Ud->Usr->xp_priv=save_xp_priv;
                 Ud->Usr->xp_flag=save_xp_flag;
                 Ud->Usr->xp_mins=save_xp_mins;
        case 6 : done++;
                 break;
        }
    }

    WinClose(); /* Close window */

    /* If there were changes */
    if( save_xp_priv!=Ud->Usr->xp_priv ||
        save_xp_flag!=Ud->Usr->xp_flag ||
        save_xp_mins!=Ud->Usr->xp_mins ||
        strcmp(savedate,ShowDate(&Ud->Usr->xp_date,str))
    ) {
        ShowDisplay(); WriteRec();
    }

    SetHKeys();
}

/**/

/* Toggle the user keys functions */
static VOID FlipK1 (VOID) { lkey(Ud->Usr->xkeys) ^= 0x0001; WRITE_KEYS(); WriteRec(); }
static VOID FlipK2 (VOID) { lkey(Ud->Usr->xkeys) ^= 0x0002; WRITE_KEYS(); WriteRec(); }
static VOID FlipK3 (VOID) { lkey(Ud->Usr->xkeys) ^= 0x0004; WRITE_KEYS(); WriteRec(); }
static VOID FlipK4 (VOID) { lkey(Ud->Usr->xkeys) ^= 0x0008; WRITE_KEYS(); WriteRec(); }
static VOID FlipK5 (VOID) { lkey(Ud->Usr->xkeys) ^= 0x0010; WRITE_KEYS(); WriteRec(); }
static VOID FlipK6 (VOID) { lkey(Ud->Usr->xkeys) ^= 0x0020; WRITE_KEYS(); WriteRec(); }
static VOID FlipK7 (VOID) { lkey(Ud->Usr->xkeys) ^= 0x0040; WRITE_KEYS(); WriteRec(); }
static VOID FlipK8 (VOID) { lkey(Ud->Usr->xkeys) ^= 0x0080; WRITE_KEYS(); WriteRec(); }
static VOID FlipKa (VOID) { lkey(Ud->Usr->xkeys) ^= 0x0100; WRITE_KEYS(); WriteRec(); }
static VOID FlipKb (VOID) { lkey(Ud->Usr->xkeys) ^= 0x0200; WRITE_KEYS(); WriteRec(); }
static VOID FlipKc (VOID) { lkey(Ud->Usr->xkeys) ^= 0x0400; WRITE_KEYS(); WriteRec(); }
static VOID FlipKd (VOID) { lkey(Ud->Usr->xkeys) ^= 0x0800; WRITE_KEYS(); WriteRec(); }
static VOID FlipKe (VOID) { lkey(Ud->Usr->xkeys) ^= 0x1000; WRITE_KEYS(); WriteRec(); }
static VOID FlipKf (VOID) { lkey(Ud->Usr->xkeys) ^= 0x2000; WRITE_KEYS(); WriteRec(); }
static VOID FlipKg (VOID) { lkey(Ud->Usr->xkeys) ^= 0x4000; WRITE_KEYS(); WriteRec(); }
static VOID FlipKh (VOID) { lkey(Ud->Usr->xkeys) ^= 0x8000; WRITE_KEYS(); WriteRec(); }
static VOID FlipKi (VOID) { hkey(Ud->Usr->xkeys) ^= 0x0001; WRITE_KEYS(); WriteRec(); }
static VOID FlipKj (VOID) { hkey(Ud->Usr->xkeys) ^= 0x0002; WRITE_KEYS(); WriteRec(); }
static VOID FlipKk (VOID) { hkey(Ud->Usr->xkeys) ^= 0x0004; WRITE_KEYS(); WriteRec(); }
static VOID FlipKl (VOID) { hkey(Ud->Usr->xkeys) ^= 0x0008; WRITE_KEYS(); WriteRec(); }
static VOID FlipKm (VOID) { hkey(Ud->Usr->xkeys) ^= 0x0010; WRITE_KEYS(); WriteRec(); }
static VOID FlipKn (VOID) { hkey(Ud->Usr->xkeys) ^= 0x0020; WRITE_KEYS(); WriteRec(); }
static VOID FlipKo (VOID) { hkey(Ud->Usr->xkeys) ^= 0x0040; WRITE_KEYS(); WriteRec(); }
static VOID FlipKp (VOID) { hkey(Ud->Usr->xkeys) ^= 0x0080; WRITE_KEYS(); WriteRec(); }
static VOID FlipKq (VOID) { hkey(Ud->Usr->xkeys) ^= 0x0100; WRITE_KEYS(); WriteRec(); }
static VOID FlipKr (VOID) { hkey(Ud->Usr->xkeys) ^= 0x0200; WRITE_KEYS(); WriteRec(); }
static VOID FlipKs (VOID) { hkey(Ud->Usr->xkeys) ^= 0x0400; WRITE_KEYS(); WriteRec(); }
static VOID FlipKt (VOID) { hkey(Ud->Usr->xkeys) ^= 0x0800; WRITE_KEYS(); WriteRec(); }
static VOID FlipKu (VOID) { hkey(Ud->Usr->xkeys) ^= 0x1000; WRITE_KEYS(); WriteRec(); }
static VOID FlipKv (VOID) { hkey(Ud->Usr->xkeys) ^= 0x2000; WRITE_KEYS(); WriteRec(); }
static VOID FlipKw (VOID) { hkey(Ud->Usr->xkeys) ^= 0x4000; WRITE_KEYS(); WriteRec(); }
static VOID FlipKx (VOID) { hkey(Ud->Usr->xkeys) ^= 0x8000; WRITE_KEYS(); WriteRec(); }

/**/

static VOID PASCAL WriteRec (VOID)
{
    if(!IsRegistered && ++RegWriteCount>UNREGWRITELIMIT) {
        Mesage("Unregistered write limit exceeded!",11,20,13,60);
        TONEERROR(); MenuWaitKeyT(17); WinClose();
    }
    else TONEUPDATE();

    UserIdxWrite(Ud,CurRec);
}

/**/

VOID StringToMD5 (PCHAR szString, PCHAR pbMD5)
{
  MD5_CTX ctx;

  MD5Init(&ctx);
  MD5Update(&ctx,szString,strlen(szString));
  MD5Final(pbMD5,&ctx);
}

/**/

static VOID EncryptPwd (PCHAR str)
{
    SHORT i;
    UCHAR pwd[16];


    memcpy(pwd,str,16);
    for(i=0;i<16;i++) pwd[i]=(CHAR)tolower(pwd[i]);
    StringToMD5(pwd,str);
}

/**/

