{
  MANNFOS.PAS
  FOSSIL communications routines

    Written By:   Rick Parrish
    Last Updated: September 07, 2002

  CHANGE LOG

    09/07/02 - First official release

  NOTES

    All FOSSIL code was ripped from EleCom
    http://www.elebbs.com
}
unit MannFos;

interface

uses
  Dos, Windows;

type
  TMannFos = Object
    private
      FBuffer: String;
      FDontClose: Boolean;
      FComNum: LongInt;
      FRegs: Registers;
      FStripLF: Boolean;

      procedure DoRX;
    public
      DontClose: Boolean;
      StripLF: Boolean;

      constructor Create;
      destructor Destroy;

      procedure Close(ADestroy: Boolean);
      function Connected: Boolean;
      function KeyPressed: Boolean;
      function Open(AComNum: LongInt): Boolean;
      function ReadBuf: String;
      function ReadKey: Char;
      procedure Write(ALine: String);
      procedure WriteLn(ALine: String);
  end;

implementation

constructor TMannFos.Create;
begin
     FBuffer := '';
     FDontClose := True;
     FComNum := 0;
     FStripLF := True;
end;

destructor TMannFos.Destroy;
begin
     Close(True);
end;

procedure TMannFos.Close(ADestroy: Boolean);
begin
     if (ADestroy) then
     begin
          FRegs.AH := $05;
          FRegs.DX := FComNum;
          Intr($14, FRegs);
     end;
end;

function TMannFos.Connected: Boolean;
begin
     FRegs.AH := $03;
     FRegs.DX := FComNum;
     Intr($14, FRegs);

     Connected := (FRegs.AL and $80) <> 0;
end;

procedure TMannFos.DoRX;
var
   Done: Boolean;
begin
     Done := False;
     repeat
           FRegs.AH := $03;
           FRegs.DX := FComNum;
           Intr($14, FRegs);

           if ((FRegs.AH and $01) <> 0) then
           begin
                FRegs.AH := $02;
                FRegs.DX := FComNum;
                Intr($14, FRegs);
                FBuffer := FBuffer + Chr(FRegs.AL);
           end else
               Done := True;
     until (Done);
end;

function TMannFos.KeyPressed: Boolean;
begin
     if (Length(FBuffer) = 0) then
        DoRX;
     KeyPressed := Length(FBuffer) > 0;
end;

function TMannFos.Open(AComNum: LongInt): Boolean;
begin
     if (Connected) then
        Close(True);

     FBuffer := '';
     FComNum := AComNum - 1;

     FRegs.AH := $04;
     FRegs.DX := FComNum;
     FRegs.BX := $4F50;
     Intr($14, FRegs);

     Open := (FRegs.AX = $1954);
end;

function TMannFos.ReadBuf: String;
begin
     DoRX;
     ReadBuf := FBuffer;
     FBuffer := '';
end;

function TMannFos.ReadKey: Char;
begin
     while (Connected) and Not(KeyPressed) do
           Sleep(1);

     if (KeyPressed) then
     begin
          ReadKey := FBuffer[1];
          Delete(FBuffer, 1, 1);
     end else
         ReadKey := #0;
end;

procedure TMannFos.Write(ALine: String);
begin
     FRegs.AH := $19;
     FRegs.DX := FComNum;
     FRegs.CX := Length(ALine);
     FRegs.ES := Seg(ALine[1]);
     FRegs.DI := Ofs(ALine[1]);
     Intr($14, FRegs);
end;

procedure TMannFos.WriteLn(ALine: String);
begin
     Write(ALine + #13#10);
end;

end.
